// CMG_310.cpp : Defines the entry point for the DLL application.
//

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "tinyxml.h"
#include "CMG_310.hpp"

void FillRecord( char * sIrfRecord, char * sData, int iLoc, int len )
{
    iLoc--;
	for ( int i=0; i<len; i++ ) sIrfRecord[iLoc + i] = sData[i];
}

void FillData( char * sIrfRecord, char * sData, int iLoc, int iLen )
{
        iLoc--;
        for ( int i=0; i<iLen; i++ ) sData[i] = sIrfRecord[iLoc + i];
        sData[iLen] = '\0';
}

void Trim_CMRBD( char * CMRBD )
{
         char TrimCMRBD[9];
         int i, j;
         j = 0;
         for ( i=0; i<8; i++ )
               if ( CMRBD[i] != ' ' )
                   TrimCMRBD[j++] = CMRBD[i];
         TrimCMRBD[j] = '\0';
         strcpy( CMRBD, TrimCMRBD );
}

#ifdef SOLARIS
   int CMG_310( char * sIrfRecord,
                char * sCmgValue,
                int * iErrorCode,
                char * sMotorScore,
                int * iCognitive,
                int * iAge,
                char *sCmgVersion,
                char * sDllVersion )
#else
extern "C" __declspec(dllexport) int __stdcall
           CMG_310( char * sIrfRecord,
                    char * sCmgValue,
                    int * iErrorCode,
                    char * sMotorScore,
                    int * iCognitive,
                    int * iAge,
                    char *sCmgVersion,
                    char * sDllVersion )
#endif
{
        char ASMT_SYS_CD[11], TRANS_TYPE_CD[2], BIRTH_DT[9], ADMSN_DT[9];
        char IMPRMNT_GRP_ADMSN_CD[10], CMRBD_COND_A_CD[9], CMRBD_COND_B_CD[9];
        char CMRBD_COND_C_CD[9], CMRBD_COND_D_CD[9], CMRBD_COND_E_CD[9];
        char CMRBD_COND_F_CD[9], CMRBD_COND_G_CD[9], CMRBD_COND_H_CD[9];
        char CMRBD_COND_I_CD[9], CMRBD_COND_J_CD[9], CMRBD_COND_K_CD[9];
        char CMRBD_COND_L_CD[9], CMRBD_COND_M_CD[9], CMRBD_COND_N_CD[9];
        char CMRBD_COND_O_CD[9], CMRBD_COND_P_CD[9], CMRBD_COND_Q_CD[9];
        char CMRBD_COND_R_CD[9], CMRBD_COND_S_CD[9], CMRBD_COND_T_CD[9];
        char CMRBD_COND_U_CD[9], CMRBD_COND_V_CD[9], CMRBD_COND_W_CD[9];
        char CMRBD_COND_X_CD[9], CMRBD_COND_Y_CD[9];
        char EATG_ADMSN_CD[3];
        char GRMG_ADMSN_CD[3], BATHG_ADMSN_CD[3], DRSG_UPR_ADMSN_CD[3];
        char DRSG_LWR_ADMSN_CD[3], TOILTG_ADMSN_CD[3], SPHNCTR_BLADR_ADMSN_CD[3];
        char SPHNCTR_BWL_ADMSN_CD[3], BED_CHR_WC_ADMSN_CD[3], TOILT_ADMSN_CD[3];
        char WLK_WC_ADMSN_CD[3], STR_ADMSN_CD[3], CMPRHNSN_ADMSN_CD[3];
        char EXPRSN_ADMSN_CD[3], SCL_INTRCTN_ADMSN_CD[3], PRBLM_SLVG_ADMSN_CD[3];
        char MEMRY_ADMSN_CD[3], DSCHGR_DT[9];
        char IRF_PAI[11], ADMSN_YYYY[5], ADMSN_MM[3], ADMSN_DD[3];
        char BIRTH_YYYY[5], BIRTH_MM[3], BIRTH_DD[3], TRIM_IMP[10];
        char RIC_Code[3], CMG_Group_Number[5], Tier_Code[2], tokenStr[21];
        char CMRBD_COND_CD[25][9];
        int  dWeights[13];
        int iMotorScore;
        int iValue[13], iCog[6], Cognitive_Score, Age_Value;
        int i, j, k, bFound, eFound, bFound1, bFound2, errorCode;
        int partialBirthDt = 0;
        long dschgDate;
        char * token;
        char str[10];
        int l = 0;
        strcpy( sCmgValue, "     " );
        *iErrorCode = 0;
        *iCognitive = 0;
        strcpy( sMotorScore, " 0.0" );
		*iAge = 0;
        strcpy( sCmgVersion, "    " );
        FillData( sIrfRecord, ASMT_SYS_CD, 1, 10 );
        FillData( sIrfRecord, TRANS_TYPE_CD, 11, 1);
        FillData( sIrfRecord, BIRTH_DT, 657, 8);
        FillData( sIrfRecord, ADMSN_DT, 688, 8);
        FillData( sIrfRecord, IMPRMNT_GRP_ADMSN_CD, 720, 9);
        FillData( sIrfRecord, CMRBD_COND_A_CD, 754, 8);
        FillData( sIrfRecord, CMRBD_COND_B_CD, 762, 8);
        FillData( sIrfRecord, CMRBD_COND_C_CD, 770, 8);
        FillData( sIrfRecord, CMRBD_COND_D_CD, 778, 8);
        FillData( sIrfRecord, CMRBD_COND_E_CD, 786, 8);
        FillData( sIrfRecord, CMRBD_COND_F_CD, 794, 8);
        FillData( sIrfRecord, CMRBD_COND_G_CD, 802, 8);
        FillData( sIrfRecord, CMRBD_COND_H_CD, 810, 8);
        FillData( sIrfRecord, CMRBD_COND_I_CD, 818, 8);
        FillData( sIrfRecord, CMRBD_COND_J_CD, 826, 8);
        FillData( sIrfRecord, CMRBD_COND_K_CD, 1132, 8);
        FillData( sIrfRecord, CMRBD_COND_L_CD, 1140, 8);
        FillData( sIrfRecord, CMRBD_COND_M_CD, 1148, 8);
        FillData( sIrfRecord, CMRBD_COND_N_CD, 1156, 8);
        FillData( sIrfRecord, CMRBD_COND_O_CD, 1164, 8);
        FillData( sIrfRecord, CMRBD_COND_P_CD, 1172, 8);
        FillData( sIrfRecord, CMRBD_COND_Q_CD, 1180, 8);
        FillData( sIrfRecord, CMRBD_COND_R_CD, 1188, 8);
        FillData( sIrfRecord, CMRBD_COND_S_CD, 1196, 8);
        FillData( sIrfRecord, CMRBD_COND_T_CD, 1204, 8);
        FillData( sIrfRecord, CMRBD_COND_U_CD, 1212, 8);
        FillData( sIrfRecord, CMRBD_COND_V_CD, 1220, 8);
        FillData( sIrfRecord, CMRBD_COND_W_CD, 1228, 8);
        FillData( sIrfRecord, CMRBD_COND_X_CD, 1236, 8);
        FillData( sIrfRecord, CMRBD_COND_Y_CD, 1244, 8);
        FillData( sIrfRecord, EATG_ADMSN_CD, 882, 2);
        FillData( sIrfRecord, GRMG_ADMSN_CD, 888, 2);
        FillData( sIrfRecord, BATHG_ADMSN_CD, 894, 2);
        FillData( sIrfRecord, DRSG_UPR_ADMSN_CD, 900, 2);
        FillData( sIrfRecord, DRSG_LWR_ADMSN_CD, 906, 2);
        FillData( sIrfRecord, TOILTG_ADMSN_CD, 912, 2);
        FillData( sIrfRecord, SPHNCTR_BLADR_ADMSN_CD, 918, 2);
        FillData( sIrfRecord, SPHNCTR_BWL_ADMSN_CD, 924, 2);
        FillData( sIrfRecord, BED_CHR_WC_ADMSN_CD, 930, 2);
        FillData( sIrfRecord, TOILT_ADMSN_CD, 936, 2);
        FillData( sIrfRecord, WLK_WC_ADMSN_CD, 948, 2);
        FillData( sIrfRecord, STR_ADMSN_CD, 956, 2);
        FillData( sIrfRecord, CMPRHNSN_ADMSN_CD, 962, 2);
        FillData( sIrfRecord, EXPRSN_ADMSN_CD, 970, 2);
        FillData( sIrfRecord, SCL_INTRCTN_ADMSN_CD, 978, 2);
        FillData( sIrfRecord, PRBLM_SLVG_ADMSN_CD, 984, 2);
        FillData( sIrfRecord, MEMRY_ADMSN_CD, 990, 2);
        FillData( sIrfRecord, DSCHGR_DT, 996, 8);
        dschgDate = atol( DSCHGR_DT );
        errorCode = 0;

		if ( dschgDate >= 20100701 && dschgDate <= 20100930 )
	         strcpy( sCmgVersion, "2.40" );
	    else if ( dschgDate >= 20101001 && dschgDate <= 20110930 )
	          strcpy( sCmgVersion, "2.50" );
	    else if ( dschgDate >= 20111001 && dschgDate <= 20140930 )
	          strcpy( sCmgVersion, "2.60" );
	    else if ( dschgDate >= 20141001 && dschgDate <= 20150930)
	          strcpy( sCmgVersion, "2.70" );
		else if ( dschgDate >= 20151001 && dschgDate <= 20160930)
	          strcpy( sCmgVersion, "2.82" );

// JJ - changes to accommodate new CMG and DLL versions
		else if ( dschgDate >= 20161001 && dschgDate <= 20170930)
	          strcpy( sCmgVersion, "2.90" );
	    else if ( dschgDate >= 20171001 && dschgDate <= 20180930)
	          strcpy( sCmgVersion, "3.00" );
	    else if ( dschgDate >= 20181001)
	          strcpy( sCmgVersion, "3.10" );
        strcpy(	sDllVersion, "3.10" );
// JJ - end of version changes

    // Check is a IRF-PAI record
        j = 0;
        for ( i=0; i<10; i++ )
          if ( ASMT_SYS_CD[i] != ' ' ) IRF_PAI[j++] = ASMT_SYS_CD[i];
        IRF_PAI[j] = '\0';
       if ( 0 != strcmp( "IRF-PAI", IRF_PAI ) )
        {
              errorCode = 1;
              *iErrorCode = 1;
              return errorCode;
        }
		if ( TRANS_TYPE_CD[0] == '3' )
        {
              errorCode = 2;
              *iErrorCode = 2;
              return errorCode;
        }
        if ( dschgDate < 20100701 )
        {
              errorCode = 3;
              *iErrorCode = 3;
              return errorCode;
        }
        for ( i=0; i<8; i++ )
        {
               if ( BIRTH_DT[i] == ' ' )
               {
                    partialBirthDt = 1;
                    break;
               }
        }
        if ( partialBirthDt )
        {
                 if ( (BIRTH_DT[0]==ADMSN_DT[0]) && (BIRTH_DT[1]==ADMSN_DT[1]) &&
                          (BIRTH_DT[2]==ADMSN_DT[2]) && (BIRTH_DT[3]==ADMSN_DT[3]) )
                 {
                       errorCode = 5;
                       *iErrorCode = 5;
                       return errorCode;
                 }
        }
        if ( (BIRTH_DT[4]==' ') && (BIRTH_DT[5]==' ') )
        {
                 BIRTH_DT[4] = '0';
                 BIRTH_DT[5] = '6';
        }
        if ( (BIRTH_DT[6]==' ') && (BIRTH_DT[7]==' ') )
        {
/*               Bug Fix 08/08/2012
         BIRTH_DT[4] = '1';
                 BIRTH_DT[5] = '5';
*/
                 BIRTH_DT[6] = '1';
                 BIRTH_DT[7] = '5';
        }
    if ( atol(ADMSN_DT) < atol(BIRTH_DT) )
        {
                 errorCode = 6;
                 *iErrorCode = 6;
                 return errorCode;
        }
    ADMSN_YYYY[0] = ADMSN_DT[0];
    ADMSN_YYYY[1] = ADMSN_DT[1];
    ADMSN_YYYY[2] = ADMSN_DT[2];
    ADMSN_YYYY[3] = ADMSN_DT[3];
    ADMSN_YYYY[4] = '\0';
    ADMSN_MM[0] = ADMSN_DT[4];
    ADMSN_MM[1] = ADMSN_DT[5];
    ADMSN_MM[2] = '\0';
    ADMSN_DD[0] = ADMSN_DT[6];
    ADMSN_DD[1] = ADMSN_DT[7];
    ADMSN_DD[2] = '\0';
    BIRTH_YYYY[0] = BIRTH_DT[0];
    BIRTH_YYYY[1] = BIRTH_DT[1];
    BIRTH_YYYY[2] = BIRTH_DT[2];
    BIRTH_YYYY[3] = BIRTH_DT[3];
    BIRTH_YYYY[4] = '\0';
    BIRTH_MM[0] = BIRTH_DT[4];
    BIRTH_MM[1] = BIRTH_DT[5];
    BIRTH_MM[2] = '\0';
    BIRTH_DD[0] = BIRTH_DT[6];
    BIRTH_DD[1] = BIRTH_DT[7];
    BIRTH_DD[2] = '\0';
	if ( atoi(ADMSN_MM) < atoi(BIRTH_MM) )
		 Age_Value = atoi(ADMSN_YYYY) - atoi(BIRTH_YYYY) - 1;
	else if ( atoi(ADMSN_MM) > atoi(BIRTH_MM) )
		 Age_Value = atoi(ADMSN_YYYY) - atoi(BIRTH_YYYY);
	else if ( atoi(ADMSN_MM) == atoi(BIRTH_MM) )
	{
		 if ( atoi(ADMSN_DD) < atoi(BIRTH_DD) )
		      Age_Value = atoi(ADMSN_YYYY) - atoi(BIRTH_YYYY) - 1;
		 else
			  Age_Value = atoi(ADMSN_YYYY) - atoi(BIRTH_YYYY);
	}
	*iAge = Age_Value;
	if ( Age_Value > 140 )
	{
		 errorCode = 7;
		 *iErrorCode = 7;
		 return errorCode;
	}

	//Revise IMPRMNT_GRP_ADMSN_CD to remove the first two bytes:
    //IMPRMNT_GRP_ADMSN_CD = SUBSTR(IMPRMNT_GRP_ADMSN_CD,3,7)
    //The first two bytes of the submitted IMPRMNT_GRP_ADMSN_CD are always both 0.
        //These two initial bytes are removed before matching using the RIC Lookup array
        //(which does not include the two leading zeros.
    //Trim the IMPRMNT_GRP_ADMSN_CD
    j = 0;
    for ( i=2; i<9; i++ )
          if ( IMPRMNT_GRP_ADMSN_CD[i] != ' ' )
               TRIM_IMP[j++] = IMPRMNT_GRP_ADMSN_CD[i];
    TRIM_IMP[j] = '\0';
    strcpy( IMPRMNT_GRP_ADMSN_CD, TRIM_IMP );
    //Look through the RIC Lookuparray
    for ( i=1; i<86; i++ )
        {
                  if ( 0 == strcmp( IMPRMNT_GRP_ADMSN_CD, Imp240[i] ) )
                  {
                           strcpy( RIC_Code, Ric240[i] );
                           break;
                  }
        }
        if ( i == 86 )
        {
                 errorCode = 9;
                 *iErrorCode = 9;
                 return errorCode;
        }
        //Compute Motor Score
    dWeights[0] = 0;
    dWeights[1] = 6;
    dWeights[2] = 2;
    dWeights[3] = 9;
    dWeights[4] = 2;
    dWeights[5] = 14;
    dWeights[6] = 12;
    dWeights[7] = 5;
    dWeights[8] = 2;
    dWeights[9] = 22;
    dWeights[10] = 14;
    dWeights[11] = 16;
    dWeights[12] = 16;
    iValue[0] = 0;
    iValue[1] = atoi(EATG_ADMSN_CD);
    iValue[2] = atoi(GRMG_ADMSN_CD);
    iValue[3] = atoi(BATHG_ADMSN_CD);
    iValue[4] = atoi(DRSG_UPR_ADMSN_CD);
    iValue[5] = atoi(DRSG_LWR_ADMSN_CD);
    iValue[6] = atoi(TOILTG_ADMSN_CD);
    iValue[7] = atoi(SPHNCTR_BLADR_ADMSN_CD);
    iValue[8] = atoi(SPHNCTR_BWL_ADMSN_CD);
    iValue[9] = atoi(BED_CHR_WC_ADMSN_CD);
    iValue[10] = atoi(TOILT_ADMSN_CD);
    iValue[11] = atoi(WLK_WC_ADMSN_CD);
    iValue[12] = atoi(STR_ADMSN_CD);
    iMotorScore = 0;
    for ( i=1; i<13; i++ )
        {
                  if ( iValue[i] == 0 )
                  {
               if ( i == 10 ) iValue[i] = 2;
                           else iValue[i] = 1;
                  }
          iMotorScore += iValue[i] * dWeights[i];
        }
        sprintf( str, "%d", iMotorScore );
        l = strlen(str);
        str[l] = str[l-1];
        str[l-1] = '.';
        str[l+1] = '\0';
        strcpy( sMotorScore, str );


        //Compute Cognitive Score
        Cognitive_Score = 0;
        iCog[0] = 0;
        iCog[1] = atoi(CMPRHNSN_ADMSN_CD);
        iCog[2] = atoi(EXPRSN_ADMSN_CD);
        iCog[3] = atoi(SCL_INTRCTN_ADMSN_CD);
        iCog[4] = atoi(PRBLM_SLVG_ADMSN_CD);
        iCog[5] = atoi(MEMRY_ADMSN_CD);
        for ( i=1; i<6; i++ )
        {
                  if ( iCog[i] == 0 ) iCog[i] = 1;
                  Cognitive_Score += iCog[i];
        }
        *iCognitive = Cognitive_Score;
    //Lookup CMG Group Number
        //1. Loop through the rows of the Group Lookup Array Version 2.40 Until a match is found.
        //   a. The RIC code must match the code listed in column 2 of the lookup array.
    //   b. The motor score must be greater than or equal to the motor score low value
        //      listed in column 3 and less than or equal to the motor score high value listed
        //      in column 4 of the lookup array.
        //   c. If the cognitive score low value in column 5 and the cognitive score high value
        //      in column 6 are both non-blank, then the cognitive score must be greater than or equal
        //      to the cognitive score low value and less than or equal to the cognitive score high value
        //      listed in the lookup array.
        //   d. If the age low value in column 7 and the age high value in column 8 are both non-blank,
        //      then the age must be greater than or equal to the age low value and less than or equal to
        //      the age high value listed in the lookup array.
        for ( i = 1; i<88; i++ )
        {
              if ( 0 == strcmp( RIC_Code, RicCode[i] ) )
                  {
//                         if ( floor(Motor_Score*10.0+0.5) = floor(atof(MotLow[i])*10.0+0.5) &&
//                                  floor(Motor_Score*10.0+0.5) <= floor(atof(MotHigh[i])*10.0+0.5) )
               if ( (iMotorScore >= atoi(MotLow[i])) && (iMotorScore <= atoi(MotHigh[i])) )
                           {
                     if ( (CogLow[i][0]!=' ') && (CogHigh[i][0]!=' ') )
                                 {
                          if ( !((Cognitive_Score >= atoi(CogLow[i])) &&
                                                           (Cognitive_Score <= atoi(CogHigh[i]))) )
                                                           continue;
                                         }
                                         if ( (AgeLow[i][0]!=' ') && (AgeHigh[i][0]!=' ') )
                                         {
                          if ( !((Age_Value >= atoi(AgeLow[i])) &&
                                                             (Age_Value <= atoi(AgeHigh[i])))  )
                                                           continue;
                                         }
                                         break;
                           }
                           else
                                   continue;
                  }
        }
        //2.When a match is found in Group Lookup Table Version 2.40, then the
        //  CMG Group Number is equal to the 4 digit number listed in column 1 of the lookup array.
        if ( i <= 87 ) strcpy( CMG_Group_Number, CMG[i] );
        //Lookup Comorbidity Tier Code
        //1. Initialize the Tier Code to A, indicting no comorbidity.
        strcpy( Tier_Code, "A" );
    //2. Select the appropriate Comorbidity Lookup array depending on Discharge Date (item 40),
        //   as follows:
        //   a.     If discharge date is equal to or later than 7/1/2010 and equal to or earlier than
        //      9/30/2010, then select SCmdLookup240.
        //   b.     If discharge date is equal to or later than 10/1/2010 and equal to or earlier than
        //      9/30/2011, then select SCmdLookup250.
        //   c. If discharge date is equal to or later than 10/1/2011
		//      then select SCmdLookup260.
    //3. Trim the values of the 25 comorbidity condition codes (CMRB_COND_A_CD through CMRB_COND_J_CD).
    Trim_CMRBD( CMRBD_COND_A_CD );
    Trim_CMRBD( CMRBD_COND_B_CD );
    Trim_CMRBD( CMRBD_COND_C_CD );
    Trim_CMRBD( CMRBD_COND_D_CD );
    Trim_CMRBD( CMRBD_COND_E_CD );
    Trim_CMRBD( CMRBD_COND_F_CD );
    Trim_CMRBD( CMRBD_COND_G_CD );
    Trim_CMRBD( CMRBD_COND_H_CD );
    Trim_CMRBD( CMRBD_COND_I_CD );
    Trim_CMRBD( CMRBD_COND_J_CD );
    Trim_CMRBD( CMRBD_COND_K_CD );
    Trim_CMRBD( CMRBD_COND_L_CD );
    Trim_CMRBD( CMRBD_COND_M_CD );
    Trim_CMRBD( CMRBD_COND_N_CD );
    Trim_CMRBD( CMRBD_COND_O_CD );
    Trim_CMRBD( CMRBD_COND_P_CD );
    Trim_CMRBD( CMRBD_COND_Q_CD );
    Trim_CMRBD( CMRBD_COND_R_CD );
    Trim_CMRBD( CMRBD_COND_S_CD );
    Trim_CMRBD( CMRBD_COND_T_CD );
    Trim_CMRBD( CMRBD_COND_U_CD );
    Trim_CMRBD( CMRBD_COND_V_CD );
    Trim_CMRBD( CMRBD_COND_W_CD );
    Trim_CMRBD( CMRBD_COND_X_CD );
    Trim_CMRBD( CMRBD_COND_Y_CD );
    strcpy( CMRBD_COND_CD[0], CMRBD_COND_A_CD );
    strcpy( CMRBD_COND_CD[1], CMRBD_COND_B_CD );
    strcpy( CMRBD_COND_CD[2], CMRBD_COND_C_CD );
    strcpy( CMRBD_COND_CD[3], CMRBD_COND_D_CD );
    strcpy( CMRBD_COND_CD[4], CMRBD_COND_E_CD );
    strcpy( CMRBD_COND_CD[5], CMRBD_COND_F_CD );
    strcpy( CMRBD_COND_CD[6], CMRBD_COND_G_CD );
    strcpy( CMRBD_COND_CD[7], CMRBD_COND_H_CD );
    strcpy( CMRBD_COND_CD[8], CMRBD_COND_I_CD );
    strcpy( CMRBD_COND_CD[9], CMRBD_COND_J_CD );
    strcpy( CMRBD_COND_CD[10], CMRBD_COND_K_CD );
    strcpy( CMRBD_COND_CD[11], CMRBD_COND_L_CD );
    strcpy( CMRBD_COND_CD[12], CMRBD_COND_M_CD );
    strcpy( CMRBD_COND_CD[13], CMRBD_COND_N_CD );
    strcpy( CMRBD_COND_CD[14], CMRBD_COND_O_CD );
    strcpy( CMRBD_COND_CD[15], CMRBD_COND_P_CD );
    strcpy( CMRBD_COND_CD[16], CMRBD_COND_Q_CD );
    strcpy( CMRBD_COND_CD[17], CMRBD_COND_R_CD );
    strcpy( CMRBD_COND_CD[18], CMRBD_COND_S_CD );
    strcpy( CMRBD_COND_CD[19], CMRBD_COND_T_CD );
    strcpy( CMRBD_COND_CD[20], CMRBD_COND_U_CD );
    strcpy( CMRBD_COND_CD[21], CMRBD_COND_V_CD );
    strcpy( CMRBD_COND_CD[22], CMRBD_COND_W_CD );
    strcpy( CMRBD_COND_CD[23], CMRBD_COND_X_CD );
    strcpy( CMRBD_COND_CD[24], CMRBD_COND_Y_CD );
    bFound = 0;
    eFound = 0;
    bFound1 = 0;
    bFound2 = 0;
	if ( dschgDate >= 20100701 && dschgDate <= 20100930 )
        {
                for ( i=1; i<947; i++ )
                {
                      eFound = 0;
                  if ( CmdRIC240[i][0] != ' ' )
                          {
                   strcpy( tokenStr, CmdRIC240[i] );
                   token = strtok( tokenStr, "," );
                                   if ( 0 == strcmp( RIC_Code, token ) ) continue;
                   while ( token != NULL )
                   {
                        token = strtok(NULL, ",");
                        if ( token != NULL )
                                                {
                                             if ( 0 == strcmp( RIC_Code, token ) )
                                                         {
                                                                  eFound = 1;
                                                                  break;
                                                         }
                                                }
                   }
                          }
                          if ( eFound ) continue;
                          for ( j=0; j<10; j++ )
                          {
                                if ( 0 == strcmp( CmdICD240[i], CMRBD_COND_CD[j] ) )
                                        {
                         strcpy( Tier_Code, CmdTier240[i] );
                                             bFound = 1;
                                             break;
                                        }
                          }
              if ( bFound ) break;
                }
        }
        else if ( dschgDate >= 20101001 && dschgDate <= 20110930 )
        {
        for ( i=1; i<952; i++ )
                {
                        eFound = 0;
                          if ( CmdRIC250[i][0] != ' ' )
                          {
                   strcpy( tokenStr, CmdRIC250[i] );
                   token = strtok( tokenStr, "," );
                                   if ( 0 == strcmp( RIC_Code, token ) ) continue;
                   while ( token != NULL )
                   {
                        token = strtok(NULL, ",");
                        if ( token != NULL )
                                                {
                                             if ( 0 == strcmp( RIC_Code, token ) )
                                                         {
                                                                  eFound = 1;
                                                                  break;
                                                         }
                                                }
                   }
                          }
                          if ( eFound ) continue;
                          for ( j=0; j<10; j++ )
                          {
                                if ( 0 == strcmp( CmdICD250[i], CMRBD_COND_CD[j] ) )
                                        {
                         strcpy( Tier_Code, CmdTier250[i] );
                                             bFound = 1;
                                             break;
                                        }
                          }
              if ( bFound ) break;
                }
        }
        else if ( dschgDate >= 20111001 && dschgDate <= 20140930 )
        {
                for ( i=1; i<968; i++ )
                {
                      eFound = 0;
                          if ( CmdRIC260[i][0] != ' ' )
                          {
                               strcpy( tokenStr, CmdRIC260[i] );
                                   token = strtok( tokenStr, "," );
                                   if ( 0 == strcmp( RIC_Code, token ) ) continue;
                                   while ( token != NULL )
                   {
                        token = strtok(NULL, ",");
                        if ( token != NULL )
                                       {
                                             if ( 0 == strcmp( RIC_Code, token ) )
                                                         {
                                  eFound = 1;
                                                                  break;
                                                         }
                                                }
                   }
                          }
                          if ( eFound ) continue;
                          for ( j=0; j<10; j++ )
                          {
                                if ( 0 == strcmp( CmdICD260[i], CMRBD_COND_CD[j] ) )
                                        {
                         strcpy( Tier_Code, CmdTier260[i] );
                                             bFound = 1;
                                             break;
                                        }
                          }
              if ( bFound ) break;
                }
        }
    else if ( dschgDate >= 20141001 && dschgDate <= 20150930)
    {
		        //Process 2.60 comorbidity list.
                for ( i=1; i<968; i++ )
                {
                      eFound = 0;
                      if ( CmdRIC260[i][0] != ' ' )
                      {
                           strcpy( tokenStr, CmdRIC260[i] );
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) ) continue;
                           while ( token != NULL )
                           {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                           }
                      }
                      if ( eFound ) continue;
                      for ( j=0; j<25 ; j++ )
                      {
							if (CMRBD_COND_CD[j][0] == '^' ) break;

							if ( 0 == strcmp( CmdICD260[i], CMRBD_COND_CD[j] ) )
                            {
                                 strcpy( Tier_Code, CmdTier260[i] );
                                 bFound = 1;
                                 break;
                            }
                      }
                      if ( bFound ) break;
                }
	    }
    else if ( dschgDate >= 20151001 && dschgDate <= 20160930)
    {
		    //Process version 2.81 single code list1.
            for ( i=1; i<1003; i++ )
            {
                  eFound = 0;
                  if ( CmdRIC281s1[i][0] != ' ' )
                  {
                       int len = strlen(CmdRIC281s1[i]);
				       int m = 0;
                       for ( k=0; k<len; k++ )
					   {
							 if ( CmdRIC281s1[i][k] != ' ' )
							      tokenStr[m++] = CmdRIC281s1[i][k];
					   }
					   tokenStr[m] = '\0';
                       token = strtok( tokenStr, "," );
                       if ( 0 == strcmp( RIC_Code, token ) ) continue;
                       while ( token != NULL )
                       {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                        }
                  }

                  if ( eFound ) continue;
				  bFound = 0;
                  for ( j=0; j<25 ; j++ )
                  {
					    if (CMRBD_COND_CD[j][0] == '^' ) break;

						if ( 0 == strcmp( CmdICD281s1[i], CMRBD_COND_CD[j] ) )
                        {
                             strcpy( Tier_Code, CmdTier281s1[i] );
                             bFound = 1;
                             break;
                         }
                  }
                  if ( bFound ) break;
            }

			//Skip combination code list if Tier already assigned ( not = 'A' )
			if ( bFound != 1)
			{
			     //Process version 2.81 combination code list.
                 //Initialze CmdEflag281s2 vector .
                 for (k=1; k<49; k++)
				 {
                     CmdEflag281s2[k][0] = '0';
				 }
                 for ( i=1; i<64; i++ )
                 {
                      eFound = 0;
                      if ( CmdRIC281c[i][0] != ' ' )
                      {
                           int len = strlen(CmdRIC281c[i]);
					       int m = 0;
                           for ( k=0; k<len; k++ )
						   {
						         if ( CmdRIC281c[i][k] != ' ' )
								      tokenStr[m++] = CmdRIC281c[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) )
						   {    eFound = 1;
						   }
						   else
						   {
                               while ( token != NULL )
                               {
                                  token = strtok(NULL, ",");
                                  if ( token != NULL )
                                  {
                                       if ( 0 == strcmp( RIC_Code, token ) )
                                       {
                                            eFound = 1;
											break;
									   }
                                   }
                               }
						   }
                       }
						bFound1 = 0;
						bFound2 = 0;
                        for ( j=0; j<25 ; j++ )
                        {
							  if (CMRBD_COND_CD[j][0] == '^' )  break;

						      //Check that combination list code 1 present.
                              if ( 0 == strcmp( CmdICD281c1[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound1 = 1;
                              }
                              //Check if combination list code 2 found.
                              if ( 0 == strcmp( CmdICD281c2[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound2 = 1;
							  }
						}
                        //New code to add.  PLEASE CORRECT SYNTAX
                        if (eFound == 1 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and excluded
                            //Locate code 1 in single code list 2 and if found
                            //   update exception flag in single code list 2
                            for (k=1; k<49; k++)
                            {
								if ( 0 == strcmp( CmdICD281c1[i], CmdICD281s2[k] ) )
                                 {
                                     CmdEflag281s2[k][0] = '1';
                                     break;
                                 }
                             }
                             //Locate code 2 in single code list 2 and if found
                             //update exception flag in single code list 2
                             for (k=1; k<49; k++)
                             {

                                 if ( 0 == strcmp( CmdICD281c2[i], CmdICD281s2[k] ) )
                                 {
                                      CmdEflag281s2[k][0] = '1';
                                      break;
                                 }
                           }
					    }
                        if (eFound == 0 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and not excluded
                            //Update comorbidity Tier code
                            strcpy( Tier_Code, CmdTier281c[i] );
							bFound = 1;
                        }
                 }
			}
				//Skip single code list 2 if Tier already assigned (not = 'A')
            if ( bFound != 1 )
  	        //Process version 2.81 single code list 2.
			{
			for ( i=1; i<49; i++ )
                {
					 eFound = 0;
                      if ( CmdRIC281s2[i][0] != ' ' )
                      {
                           int len = strlen(CmdRIC281s2[i]);
						   int m = 0;
                           for ( int k=0; k<len; k++ )
						   {
							   if ( CmdRIC281s2[i][k] != ' ' )
								    tokenStr[m++] = CmdRIC281s2[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) ) continue;
                           while ( token != NULL )
                           {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                           }
                          }
                          if ( eFound || CmdEflag281s2[i][0]=='1') continue;
                          for ( j=0; j<25 ; j++ )
                          {
		                        if (CMRBD_COND_CD[j][0] == '^' ) break;
								if ( 0 == strcmp( CmdICD281s2[i], CMRBD_COND_CD[j] ) )
                                {
                                     strcpy( Tier_Code, CmdTier281s2[i] );
                                     bFound = 1;
                                     break;
                                }
                          }
                          if ( bFound ) break;
                      }
			}
		  }
// JJ - added end date for the 2.90 version of the processing
    else if ( dschgDate >= 20161001 && dschgDate <= 20170930 )
    {
		    //Process version 2.90 single code list1.
            for ( i=1; i<1157; i++ )
            {
                  eFound = 0;
                  if ( CmdRIC290s1 [i][0] != ' ' )
                  {
                       int len = strlen(CmdRIC290s1[i]);
				       int m = 0;
                       for ( k=0; k<len; k++ )
					   {
							 if ( CmdRIC290s1[i][k] != ' ' )
							      tokenStr[m++] = CmdRIC290s1[i][k];
					   }
					   tokenStr[m] = '\0';
                       token = strtok( tokenStr, "," );
                       if ( 0 == strcmp( RIC_Code, token ) ) continue;
                       while ( token != NULL )
                       {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                        }
                  }

                  if ( eFound ) continue;
				  bFound = 0;
                  for ( j=0; j<25 ; j++ )
                  {
					    if (CMRBD_COND_CD[j][0] == '^' ) break;

						if ( 0 == strcmp( CmdICD290s1[i], CMRBD_COND_CD[j] ) )
                        {
                             strcpy( Tier_Code, CmdTier290s1[i] );
                             bFound = 1;
                             break;
                         }
                  }
                  if ( bFound ) break;
            }

			//Skip combination code list if Tier already assigned ( not = 'A' )
			if ( bFound != 1)
			{
			     //Process version 2.90 combination code list.
                 //Initialze CmdEflag290s2 vector .
                 for (k=1; k<49; k++)
				 {
                     CmdEflag290s2[k][0] = '0';
				 }
                 for ( i=1; i<64; i++ )
                 {
                      eFound = 0;
                      if ( CmdRIC290c[i][0] != ' ' )
                      {
                           int len = strlen(CmdRIC290c[i]);
					       int m = 0;
                           for ( k=0; k<len; k++ )
						   {
						         if ( CmdRIC290c[i][k] != ' ' )
								      tokenStr[m++] = CmdRIC290c[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) )
						   {    eFound = 1;
						   }
						   else
						   {
                               while ( token != NULL )
                               {
                                  token = strtok(NULL, ",");
                                  if ( token != NULL )
                                  {
                                       if ( 0 == strcmp( RIC_Code, token ) )
                                       {
                                            eFound = 1;
											break;
									   }
                                   }
                               }
						   }
                       }
						bFound1 = 0;
						bFound2 = 0;
                        for ( j=0; j<25 ; j++ )
                        {
							  if (CMRBD_COND_CD[j][0] == '^' )  break;

						      //Check that combination list code 1 present.
                              if ( 0 == strcmp( CmdICD290c1[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound1 = 1;
                              }
                              //Check if combination list code 2 found.
                              if ( 0 == strcmp( CmdICD290c2[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound2 = 1;
							  }
						}
                        //New code to add.  PLEASE CORRECT SYNTAX
                        if (eFound == 1 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and excluded
                            //Locate code 1 in single code list 2 and if found
                            //   update exception flag in single code list 2
                            for (k=1; k<49; k++)
                            {
								if ( 0 == strcmp( CmdICD290c1[i], CmdICD290s2[k] ) )
                                 {
                                     CmdEflag290s2[k][0] = '1';
                                     break;
                                 }
                             }
                             //Locate code 2 in single code list 2 and if found
                             //update exception flag in single code list 2
                             for (k=1; k<49; k++)
                             {

                                 if ( 0 == strcmp( CmdICD290c2[i], CmdICD290s2[k] ) )
                                 {
                                      CmdEflag290s2[k][0] = '1';
                                      break;
                                 }
                           }
					    }
                        if (eFound == 0 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and not excluded
                            //Update comorbidity Tier code
                            strcpy( Tier_Code, CmdTier290c[i] );
							bFound = 1;
                        }
                 }
			}
				//Skip single code list 2 if Tier already assigned (not = 'A')
            if ( bFound != 1 )
  	        //Process version 2.90 single code list 2.
			{
			for ( i=1; i<49; i++ )
                {
					 eFound = 0;
                      if ( CmdRIC290s2[i][0] != ' ' )
                      {
                           int len = strlen(CmdRIC290s2[i]);
						   int m = 0;
                           for ( int k=0; k<len; k++ )
						   {
							   if ( CmdRIC290s2[i][k] != ' ' )
								    tokenStr[m++] = CmdRIC290s2[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) ) continue;
                           while ( token != NULL )
                           {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                           }
                          }
                          if ( eFound || CmdEflag290s2[i][0]=='1') continue;
                          for ( j=0; j<25 ; j++ )
                          {
		                        if (CMRBD_COND_CD[j][0] == '^' ) break;
								if ( 0 == strcmp( CmdICD290s2[i], CMRBD_COND_CD[j] ) )
                                {
                                     strcpy( Tier_Code, CmdTier290s2[i] );
                                     bFound = 1;
                                     break;
                                }
                          }
                          if ( bFound ) break;
                      }
			}
		}


	// JJ - added end date for the 3.00 version of the processing
    else if ( dschgDate >= 20171001 && dschgDate <= 20180930 )
    {
		    //Process version 3.00 single code list1.
            for ( i=1; i<1158; i++ )
            {
                  eFound = 0;
                  if ( CmdRIC300s1 [i][0] != ' ' )
                  {
                       int len = strlen(CmdRIC300s1[i]);
				       int m = 0;
                       for ( k=0; k<len; k++ )
					   {
							 if ( CmdRIC300s1[i][k] != ' ' )
							      tokenStr[m++] = CmdRIC300s1[i][k];
					   }
					   tokenStr[m] = '\0';
                       token = strtok( tokenStr, "," );
                       if ( 0 == strcmp( RIC_Code, token ) ) continue;
                       while ( token != NULL )
                       {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                        }
                  }

                  if ( eFound ) continue;
				  bFound = 0;
                  for ( j=0; j<25 ; j++ )
                  {
					    if (CMRBD_COND_CD[j][0] == '^' ) break;

						if ( 0 == strcmp( CmdICD300s1[i], CMRBD_COND_CD[j] ) )
                        {
                             strcpy( Tier_Code, CmdTier300s1[i] );
                             bFound = 1;
                             break;
                         }
                  }
                  if ( bFound ) break;
            }

			//Skip combination code list if Tier already assigned ( not = 'A' )
			if ( bFound != 1)
			{
			     //Process version 3.00 combination code list

                 //Initialize CmdEflag290s2 vector .
                 for (k=1; k<49; k++)
				 {
                     CmdEflag290s2[k][0] = '0';
				 }

			     // vector expanded in v3.00 from 64 to 88
                 for ( i=1; i<88; i++ )
                 {
                      eFound = 0;
                      if ( CmdRIC300c[i][0] != ' ' )
                      {
                           int len = strlen(CmdRIC300c[i]);
					       int m = 0;
                           for ( k=0; k<len; k++ )
						   {
						         if ( CmdRIC300c[i][k] != ' ' )
								      tokenStr[m++] = CmdRIC300c[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) )
						   {    eFound = 1;
						   }
						   else
						   {
                               while ( token != NULL )
                               {
                                  token = strtok(NULL, ",");
                                  if ( token != NULL )
                                  {
                                       if ( 0 == strcmp( RIC_Code, token ) )
                                       {
                                            eFound = 1;
											break;
									   }
                                   }
                               }
						   }
                       }
						bFound1 = 0;
						bFound2 = 0;
                        for ( j=0; j<25 ; j++ )
                        {
							  if (CMRBD_COND_CD[j][0] == '^' )  break;

						      //Check that combination list code 1 present.
                              if ( 0 == strcmp( CmdICD300c1[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound1 = 1;
                              }
                              //Check if combination list code 2 found.
                              if ( 0 == strcmp( CmdICD300c2[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound2 = 1;
							  }
						}
                        //New code to add.  PLEASE CORRECT SYNTAX
                        if (eFound == 1 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and excluded
                            //Locate code 1 in single code list 2 and if found
                            //   update exception flag in single code list 2
                            for (k=1; k<49; k++)
                            {
								if ( 0 == strcmp( CmdICD300c1[i], CmdICD290s2[k] ) )
                                 {
                                     CmdEflag290s2[k][0] = '1';
                                     break;
                                 }
                             }
                             //Locate code 2 in single code list 2 and if found
                             //update exception flag in single code list 2
                             for (k=1; k<49; k++)
                             {

                                 if ( 0 == strcmp( CmdICD300c2[i], CmdICD290s2[k] ) )
                                 {
                                      CmdEflag290s2[k][0] = '1';
                                      break;
                                 }
                           }
					    }
                        if (eFound == 0 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and not excluded
                            //Update comorbidity Tier code
                            strcpy( Tier_Code, CmdTier300c[i] );
							bFound = 1;
                        }
                 }
			}
				//Skip single code list 2 if Tier already assigned (not = 'A')
            if ( bFound != 1 )
  	        //Process version 2.90 single code list 2 - did not change in version 3.00
			{
			for ( i=1; i<49; i++ )
                {
					 eFound = 0;
                      if ( CmdRIC290s2[i][0] != ' ' )
                      {
                           int len = strlen(CmdRIC290s2[i]);
						   int m = 0;
                           for ( int k=0; k<len; k++ )
						   {
							   if ( CmdRIC290s2[i][k] != ' ' )
								    tokenStr[m++] = CmdRIC290s2[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) ) continue;
                           while ( token != NULL )
                           {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                           }
                          }
                          if ( eFound || CmdEflag290s2[i][0]=='1') continue;
                          for ( j=0; j<25 ; j++ )
                          {
		                        if (CMRBD_COND_CD[j][0] == '^' ) break;
								if ( 0 == strcmp( CmdICD290s2[i], CMRBD_COND_CD[j] ) )
                                {
                                     strcpy( Tier_Code, CmdTier290s2[i] );
                                     bFound = 1;
                                     break;
                                }
                          }
                          if ( bFound ) break;
                      }
			}
		}
// JJ - REVISED NEW VERSION CODE
else if ( dschgDate >= 20181001 )
    {
		    //Process version 3.10 single code list1.
            for ( i=1; i<1166; i++ )
            {
                  eFound = 0;
                  if ( CmdRIC310s1 [i][0] != ' ' )
                  {
                       int len = strlen(CmdRIC310s1[i]);
				       int m = 0;
                       for ( k=0; k<len; k++ )
					   {
							 if ( CmdRIC310s1[i][k] != ' ' )
							      tokenStr[m++] = CmdRIC310s1[i][k];
					   }
					   tokenStr[m] = '\0';
                       token = strtok( tokenStr, "," );
                       if ( 0 == strcmp( RIC_Code, token ) ) continue;
                       while ( token != NULL )
                       {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                        }
                  }

                  if ( eFound ) continue;
				  bFound = 0;
                  for ( j=0; j<25 ; j++ )
                  {
					    if (CMRBD_COND_CD[j][0] == '^' ) break;

						if ( 0 == strcmp( CmdICD310s1[i], CMRBD_COND_CD[j] ) )
                        {
                             strcpy( Tier_Code, CmdTier310s1[i] );
                             bFound = 1;
                             break;
                         }
                  }
                  if ( bFound ) break;
            }

			//Skip combination code list if Tier already assigned ( not = 'A' )
			if ( bFound != 1)
			{
			     //JJ - Process version 3.00 combination code list, did not change in 3.10

                 //Initialize CmdEflag290s2 vector .
                 for (k=1; k<49; k++)
				 {
                     CmdEflag290s2[k][0] = '0';
				 }

			     // vector expanded in v3.00 from 64 to 88, stayed the same in 3.10
                 for ( i=1; i<88; i++ )
                 {
                      eFound = 0;
                      if ( CmdRIC300c[i][0] != ' ' )
                      {
//Sheng-Shi 06/27/2018 comment int len = strlen(CmdRIC310c[i]);
                          int len = strlen(CmdRIC300c[i]);

						   int m = 0;
                           for ( k=0; k<len; k++ )
						   {
						         if ( CmdRIC300c[i][k] != ' ' )
								      tokenStr[m++] = CmdRIC300c[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) )
						   {    eFound = 1;
						   }
						   else
						   {
                               while ( token != NULL )
                               {
                                  token = strtok(NULL, ",");
                                  if ( token != NULL )
                                  {
                                       if ( 0 == strcmp( RIC_Code, token ) )
                                       {
                                            eFound = 1;
											break;
									   }
                                   }
                               }
						   }
                       }
						bFound1 = 0;
						bFound2 = 0;
                        for ( j=0; j<25 ; j++ )
                        {
							  if (CMRBD_COND_CD[j][0] == '^' )  break;

						      //Check that combination list code 1 present.
                              if ( 0 == strcmp( CmdICD300c1[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound1 = 1;
                              }
                              //Check if combination list code 2 found.
                              if ( 0 == strcmp( CmdICD300c2[i], CMRBD_COND_CD[j] ) )
                              {
                                     bFound2 = 1;
							  }
						}
                        //New code to add.  PLEASE CORRECT SYNTAX
                        if (eFound == 1 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and excluded
                            //Locate code 1 in single code list 2 and if found
                            //   update exception flag in single code list 2
                            for (k=1; k<49; k++)
                            {
								if ( 0 == strcmp( CmdICD300c1[i], CmdICD290s2[k] ) )
                                 {
                                     CmdEflag290s2[k][0] = '1';
                                     break;
                                 }
                             }
                             //Locate code 2 in single code list 2 and if found
                             //update exception flag in single code list 2
                             for (k=1; k<49; k++)
                             {

                                 if ( 0 == strcmp( CmdICD300c2[i], CmdICD290s2[k] ) )
                                 {
                                      CmdEflag290s2[k][0] = '1';
                                      break;
                                 }
                           }
					    }
                        if (eFound == 0 && bFound1 == 1 && bFound2 == 1)
                        {
                            //Combination present and not excluded
                            //Update comorbidity Tier code
                            strcpy( Tier_Code, CmdTier300c[i] );
							bFound = 1;
                        }
                 }
			}
				//Skip single code list 2 if Tier already assigned (not = 'A')
            if ( bFound != 1 )
  	        //Process version 2.90 single code list 2 - did not change in version 3.10
			{
			for ( i=1; i<49; i++ )
                {
					 eFound = 0;
                      if ( CmdRIC290s2[i][0] != ' ' )
                      {
                           int len = strlen(CmdRIC290s2[i]);
						   int m = 0;
                           for ( int k=0; k<len; k++ )
						   {
							   if ( CmdRIC290s2[i][k] != ' ' )
								    tokenStr[m++] = CmdRIC290s2[i][k];
						   }
						   tokenStr[m] = '\0';
                           token = strtok( tokenStr, "," );
                           if ( 0 == strcmp( RIC_Code, token ) ) continue;
                           while ( token != NULL )
                           {
                             token = strtok(NULL, ",");
                             if ( token != NULL )
                             {
                                  if ( 0 == strcmp( RIC_Code, token ) )
                                  {
                                       eFound = 1;
                                       break;
                                  }
                             }
                           }
                          }
                          if ( eFound || CmdEflag290s2[i][0]=='1') continue;
                          for ( j=0; j<25 ; j++ )
                          {
		                        if (CMRBD_COND_CD[j][0] == '^' ) break;
								if ( 0 == strcmp( CmdICD290s2[i], CMRBD_COND_CD[j] ) )
                                {
                                     strcpy( Tier_Code, CmdTier290s2[i] );
                                     bFound = 1;
                                     break;
                                }
                          }
                          if ( bFound ) break;
                      }
			}
		}
// JJ - END OF NEW CODE

		strcpy( sCmgValue, Tier_Code );
        strcat( sCmgValue, CMG_Group_Number );

		return errorCode;
}

#ifdef SOLARIS
   int CMG_310_XML( char * sXMLRecord,
                    char * sCmgValue,
                    int * iErrorCode,
                    char * sMotorScore,
                    int * iCognitive,
                    int * iAge,
                    char *sCmgVersion,
                    char * sDllVersion )
#else
extern "C" __declspec(dllexport) int __stdcall
           CMG_310_XML( char * sXMLRecord,
                        char * sCmgValue,
                        int * iErrorCode,
                        char * sMotorScore,
                        int * iCognitive,
                        int * iAge,
                        char *sCmgVersion,
                        char * sDllVersion )
#endif
{
	char irfRecord[2786];
	memset(irfRecord, ' ', 2786);
	irfRecord[2784] = '%';
	irfRecord[2785] = '\0';

    TiXmlDocument doc = TiXmlDocument();
	doc.Parse(sXMLRecord);
	if ( doc.Error() )
	{
	    printf( "Error in %s: %s\n", doc.Value(), doc.ErrorDesc() );
        return 99;
	}

		TiXmlNode* node = 0;
		TiXmlElement* irfElement = 0;
		TiXmlElement* itemElement = 0;
		TiXmlElement*	element;

    	node = doc.FirstChild( "ASSESSMENT" );
		assert( node );
		irfElement = node->ToElement();
		assert( irfElement  );

		node = doc.RootElement();
		assert( node );
		// Walk all the elements in a node.
		char name[200];
		char itemValue[200];
		int itemCount = 0;

		for( element = irfElement->FirstChildElement();
			 element;
			 element = element->NextSiblingElement() )
		{
             strcpy( name,element->Value() );
			 for ( int i=0; i<48; i++ ) {
			     if ( 0==strcmp(name, iTems[i].name) ) {
                      strcpy(itemValue, element->GetText());
					  FillRecord( irfRecord, itemValue, iTems[i].loc, strlen(itemValue) );
                      itemCount++;
					  break;
				      }
			}

		}

	int errorCode = CMG_310( irfRecord,
		                     sCmgValue,
                             iErrorCode,
                             sMotorScore,
                             iCognitive,
                             iAge,
                             sCmgVersion,
                             sDllVersion );

	return errorCode;

}

#ifdef SOLARIS
   int CMG_310_XML_FILE( char * sFileName,
                         char * sCmgValue,
                         int * iErrorCode,
                         char * sMotorScore,
                         int * iCognitive,
                         int * iAge,
                         char *sCmgVersion,
                         char * sDllVersion )
#else
extern "C" __declspec(dllexport) int __stdcall
           CMG_310_XML_FILE( char * sFileName,
                             char * sCmgValue,
                             int * iErrorCode,
                             char * sMotorScore,
                             int * iCognitive,
                             int * iAge,
                             char *sCmgVersion,
                             char * sDllVersion )
#endif
{
	char irfRecord[2786];
    memset(irfRecord, ' ', 2786);
	irfRecord[2784] = '%';
	irfRecord[2785] = '\0';

	TiXmlDocument doc( sFileName );
	bool loadOkay = doc.LoadFile();

	if ( !loadOkay )
		{
			printf( "Could not load xml file %s. Error=%s. Exiting.\n", sFileName, doc.ErrorDesc() );
            return 99;
		}

		TiXmlNode* node = 0;
		TiXmlElement* irfElement = 0;
		TiXmlElement* itemElement = 0;
		TiXmlElement*	element;

		node = doc.FirstChild( "ASSESSMENT" );
		assert( node );
		irfElement = node->ToElement();
		assert( irfElement  );

		node = doc.RootElement();
		assert( node );
		// Walk all the elements in a node.
		char name[200];
		char itemValue[200];
		int itemCount = 0;

		for( element = irfElement->FirstChildElement();
			 element;
			 element = element->NextSiblingElement() )
		{
             strcpy( name,element->Value() );
			 for ( int i=0; i<48; i++ ) {
			     if ( 0==strcmp(name, iTems[i].name) ) {
                      strcpy(itemValue, element->GetText());
					  FillRecord( irfRecord, itemValue, iTems[i].loc, strlen(itemValue) );
                      itemCount++;
					  break;
				      }
			}

		}

	int errorCode = CMG_310( irfRecord,
                             sCmgValue,
                             iErrorCode,
                             sMotorScore,
                             iCognitive,
                             iAge,
                             sCmgVersion,
                             sDllVersion );

    return errorCode;
}

