/*************************************************************************;
%** PROGRAM: create_function_score.sas
%** PURPOSE: Creates 2 function scores:
%** 1). PDPM PT and OT function score based on Section GG
%** 2). PDPM nursing function score based on Section GG
%** DATE Created: 07/27/2018
%** NOTES: Program is called by assign_assessments_to_cmgs.sas  
%** 
%** RESTRICTED RIGHTS NOTICE (SEPT 2014)
%** (a) This computer software is submitted with restricted rights under Government Agreement No. CMS: DataLink 3 OY1. It may not be used, reproduced, or disclosed by the Government except as provided in paragraph (b) of this Notice or as otherwise expressly stated in the agreement. 
%** (b) This computer software may be:
%**    (1) Used or copied for use in or with the computer or computers for which it was acquired, including use at any Government installation to which such computer or computers may be transferred; 
%**    (2) Used or copied for use in a backup computer if any computer for which it was acquired is inoperative; 
%**    (3) Reproduced for safekeeping (archives) or backup purposes; 
%**    (4) Modified, adapted, or combined with other computer software, provided that the modified, combined, or adapted portions of the derivative software are made subject to the same restricted rights; 
%**    (5) Disclosed to and reproduced for use by support service Recipients in accordance with subparagraphs (b)(1) through (4) of this clause, provided the Government makes such disclosure or reproduction subject to these restricted rights; and
%**    (6) Used or copied for use in or transferred to a replacement computer. 
%** (c) Notwithstanding the foregoing, if this computer software is published copyrighted computer software, it is licensed to the Government, without disclosure prohibitions, with the minimum rights set forth in paragraph (b) of this clause. 
%** (d) Any other rights or limitations regarding the use, duplication, or disclosure of this computer software are to be expressly stated in, or incorporated in, the agreement. 
%** (e) This Notice shall be marked on any reproduction of this computer software, in whole or in part. 
%** (End of notice)   
%*************************************************************************/

%macro create_function_score();

   *********************************************************;
   *1: Section GG-based Functional Score (PT & OT Component);
   *********************************************************;
   %*Scoring is based on functional independence;
   %*Score includes 3 early-loss items and 7 late-loss self-performance ADL items;
  
   *Recode GG walking items for skip patterns based on gg0170i1; 
   %*If resident cannot walk 10 feet then recode walk 50 and walk 150 from missing to skipped;
   %* Response level "11" = resident cannot walk;
   if gg0170i1_wlk_10_admsn_cd in ("07","09","10", "88") then do; 
      gg0170j1_wlk_50_admsn_cd = "11"; 
      gg0170k1_wlk_150_admsn_cd  = "11"; 
   end;
   
   *Construct new PT and OT function scores based on Section GG;  
   %do p =1 %to &npt_ot_gg_items.;       
      if missing(&&pt_ot_gg_items&p..)     then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 0;
      else if &&pt_ot_gg_items&p..  = "01" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 0;
      else if &&pt_ot_gg_items&p..  = "02" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 1; 
      else if &&pt_ot_gg_items&p..  = "03" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 2; 
      else if &&pt_ot_gg_items&p..  = "04" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 3; 
      else if &&pt_ot_gg_items&p..  = "05" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 4; 
      else if &&pt_ot_gg_items&p..  = "06" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 4; 
      else if &&pt_ot_gg_items&p..  = "07" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 0; 
      else if &&pt_ot_gg_items&p..  = "09" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 0; 
      else if &&pt_ot_gg_items&p..  = "10" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 0;    
      else if &&pt_ot_gg_items&p..  = "11" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 0;       
      else if &&pt_ot_gg_items&p..  = "88" then _PT_OT_GG_&&pt_ot_gg_items_label&p.. = 0; 
   %end;
      
   *Take average of multiple related-GG items;
   _pt_ot_avg_bed_mobility = (_PT_OT_GG_SIT + _PT_OT_GG_LYNG)/2;
   _pt_ot_avg_transfer     = (_PT_OT_GG_STAND + _PT_OT_GG_CHR_TRNSF + _PT_OT_GG_TOILT_TRNSF)/3;
   _pt_ot_avg_walking      = (_PT_OT_GG_wlk_150 + _PT_OT_GG_wlk_50)/2;   

   *Sum item scores to create total PT/OT function score and round to the nearest integer;                        
   pt_ot_function_score = round(_PT_OT_GG_EATG + _PT_OT_GG_ORAL_HYGNE + _PT_OT_GG_TOILT_HYGNE + _pt_ot_avg_bed_mobility+ _pt_ot_avg_transfer + _pt_ot_avg_walking);  
   
   *********************************************************;
   *2: Section GG-based Functional Score (Nursing Component);
   *********************************************************;
   %*Scoring is based on functional independence;
   %*Score includes 7 late-loss self-performance ADL items;   
   %do n =1 %to &nnursing_gg_items.;       
      if missing(&&nursing_gg_items&n..)     then _nursing_GG_&&nursing_gg_items_label&n.. = 0;     
      else if &&nursing_gg_items&n..  = "01" then _nursing_GG_&&nursing_gg_items_label&n.. = 0;
      else if &&nursing_gg_items&n..  = "02" then _nursing_GG_&&nursing_gg_items_label&n.. = 1; 
      else if &&nursing_gg_items&n..  = "03" then _nursing_GG_&&nursing_gg_items_label&n.. = 2; 
      else if &&nursing_gg_items&n..  = "04" then _nursing_GG_&&nursing_gg_items_label&n.. = 3; 
      else if &&nursing_gg_items&n..  = "05" then _nursing_GG_&&nursing_gg_items_label&n.. = 4; 
      else if &&nursing_gg_items&n..  = "06" then _nursing_GG_&&nursing_gg_items_label&n.. = 4; 
      else if &&nursing_gg_items&n..  = "07" then _nursing_GG_&&nursing_gg_items_label&n.. = 0; 
      else if &&nursing_gg_items&n..  = "09" then _nursing_GG_&&nursing_gg_items_label&n.. = 0; 
      else if &&nursing_gg_items&n..  = "10" then _nursing_GG_&&nursing_gg_items_label&n.. = 0;       
      else if &&nursing_gg_items&n..  = "88" then _nursing_GG_&&nursing_gg_items_label&n.. = 0; 
   %end;
   
   *Take average of multiple related items;
   _nursing_avg_bed_mobility = (_nursing_GG_SIT + _nursing_GG_LYNG)/2;
   _nursing_avg_transfer     = (_nursing_GG_STAND + _nursing_GG_CHR_TRNSF + _nursing_GG_TOILT_TRNSF)/3;   
   
   *Sum item scores to create total nursing function score and round to the nearest integer;   
   nursing_function_score      = round(_nursing_GG_EATG + _nursing_GG_TOILT_HYGNE + _nursing_avg_bed_mobility + _nursing_avg_transfer);
   
%mend;