/*************************************************************************;
%** PROGRAM: create_i8000_condition_flgs.sas
%** PURPOSE: Flag SLP and NTA conditions for ICD-10-CM codes recorded in 
%**          MDS item I8000.
%** DATE Created: 07/27/2018
%** NOTES: Program is called by assign_assessments_to_cmgs.sas  
%** 
%** RESTRICTED RIGHTS NOTICE (SEPT 2014)
%** (a) This computer software is submitted with restricted rights under Government Agreement No. CMS: DataLink 3 OY1. It may not be used, reproduced, or disclosed by the Government except as provided in paragraph (b) of this Notice or as otherwise expressly stated in the agreement. 
%** (b) This computer software may be:
%**    (1) Used or copied for use in or with the computer or computers for which it was acquired, including use at any Government installation to which such computer or computers may be transferred; 
%**    (2) Used or copied for use in a backup computer if any computer for which it was acquired is inoperative; 
%**    (3) Reproduced for safekeeping (archives) or backup purposes; 
%**    (4) Modified, adapted, or combined with other computer software, provided that the modified, combined, or adapted portions of the derivative software are made subject to the same restricted rights; 
%**    (5) Disclosed to and reproduced for use by support service Recipients in accordance with subparagraphs (b)(1) through (4) of this clause, provided the Government makes such disclosure or reproduction subject to these restricted rights; and
%**    (6) Used or copied for use in or transferred to a replacement computer. 
%** (c) Notwithstanding the foregoing, if this computer software is published copyrighted computer software, it is licensed to the Government, without disclosure prohibitions, with the minimum rights set forth in paragraph (b) of this clause. 
%** (d) Any other rights or limitations regarding the use, duplication, or disclosure of this computer software are to be expressly stated in, or incorporated in, the agreement. 
%** (e) This Notice shall be marked on any reproduction of this computer software, in whole or in part. 
%** (End of notice)  
%*************************************************************************/
%macro create_i8000_condition_flgs(); 

   *Loop through i8000 items to create temporary condition variable for each i8000 item;      
   %do i = 1 %to &nmds_i8000s.;  
      %let mds_i8000 = &&mds_i8000s&i..;
      %*Remove all characters from i8000 items;
      &mds_i8000. = compress(&mds_i8000.,"^.");   
      %*Loop through comorbidity mappings;
      %do h= 1 %to &nmap_hash_names.; 
         %let map_hash_name=&&map_hash_names&h..;      
         _rc = &map_hash_name..find(key:&mds_i8000.);
         _has_more = 0;
         if _rc = 0 then do;
            _first_condition_&i. = condition;
            &map_hash_name..has_next(result:_has_more);
            do while(_has_more >0);
               _rc = &map_hash_name..find_next(result:_has_more);
               if _rc = 0 then _second_condition_&i. = condition;
               &map_hash_name..has_next(result:_has_more);   
            end; %*close do while loop;
         end; %*close rc= 0 do block;  
      %end; %*close component do loop;       
   %end; %*close i8000 do loop;  

   *Create binary condition flags for NTA comorbidities and SLP comorbidities;
   %do a= 1 %to &nall_conditions.;
      &&all_conditions&a.. = 0;      
      %do i = 1 %to &nmds_i8000s.;   
         if _first_condition_&i. = "&&all_conditions&a.." then &&all_conditions&a.. = 1;   
         if _second_condition_&i = "&&all_conditions&a.." then &&all_conditions&a.. = 1;          
      %end; %*close i8000 do loop; 
   %end; %*close comorbidity do loop;     

%mend;
