/*************************************************************************;
%** PROGRAM: Ref_Loop
%** PURPOSE: A macro that enables looping through elements in an array.
%** DATE CREATED: 01/17/2017 
%** DATE LAST MODIFIED: 11/12/2018
%** RESTRICTED RIGHTS NOTICE (SEPT 2014)
%** (a) This computer software is submitted with restricted rights under Government Agreement No. CMS: DataLink 3 OY1. It may not be used, reproduced, or disclosed by the Government except as provided in paragraph (b) of this Notice or as otherwise expressly stated in the agreement. 
%** (b) This computer software may be 
%** (1) Used or copied for use in or with the computer or computers for which it was acquired, including use at any Government installation to which such computer or computers may be transferred;  
%** (2) Used or copied for use in a backup computer if any computer for which it was acquired is inoperative;  
%** (3) Reproduced for safekeeping (archives) or backup purposes;  
%** (4) Modified, adapted, or combined with other computer software, provided that the modified, combined, or adapted portions of the derivative software are made subject to the same restricted rights;  
%** (5) Disclosed to and reproduced for use by support service Recipients in accordance with subparagraphs (b)(1) through (4) of this clause, provided the Government makes such disclosure or reproduction subject to these restricted rights; and 
%** (6) Used or copied for use in or transferred to a replacement computer.  
%** (c) Notwithstanding the foregoing, if this computer software is published copyrighted computer software, it is licensed to the Government, without disclosure prohibitions, with the minimum rights set forth in paragraph (b) of this clause. 
%** (d) Any other rights or limitations regarding the use, duplication, or disclosure of this computer software are to be expressly stated in, or incorporated in, the agreement.  
%** (e) This Notice shall be marked on any reproduction of this computer software, in whole or in part. 
%** (End of notice)
%*************************************************************************/
%macro ref_loop (
                 group_name     , 
                 elements       ,
                 dlm            = %STR( ),
                 print_to_log  = 1
                ); 
           
   %global n&group_name.; 
   
   %put Character Loop string is &elements.; 
   
   *(1) Counting the number of elements in the character loop string and feeding it into a macrovariable; 
   %*This macrovariable will help us to loop through the elements using a percent do loop; 
   %if &dlm. = %STR() %then %let n&group_name. = %sysfunc(countw(&elements.));
   %else %let n&group_name =  %sysfunc(countw("&elements.", "&dlm."));
   %put Number of elements in character loop string = &&n&group_name.; 

   *(2) Assigning each element of the character loop string to a macrovariable;
   %*These macrovariables will be used to refer to the elements of the string; 
   data _NULL_;       
      %do e = 1 %to &&n&group_name.; %*Looping through the elements of the string; 
         %put &group_name.&e.;
         %global &group_name.&e.; 
         length elementnumber elementname $10000.; 
         %*Equating variable elementnumber to the macrovariable name corresponding to the element of the string being looped through;
         elementnumber = "&group_name.&e."; 
         %*Equating variable elementname to the actual element of the string being looped through; 
         elementname = scan("&elements.", &e., "&dlm."); 
         %*Feeding the actual element of the string being looped through into a macrovariable corresponding to the elementnumber value; 
         call symputx ("&group_name.&e.", elementname); 
      %end; 
   run; 
   
   %*Listing the elements of the character loop string if requested by the user; 
   %if &print_to_log. = 1 %then %do; 
      %do e = 1 %to &&n&group_name.; 
         %put element&e. is &&&group_name&e..;      
      %end; 
   %end; 
%mend;
