
* PROGRAM: COST_SHARING_ER.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR ER CLAIMS;


%MACRO ER_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
    WHERE CATEGORY IN('4b');
    CLASS BASEID YEAR;
    VAR AMTTOT;
    OUTPUT OUT=CAT_SUMMARY (DROP=_TYPE_ _FREQ_) SUM=;
  RUN;
    
  %obsnvars(CAT_SUMMARY);
  
  DATA FMTDATA;
    SET CAT_SUMMARY END=LAST;
    LENGTH HLO $1 START $12;
    FMTNAME='$CATFMT';
    START=BASEID || YEAR;
    LABEL=AMTTOT;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL=0;
      HLO='O';
      OUTPUT;
    END;
    KEEP FMTNAME START LABEL HLO;
  RUN;
    
  PROC FORMAT CNTLIN=FMTDATA;
  RUN;

  DATA ER_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='4a'));
  RUN;
 
  DATA ER_FILE;
    SET  PBP_FILE(KEEP =
                  CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                  PBP_B4A_MAXENR_AMT PBP_B4A_MAXENR_PER
                  PBP_B4A_COPAY_AMT_MC_MIN PBP_B4A_COINS_PCT_MC_MIN 
                  PBP_B4B_MAXENR_AMT
                  PBP_B4B_MAXENR_TYPE
                  PBP_B4B_MAXENR_PER
                  PBP_A_PLAN_TYPE
                  );
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B4A_MAXENR_PER,PBP_B4A_MAXENR_AMT);
    %ANNUALIZATION(PBP_B4B_MAXENR_PER,PBP_B4B_MAXENR_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM ER_BASEID B, ER_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
         PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='4a'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;

    IF PBP_B4A_MAXENR_AMT NE . THEN 
      BENE_MAXIMUM = PBP_B4A_MAXENR_AMT;

    BASEIDYR=BASEID || YEAR;
    IF PBP_B4B_MAXENR_AMT = . AND PBP_B4B_MAXENR_TYPE = '1' THEN DO;
      %IF "&NOBS." > "0" %THEN %DO;
        AMTTOTU=INPUT(PUT(BASEIDYR,$CATFMT.),8.);
      %END;
      %ELSE %DO;
        AMTTOTU=0;
      %END;
      PBPCAT_TOT=SUM(AMTTOTU,AMTTOT);
      IF PBPCAT_TOT>0 THEN 
        BENE_MAXIMUM = PBP_B4A_MAXENR_AMT*(AMTTOT/PBPCAT_TOT);
    END;
    
    COST = SUM(COST, (VISITS*PBP_B4A_COPAY_AMT_MC_MIN));
    COST = SUM(COST, (AMTTOT*PBP_B4A_COINS_PCT_MC_MIN));
  
    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
    COST = MIN(COST, BENE_MAXIMUM);

    IF PUT(HPLAN,$TYPEF.) = "MSA" THEN COST = SUM(COST, PLAN_DED_AMTTOT_MC);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "4a";
  RUN;

  PROC APPEND DATA=ER(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE ER ER_BASEID ER_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;


