
* PROGRAM: COST_SHARING_LAB.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR LAB CLAIMS;

%MACRO LAB_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
    WHERE CATEGORY IN('8a2','8a1');
    CLASS BASEID YEAR;
    VAR AMTTOT;
    OUTPUT OUT=CAT_SUMMARY (DROP=_TYPE_ _FREQ_) SUM=;
  RUN;
  
  %obsnvars(CAT_SUMMARY);
  
  DATA FMTDATA;
    SET CAT_SUMMARY END=LAST;
    LENGTH HLO $1 START $12;
    FMTNAME='$CATFMT';
    START=BASEID || YEAR;
    LABEL=AMTTOT;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL=0;
      HLO='O';
      OUTPUT;
    END;
    KEEP FMTNAME START LABEL HLO;
  RUN;
  
  PROC FORMAT CNTLIN=FMTDATA;
  RUN;
  
  DATA LAB_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='8a2'));
  RUN;

  DATA LAB_FILE;
    SET PBP_FILE (KEEP =
                  CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                  PBP_B8A_MAXENR_AMT PBP_B8A_MAXENR_PER
  
                  PBP_B8A_LAB_COPAY_AMT
                  PBP_B8A_LAB_COPAY_AMT_MAX
                  PBP_B8A_COINS_PCT_LAB
                  PBP_B8A_COINS_PCT_LAB_MAX

                  PBP_B8A_COINS_PCT_DMC
                  PBP_B8A_COINS_PCT_DMC_MAX
                  PBP_B8A_COPAY_MIN_DMC_AMT
                  PBP_B8A_COPAY_MAX_DMC_AMT

                  PBP_B8A_DED_AMT
                  PBP_B8A_COST_SHARE_COINS_YN
                  PBP_B8A_COST_SHARE_COINS_MIN
                  PBP_B8A_COST_SHARE_COPAY_YN
                  PBP_B8A_COST_SHARE_COPAY_MIN
                
                  PBP_B8A_COPAY_EHC
                  PBP_B8A_COINS_EHC
                  PBP_A_PLAN_TYPE
                  PBP_D_DIFF_DEDUCT_8A_AMT);
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B8A_MAXENR_PER,PBP_B8A_MAXENR_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM LAB_BASEID B, LAB_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      order by hplan, baseid, year, category;
    QUIT;
  RUN;
     
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='8a2'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);

    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;
    CAT_DEDUCTIBLE=0;
    
    BASEIDYR=BASEID || YEAR;
    %IF "&NOBS." > "0" %THEN %DO;
      PBPCAT_AMTTOT=INPUT(PUT(BASEIDYR,$CATFMT.),8.);
    %END;
    %ELSE %DO;
      PBPCAT_AMTTOT=0;
    %END;

    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      PBP_CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_8A_AMT;
    ELSE PBP_CAT_DEDUCTIBLE=PBP_B8A_DED_AMT;
            
    IF PLAN_DED_CAT^='1' & PBPCAT_AMTTOT>0 THEN  
      CAT_DEDUCTIBLE=PBP_CAT_DEDUCTIBLE*(AMTTOT/PBPCAT_AMTTOT);

    IF PBP_B8A_MAXENR_AMT NE . THEN 
      BENE_MAXIMUM = PBP_B8A_MAXENR_AMT;
    
    IF PBPCAT_AMTTOT>0 THEN
      BENE_MAXIMUM=BENE_MAXIMUM*(AMTTOT/PBPCAT_AMTTOT);

    IF CAT_DEDUCTIBLE = . THEN DO;
      IF SUBSTR(PBP_B8A_COPAY_EHC,1,1) = '1' THEN 
        COST = SUM(COST,(VISITS*PBP_B8A_LAB_COPAY_AMT));
      IF SUBSTR(PBP_B8A_COINS_EHC,1,1) = '1' THEN 
        COST = SUM(COST,(AMTTOT*PBP_B8A_COINS_PCT_LAB));
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        IF SUBSTR(PBP_B8A_COPAY_EHC,1,1) = '1' THEN 
          COST = SUM(COST,(VISITS*PBP_B8A_LAB_COPAY_AMT));
        IF SUBSTR(PBP_B8A_COINS_EHC,1,1) = '1' THEN 
          COST = SUM(COST,(AMTTOT*PBP_B8A_COINS_PCT_LAB));
      END;
    END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
      COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "8a2";
  RUN;

  PROC APPEND DATA=LAB(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE LAB LAB_BASEID LAB_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;


