
* PROGRAM: COST_SHARING_MEDICARE_DRUGS_CHEMO.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR MEDICARE DRUGS CHEMO CLAIMS;

%MACRO CHEMO_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
    WHERE CATEGORY IN('15m','15c');
    CLASS BASEID YEAR;
    VAR AMTTOT;
    OUTPUT OUT=CAT_SUMMARY (DROP=_TYPE_ _FREQ_) SUM=;
  RUN;
  
  %obsnvars(CAT_SUMMARY);
  
  DATA FMTDATA;
    SET CAT_SUMMARY END=LAST;
    LENGTH HLO $1 START $12;
    FMTNAME='$CATFMT';
    START=BASEID || YEAR;
    LABEL=AMTTOT;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL=0;
       HLO='O';
      OUTPUT;
    END;
    KEEP FMTNAME START LABEL HLO;
  RUN;
  
  PROC FORMAT CNTLIN=FMTDATA;
  RUN;
  
  DATA CHEMO_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='15c'));
  RUN;
 
  DATA CHEMO_FILE;
    SET PBP_FILE (KEEP =
                  CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                  PBP_A_PLAN_TYPE
                  PBP_B20_B_COINS_MIN_PCT
                  PBP_B20_B_MIN_COPAY
                  PBP_B20_COINS_MC_PCT
                  PBP_B20_COPAY_MIN_MC_AMT
                  PBP_B20_DED_AMT
                  MRX_B_COINS_PCT
                  MRX_B_COPAY_MIN_AMT
                  MRX_B_CHEMO_COINS_PCT
                  MRX_B_CHEMO_COPAY_AMT
                  MRX_B_DED_AMT
                  MRX_B_MAX_OOP_AMT
                  MRX_B_MAX_OOP_PER
                  PBP_B20_COPAY_MC_EHC
                  PBP_B20_COINS_MC_EHC
                  MRX_B_COPAY_EHC
                  MRX_B_COINS_EHC
                  PBP_A_PLAN_TYPE
                  PBP_D_DIFF_DEDUCT_15_AMT);
    JOIN_ID = '1';
    %ANNUALIZATION(MRX_B_MAX_OOP_PER,MRX_B_MAX_OOP_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM CHEMO_BASEID B, CHEMO_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;
     
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='15c'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);

    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;
    CAT_DEDUCTIBLE=0;
        
    BASEIDYR=BASEID || YEAR;
    %IF "&NOBS." > "0" %THEN %DO;
      PBPCAT_AMTTOT=INPUT(PUT(BASEIDYR,$CATFMT.),8.);
    %END;
    %ELSE %DO;
      PBPCAT_AMTTOT=0;
    %END;

    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      PBP_CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_15_AMT;
    ELSE PBP_CAT_DEDUCTIBLE=MRX_B_DED_AMT;
                
    IF PLAN_DED_CAT^='1' & PBPCAT_AMTTOT>0 THEN 
      CAT_DEDUCTIBLE=PBP_CAT_DEDUCTIBLE*(AMTTOT/PBPCAT_AMTTOT);

    IF MRX_B_MAX_OOP_AMT ^ = . THEN BENE_MAX = MRX_B_MAX_OOP_AMT;
    
    IF PBPCAT_AMTTOT>0 THEN
      BENE_MAX=BENE_MAX*(AMTTOT/PBPCAT_AMTTOT);

    IF CAT_DEDUCTIBLE = . THEN DO;
      IF SUBSTR(PBP_B20_COPAY_MC_EHC,2,1)='1' THEN 
        COST = SUM(COST,(VISITS*PBP_B20_COPAY_MIN_MC_AMT));
      IF SUBSTR(MRX_B_COPAY_EHC,2,1)='1' THEN 
        COST = SUM(COST,(VISITS*MRX_B_CHEMO_COPAY_AMT));
      IF SUBSTR(PBP_B20_COINS_MC_EHC,2,1)='1' THEN 
        COST = SUM(COST,(AMTTOT*PBP_B20_COINS_MC_PCT)); 
      IF SUBSTR(MRX_B_COINS_EHC,2,1)='1' THEN 
        COST = SUM(COST,(AMTTOT*MRX_B_CHEMO_COINS_PCT));
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        IF SUBSTR(PBP_B20_COPAY_MC_EHC,2,1)='1' THEN 
          COST = SUM(COST,(VISITS*PBP_B20_COPAY_MIN_MC_AMT));
        IF SUBSTR(MRX_B_COPAY_EHC,2,1)='1' THEN 
          COST = SUM(COST,(VISITS*MRX_B_CHEMO_COPAY_AMT));
        IF SUBSTR(PBP_B20_COINS_MC_EHC,2,1)='1' THEN 
          COST = SUM(COST,(AMTTOT*PBP_B20_COINS_MC_PCT)); 
        IF SUBSTR(MRX_B_COINS_EHC,2,1)='1' THEN 
          COST = SUM(COST,(AMTTOT*MRX_B_CHEMO_COINS_PCT));
      END;
    END;
    
    IF BENE_MAX >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAX);

    COST_SHARE_COST = COST;
    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "15c";
  RUN;

  PROC APPEND DATA=CHEMO(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE CHEMO CHEMO_BASEID CHEMO_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;

