* PROGRAM: COST_SHARING_SNF.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR SNF CLAIMS;


%MACRO SNF_COST_SHARE(SERV_CAT);

  DATA SNF_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='2'));
  RUN;
  
  PROC SUMMARY DATA=SNF_BASEID NWAY MISSING;
    CLASS BASEID YEAR;
    OUTPUT OUT=BENESUM (DROP=_TYPE_ RENAME=_FREQ_=STAYCNT);
  RUN;
    
  PROC SORT DATA=SNF_BASEID;
    BY BASEID YEAR;  
  RUN;
    
  DATA SNF_BASEID (DROP=STAYCNT);
    MERGE SNF_BASEID (IN=A DROP=AMTTOT)
    BENESUM (IN=B);
    BY BASEID YEAR;
    IF A & B;
    *AMTTOT_PHYSICIAN=AMTTOT_PHYSICIAN/STAYCNT;
    AMTTOT=SUM(AMTTOT_FACILITY,AMTTOT_PHYSICIAN);
  RUN;

  DATA SNF_FILE;
    SET  PBP_FILE (KEEP =
         CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
         PBP_B2_BENDESC_YN
         PBP_B2_COINS_YN
         PBP_B2_MDCR_COINS_CSTSHRS_YN
         PBP_B2_COPAY_YN
         PBP_B2_MDCR_COPAY_CSTSHRS_YN
         PBP_B2_COPAY_MCS_AMT
         PBP_B2_COPAY_MCS_AMT_INTRVL1 - PBP_B2_COPAY_MCS_AMT_INTRVL3
         PBP_B2_COPAY_MCS_BGND_INTRVL1 - PBP_B2_COPAY_MCS_BGND_INTRVL3
         PBP_B2_COPAY_MCS_ENDD_INTRVL1 - PBP_B2_COPAY_MCS_ENDD_INTRVL3
 
         PBP_B2_COPAY_NMCS_AMT
         PBP_B2_COPAY_NMCS_AMT_INTRVL1 - PBP_B2_COPAY_NMCS_AMT_INTRVL3
         PBP_B2_COPAY_NMCS_BGND_INTRVL1 - PBP_B2_COPAY_NMCS_BGND_INTRVL3
         PBP_B2_COPAY_NMCS_ENDD_INTRVL1 - PBP_B2_COPAY_NMCS_ENDD_INTRVL3

         PBP_B2_COINS_MCS_PCT
         PBP_B2_COINS_MCS_PCT_INTRVL1 - PBP_B2_COINS_MCS_PCT_INTRVL3
         PBP_B2_COINS_MCS_BGND_INTRVL1 - PBP_B2_COINS_MCS_BGND_INTRVL3
         PBP_B2_COINS_MCS_ENDD_INTRVL1 - PBP_B2_COINS_MCS_ENDD_INTRVL3

         PBP_B2_COINS_NMCS_PCT
         PBP_B2_COINS_NMCS_PCT_INTRVL1 - PBP_B2_COINS_NMCS_PCT_INTRVL3
         PBP_B2_COINS_NMCS_BGND_INTRVL1 - PBP_B2_COINS_NMCS_BGND_INTRVL3
         PBP_B2_COINS_NMCS_ENDD_INTRVL1 - PBP_B2_COINS_NMCS_ENDD_INTRVL3

         PBP_B2_BENDESC_AMO_AD
 
         PBP_B2_COPAY_AD_AMT_INTRVL1 - PBP_B2_COPAY_AD_AMT_INTRVL3
         PBP_B2_COPAY_AD_BGND_INTRVL1 - PBP_B2_COPAY_AD_BGND_INTRVL3
         PBP_B2_COPAY_AD_ENDD_INTRVL1 - PBP_B2_COPAY_AD_ENDD_INTRVL3

         PBP_B2_MAXENR_AMT PBP_B2_MAXENR_PER
 
         PBP_B2_COINS_AD_PCT_INTRVL1 - PBP_B2_COINS_AD_PCT_INTRVL3
         PBP_B2_COINS_AD_BGND_INTRVL1 - PBP_B2_COINS_AD_BGND_INTRVL3
         PBP_B2_COINS_AD_ENDD_INTRVL1 - PBP_B2_COINS_AD_ENDD_INTRVL3
 
         PBP_B2_DED_AMT
         PBP_B2_BENEDESC_LIM_AD
         PBP_B2_BENDESC_AD
         PBP_B2_COINS_NMCS_STRUC_YN
         PBP_B2_COPAY_NMCS_STRUC_YN
         PBP_B2_BENDESC_AMO_NMCS
         PBP_A_PLAN_TYPE
         PBP_D_DIFF_DEDUCT_2_AMT);

    JOIN_ID = '1';
  
    * DEFINE THE MEDICARE DEFINED AMOUNTS;
    IF (PBP_B2_MDCR_COINS_CSTSHRS_YN='1' OR PBP_B2_MDCR_COPAY_CSTSHRS_YN='1') THEN DO;
      PBP_B2_COPAY_MCS_AMT_INTRVL1 = &B2_COPAY_AMT_INT1.;
      PBP_B2_COPAY_MCS_AMT_INTRVL2 = &B2_COPAY_AMT_INT2.;
      PBP_B2_COPAY_MCS_BGND_INTRVL1 = &B2_COPAY_BGND_INT1.;
      PBP_B2_COPAY_MCS_BGND_INTRVL2 = &B2_COPAY_BGND_INT2.;
      PBP_B2_COPAY_MCS_BGND_INTRVL3 = &B2_COPAY_BGND_INT3.;
      PBP_B2_COPAY_MCS_ENDD_INTRVL1 = &B2_COPAY_ENDD_INT1.;
      PBP_B2_COPAY_MCS_ENDD_INTRVL2 = &B2_COPAY_ENDD_INT2.;
      PBP_B2_COPAY_MCS_ENDD_INTRVL3 = &B2_COPAY_ENDD_INT3.;
    END;
  
    IF PBP_B2_MAXENR_AMT NE . THEN DO;
      IF PBP_B2_MAXENR_PER = '1' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B2_MAXENR_PER = '2' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B2_MAXENR_PER = '3' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B2_MAXENR_PER = '4' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B2_MAXENR_PER = '5' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B2_MAXENR_PER = '6' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT; * EVERY STAY;
      ELSE IF PBP_B2_MAXENR_PER = '7' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT; * OTHER;
    END;
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.YEAR, B.UTLZNDAY, B.TOTDAYS, B.LRDAYS, B.AMTTOT, B.AMTTOT_FACILITY, B.FIRST_STAY, P.*
      FROM SNF_BASEID B, SNF_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='2'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;


  PROC SORT;
    BY HPLAN BASEID DESCENDING FIRST_STAY;
  RUN;

  DATA &SERV_CAT;
    LENGTH CATEGORY $3;
    RETAIN PBP_DEDUCTIBLE;
    SET CAT_JOIN (DROP = JOIN_ID);
    BY HPLAN BASEID DESCENDING FIRST_STAY;
    IF FIRST.BASEID THEN PBP_DEDUCTIBLE = .;

    IF PUT(HPLAN,$TYPEF.) IN('FFS','MGAP') THEN AMTTOT=AMTTOT_FACILITY;
    AMTTOT_PER_DAY = AMTTOT / TOTDAYS;

    IF PBP_B2_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B2_MAXENR_AMT;

    IF PBP_B2_COPAY_AD_ENDD_INTRVL1 = 999 THEN PBP_B2_COPAY_AD_ENDD_INTRVL1 = SUM(TOTDAYS,PBP_B2_COPAY_AD_BGND_INTRVL1-1);
    ELSE IF PBP_B2_COPAY_AD_ENDD_INTRVL2 = 999 THEN PBP_B2_COPAY_AD_ENDD_INTRVL2 = SUM(TOTDAYS,PBP_B2_COPAY_AD_BGND_INTRVL1-1);
    ELSE IF PBP_B2_COPAY_AD_ENDD_INTRVL3 = 999 THEN PBP_B2_COPAY_AD_ENDD_INTRVL3 = SUM(TOTDAYS,PBP_B2_COPAY_AD_BGND_INTRVL1-1);

    IF PBP_B2_COINS_AD_ENDD_INTRVL1 = 999 THEN PBP_B2_COINS_AD_ENDD_INTRVL1 = SUM(TOTDAYS,PBP_B2_COINS_AD_BGND_INTRVL1-1);
    ELSE IF PBP_B2_COINS_AD_ENDD_INTRVL2 = 999 THEN PBP_B2_COINS_AD_ENDD_INTRVL2 = SUM(TOTDAYS,PBP_B2_COINS_AD_BGND_INTRVL1-1);
    ELSE IF PBP_B2_COINS_AD_ENDD_INTRVL3 = 999 THEN PBP_B2_COINS_AD_ENDD_INTRVL3 = SUM(TOTDAYS,PBP_B2_COINS_AD_BGND_INTRVL1-1);

    STAY_COST_MC  = 0;
    STAY_COST_AMO = 0;
    DAY_COST_MC   = 0;
    DAY_COST_AMO  = 0;

    * MEDICARE COVERED STAY;
    IF UTLZNDAY > 0 THEN DO;

      IF FIRST_STAY = 1 THEN DO;
        IF PLAN_DED_CAT='1' THEN DO;
          IF PLAN_DED_AMTTOT_MC_PTA>0 THEN PBP_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTA;
          ELSE PBP_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
        END;
        ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN PBP_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_2_AMT;
        ELSE PBP_DEDUCTIBLE = PBP_B2_DED_AMT;
      END;

      IF PBP_DEDUCTIBLE > 0 THEN DO;
        IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
          STAY_COST = AMTTOT;
          MEDICARE_COVERED_DAYS = 0;
          ADDITIONAL_DAYS = 0;
          PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
        END;
        ELSE DO;
          AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
          STAY_COST = SUM(PBP_B2_COPAY_MCS_AMT, AMTTOT * PBP_B2_COINS_MCS_PCT, PBP_DEDUCTIBLE);
          MEDICARE_COVERED_DAYS = UTLZNDAY;
          ADDITIONAL_DAYS = SUM(TOTDAYS, -MEDICARE_COVERED_DAYS );
          PBP_DEDUCTIBLE = 0;
        END;
      END;
      ELSE DO;
        STAY_COST    = SUM(PBP_B2_COPAY_MCS_AMT, AMTTOT * PBP_B2_COINS_MCS_PCT);
        MEDICARE_COVERED_DAYS = UTLZNDAY;
        ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
      END;

      STAY_COST_MC = STAY_COST;

      IF MEDICARE_COVERED_DAYS > 0 THEN DO;
        N1 = PBP_B2_COPAY_MCS_ENDD_INTRVL1 - PBP_B2_COPAY_MCS_BGND_INTRVL1 + 1;
        N2 = PBP_B2_COPAY_MCS_ENDD_INTRVL2 - PBP_B2_COPAY_MCS_BGND_INTRVL2 + 1;
        N3 = PBP_B2_COPAY_MCS_ENDD_INTRVL3 - PBP_B2_COPAY_MCS_BGND_INTRVL3 + 1;

        DAY_COPAY = .;
        IF PBP_B2_COPAY_MCS_ENDD_INTRVL3 > 0 AND
          MEDICARE_COVERED_DAYS > PBP_B2_COPAY_MCS_ENDD_INTRVL3 THEN DO;
          DAY_COPAY = N1 * PBP_B2_COPAY_MCS_AMT_INTRVL1;
          DAY_COPAY = SUM( DAY_COPAY, N2 * PBP_B2_COPAY_MCS_AMT_INTRVL2);
          DAY_COPAY = SUM( DAY_COPAY, N3 * PBP_B2_COPAY_MCS_AMT_INTRVL3);
        END;
        ELSE IF PBP_B2_COPAY_MCS_ENDD_INTRVL2 > 0 AND
          MEDICARE_COVERED_DAYS > PBP_B2_COPAY_MCS_ENDD_INTRVL2 THEN DO;
          DAY_COPAY = N1 * PBP_B2_COPAY_MCS_AMT_INTRVL1;
          DAY_COPAY = SUM(DAY_COPAY, N2 * PBP_B2_COPAY_MCS_AMT_INTRVL2);
          DAY_COPAY = SUM(DAY_COPAY, ((MEDICARE_COVERED_DAYS - (N1 + N2)) *
                                                    PBP_B2_COPAY_MCS_AMT_INTRVL3));
        END;
        ELSE IF PBP_B2_COPAY_MCS_ENDD_INTRVL1 > 0 AND
          MEDICARE_COVERED_DAYS > PBP_B2_COPAY_MCS_ENDD_INTRVL1 THEN DO;
          DAY_COPAY = N1 * PBP_B2_COPAY_MCS_AMT_INTRVL1;
          DAY_COPAY = SUM(DAY_COPAY, ((MEDICARE_COVERED_DAYS - N1) *
                                                    PBP_B2_COPAY_MCS_AMT_INTRVL2));
        END;
        ELSE DO;
          DAY_COPAY = MEDICARE_COVERED_DAYS * PBP_B2_COPAY_MCS_AMT_INTRVL1;
        END;

        N1 = PBP_B2_COINS_MCS_ENDD_INTRVL1 - PBP_B2_COINS_MCS_BGND_INTRVL1 + 1;
        N2 = PBP_B2_COINS_MCS_ENDD_INTRVL2 - PBP_B2_COINS_MCS_BGND_INTRVL2 + 1;
        N3 = PBP_B2_COINS_MCS_ENDD_INTRVL3 - PBP_B2_COINS_MCS_BGND_INTRVL3 + 1;

        DAY_COINS = .;
        IF PBP_B2_COINS_MCS_ENDD_INTRVL3 > 0 AND
          MEDICARE_COVERED_DAYS > PBP_B2_COINS_MCS_ENDD_INTRVL3 THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
          DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL2);
          DAY_COINS = SUM(DAY_COINS, N3 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL3);
        END;
        ELSE IF PBP_B2_COINS_MCS_ENDD_INTRVL2 > 0 AND
          MEDICARE_COVERED_DAYS > PBP_B2_COINS_MCS_ENDD_INTRVL2 THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
          DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL2);
          DAY_COINS = SUM(DAY_COINS, (MEDICARE_COVERED_DAYS - (N1 + N2)) * AMTTOT_PER_DAY *
                                                    PBP_B2_COINS_MCS_PCT_INTRVL3);
        END;
        ELSE IF PBP_B2_COINS_MCS_ENDD_INTRVL1 > 0 AND
          MEDICARE_COVERED_DAYS > PBP_B2_COINS_MCS_ENDD_INTRVL1 THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
          DAY_COINS = SUM(DAY_COINS, (MEDICARE_COVERED_DAYS - N1)* AMTTOT_PER_DAY *
                                                    PBP_B2_COINS_MCS_PCT_INTRVL2);
        END;
        ELSE DO;
          DAY_COINS = MEDICARE_COVERED_DAYS * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
        END;

        DAY_COST    = SUM(DAY_COPAY, DAY_COINS);
        DAY_COST_MC = SUM(DAY_COPAY, DAY_COINS);
      END; * MEDICARE_COVERED_DAYS > 0;

      IF ADDITIONAL_DAYS > 0 THEN DO;

        IF PBP_B2_BENDESC_AMO_AD IN ('1','2') THEN DO;

          IF PBP_B2_BENEDESC_LIM_AD = '1' THEN
            PLAN_MAX_AD = 999;
          ELSE
            PLAN_MAX_AD = PBP_B2_BENDESC_AD;

          IF ADDITIONAL_DAYS <= PLAN_MAX_AD THEN DO;
            DAYS = ADDITIONAL_DAYS;
          END;
          ELSE DO;
            DAYS = PLAN_MAX_AD;
            NONCOVERED_DAYS = SUM( ADDITIONAL_DAYS, -PLAN_MAX_AD );
          END;

          N1 = PBP_B2_COPAY_AD_ENDD_INTRVL1 - PBP_B2_COPAY_AD_BGND_INTRVL1 + 1;
          N2 = PBP_B2_COPAY_AD_ENDD_INTRVL2 - PBP_B2_COPAY_AD_BGND_INTRVL2 + 1;
          N3 = PBP_B2_COPAY_AD_ENDD_INTRVL3 - PBP_B2_COPAY_AD_BGND_INTRVL3 + 1;

          AD_COPAY = .;
          IF PBP_B2_COPAY_AD_ENDD_INTRVL3 > 0 AND
            DAYS > SUM(PBP_B2_COPAY_AD_ENDD_INTRVL3,-(PBP_B2_COPAY_AD_BGND_INTRVL1-1)) THEN DO;
            AD_COPAY = N1 * PBP_B2_COPAY_AD_AMT_INTRVL1;
            AD_COPAY = SUM(AD_COPAY, N2 * PBP_B2_COPAY_AD_AMT_INTRVL2);
            AD_COPAY = SUM(AD_COPAY, N3 * PBP_B2_COPAY_AD_AMT_INTRVL3);
          END;
          ELSE IF PBP_B2_COPAY_AD_ENDD_INTRVL2 > 0 AND
            DAYS > SUM(PBP_B2_COPAY_AD_ENDD_INTRVL2,-(PBP_B2_COPAY_AD_BGND_INTRVL1-1)) THEN DO;
            AD_COPAY = N1 * PBP_B2_COPAY_AD_AMT_INTRVL1;
            AD_COPAY = SUM(AD_COPAY, N2 * PBP_B2_COPAY_AD_AMT_INTRVL2);
            AD_COPAY = SUM(AD_COPAY, ((DAYS - (N1 + N2)) * PBP_B2_COPAY_AD_AMT_INTRVL3));
          END;
          ELSE IF PBP_B2_COPAY_AD_ENDD_INTRVL1 > 0 AND
            DAYS > SUM(PBP_B2_COPAY_AD_ENDD_INTRVL1,-(PBP_B2_COPAY_AD_BGND_INTRVL1-1)) THEN DO;
            AD_COPAY = N1 * PBP_B2_COPAY_AD_AMT_INTRVL1;
            AD_COPAY = SUM(AD_COPAY, ((DAYS - N1) * PBP_B2_COPAY_AD_AMT_INTRVL2));
          END;
          ELSE DO;
            AD_COPAY = DAYS  * PBP_B2_COPAY_AD_AMT_INTRVL1;
          END;

          N1 = PBP_B2_COINS_AD_ENDD_INTRVL1 - PBP_B2_COINS_AD_BGND_INTRVL1 + 1;
          N2 = PBP_B2_COINS_AD_ENDD_INTRVL2 - PBP_B2_COINS_AD_BGND_INTRVL2 + 1;
          N3 = PBP_B2_COINS_AD_ENDD_INTRVL3 - PBP_B2_COINS_AD_BGND_INTRVL3 + 1;

          AD_COINS = .;
          IF PBP_B2_COINS_AD_ENDD_INTRVL3 > 0 AND
            DAYS > SUM(PBP_B2_COINS_AD_ENDD_INTRVL3,-(PBP_B2_COINS_AD_BGND_INTRVL1-1)) THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL1;
            AD_COINS = SUM(AD_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL2);
            AD_COINS = SUM(AD_COINS, N3 * AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL3);
          END;
          ELSE IF PBP_B2_COINS_AD_ENDD_INTRVL2 > 0 AND
            DAYS > SUM(PBP_B2_COINS_AD_ENDD_INTRVL2,-(PBP_B2_COINS_AD_BGND_INTRVL1-1)) THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL1;
            AD_COINS = SUM(AD_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL2);
            AD_COINS = SUM(AD_COPAY, (DAYS - (N1 + N2)) * (AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL3));
          END;
          ELSE IF PBP_B2_COINS_AD_ENDD_INTRVL1 > 0 AND
            DAYS > SUM(PBP_B2_COINS_AD_ENDD_INTRVL1,-(PBP_B2_COINS_AD_BGND_INTRVL1-1)) THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL1;
            AD_COINS = SUM(AD_COPAY, (DAYS - N1) * (AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL2));
          END;
          ELSE DO;
            AD_COINS = DAYS * (AMTTOT_PER_DAY * PBP_B2_COINS_AD_PCT_INTRVL1);
          END;

          DAY_COST     = SUM(DAY_COST, AD_COPAY, AD_COINS);
          DAY_COST_AMO = SUM(DAY_COST_AMO, AD_COPAY, AD_COINS);

        END; * IF PBP_B2_BENDESC_AMO_AD IN ('1','2');
        ELSE DO;
          NONCOVERED_DAYS = ADDITIONAL_DAYS;
        END;

        IF NONCOVERED_DAYS > 0 THEN DO;
          NONCOV_COST = NONCOVERED_DAYS * AMTTOT_PER_DAY;
        END;

      END; * IF ADDITIONAL_DAYS > 0;

    END; * IF UTLZNDAY > 0;
    ELSE DO;

      STAY_COST = .;
      DAY_COPAY = .;
      DAY_COINS = .;

      IF PBP_B2_BENDESC_AMO_NMCS IN ('1','2') THEN DO;

        * NMCS COPAY STRUCTURE SAME AS MCS;
        IF PBP_B2_COPAY_NMCS_STRUC_YN = '1' THEN DO;

          IF FIRST_STAY = 1 THEN DO;
            IF PLAN_DED_CAT='1' THEN DO;
	      PLAN_DED_AMTTOT_AMO_PTA=SUM(PLAN_DEDUCT_PTA,-PLAN_DED_AMTTOT_MC_PTA);
	      IF PLAN_DED_AMTTOT_AMO_PTA>0 THEN PBP_DEDUCTIBLE=PLAN_DED_AMTTOT_AMO_PTA;
	      ELSE PBP_DEDUCTIBLE=SUM(PLAN_DED_AMTTOT,-PLAN_DED_AMTTOT_MC);
            END;
            ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN PBP_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_2_AMT;
            ELSE PBP_DEDUCTIBLE = PBP_B2_DED_AMT;
          END;

          IF PBP_DEDUCTIBLE > 0 THEN DO;
            IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
              STAY_COST = AMTTOT;
              ADDITIONAL_DAYS = 0;
              PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
            END;
            ELSE DO;
              AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
              STAY_COST = SUM(PBP_B2_COPAY_MCS_AMT, AMTTOT * PBP_B2_COINS_MCS_PCT, PBP_DEDUCTIBLE);
              ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
              PBP_DEDUCTIBLE = 0;
            END;
          END;
          ELSE DO;
            STAY_COST    = SUM(PBP_B2_COPAY_MCS_AMT, AMTTOT * PBP_B2_COINS_MCS_PCT);
            ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
          END;

          STAY_COST_AMO = STAY_COST;

          N1 = PBP_B2_COPAY_MCS_ENDD_INTRVL1 - PBP_B2_COPAY_MCS_BGND_INTRVL1 + 1;
          N2 = PBP_B2_COPAY_MCS_ENDD_INTRVL2 - PBP_B2_COPAY_MCS_BGND_INTRVL2 + 1;
          N3 = PBP_B2_COPAY_MCS_ENDD_INTRVL3 - PBP_B2_COPAY_MCS_BGND_INTRVL3 + 1;

          DAY_COPAY = .;
          IF (PBP_B2_COPAY_MCS_ENDD_INTRVL3 > 0) AND
            (TOTDAYS > PBP_B2_COPAY_MCS_ENDD_INTRVL3) THEN DO;
            DAY_COPAY = N1 * PBP_B2_COPAY_MCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, N2 * PBP_B2_COPAY_MCS_AMT_INTRVL2);
            DAY_COPAY = SUM(DAY_COPAY, N3 * PBP_B2_COPAY_MCS_AMT_INTRVL3);
          END;
          ELSE IF (PBP_B2_COPAY_MCS_ENDD_INTRVL2 > 0) AND
            (TOTDAYS > PBP_B2_COPAY_MCS_ENDD_INTRVL2) THEN DO;
            DAY_COPAY = N1 * PBP_B2_COPAY_MCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, N2 * PBP_B2_COPAY_MCS_AMT_INTRVL2);
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - (N1 + N2)) * PBP_B2_COPAY_MCS_AMT_INTRVL3));
          END;
          ELSE IF (PBP_B2_COPAY_MCS_ENDD_INTRVL1 > 0) AND
            (TOTDAYS > PBP_B2_COPAY_MCS_ENDD_INTRVL1) THEN DO;
            DAY_COPAY = N1 * PBP_B2_COPAY_MCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - N1) * PBP_B2_COPAY_MCS_AMT_INTRVL2));
          END;
          ELSE DO;
            DAY_COPAY = TOTDAYS * PBP_B2_COPAY_MCS_AMT_INTRVL1;
          END;

        END; * PBP_B2_COPAY_NMCS_STRUC_YN = '1';
        ELSE
        IF PBP_B2_COPAY_NMCS_STRUC_YN = '2' THEN DO; * NMCS COPAY STRUCTURE NOT THE SAME AS MCS;

          IF FIRST_STAY = 1 THEN DO;
            IF PLAN_DED_CAT='1' THEN DO;
	      PLAN_DED_AMTTOT_AMO_PTA=SUM(PLAN_DEDUCT_PTA,-PLAN_DED_AMTTOT_MC_PTA);
	      IF PLAN_DED_AMTTOT_AMO_PTA>0 THEN PBP_DEDUCTIBLE=PLAN_DED_AMTTOT_AMO_PTA;
	      ELSE PBP_DEDUCTIBLE=SUM(PLAN_DED_AMTTOT,-PLAN_DED_AMTTOT_MC);
            END;
            ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN PBP_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_2_AMT;
            ELSE PBP_DEDUCTIBLE = PBP_B2_DED_AMT;
          END;

          IF PBP_DEDUCTIBLE > 0 THEN DO;
            IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
              STAY_COST = AMTTOT;
              ADDITIONAL_DAYS = 0;
              PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
            END;
            ELSE DO;
              AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
              STAY_COST = SUM(PBP_B2_COPAY_NMCS_AMT, AMTTOT * PBP_B2_COINS_NMCS_PCT, PBP_DEDUCTIBLE);
              ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
              PBP_DEDUCTIBLE = 0;
            END;
          END;
          ELSE DO;
            STAY_COST    = SUM(PBP_B2_COPAY_NMCS_AMT, AMTTOT * PBP_B2_COINS_NMCS_PCT);
            ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
          END;

          STAY_COST_AMO = STAY_COST;

          N1 = PBP_B2_COPAY_NMCS_ENDD_INTRVL1 - PBP_B2_COPAY_NMCS_BGND_INTRVL1 + 1;
          N2 = PBP_B2_COPAY_NMCS_ENDD_INTRVL2 - PBP_B2_COPAY_NMCS_BGND_INTRVL2 + 1;
          N3 = PBP_B2_COPAY_NMCS_ENDD_INTRVL3 - PBP_B2_COPAY_NMCS_BGND_INTRVL3 + 1;

          DAY_COPAY = .;
          IF (PBP_B2_COPAY_NMCS_ENDD_INTRVL3 > 0) AND
            (TOTDAYS > PBP_B2_COPAY_NMCS_ENDD_INTRVL3) THEN DO;
            DAY_COPAY = N1 * PBP_B2_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, N2 * PBP_B2_COPAY_NMCS_AMT_INTRVL2);
            DAY_COPAY = SUM(DAY_COPAY, N3 * PBP_B2_COPAY_NMCS_AMT_INTRVL3);
          END;
          ELSE IF (PBP_B2_COPAY_NMCS_ENDD_INTRVL2 > 0) AND
            (TOTDAYS > PBP_B2_COPAY_NMCS_ENDD_INTRVL2) THEN DO;
            DAY_COPAY = N1 * PBP_B2_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, N2 * PBP_B2_COPAY_NMCS_AMT_INTRVL2);
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - (N1 + N2)) * PBP_B2_COPAY_NMCS_AMT_INTRVL3));
          END;
          ELSE IF (PBP_B2_COPAY_NMCS_ENDD_INTRVL1 > 0) AND
            (TOTDAYS > PBP_B2_COPAY_NMCS_ENDD_INTRVL1) THEN DO;
            DAY_COPAY = N1 * PBP_B2_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - N1) * PBP_B2_COPAY_NMCS_AMT_INTRVL2));
          END;
          ELSE DO;
            DAY_COPAY = TOTDAYS * PBP_B2_COPAY_NMCS_AMT_INTRVL1;
          END;

        END; * PBP_B2_COPAY_NMCS_STRUC_YN != '1';

        * NMCS COINSURANCE STRUCTURE SAME AS MCS;
        IF PBP_B2_COINS_NMCS_STRUC_YN = '1' THEN DO;
          STAY_COST     = SUM(STAY_COST, AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT);
          STAY_COST_AMO = SUM(STAY_COST_AMO, AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT);

          N1 = PBP_B2_COINS_MCS_ENDD_INTRVL1 - PBP_B2_COINS_MCS_BGND_INTRVL1 + 1;
          N2 = PBP_B2_COINS_MCS_ENDD_INTRVL2 - PBP_B2_COINS_MCS_BGND_INTRVL2 + 1;
          N3 = PBP_B2_COINS_MCS_ENDD_INTRVL3 - PBP_B2_COINS_MCS_BGND_INTRVL3 + 1;

          DAY_COINS = .;
          IF (PBP_B2_COINS_MCS_ENDD_INTRVL3 > 0) AND
            (TOTDAYS > PBP_B2_COINS_MCS_ENDD_INTRVL3) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
            DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL2);
            DAY_COINS = SUM(DAY_COINS, N3 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B2_COINS_MCS_ENDD_INTRVL2 > 0) AND
            (TOTDAYS > PBP_B2_COINS_MCS_ENDD_INTRVL2) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
            DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL2);
            DAY_COINS = SUM(DAY_COINS, (TOTDAYS - (N1 + N2)) * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B2_COINS_MCS_ENDD_INTRVL1 > 0) AND
            (TOTDAYS > PBP_B2_COINS_MCS_ENDD_INTRVL1) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
            DAY_COINS = SUM(DAY_COINS, (TOTDAYS - N1) * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL2);
          END;
          ELSE DO;
            DAY_COINS = TOTDAYS * AMTTOT_PER_DAY * PBP_B2_COINS_MCS_PCT_INTRVL1;
          END;

        END; * PBP_B2_COINS_NMCS_STRUC_YN = '1';
        ELSE
        IF PBP_B2_COINS_NMCS_STRUC_YN = '2' THEN DO; * NMCS COINSURANCE STRUCTURE NOT THE SAME AS MCS;
          STAY_COST     = SUM(STAY_COST, AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT);
          STAY_COST_AMO = SUM(STAY_COST_AMO, AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT);

          N1 = PBP_B2_COINS_NMCS_ENDD_INTRVL1 - PBP_B2_COINS_NMCS_BGND_INTRVL1 + 1;
          N2 = PBP_B2_COINS_NMCS_ENDD_INTRVL2 - PBP_B2_COINS_NMCS_BGND_INTRVL2 + 1;
          N3 = PBP_B2_COINS_NMCS_ENDD_INTRVL3 - PBP_B2_COINS_NMCS_BGND_INTRVL3 + 1;

          DAY_COINS = .;
          IF (PBP_B2_COINS_NMCS_ENDD_INTRVL3 > 0) AND
            (TOTDAYS > PBP_B2_COINS_NMCS_ENDD_INTRVL3) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL2);
            DAY_COINS = SUM(DAY_COINS, N3 * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B2_COINS_NMCS_ENDD_INTRVL2 > 0) AND
            (TOTDAYS > PBP_B2_COINS_NMCS_ENDD_INTRVL2) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL2);
            DAY_COINS = SUM(DAY_COINS, (TOTDAYS - (N1 + N2)) * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B2_COINS_NMCS_ENDD_INTRVL1 > 0) AND
            (TOTDAYS > PBP_B2_COINS_NMCS_ENDD_INTRVL1) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM(DAY_COINS, (TOTDAYS - N1) * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL2);
          END;
          ELSE DO;
            DAY_COINS = TOTDAYS * AMTTOT_PER_DAY * PBP_B2_COINS_NMCS_PCT_INTRVL1;
          END;

        END; * PBP_B2_COINS_NMCS_STRUC_YN != '1';

        DAY_COST     = SUM(DAY_COPAY, DAY_COINS);
        DAY_COST_AMO = SUM(DAY_COPAY, DAY_COINS);

      END; * PBP_B2_BENDESC_AMO_NMCS IN ('1','2');
      ELSE DO;
        NONCOV_COST = TOTDAYS * AMTTOT_PER_DAY;
      END;

    END; * END UTLZNDAY <= 0;

    COST_SHARE_COST = SUM(STAY_COST, DAY_COST);
    COST_SHARE_COST_MC  = SUM(STAY_COST_MC, DAY_COST_MC);
    COST_SHARE_COST_AMO = SUM(STAY_COST_AMO, DAY_COST_AMO);
    OTHER_COST = NONCOV_COST;

    IF PBP_B2_MAXENR_PER = '6' AND BENE_MAXIMUM >= 0 AND COST_SHARE_COST > BENE_MAXIMUM THEN DO;
      MAX_REDUCTION = (BENE_MAXIMUM / SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
      COST_SHARE_COST = COST_SHARE_COST * MAX_REDUCTION;
      COST_SHARE_COST_MC = COST_SHARE_COST_MC * MAX_REDUCTION;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * MAX_REDUCTION;
    END;

    CATEGORY = "2";
  RUN;

  PROC SORT DATA = SNF;
    BY HPLAN;
  RUN;

  PROC SUMMARY DATA = SNF NWAY MISSING;
    CLASS YEAR BASEID;
    BY HPLAN;
    VAR AMTTOT COST_SHARE_COST OTHER_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO;
    ID BENE_MAXIMUM PBP_B2_MAXENR_PER CATEGORY;
    OUTPUT OUT = TOTSNF(RENAME = _FREQ_=RCCNT) SUM = ;
  RUN;

  DATA COSTDATA_SNF;
    SET TOTSNF;
  
    IF PBP_B2_MAXENR_PER IN ('1','2','3','4','5','7') AND BENE_MAXIMUM >= 0 AND
      COST_SHARE_COST > BENE_MAXIMUM THEN DO;
      MAX_REDUCTION = (BENE_MAXIMUM / SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
     COST_SHARE_COST = COST_SHARE_COST * MAX_REDUCTION;
      COST_SHARE_COST_MC = COST_SHARE_COST_MC * MAX_REDUCTION;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * MAX_REDUCTION;
    END;

    COST = SUM(COST_SHARE_COST, OTHER_COST);
  
    IF . < COST < 0 THEN DELETE;

    KEEP HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
         OTHER_COST COST CATEGORY RCCNT AMTTOT;
  RUN;

  PROC SORT DATA = COSTDATA_SNF;
    BY YEAR BASEID HPLAN;
  RUN;

  PROC APPEND DATA=COSTDATA_SNF(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
         OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE SNF TOTSNF COSTDATA_SNF SNF_BASEID SNF_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;


