* PROGRAM: MISSING_CELLS_YEAR.SAS;


DATA  PBPCATS_MCCOST_&YEAR1  PBPCATS_MCCOST_&YEAR2;
SET  PBPCATS_MCCOST;
CATEGORY = LOWCASE(CATEGORY);
IF YEAR = "&YEAR1" THEN OUTPUT  PBPCATS_MCCOST_&YEAR1;
ELSE IF YEAR = "&YEAR2" THEN OUTPUT  PBPCATS_MCCOST_&YEAR2;
RUN;

PROC SQL;
  CREATE TABLE BASEID_MANAGEDCARE AS
  SELECT DISTINCT BASEID
    FROM  PBPCATS_MCCOST_&YEAR2
   ORDER BY BASEID;
RUN;

DATA MISSING_COHORT;
  MERGE &INP(IN = A WHERE=(YEAR="&YEAR2")
             KEEP = BASEID CSYRWGT CELL_GROUP INDMON YEAR)
        BASEID_MANAGEDCARE(IN = B);
  BY BASEID;
  IF A AND NOT B;

  INDMON = INDMON * CSYRWGT;

  KEEP BASEID CELL_GROUP INDMON CSYRWGT;
RUN;

PROC SUMMARY DATA = MISSING_COHORT NWAY MISSING;
  CLASS CELL_GROUP;
  VAR INDMON CSYRWGT;
  OUTPUT OUT = MISSING_COHORT_CELL_GROUP(DROP = _TYPE_ _FREQ_) SUM=;
RUN;

DATA  MISSING_CELLS_&YEAR2;
  SET MISSING_COHORT_CELL_GROUP END = LAST;

  LENGTH CELL1 - CELL30 $ 2;
  RETAIN CELL1 - CELL30 INDMON1 - INDMON30 CWGT1 - CWGT30;
  ARRAY ACELL $ CELL1 - CELL30;
  ARRAY AINDMON INDMON1 - INDMON30;
  ARRAY ACWGT CWGT1 - CWGT30;

  CG = INPUT(CELL_GROUP,2.);

  ACELL(CG)   = CELL_GROUP;
  AINDMON(CG) = INDMON;
  ACWGT(CG) = CSYRWGT;

  IF LAST THEN OUTPUT;
  DROP CELL_GROUP INDMON CSYRWGT CG;
RUN;

PROC SQL;
  CREATE TABLE BASEID_MANAGEDCARE AS
  SELECT DISTINCT BASEID
    FROM  PBPCATS_MCCOST_&YEAR1
   ORDER BY BASEID;
RUN;

DATA MISSING_COHORT;
  MERGE &INP(IN = A WHERE=(YEAR="&YEAR1")
             KEEP = BASEID CSYRWGT CELL_GROUP INDMON YEAR)
        BASEID_MANAGEDCARE(IN = B);
  BY BASEID;
  IF A AND NOT B;

  INDMON = INDMON * CSYRWGT;

  KEEP BASEID CELL_GROUP INDMON CSYRWGT;
RUN;

PROC SUMMARY DATA = MISSING_COHORT NWAY MISSING;
  CLASS CELL_GROUP;
  VAR INDMON CSYRWGT;
  OUTPUT OUT = MISSING_COHORT_CELL_GROUP(DROP = _TYPE_ _FREQ_) SUM=;
RUN;

DATA  MISSING_CELLS_&YEAR1;
  SET MISSING_COHORT_CELL_GROUP END = LAST;

  LENGTH CELL1 - CELL30 $ 2;
  RETAIN CELL1 - CELL30 INDMON1 - INDMON30 CWGT1 - CWGT30;
  ARRAY ACELL $ CELL1 - CELL30;
  ARRAY AINDMON INDMON1 - INDMON30;
  ARRAY ACWGT CWGT1 - CWGT30;

  CG = INPUT(CELL_GROUP,2.);

  ACELL(CG)   = CELL_GROUP;
  AINDMON(CG) = INDMON;
  ACWGT(CG) = CSYRWGT;

  IF LAST THEN OUTPUT;
  DROP CELL_GROUP INDMON CSYRWGT CG;
RUN;
