
* MOC_FILE_CREATION.SAS;
* DESCRIPTION: CREATES MOC FILES;

LIBNAME FORM    "&FORMULARY";

data oopc_plan_health_detail;
  set OUT.OOPC_PLAN_DETAIL;
  if cell_group in ('1','2','3','4','5','6') then health = 1;
  else if cell_group in ('7','8','9','10','11','12') then health = 2; 
  else if cell_group in ('13','14','15','16','17','18') then health = 3;
  else if cell_group in ('19','20','21','22','23','24') then health = 4;
  else if cell_group in ('25','26','27','28','29','30') then health = 5;
  else if cell_group = '31' then health=31;
  else if cell_group = '32' then health=32;
  else if cell_group = '33' then health=33;
run;

proc sort data=oopc_plan_health_detail out=oopc_plan_health_detail;
  by hplan health category;
run;

proc means data = oopc_plan_health_detail noprint;
  by hplan health category;
  weight combowgt_sum;
  var monthly_cost_mean;
  output out = plan_category_health(drop=_type_ _freq_) mean = monthly_cost_mean;
run;

data plan_health;
  set plan_category_health;
  by hplan health;
  
  length contract_id $5 plan_id $3 segment_id $3 contract_year $4;

  retain drugs dental_services inpatient_care 
          plan_deductible all_other_utilization all;

  array vvars drugs dental_services  inpatient_care 
                            plan_deductible all_other_utilization all;

  if first.health then do;
    do over vvars;
      vvars = .;
    end;
  end;

  contract_id = substr(hplan,1,5);
  plan_id = substr(hplan,6,3);
  segment_id=substr(hplan,9,3);
  contract_year ="&RUNYEAR";

  if category = 'PTD' then drugs = monthly_cost_mean;
  else if category in ('16a', '16b') then dental_services = sum(dental_services, monthly_cost_mean);
  else if category in ('1a', '1b') then inpatient_care = sum(inpatient_care, monthly_cost_mean);
  else if UPCASE(category) = 'DED' then plan_deductible = sum(plan_deductible, monthly_cost_mean);
  else if UPCASE(category) = 'ALL' then all = sum(all, monthly_cost_mean);
  else all_other_utilization =  sum(all_other_utilization, monthly_cost_mean);

  
  if last.health then output;
  drop category monthly_cost_mean; 
run;

proc sort data=snpplanfile out=snpplanfile;
  by hplan;
run;

data plan_health (drop=i);
  set plan_health (in=a)
      snpplanfile (in=b);
  by hplan;
  length type $4 snpflag $1;
  type=put(hplan,$typef.);
  if a then output;
  if b then do;
    snpflag='1';
    do i=1 to 5;
      health=i;
      contract_id=substr(hplan,1,5);
      plan_id = substr(hplan,6,3);
      segment_id=substr(hplan,9,3);
      contract_year ="&RUNYEAR";
      output;
    end;
  end;
run;

data plan_health;
  merge plan_health (in=a)
        form.premium_partcd (in=b drop=contract_id plan_id segment_id);
  by hplan;
  if a | (b & type in('FFS','MGAP'));
  
  if pbp_a_ben_cov='2' then plan_premium=pbp_d_mplusc_bonly_premium;
  else if pbp_a_ben_cov='1' then plan_premium=pbp_d_mplusc_premium;
  
  if type ne 'PDP' then do;
    part_b_premium_val=&PARTB_PREMIUM.;
    part_b_premium=max(sum(part_b_premium_val,-pbp_d_mco_pay_reduct_amt),0);
  end;
  
  part_d_premium=plan_total_premium_net_rebate;
  
  if type='MSA' then do;
    plan_premium=0;
  end;
  
  if put(hplan,$plntype.) in('48','49','50') then do;
    plan_premium=0;
    part_b_premium=0;
    part_d_premium=0;
  end;
  
  all=sum(all,plan_premium,part_b_premium,part_d_premium);
  
  if type='PDP' then do;
    dental_services=.;
    inpatient_care=.;
    plan_deductible=.;
    all_other_utilization=.;
  end;    
  
  *new rounded total as sum of rounded components;
  total=sum(drugs, dental_services, plan_premium,
            inpatient_care, part_b_premium,
            part_d_premium, plan_deductible,
            all_other_utilization);
  
  if health < 31 then breakdown_total=sum(round(drugs), round(dental_services), plan_premium,
                    round(inpatient_care), part_b_premium,
                    part_d_premium, round(plan_deductible),
                    round(all_other_utilization));
  else if health >= 31 then breakdown_total=sum(round(dental_services), plan_premium,
                    round(inpatient_care), part_b_premium, round(plan_deductible),
                    round(all_other_utilization));
  
  keep hplan contract_id plan_id segment_id contract_year type snpflag
       health drugs dental_services plan_premium inpatient_care part_b_premium
       part_d_premium plan_deductible
       all_other_utilization total all breakdown_total;
run;
                         
data out.managedcare_oopc_brk_health;
  set plan_health;

  u_part_d_premium = put(part_d_premium,dollar10.2);
  u_part_b_premium = put(part_b_premium,dollar10.2);
  u_plan_premium   = put(plan_premium,dollar10.2);
  u_breakdown_total= put(breakdown_total,dollar10.2);
  array oopc drugs dental_services plan_premium inpatient_care part_b_premium
             part_d_premium plan_deductible
             all_other_utilization total;
  array c_oopc $10
        c_drugs
        c_dental_services
        c_plan_premium
        c_inpatient_care
        c_part_b_premium
        c_part_d_premium
        c_plan_deductible
        c_all_other_utilization
        c_total
        ;
        
  do over oopc;
    if oopc = . then oopc = 0;
    oopc = round(oopc);
  end;
  do over oopc;
    c_oopc = put(oopc,dollar10.2);
  end;
  
  keep  hplan contract_id plan_id segment_id contract_year health type snpflag
        drugs c_drugs c_dental_services c_plan_premium c_inpatient_care c_part_b_premium
        c_part_d_premium c_plan_deductible
        c_all_other_utilization c_total part_d_premium total
        u_part_d_premium u_part_b_premium u_plan_premium u_breakdown_total breakdown_total;

run;

proc sort data=out.managedcare_oopc_brk_health out=out.managedcare_oopc_brk_health;
  by contract_id plan_id segment_id health;
run;

data chronic;
  set out.managedcare_oopc_brk_health; 
  by contract_id plan_id segment_id health;
  if health >= 31;
run;

data chronic_plan;
  set chronic;
  by contract_id plan_id segment_id;

  retain
    oop_diabetes_all
    oop_chf_all
    oop_ahc_all 
    oop_diabetes_drug
    oop_chf_drug
    oop_ahc_drug;
    
  if first.segment_id then do;
    oop_diabetes_all=0;
    oop_chf_all=0;
    oop_ahc_all=0; 
    oop_diabetes_drug=0;
    oop_chf_drug=0;
    oop_ahc_drug=0;
  end;
  
  select(health);
    when(31) do;
      oop_ahc_all=breakdown_total;
      oop_ahc_drug=sum(drugs,part_d_premium);
    end;
    when(32) do;
      oop_chf_all=breakdown_total;
      oop_chf_drug=sum(drugs,part_d_premium);
    end;
    when(33) do;
      oop_diabetes_all=breakdown_total;
      oop_diabetes_drug=sum(drugs,part_d_premium);
    end;
    otherwise;
  end;
   
  if last.segment_id;
  keep contract_id plan_id segment_id oop_diabetes_all
    oop_chf_all oop_ahc_all oop_diabetes_drug oop_chf_drug oop_ahc_drug;
run;

data oopc_prep;
  merge out.managedcare_oopc_brk_health (in=a)
        chronic_plan (in=b);
  by contract_id plan_id segment_id;
  if a;
  if health in(1,3,5);
run;

data _null_ mgap_plan;
  set oopc_prep;

  if type in('MAON','FFS','MGAP') | (type='MSA' & c_drugs=' ') then do;
    PartD=round(input(health,ptdffsh.));
    c_drugs = put(PartD,dollar10.2);
    oop_ahc_drug=input(31,ptdffsh.);
    oop_chf_drug=input(32,ptdffsh.);
    oop_diabetes_drug=input(33,ptdffsh.); 
    breakdown_total=sum(PartD,breakdown_total);
    u_breakdown_total= put(breakdown_total,dollar10.2);
    total=sum(PartD,total);
  end;

  if type ne 'PDP' then do;
    *make the chronic values character also;
    c_oop_diabetes_all = put(oop_diabetes_all,dollar8.);
    c_oop_chf_all      = put(oop_chf_all,dollar8.);
    c_oop_ahc_all      = put(oop_ahc_all,dollar8.);
  end;

  c_oop_diabetes_drug = put(oop_diabetes_drug,dollar8.);
  c_oop_chf_drug      = put(oop_chf_drug,dollar8.);
  c_oop_ahc_drug      = put(oop_ahc_drug,dollar8.);
 
  if snpflag='1' then do;
    c_dental_services=' ';
    c_inpatient_care=' ';
    c_plan_deductible=' ';
    c_all_other_utilization=' ';
    drugs=.;
    PartD=.;
    c_drugs=' ';
    total=.;
    u_breakdown_total=' ';
  end;
  
  if type='PDP' then do;
    c_dental_services=' ';
    c_inpatient_care=' ';
    c_plan_deductible=' ';
    c_all_other_utilization=' ';
  end; 
  
  segment_id_n=input(segment_id,8.);
  contract_year="&RUNYEAR";
  
  array c_oopc $ c_oop_diabetes_all
                 c_oop_chf_all
                 c_oop_ahc_all
                 c_oop_diabetes_drug
                 c_oop_chf_drug
                 c_oop_ahc_drug
                 c_dental_services
                 u_plan_premium
                 c_inpatient_care
                 u_part_b_premium
                 c_plan_deductible
                 c_all_other_utilization
                 u_part_d_premium
                 c_drugs
                 u_breakdown_total;
                 
  do over c_oopc;
    if left(c_oopc)='.' then c_oopc=' ';
  end;                 
         
  * per kim on 7/8/2014 - blank deductible;
  c_plan_deductible = ' ';
  
  * per kim on 7/2/15 - took out c_plan_deductible from put statement based on;
  * the planfinder_2016_DB_design.docx;
         
  file outfile delimiter = '09'x dsd encoding=unicode;
  if type ^= 'MGAP' then put
  contract_id
  plan_id
  segment_id_n
  contract_year
  health
  c_oop_diabetes_all
  c_oop_chf_all
  c_oop_ahc_all
  c_oop_diabetes_drug
  c_oop_chf_drug
  c_oop_ahc_drug
  c_dental_services
  u_plan_premium
  c_inpatient_care
  u_part_b_premium
  c_all_other_utilization
  u_part_d_premium
  c_drugs
  u_breakdown_total
  ;
  else if type='MGAP' then output mgap_plan;
run;

data mgap_plan;
  set mgap_plan(drop=c_oop_diabetes_all c_oop_chf_all c_oop_ahc_all u_breakdown_total);
  length hplan $11;
  hplan=contract_id||plan_id||segment_id;
run;

proc sql;
  create table mgap_state as 
   select p.state_abbrev,p.simple_plantype,p.medigap_premium,o.*
 from mgap_plan o,pbp.premiums_medigap2016 p
   where o.hplan=p.hplan;
  quit;
run;

proc sort data=mgap_state;
  by simple_plantype state_abbrev contract_year health;
run;

data _null_;
set mgap_state;
medigap_premium=round(medigap_premium/12,.01);
u_plan_premium=put(medigap_premium,dollar10.2);
oop_diabetes_all=sum(oop_diabetes_all,medigap_premium);
oop_chf_all=sum(oop_chf_all,medigap_premium);
oop_ahc_all=sum(oop_ahc_all,medigap_premium);
c_oop_diabetes_all = put(oop_diabetes_all,dollar8.);
c_oop_chf_all      = put(oop_chf_all,dollar8.);
c_oop_ahc_all      = put(oop_ahc_all,dollar8.);
breakdown_total=sum(breakdown_total,medigap_premium);
u_breakdown_total= put(breakdown_total,dollar10.2);

  * per kim on 7/8/2014 - blank deductible;
  c_plan_deductible = ' ';

  * per kim on 7/2/15 - took out c_plan_deductible from put statement based on;
  * the planfinder_2016_DB_design.docx;
  
file outmgap delimiter = '09'x dsd encoding=unicode;
  if medigap_premium ne . then 
    put
    state_abbrev
    simple_plantype
    contract_year
    health
    c_oop_diabetes_all
    c_oop_chf_all
    c_oop_ahc_all
    c_oop_diabetes_drug
    c_oop_chf_drug
    c_oop_ahc_drug
    c_drugs
    c_dental_services
    u_plan_premium
    c_inpatient_care
    u_part_b_premium
    c_all_other_utilization
    u_breakdown_total
    ;
  else if medigap_premium = . then 
    put
    state_abbrev
    simple_plantype
    contract_year
    health
    ;
run;

