
* PLAN_CATNAME_NEW.SAS;
* DESCRIPTION: PERFORM FINAL CALCULATIONS AND CREATE FINAL SPREADSHEET;

DATA FMTSUB;
SET &CATEG;
IF CATEGORY ^= ' ' THEN OUTPUT;
RUN;

DATA FMTDATA;
SET FMTSUB END=LAST;
LENGTH FMTNAME $8 HLO $1 START $3;
RETAIN FMTNAME '$CATNAME' HLO ' ';
START=CATEGORY;
OUTPUT FMTDATA;
RUN;

PROC SORT DATA=FMTDATA OUT=FMTSORT NODUPKEY;
BY START;
RUN;

PROC FORMAT CNTLIN=FMTSORT;
RUN;

PROC SORT DATA=&CATEG OUT=SORTCATEG (KEEP=LABEL CATEGORY);
BY ORDER;
RUN;

DATA _NULL_;
SET SORTCATEG end = last;
FILE "&INPUTDIR.\CATORDER.TXT";
if _n_ = 1 then put '%let catlist = %str(';
PUT LABEL;
if last then put ');';
RUN;

%MACRO PLAN;

 %include "&INPUTDIR.\CATORDER.TXT";
 
 DATA  BASEID_CATEGORY_ALLYEARS;
 SET

 %IF &PDP > 0 OR &MAPD > 0 %THEN %DO;
    BASEID_PLAN_CATEGORY_PARTD_&YEAR1(RENAME=CWGT=COMBO_WGT)
    BASEID_PLAN_CATEGORY_PARTD_&YEAR2(RENAME=CWGT=COMBO_WGT)
 %END;


 %IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 OR &FFS > 0 or &MGAP > 0 %THEN %DO;
    BASEID_PLAN_CATEGORY_COMP_&YEAR1(RENAME=CWGT=COMBO_WGT)
    BASEID_PLAN_CATEGORY_COMP_&YEAR2(RENAME=CWGT=COMBO_WGT)
 %END;
 ;
 BY CELL_GROUP HPLAN CATEGORY;
 
 OUTPUT;
 
 IF PUT(HPLAN,$TYPEF.)='MSA' & CATEGORY='ALL' THEN DO;
   CATEGORY='PTD';
   IF YEAR=&YEAR1. THEN DO;
     COST=PUT(BASEID,$BYR1FFS.);
     monthly_balance=msa_balance/indmon;
     if monthly_balance > 0 then MONTHLY_COST=MAX(0,SUM(COST,-monthly_balance));
     else if monthly_balance <= 0 then MONTHLY_COST=COST;
     if monthly_balance > 0 then b_flag = '1';
     else b_flag = '0';
     OUTPUT;
   END;
   ELSE IF YEAR=&YEAR2. THEN DO;
     COST=PUT(BASEID,$BYR2FFS.);
     monthly_balance=msa_balance/indmon;
     if monthly_balance > 0 then MONTHLY_COST=MAX(0,SUM(COST,-monthly_balance));
     else if monthly_balance <= 0 then MONTHLY_COST=COST;
     if monthly_balance > 0 then b_flag = '1';
     else b_flag = '0';
     OUTPUT;
   END;
 END;
 ELSE DO;
   MSA_BALANCE = .;
   INDMON = .;
 END;
 
 %IF &INPUT=INPUTMPF %THEN %DO;
   * ADDED CODE FOR CHRONICS;
   IF YEAR="&YEAR1" THEN DO;
     IF PUT(BASEID,$AHCY1F.)='yes' THEN DO;
       CELL_GROUP='31';
       OUTPUT;
     END;
     IF PUT(BASEID,$CHFY1F.)='yes' THEN DO;
       CELL_GROUP='32';
       OUTPUT;
     END;
     IF PUT(BASEID,$DIAY1F.)='yes' THEN DO;
       CELL_GROUP='33';
       OUTPUT;
     END;
   END;
   ELSE IF YEAR="&YEAR2" THEN DO;
     IF PUT(BASEID,$AHCY2F.)='yes' THEN DO;
       CELL_GROUP='31';
       OUTPUT;
     END;
     IF PUT(BASEID,$CHFY2F.)='yes' THEN DO;
       CELL_GROUP='32';
       OUTPUT;
     END;
     IF PUT(BASEID,$DIAY2F.)='yes' THEN DO;
       CELL_GROUP='33';
       OUTPUT;
     END;
   END;
 %END;
 RUN;

PROC SORT DATA=BASEID_CATEGORY_ALLYEARS;
BY CELL_GROUP HPLAN CATEGORY;
RUN;

DATA CCOHORT;
  SET &INP(KEEP=BASEID CSYRWGT YEAR CELL_GROUP);
  IF YEAR = "&YEAR1" THEN SOURCE = "&MCBSYR1";
  ELSE IF YEAR = "&YEAR2" THEN SOURCE = "&MCBSYR2";
     COMBO_WGT = CSYRWGT;
  OUTPUT;
  %IF &INPUT=INPUTMPF %THEN %DO;
    IF YEAR = "&YEAR1" THEN DO;
      IF PUT(BASEID,$AHCY1F.)='yes' THEN DO;
        CELL_GROUP='31';
        OUTPUT;
      END;
      IF PUT(BASEID,$CHFY1F.)='yes' THEN DO;
        CELL_GROUP='32';
        OUTPUT;
      END;
      IF PUT(BASEID,$DIAY1F.)='yes' THEN DO;
        CELL_GROUP='33';
        OUTPUT;
      END;
    END;
    ELSE IF YEAR = "&YEAR2" THEN DO;
      IF PUT(BASEID,$AHCY2F.)='yes' THEN DO;
        CELL_GROUP='31';
        OUTPUT;
      END;
      IF PUT(BASEID,$CHFY2F.)='yes' THEN DO;
        CELL_GROUP='32';
        OUTPUT;
      END;
      IF PUT(BASEID,$DIAY2F.)='yes' THEN DO;
        CELL_GROUP='33';
        OUTPUT;
      END;
    END;
  %END;
RUN;

/* DETAILED SAS VERSION FOR MOC */
PROC SUMMARY DATA = CCOHORT NWAY MISSING;
CLASS CELL_GROUP;
  VAR COMBO_WGT;
  OUTPUT OUT = COHORT_CELL_GROUP_DETAIL(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
RUN;

PROC MEANS DATA = BASEID_CATEGORY_ALLYEARS NOPRINT NWAY;
  CLASS CELL_GROUP HPLAN CATEGORY;
  WEIGHT COMBO_WGT;
  VAR MONTHLY_COST;
  OUTPUT OUT = PLAN_DETAIL SUM = MONTHLY_COST_SUM;
RUN;

DATA PLAN_COSTS_DETAIL;
  MERGE PLAN_DETAIL (IN=A)
        COHORT_CELL_GROUP_DETAIL (IN=B);
  BY CELL_GROUP;
  IF A & B;
  MONTHLY_COST_MEAN = MONTHLY_COST_SUM / COMBOWGT_SUM;
RUN;

DATA PLAN_COSTS_DETAIL_CAT(DROP=_TYPE_ _FREQ_);
LENGTH CATNAME $50;
SET PLAN_COSTS_DETAIL (WHERE=(_TYPE_ ^=0 AND HPLAN ^=:' ' AND CATEGORY ^= '   '));
CATNAME = PUT(CATEGORY,$CATNAME.);
RUN;

%IF &INPUT=INPUTMPF %THEN %DO;
  DATA OUT.OOPC_PLAN_DETAIL;
  SET PLAN_COSTS_DETAIL_CAT; 
  RUN;
%END;

/* END OF DETAILED SAS VERSION FOR MOC */

PROC SUMMARY DATA = CCOHORT NWAY MISSING;
  WHERE CELL_GROUP NOT IN('31','32','33');
  VAR COMBO_WGT;
  OUTPUT OUT = COHORT_CELL_GROUP(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
RUN;

PROC MEANS DATA =  BASEID_CATEGORY_ALLYEARS NOPRINT;
  CLASS HPLAN CATEGORY;
  WEIGHT COMBO_WGT;
  VAR MONTHLY_COST;
  WHERE CELL_GROUP NOT IN('31','32','33');
  OUTPUT OUT = PLAN SUM = MONTHLY_COST_SUM;
RUN;

DATA PLAN_COSTS;
  IF _N_ = 1 THEN SET COHORT_CELL_GROUP(KEEP = COMBOWGT_SUM);
  SET PLAN(IN = A);
  MONTHLY_COST_MEAN      = MONTHLY_COST_SUM / COMBOWGT_SUM;
  RUN;

PROC SORT DATA=PLAN_COSTS OUT= PLAN_COSTS;
BY HPLAN;
RUN;

DATA SECTION_A(RENAME=(PBP_A_ORG_TYPE=ORG_TYPE
                       PBP_A_PLAN_TYPE=PLAN_TYPE PBP_A_ORG_MARKETING_NAME=MARKETING_NAME
                       PBP_A_ORG_NAME=ORG_NAME PBP_A_Plan_Name=Plan_Name));
LENGTH TYPE $4;
  SET  PBP_FILE;
  TYPE = PUT(HPLAN,$TYPEF.);
  IF TYPE NE 'NO';
RUN;

DATA PLAN_COSTS_CAT(DROP=_TYPE_ _FREQ_  COMBOWGT_SUM);
LENGTH CATNAME $ 50;
SET  PLAN_COSTS(WHERE=(_TYPE_ ^=0 AND HPLAN ^=:' ' AND CATEGORY ^= '   '));
CATNAME = PUT(CATEGORY,$CATNAME.);
RUN;

DATA PLAN_CATS(KEEP=HPLAN CATNAME CATEGORY MONTHLY_COST_MEAN);
 SET  PLAN_COSTS_CAT;
RUN;

PROC TRANSPOSE DATA=PLAN_CATS(DROP=CATEGORY) OUT=PARTC_PLANS(DROP=_NAME_);
VAR MONTHLY_COST_MEAN;
ID CATNAME;
BY HPLAN;
RUN;

DATA PARTC_PLANS_ALL;
SET
    %IF &MAPD > 0 OR &MAON > 0 OR &FFS > 0 OR &MGAP > 0 OR &MSA > 0 %THEN %DO;
    PARTC_PLANS
    %END;
;
BY HPLAN;
RUN;

DATA PARTC_PLANS;
SET PARTC_PLANS_ALL;
%IF &MAON = 0 AND &MAPD = 0 AND &PDP > 0 %THEN %DO;
 ALL = .;
%END;
%IF &MAPD > 0 OR &PDP > 0 OR &MSA > 0 %THEN %DO;
 PartD = PTD;
%END;
RUN;

DATA PARTC_PLANS_CD(DROP=MARKETING_NAME);
LENGTH HPLAN $11
       CONTRACT_ID $5
       Plan_ID $3
       Segment_ID $3
       ORG_MKT_NAME $50
       Plan_Name $75
       YEAR $4
       PARTD 8;
MERGE PARTC_PLANS(IN=A)
      SECTION_A(IN=C KEEP=PLAN_TYPE TYPE HPLAN MARKETING_NAME Plan_Name);
BY HPLAN;
IF TYPE IN('MAON','FFS','MGAP') THEN PartD=&ptdffs.;
IF TOTAL = . THEN TOTAL = ALL;
Grand_Total = SUM(TOTAL,PartD);
YEAR = "&RUNYEAR";
ORG_MKT_NAME  = MARKETING_NAME;
IF TYPE = 'PDP' THEN Grand_Total = PartD;
CONTRACT_ID=SUBSTR(HPLAN,1,5);
PLAN_ID=SUBSTR(HPLAN,6,3);
SEGMENT_ID=SUBSTR(HPLAN,9,3);
ARRAY CTX &CATLIST.;
RUN;

DATA  OOPCS_ALL_FINAL_CD(DROP=TYPE RENAME=(CONTRACT_ID=Contract_Number
ORG_MKT_NAME=Organization_Marketing_Name YEAR=Benefit_Year));
LENGTH CONTRACT_ID $5 Plan_ID $3 Segment_ID $3 ORG_MKT_NAME $50 Plan_Name $75 YEAR $4 
 %IF &INPUT^=INPUTPLAN %THEN %DO;
   Formulary_Version 8
  %END;
 %IF &MAPD > 0 OR &PDP > 0 OR &MAON > 0 OR &FFS > 0 OR &MGAP > 0 OR &MSA > 0 %THEN %DO;
   &catlist.
 %END;
 PartD
 Grand_Total 8
 PBP_Version_Date $21;
SET PARTC_PLANS_CD(KEEP=CONTRACT_ID Plan_ID Segment_ID ORG_MKT_NAME Plan_Name YEAR 
 %IF &MAPD > 0 OR &MAON > 0 OR &FFS > 0 OR &MGAP > 0 OR &MSA > 0 %THEN %DO;
   &catlist.
 %END;
 PartD
 Grand_Total
 HPLAN TYPE);
%IF &INPUT^=INPUTPLAN %THEN %DO;
  Formulary_Version=PUT(CONTRACT_ID||PLAN_ID,$CONTVER.);
%END;
PBP_Version_Date=PUT(HPLAN,$HISTFMT.);
ARRAY C &CATLIST.;
IF TYPE='PDP' THEN DO OVER C;
  C=.;
END;
RUN;
  
DATA OOPCS_ALL_FINAL_CD_WO_MGAPFFS (DROP=HPLAN) OOPCS_ALL_FINAL_CD_MGAPFFS (DROP=HPLAN);
SET OOPCS_ALL_FINAL_CD (DROP=Plan_Deductible_Allocation);
IF PUT(HPLAN,$TYPEF.) IN('MGAP','FFS') THEN OUTPUT OOPCS_ALL_FINAL_CD_MGAPFFS;
ELSE OUTPUT OOPCS_ALL_FINAL_CD_WO_MGAPFFS;
RUN;

%IF &INPUT=INPUTMPF %THEN %DO;
  PROC EXPORT DATA=OOPCS_ALL_FINAL_CD_MGAPFFS
              OUTFILE= "&OOPC_W_MGAPFFS"
              DBMS=XLSX REPLACE;
       SHEET="OOPCS &RUNYEAR";
  RUN;
%END;

PROC EXPORT DATA=OOPCS_ALL_FINAL_CD_WO_MGAPFFS 
            OUTFILE= "&OOPC"
            DBMS=XLSX REPLACE;
     SHEET="OOPCS &RUNYEAR";
RUN;

%IF &INPUT=INPUTCMS %THEN %DO;

  DATA RUN_DOCUMENTATION;
    LENGTH NOTES $250;
    NOTES="OOPC Model Version/Date:  &MODVERSION.";
    OUTPUT;
    NOTES="Plan Model Year:  &RUNYEAR.";
    OUTPUT;
    NOTES="MCBS Survey Data Years:  &YEAR1./&YEAR2.";
    OUTPUT;
    NOTES="PBP/Formulary Data Extract Date:  &EXTDATE.";
    OUTPUT;
    NOTES="FRF Related Files Date:  &FRFDATE.";
    OUTPUT;
    NOTES="Generic Substitution File Date:  &GENSUBDATE.";
    OUTPUT;       
    NOTES="PDE Price Data Year:  &PDEYEAR";
    OUTPUT;
    NOTES="Part D Parameter Year:  &RUNYEAR.";
    OUTPUT;
    NOTES="OACT Inflation Rates Year:  &OACT_INFLATION_YEAR.";
    OUTPUT;
    NOTES="Medicare Financing Rates Year:  &MED_FINANCE_RATE_YEAR.";
    OUTPUT;
  RUN;
  
  PROC EXPORT DATA=RUN_DOCUMENTATION
              OUTFILE= "&OOPC"
              DBMS=XLSX;
       SHEET="RUN_DOCUMENTATION";
  RUN;
%END;
    
%MEND;
RUN;

%PLAN;
RUN;
