

* PROGRAM: OOPCV1P.SAS;
* DESCRIPTION: MAIN OOPC PROGRAM;

%LET INPUTDIR    = c:\oopc\input;
%LET PROGDIR     = c:\oopc\programs;
%LET PBPDIR      = c:\program files\pbp2019;
%LET FORMDIR     = c:\oopc\formulary;
%LET PLANFILEDIR = c:\oopc\programs;
%LET OUTPUT      = c:\oopc\output\;

%LET INPUT=INPUTPLAN;

OPTIONS OBS = MAX NOCENTER MSGLEVEL = N SUMSIZE = 1000M BUFNO = 6
   SORTPGM = SAS  NOSORTEQUALS THREADS = YES NOTES;
OPTIONS VALIDVARNAME=ANY;

OPTIONS NOMPRINT NOSOURCE2;
RUN;

FILENAME IN0     "&INPUTDIR.";
LIBNAME  IN1     "&INPUTDIR.";

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****BEGIN OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;


*SET UP MACRO VARIABLES FOR YEARS;
%LET PBPMAIN       = PBP2019.MDB;
%LET YEAR1         = 2013;
%LET YEAR2         = 2015;
%LET RUNYEAR       = 2019;
%LET MCBSYR1       = 'MCBS 13';
%LET MCBSYR2       = 'MCBS 15';
%LET PARTB_PREMIUM = 135.50; 
%LET DRUG_INF_YR1  = 1.25;
%LET DRUG_INF_YR2  = 1.02; 
%LET PARTA_DEDUCT  = 1364.00;
%LET PARTB_DEDUCT  = 185.00;
%LET GENERIC_GAP_DISCOUNT = 0.63;
%LET BRAND_GAP_DISCOUNT = 0.70;
%LET BRAND_GAP_LIABDISC = 0.05;
%LET DEDUCTIBLE_&RUNYEAR = 415;
%LET ICL_&RUNYEAR = 3820;
%LET TROOP_&RUNYEAR = 5100;
%LET THRESHOLD_&RUNYEAR = 8139.54;
%LET CATGENERIC_&RUNYEAR = 3.40;
%LET CATBRAND_&RUNYEAR = 8.50;
%LET B1_DED_AMT=1364;
%LET B1_COPAY_BGND_INT1=1;
%LET B1_COPAY_BGND_INT2=61;
%LET B1_COPAY_BGND_INT3=91;
%LET B1_COPAY_ENDD_INT1=60;
%LET B1_COPAY_ENDD_INT2=90;
%LET B1_COPAY_ENDD_INT3=150;
%LET B1_COPAY_AMT_INT1=0;
%LET B1_COPAY_AMT_INT2=341;
%LET B1_COPAY_AMT_INT3=682;
%LET B2_COPAY_AMT_INT1=0;
%LET B2_COPAY_AMT_INT2=170.50;
%LET B2_COPAY_BGND_INT1=1;
%LET B2_COPAY_BGND_INT2=21;
%LET B2_COPAY_BGND_INT3=.;
%LET B2_COPAY_ENDD_INT1=20;
%LET B2_COPAY_ENDD_INT2=100;
%LET B2_COPAY_ENDD_INT3=.;

%macro obsnvars(ds);
   %global dset nvars nobs;
   %let dset=&ds;
   %let dsid = %sysfunc(open(&dset));
   %if &dsid %then
      %do;
         %let nobs =%sysfunc(attrn(&dsid,NOBS));
         %let nvars=%sysfunc(attrn(&dsid,NVARS));
         %let rc = %sysfunc(close(&dsid));
      %end;
   %else
      %put Open for data set &dset failed - %sysfunc(sysmsg());
%mend obsnvars;

%INCLUDE IN0(OOPCV1M.SAS)/SOURCE2;
run;

data _null_;
  ddate = put(date(),YYMMDDN8.);
  put ddate=;
  call symput('file_date', trim(left(ddate)));
run;

%OOPCV1M(RUNYEAR           =2019,
         INP               =IN1.PERSON,
         INC               =IN1.UTILIZATION,
         CATEG             =IN1.CATEGORY,
         PBP               =&PBPDIR,
         FORMULARY         =&FORMDIR,
         PLANFILE          =&PLANFILEDIR\PLANFILE.TXT,
         OOPC              =&OUTPUT.OOPC_RUN&file_date..xlsx);  
run;

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****ENDED OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;
