* PROGRAM: BASEID_PLAN_YEAR.SAS;

*ALL CATEGORIES;
DATA CATS;
  ARRAY ACATS(35) $ CAT1 - CAT35;
  RETAIN CAT1 - CAT35;

  INFILE DATALINES EOF = LAST;
  INPUT CATEGORY $ 1-3;

  ACATS(_N_) = CATEGORY;

  RETURN;

  LAST: OUTPUT;

  DROP CATEGORY;
DATALINES;
10a
11a
11b
12
15m
15c
16
16b
17a
18a
1a
1b
2
4a
4b
6
7a
7b
7c
7d
7e
7f
7g
7h
7i
8ad
8al
8bx
8bd
8br
9a
9b
3c
3p
14e
;
RUN;

*MEDICARE CATEGORIES;
DATA CATSM;
  ARRAY ACATS(35) $ CATM1 - CATM35;
  RETAIN CATM1 - CATM35;

  INFILE DATALINES EOF = LAST;
  INPUT CATEGORY_M $ 1-3;

  ACATS(_N_) = CATEGORY_M;

  RETURN;

  LAST: OUTPUT;

  DROP CATEGORY_M;
DATALINES;
10a
11a
11b
12
15m
15c
16
16b
17a
18a
1a
1b
2
4a
4b
6
7a
7b
7c
7d
7e
7f
7g
7h
7i
8ad
8al
8bx
8bd
8br
9a
9b
3c
3p
14e
;
RUN;

*NON-MEDICARE CATEGORIES;
DATA CATSNM;
  ARRAY ACATS(5) $ CATNM1 - CATNM5;
  RETAIN CATNM1 - CATNM5;

  INFILE DATALINES EOF = LAST;
  INPUT CATEGORY_NM $ 1-3;

  ACATS(_N_) = CATEGORY_NM;

  RETURN;

  LAST: OUTPUT;

  DROP CATEGORY_NM;
DATALINES;
16
16b
17b
18a
18b
;
RUN;


*******;
*** READ THE PBP_D DATA FROM DST_DATA AND BUILD A DATASET WITH EACH ROW REPRESENTING;
*** A CONTRACT AND A CATEGORY FOR WHICH THERE IS A DEDUCTION;
*** THIS DATASET HAS TWO VARIABLES: HPLAN AND CATEGORY;
*******;

DATA DEDUCTION_CATS_M;

  IF _N_ = 1 THEN SET CATSM;

           SET  PBP_FILE(KEEP=HPLAN
                            PBP_A_PLAN_TYPE
                            PBP_A_NETWORK_FLAG
                            PBP_D_INN_DEDUCT_YN
                            PBP_D_INN_DEDUCT_PARTB_YN
                            PBP_D_INN_DEDUCT_M_YN
                            PBP_D_INN_DEDUCT_NM_YN
                            PBP_D_INN_DEDUCT_AMT
                            PBP_D_INN_DEDUCT_M_CATS
                            PBP_D_INN_DEDUCT_NM_CATS
                            PBP_D_NON_DEDUCT_YN
                            PBP_D_NON_DEDUCT_PARTB_YN
                            PBP_D_NON_DEDUCT_M_YN
                            PBP_D_NON_DEDUCT_NM_YN
                            PBP_D_NON_DEDUCT_AMT
                            PBP_D_NON_DEDUCT_M_CATS
                            PBP_D_NON_DEDUCT_NM_CATS
                            PBP_D_COMB_DEDUCT_YN
                            PBP_D_COMB_DEDUCT_PARTB_YN
                            PBP_D_COMB_DEDUCT_INN_M_YN
                            PBP_D_COMB_DEDUCT_INN_NM_YN
                            PBP_D_COMB_DEDUCT_AMT
                            PBP_D_COMB_DEDUCT_INN_M_CATS
                            PBP_D_COMB_DEDUCT_INN_NM_CATS
                            );

  *SET THE PART B DEDUCTIBLE AMOUNTS AND APPLY ACROSS MEDICARE AND NONMEDICARE;

IF PBP_A_PLAN_TYPE='09'   /* PFFS */ AND PBP_A_NETWORK_FLAG  ='2' /* NON NETWORK */ THEN
   DO;
      PBP_D_INN_DEDUCT_YN       = PBP_D_NON_DEDUCT_YN;
      PBP_D_INN_DEDUCT_PARTB_YN = PBP_D_NON_DEDUCT_PARTB_YN;
      PBP_D_INN_DEDUCT_M_YN     = PBP_D_NON_DEDUCT_M_YN;
      PBP_D_INN_DEDUCT_NM_YN    = PBP_D_NON_DEDUCT_NM_YN;
      PBP_D_INN_DEDUCT_AMT      = PBP_D_NON_DEDUCT_AMT;
      PBP_D_INN_DEDUCT_M_CATS   = PBP_D_NON_DEDUCT_M_CATS;
      PBP_D_INN_DEDUCT_NM_CATS  = PBP_D_NON_DEDUCT_NM_CATS;
   END;


IF PBP_D_INN_DEDUCT_YN='2' /* NO */ AND PBP_D_COMB_DEDUCT_YN='1' /* NETWORK */ THEN
   DO;
      PBP_D_INN_DEDUCT_YN       = PBP_D_COMB_DEDUCT_YN;
      PBP_D_INN_DEDUCT_PARTB_YN = PBP_D_COMB_DEDUCT_PARTB_YN;
      PBP_D_INN_DEDUCT_M_YN     = PBP_D_COMB_DEDUCT_INN_M_YN;
      PBP_D_INN_DEDUCT_NM_YN    = PBP_D_COMB_DEDUCT_INN_NM_YN;
      PBP_D_INN_DEDUCT_AMT      = PBP_D_COMB_DEDUCT_AMT;
      PBP_D_INN_DEDUCT_M_CATS   = PBP_D_COMB_DEDUCT_INN_M_CATS;
      PBP_D_INN_DEDUCT_NM_CATS  = PBP_D_COMB_DEDUCT_INN_NM_CATS;
   END;

IF PBP_D_INN_DEDUCT_YN='1' AND PBP_D_INN_DEDUCT_PARTB_YN='1' THEN PARTB_DEDUCT = &PARTB_DEDUCT.;
ELSE IF PBP_D_INN_DEDUCT_YN='1' AND PBP_D_INN_DEDUCT_PARTB_YN='2' THEN PARTB_DEDUCT = PBP_D_INN_DEDUCT_AMT;
ELSE IF PBP_D_INN_DEDUCT_YN='2' THEN PARTB_DEDUCT = 0.00;


PBP_D_INN_DEDUCT_AMT=PARTB_DEDUCT;

  ARRAY CATS_M(35)  CATM1 - CATM35;
  LENGTH CATEGORY_M $3;

  LENGTH TYPE $4;
  TYPE=PUT(HPLAN,$TYPEF.);
  IF PBP_D_INN_DEDUCT_AMT > 0 or type='MSA';
  IF PBP_D_INN_DEDUCT_M_YN = '1' or type='MSA' THEN DO I = 1 TO 35;
    CATEGORY_M = CATS_M(I);
    IF TYPE='MSA' THEN OUTPUT;
    ELSE IF CATEGORY_M ^IN ('4a','4b','15c') THEN OUTPUT;  
  END;
  ELSE DO;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 24, 1) = '1' THEN DO; CATEGORY_M = '10a'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 25, 1) = '1' THEN DO; CATEGORY_M = '11a'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 26, 1) = '1' THEN DO; CATEGORY_M = '11b'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 28, 1) = '1' THEN DO; CATEGORY_M = '12';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 32, 1) = '1' THEN DO; CATEGORY_M = '15m'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 33, 1) = '1' THEN DO; CATEGORY_M = '16b'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 34, 1) = '1' THEN DO; CATEGORY_M = '17a'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 35, 1) = '1' THEN DO; CATEGORY_M = '17b'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 36, 1) = '1' THEN DO; CATEGORY_M = '18a'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 2,  1) = '1' THEN DO; CATEGORY_M = '1a';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 3,  1) = '1' THEN DO; CATEGORY_M = '1b';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 4,  1) = '1' THEN DO; CATEGORY_M = '2';   OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 9,  1) = '1' THEN DO; CATEGORY_M = '7a';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 10, 1) = '1' THEN DO; CATEGORY_M = '7b';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 11, 1) = '1' THEN DO; CATEGORY_M = '7c';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 12, 1) = '1' THEN DO; CATEGORY_M = '7d';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 13, 1) = '1' THEN DO; CATEGORY_M = '7e';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 14, 1) = '1' THEN DO; CATEGORY_M = '7f';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 15, 1) = '1' THEN DO; CATEGORY_M = '7g';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 16, 1) = '1' THEN DO; CATEGORY_M = '7h';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 17, 1) = '1' THEN DO; CATEGORY_M = '7i';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 18, 1) = '1' THEN DO; CATEGORY_M = '8ad'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 18, 1) = '1' THEN DO; CATEGORY_M = '8al'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 19, 1) = '1' THEN DO; CATEGORY_M = '8bx'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 19, 1) = '1' THEN DO; CATEGORY_M = '8bd'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 19, 1) = '1' THEN DO; CATEGORY_M = '8br'; OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 20, 1) = '1' THEN DO; CATEGORY_M = '9a';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 21, 1) = '1' THEN DO; CATEGORY_M = '9b';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS,  5, 1) = '1' THEN DO; CATEGORY_M = '3c';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS,  7, 1) = '1' THEN DO; CATEGORY_M = '3p';  OUTPUT; END;
    IF SUBSTR(PBP_D_INN_DEDUCT_M_CATS, 31, 1) = '1' THEN DO; CATEGORY_M = '14e'; OUTPUT; END;
  END;

    KEEP HPLAN CATEGORY_M;
RUN;

DATA DEDUCTION_CATS_NM;

  IF _N_ = 1 THEN SET CATSNM;

    SET PBP_FILE(KEEP=HPLAN
                            PBP_A_PLAN_TYPE
                            PBP_A_NETWORK_FLAG
                            PBP_D_INN_DEDUCT_YN
                            PBP_D_INN_DEDUCT_PARTB_YN
                            PBP_D_INN_DEDUCT_M_YN
                            PBP_D_INN_DEDUCT_NM_YN
                            PBP_D_INN_DEDUCT_AMT
                            PBP_D_INN_DEDUCT_M_CATS
                            PBP_D_INN_DEDUCT_NM_CATS
                            PBP_D_NON_DEDUCT_YN
                            PBP_D_NON_DEDUCT_PARTB_YN
                            PBP_D_NON_DEDUCT_M_YN
                            PBP_D_NON_DEDUCT_NM_YN
                            PBP_D_NON_DEDUCT_AMT
                            PBP_D_NON_DEDUCT_M_CATS
                            PBP_D_NON_DEDUCT_NM_CATS);


  *SET THE PART B DEDUCTIBLE AMOUNTS AND APPLY ACROSS MEDICARE AND NONMEDICARE;

IF PBP_A_PLAN_TYPE='09' /* PFFS */ AND PBP_A_NETWORK_FLAG  ='2' /* NON NETWORK */ THEN
   DO;
      PBP_D_INN_DEDUCT_YN       = PBP_D_NON_DEDUCT_YN;
      PBP_D_INN_DEDUCT_PARTB_YN = PBP_D_NON_DEDUCT_PARTB_YN;
      PBP_D_INN_DEDUCT_M_YN     = PBP_D_NON_DEDUCT_M_YN;
      PBP_D_INN_DEDUCT_NM_YN    = PBP_D_NON_DEDUCT_NM_YN;
      PBP_D_INN_DEDUCT_AMT      = PBP_D_NON_DEDUCT_AMT;
      PBP_D_INN_DEDUCT_M_CATS   = PBP_D_NON_DEDUCT_M_CATS;
      PBP_D_INN_DEDUCT_NM_CATS  = PBP_D_NON_DEDUCT_NM_CATS;
   END;

IF      PBP_D_INN_DEDUCT_YN='1' AND PBP_D_INN_DEDUCT_PARTB_YN='1' THEN PARTB_DEDUCT = &PARTB_DEDUCT.;
ELSE IF PBP_D_INN_DEDUCT_YN='1' AND PBP_D_INN_DEDUCT_PARTB_YN='2' THEN PARTB_DEDUCT = PBP_D_INN_DEDUCT_AMT;
ELSE IF PBP_D_INN_DEDUCT_YN='2'                                   THEN PARTB_DEDUCT = 0.00;

PBP_D_INN_DEDUCT_AMT=PARTB_DEDUCT;

  ARRAY CATS_NM(4)  CATNM1- CATNM4;

  LENGTH CATEGORY_NM $3;


  IF PBP_D_INN_DEDUCT_AMT > 0;
    IF PBP_D_INN_DEDUCT_NM_YN = '1' THEN DO I = 1 TO 4;
      CATEGORY_NM = CATS_NM(I);
      OUTPUT;
    END;
    ELSE DO;
      IF SUBSTR(PBP_D_INN_DEDUCT_NM_CATS, 21, 1) = '1' THEN DO; CATEGORY_NM = '16 '; OUTPUT; END;
      IF SUBSTR(PBP_D_INN_DEDUCT_NM_CATS, 22, 1) = '1' THEN DO; CATEGORY_NM = '16b'; OUTPUT; END;
      IF SUBSTR(PBP_D_INN_DEDUCT_NM_CATS, 24, 1) = '1' THEN DO; CATEGORY_NM = '17b'; OUTPUT; END;
      IF SUBSTR(PBP_D_INN_DEDUCT_NM_CATS, 25, 1) = '1' THEN DO; CATEGORY_NM = '18a'; OUTPUT; END;
    END;

  KEEP HPLAN CATEGORY_NM;
RUN;

DATA DEDUCTION_CATS_M_NM;
 SET DEDUCTION_CATS_M(RENAME=(CATEGORY_M=CATEGORY))
     DEDUCTION_CATS_NM(RENAME=(CATEGORY_NM=CATEGORY));
RUN;

PROC SORT DATA=DEDUCTION_CATS_M_NM OUT=DEDUCTION_CATS NODUPKEY;
BY HPLAN CATEGORY;
RUN;

*******;
*** MERGE ON THE FILE THAT INDICATES WHETHER A PLAN LEVEL DEDUCTIBLE
*** APPLIED TO A PARTICULAR CATEGORY;
*******;

%MACRO BASEID_PLAN(YEAR);

DATA PBPCATS_MERGE;

   MERGE  PBPCATS_MCCOST_&YEAR(IN = A) DEDUCTION_CATS(IN = B);

  BY HPLAN CATEGORY;
  IF A AND B THEN DEDGRP = '1';
  ELSE DEDGRP = '0';
  IF A;
RUN;

PROC SORT DATA = PBPCATS_MERGE;
  BY BASEID HPLAN;
RUN;

*******;
*** SUMMARIZE MANGAGED CARE COST DATA BY PLAN AND PERSON;
*******;

PROC SUMMARY DATA = PBPCATS_MERGE NWAY MISSING;
  CLASS HPLAN BASEID DEDGRP;
  VAR COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST AMTTOT AMTTOT_AMO AMTTOT_MC;
  WHERE DEDGRP = '1';
  OUTPUT OUT = PBPCATS_SUMMARY(DROP = _TYPE_ _FREQ_) SUM= ;
RUN;


DATA PBP_DEDUCTIBLE;

           SET  PBP_FILE(KEEP=HPLAN
                            PBP_A_PLAN_TYPE
                            PBP_A_NETWORK_FLAG
                            PBP_D_INN_DEDUCT_YN
                            PBP_D_INN_DEDUCT_PARTB_YN
                            PBP_D_INN_DEDUCT_M_YN
                            PBP_D_INN_DEDUCT_NM_YN
                            PBP_D_INN_DEDUCT_AMT
                            PBP_D_INN_DEDUCT_M_CATS
                            PBP_D_INN_DEDUCT_NM_CATS
                            PBP_D_NON_DEDUCT_YN
                            PBP_D_NON_DEDUCT_PARTB_YN
                            PBP_D_NON_DEDUCT_M_YN
                            PBP_D_NON_DEDUCT_NM_YN
                            PBP_D_NON_DEDUCT_AMT
                            PBP_D_NON_DEDUCT_M_CATS
                            PBP_D_NON_DEDUCT_NM_CATS
                            PBP_D_INN_DEDUCT_BENS
                            PBP_D_NON_DEDUCT_BENS
                            PBP_D_COMB_DEDUCT_YN
                            PBP_D_COMB_DEDUCT_PARTB_YN
                            PBP_D_COMB_DEDUCT_AMT
                            PBP_D_COMB_DEDUCT_BENS
                            PBP_D_MSA_DED_AMT 
                            PBP_D_MSA_ANNUAL_AMT);


 IF PBP_A_PLAN_TYPE='09' /* PFFS */ AND PBP_A_NETWORK_FLAG  ='2' /* NON NETWORK */ THEN
    DO;
       PBP_D_INN_DEDUCT_YN       = PBP_D_NON_DEDUCT_YN;
       PBP_D_INN_DEDUCT_PARTB_YN = PBP_D_NON_DEDUCT_PARTB_YN;
       PBP_D_INN_DEDUCT_AMT      = PBP_D_NON_DEDUCT_AMT;
       PBP_D_INN_DEDUCT_BENS     = PBP_D_NON_DEDUCT_BENS;
    END;


 IF PBP_D_INN_DEDUCT_YN='2' AND PBP_D_COMB_DEDUCT_YN='1' /* NETWORK */ THEN
    DO;
       PBP_D_INN_DEDUCT_YN       = PBP_D_COMB_DEDUCT_YN;
       PBP_D_INN_DEDUCT_PARTB_YN = PBP_D_COMB_DEDUCT_PARTB_YN;
       PBP_D_INN_DEDUCT_AMT      = PBP_D_COMB_DEDUCT_AMT;
       PBP_D_INN_DEDUCT_BENS     = SUBSTR(PBP_D_COMB_DEDUCT_BENS,1,2);
    END;

 IF PBP_D_INN_DEDUCT_YN='1' AND PBP_D_INN_DEDUCT_PARTB_YN='1' THEN PARTB_DEDUCT = &PARTB_DEDUCT.;
 ELSE IF PBP_D_INN_DEDUCT_YN='1' AND PBP_D_INN_DEDUCT_PARTB_YN='2' THEN PARTB_DEDUCT = PBP_D_INN_DEDUCT_AMT;
 ELSE IF PBP_D_INN_DEDUCT_YN='2' THEN PARTB_DEDUCT = 0.00;
 
 PBP_D_INN_DEDUCT_AMT=PARTB_DEDUCT;

  IF PBP_D_INN_DEDUCT_BENS = '01' THEN PBP_D_INN_DEDUCT_TYPE = '1';
  ELSE IF PBP_D_INN_DEDUCT_BENS = '10' THEN PBP_D_INN_DEDUCT_TYPE = '2';
  ELSE IF PBP_D_INN_DEDUCT_BENS = '11' THEN PBP_D_INN_DEDUCT_TYPE = '3';
  ELSE PBP_D_INN_DEDUCT_TYPE = ' ';

  IF PBP_D_INN_DEDUCT_AMT > 0 OR PUT(HPLAN,$TYPEF.)='MSA';
  KEEP HPLAN PBP_D_INN_DEDUCT_AMT PBP_D_INN_DEDUCT_TYPE PBP_D_MSA_DED_AMT PBP_D_MSA_ANNUAL_AMT;
RUN;

PROC SORT DATA = PBP_DEDUCTIBLE;
  BY HPLAN;
RUN;

******;
*** COMPUTE REDUCTION FACTORS FOR DEDUCTIBLE (BASEID/PLAN);
******;

DATA PBP_TOTCOST_DED;
  MERGE PBPCATS_SUMMARY(IN = A) PBP_DEDUCTIBLE(IN = B);
  BY HPLAN;
  IF A AND B;

  LENGTH TYPE $4;
  TYPE=PUT(HPLAN,$TYPEF.);
  
  IF TYPE ^= 'MSA' THEN DO;
  
    AMTTOT_COVERED = SUM(AMTTOT_MC,AMTTOT_AMO);

    COST_SHARE_COST_SUM = SUM(COST_SHARE_COST_MC, COST_SHARE_COST_AMO);

    IF AMTTOT_COVERED <= PBP_D_INN_DEDUCT_AMT THEN DO;
      COST_SHARE_COST_REDUCTION = 0;
      COST_SHARE_COST_DEDUCTIBLE = AMTTOT_COVERED;
    END;
    ELSE IF AMTTOT_COVERED > 0 AND AMTTOT_COVERED > PBP_D_INN_DEDUCT_AMT THEN DO;
      COST_SHARE_COST_REDUCTION = 1 - (PBP_D_INN_DEDUCT_AMT / AMTTOT_COVERED);
      COST_SHARE_COST_DEDUCTIBLE = PBP_D_INN_DEDUCT_AMT;
    END;

    COST_SHARE_COST_SUM = SUM(COST_SHARE_COST_MC, COST_SHARE_COST_AMO);

    COST_SHARE_COST_REDUCTION_MC  = 1;
    COST_SHARE_COST_DEDUCTIBLE_MC = .;

    COST_SHARE_COST_REDUCTION_AMO  = 1;
    COST_SHARE_COST_DEDUCTIBLE_AMO = .;

    * MEDICARE BENEFITS ONLY;
    IF PBP_D_INN_DEDUCT_TYPE = '1' THEN DO;
      IF AMTTOT_MC <= PBP_D_INN_DEDUCT_AMT THEN DO;
        COST_SHARE_COST_DEDUCTIBLE_MC = AMTTOT_MC;
      END;
      ELSE IF AMTTOT_MC > 0 AND AMTTOT_MC > PBP_D_INN_DEDUCT_AMT THEN DO;
        COST_SHARE_COST_REDUCTION_MC = 1 - (PBP_D_INN_DEDUCT_AMT / AMTTOT_MC);
        COST_SHARE_COST_DEDUCTIBLE_MC = PBP_D_INN_DEDUCT_AMT;
      END;
    END;
    * ENHANCED BENEFITS ONLY;
    ELSE IF PBP_D_INN_DEDUCT_TYPE = '2' THEN DO;
      IF 0 < AMTTOT_COVERED <= PBP_D_INN_DEDUCT_AMT THEN DO;
        COST_SHARE_COST_DEDUCTIBLE_AMO = AMTTOT_COVERED * (AMTTOT_AMO/AMTTOT_COVERED);
      END;
      ELSE IF AMTTOT_COVERED > 0 AND AMTTOT_COVERED > PBP_D_INN_DEDUCT_AMT THEN DO;
        COST_SHARE_COST_REDUCTION_AMO = 1 - (PBP_D_INN_DEDUCT_AMT / AMTTOT_COVERED);
        COST_SHARE_COST_DEDUCTIBLE_AMO = PBP_D_INN_DEDUCT_AMT * (AMTTOT_AMO/AMTTOT_COVERED);
      END;
    END;
    * ALL SERVICES;
    ELSE IF PBP_D_INN_DEDUCT_TYPE  IN('3',' ') THEN DO;
  
      IF 0 < AMTTOT_COVERED <= PBP_D_INN_DEDUCT_AMT THEN DO;
        COST_SHARE_COST_DEDUCTIBLE_MC = AMTTOT_COVERED * (AMTTOT_MC/AMTTOT_COVERED);
        COST_SHARE_COST_DEDUCTIBLE_AMO = AMTTOT_COVERED * (AMTTOT_AMO/AMTTOT_COVERED);
      END;
      ELSE IF AMTTOT_COVERED > 0 AND AMTTOT_COVERED > PBP_D_INN_DEDUCT_AMT THEN DO;
        COST_SHARE_COST_REDUCTION_MC = 1 - (PBP_D_INN_DEDUCT_AMT / AMTTOT_COVERED);
        COST_SHARE_COST_REDUCTION_AMO = 1 - (PBP_D_INN_DEDUCT_AMT / AMTTOT_COVERED);
        COST_SHARE_COST_DEDUCTIBLE_MC = PBP_D_INN_DEDUCT_AMT * (AMTTOT_MC/AMTTOT_COVERED);
        COST_SHARE_COST_DEDUCTIBLE_AMO = PBP_D_INN_DEDUCT_AMT * (AMTTOT_AMO/AMTTOT_COVERED);
      END;
    END;
  END;
  
  ELSE IF TYPE='MSA' THEN DO;
    COST_SHARE_COST_REDUCTION_MC = 1;
    COST_SHARE_COST_REDUCTION_AMO = 1;
    
    AMTTOT_AMO = 0;
    AMTTOT_MC = SUM(AMTTOT,-OTHER_COST);
   
    IF AMTTOT_MC >= PBP_D_MSA_DED_AMT THEN 
      COST_SHARE_COST_REDUCTION_MC = PBP_D_MSA_DED_AMT/AMTTOT_MC;
  END;

RUN;

PROC SORT DATA = PBP_TOTCOST_DED
                 (KEEP = HPLAN BASEID COST_SHARE_COST_REDUCTION
                                      COST_SHARE_COST_REDUCTION_MC
                                      COST_SHARE_COST_REDUCTION_AMO
                                      PBP_D_INN_DEDUCT_AMT
                                      COST_SHARE_COST_DEDUCTIBLE
                                      COST_SHARE_COST_DEDUCTIBLE_MC
                                      COST_SHARE_COST_DEDUCTIBLE_AMO
                         DEDGRP AMTTOT_MC AMTTOT_COVERED AMTTOT_AMO)
          OUT = PBPCATS_PBP_DED;
  WHERE DEDGRP  = '1';
  BY BASEID HPLAN;
RUN;

******;
*** MERGE COST SHARE REDUCTION FACTORS (BASEID/PLAN) ONTO CATEGORY FILE (BASEID/PLAN/CATEGORY);
******;

DATA PBPCATS_MCCOST_DED;
  MERGE PBPCATS_MERGE(IN = A)
        PBPCATS_PBP_DED(IN = B DROP = DEDGRP AMTTOT_AMO AMTTOT_MC);
  BY BASEID HPLAN;
  LENGTH TYPE $4;
  TYPE=PUT(HPLAN,$TYPEF.);
 
  IF A AND B AND DEDGRP = '1' THEN DO;
    IF TYPE ^= 'MSA' THEN DO;
      COST_SHARE_COST     = COST_SHARE_COST * COST_SHARE_COST_REDUCTION;
      COST_SHARE_COST_MC  = COST_SHARE_COST_MC * COST_SHARE_COST_REDUCTION_MC;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * COST_SHARE_COST_REDUCTION_AMO;
    END;
    ELSE IF TYPE = 'MSA' THEN DO;
      COST_SHARE_COST_MC  = COST_SHARE_COST_MC * COST_SHARE_COST_REDUCTION_MC;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * COST_SHARE_COST_REDUCTION_AMO;
      COST_SHARE_COST=SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO);
    END;
  END;

  COST = SUM(COST_SHARE_COST_MC, COST_SHARE_COST_AMO, OTHER_COST);
  COST_CHECK = SUM(COST_SHARE_COST, OTHER_COST);

  OUTPUT;

  IF LAST.HPLAN AND TYPE ^= 'MSA' THEN DO;
    IF COST_SHARE_COST_DEDUCTIBLE NE . THEN COST = COST_SHARE_COST_DEDUCTIBLE;
    ELSE COST = 0;
    IF COST_SHARE_COST_DEDUCTIBLE_MC NE . THEN COST_SHARE_COST_MC = COST_SHARE_COST_DEDUCTIBLE_MC;
    ELSE COST_SHARE_COST_MC = 0;
    IF COST_SHARE_COST_DEDUCTIBLE_AMO NE . THEN COST_SHARE_COST_AMO = COST_SHARE_COST_DEDUCTIBLE_AMO;
    ELSE COST_SHARE_COST_AMO = 0;
    OTHER_COST = 0;
    CATEGORY = 'DED';
    OUTPUT;
  END;
   
  KEEP BASEID HPLAN COST CATEGORY COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST COST_CHECK
  AMTTOT_AMO AMTTOT_MC AMTTOT;
RUN;

PROC SORT DATA = PBPCATS_MCCOST_DED
          OUT =  PBPCATS_MCCOST;
  BY HPLAN CATEGORY;
RUN;

*******;
*** READ THE PBP_D DATA FROM DST_DATA AND BUILD A DATASET WITH EACH ROW REPRESENTING;
*** A CONTRACT AND A CATEGORY FOR WHICH THERE IS A MAX OUT OF POCKET EXPENSE;
*** THIS DATASET HAS TWO VARIABLES: HPLAN AND CATEGORY;
*******;

********;
*** CAPPING MEDICARE COSTS;
********;

DATA MAX_CATS;

  IF _N_ = 1 THEN SET CATSM;

           SET  PBP_FILE(KEEP=HPLAN
                            PBP_A_PLAN_TYPE
                            PBP_A_NETWORK_FLAG
                            PBP_D_OUT_POCKET_AMT_YN
                            PBP_D_OUT_POCKET_AMT
                            PBP_D_INN_MAX_ENR_M_YN
                            PBP_D_INN_MAX_ENR_NM_YN
                            PBP_D_INN_MAX_ENR_M_CAT_EX
                            PBP_D_INN_MAX_ENR_NM_CAT_EX

                            PBP_D_COMB_MAX_ENR_AMT
                            PBP_D_COMB_MAX_ENR_INN_M_YN
                            PBP_D_COMB_MAX_ENR_INN_NM_YN
                            PBP_D_COMB_MAX_ENR_INN_MCAT_EX
                            PBP_D_COMB_MAX_ENR_INN_NMCATEX

                            PBP_D_MAXENR_OOPC_AMT
                            PBP_D_MAXENR_OOPC_M_CATS_YN
                            PBP_D_MAXENR_OOPC_NM_CATS_YN
                            PBP_D_MAXENR_OOPC_M_CATS
                            PBP_D_MAXENR_OOPC_NM_CATS ) ;

  
  ARRAY XCATS (35) CATM1 - CATM35;

  LENGTH CATEGORY $3;

** USE INN MAX IF AVAILABLE, COMBINED IF NOT AND THEN FOR RPPOS, USE THE MAXENR AMT;

   IF PBP_D_OUT_POCKET_AMT NE . OR PBP_D_COMB_MAX_ENR_AMT NE . OR PBP_D_MAXENR_OOPC_AMT  NE . THEN
      OUT_POCKET_MAX_YN='1';
   ELSE OUT_POCKET_MAX_YN='2';
   

   IF PBP_D_OUT_POCKET_AMT NE .  THEN
      DO;
        OUT_POCKET_AMT = PBP_D_OUT_POCKET_AMT;
        MAX_ENR_M_YN   = PBP_D_INN_MAX_ENR_M_YN;
        MAX_ENR_NM_YN  = PBP_D_INN_MAX_ENR_NM_YN;
        MAX_ENR_M_CATS = PBP_D_INN_MAX_ENR_M_CAT_EX;
        MAX_ENR_NM_CATS= PBP_D_INN_MAX_ENR_NM_CAT_EX;
      END;

   ELSE IF PBP_D_OUT_POCKET_AMT=. AND PBP_D_COMB_MAX_ENR_AMT NE . THEN
      DO;
        OUT_POCKET_AMT =PBP_D_COMB_MAX_ENR_AMT;
        MAX_ENR_M_YN   =PBP_D_COMB_MAX_ENR_INN_M_YN;
        MAX_ENR_NM_YN  =PBP_D_COMB_MAX_ENR_INN_NM_YN;
        MAX_ENR_M_CATS =PBP_D_COMB_MAX_ENR_INN_MCAT_EX;
        MAX_ENR_NM_CATS=PBP_D_COMB_MAX_ENR_INN_NMCATEX;
      END;

   ELSE IF PBP_D_OUT_POCKET_AMT=. AND PBP_D_COMB_MAX_ENR_AMT=.    THEN
      DO;
        OUT_POCKET_AMT =PBP_D_MAXENR_OOPC_AMT;
        MAX_ENR_M_YN   =PBP_D_MAXENR_OOPC_M_CATS_YN;
        MAX_ENR_NM_YN  =PBP_D_MAXENR_OOPC_NM_CATS_YN;
        MAX_ENR_M_CATS =PBP_D_MAXENR_OOPC_M_CATS;
        MAX_ENR_NM_CATS=PBP_D_MAXENR_OOPC_NM_CATS;
      END;


   IF MAX_ENR_M_YN='1'  OR PUT(HPLAN,$TYPEF.)='MSA' THEN DO I = 1 TO 35;
      CATEGORY = XCATS(I);
      OUTPUT;
     END;

   ELSE DO;
          CATEGORY = '4b';  OUTPUT;
          CATEGORY = '6' ;  OUTPUT;
          CATEGORY = '15c'; OUTPUT;   
          IF SUBSTR(MAX_ENR_M_CATS, 25, 1) = '0' THEN DO; CATEGORY = '10a'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 26, 1) = '0' THEN DO; CATEGORY = '11a'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 27, 1) = '0' THEN DO; CATEGORY = '11b'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 29, 1) = '0' THEN DO; CATEGORY = '12';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 33, 1) = '0' THEN DO; CATEGORY = '15m'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 34, 1) = '0' THEN DO; CATEGORY = '16b'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 35, 1) = '0' THEN DO; CATEGORY = '17a'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 37, 1) = '0' THEN DO; CATEGORY = '18a'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 2 , 1) = '0' THEN DO; CATEGORY = '1a';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 3 , 1) = '0' THEN DO; CATEGORY = '1b';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 4 , 1) = '0' THEN DO; CATEGORY = '2';   OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 5 , 1) = '0' THEN DO; CATEGORY = '3c';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 8 , 1) = '0' THEN DO; CATEGORY = '4a';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 10 ,1) = '0' THEN DO; CATEGORY = '7a';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 11, 1) = '0' THEN DO; CATEGORY = '7b';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 12, 1) = '0' THEN DO; CATEGORY = '7c';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 13, 1) = '0' THEN DO; CATEGORY = '7d';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 14, 1) = '0' THEN DO; CATEGORY = '7e';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 15, 1) = '0' THEN DO; CATEGORY = '7f';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 16, 1) = '0' THEN DO; CATEGORY = '7g';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 17, 1) = '0' THEN DO; CATEGORY = '7h';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 18, 1) = '0' THEN DO; CATEGORY = '7i';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 19, 1) = '0' THEN DO; CATEGORY = '8ad'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 19, 1) = '0' THEN DO; CATEGORY = '8al'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 20, 1) = '0' THEN DO; CATEGORY = '8bx'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 20, 1) = '0' THEN DO; CATEGORY = '8bd'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 20, 1) = '0' THEN DO; CATEGORY = '8br'; OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 21, 1) = '0' THEN DO; CATEGORY = '9a';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 22, 1) = '0' THEN DO; CATEGORY = '9b';  OUTPUT; END;
          IF SUBSTR(MAX_ENR_M_CATS, 32, 1) = '0' THEN DO; CATEGORY = '14e'; OUTPUT; END;
    END;
    IF PUT(HPLAN,$TYPEF.)='MSA' THEN DO;
      CATEGORY = '17b'; OUTPUT; 
    END;
   

KEEP HPLAN CATEGORY;
RUN;

PROC SORT DATA = MAX_CATS OUT=MAX_CATS;
  BY HPLAN CATEGORY;
RUN;

*******;
*** MERGE ON THE FILE THAT INDICATES WHETHER A PLAN HAD A MAXIMUM OOP EXPENSE;
*** IN A PARTICULAR CATEGORY;
*******;

DATA PBPCATS_MERGE;
  MERGE PBPCATS_MCCOST(IN = A)
        MAX_CATS(IN = B);
  BY HPLAN CATEGORY;
  IF A AND B THEN MAXGRP = '1';
  ELSE MAXGRP = '0';
  IF A;
RUN;

PROC SORT DATA = PBPCATS_MERGE;
  BY BASEID HPLAN CATEGORY;
RUN;

PROC SUMMARY DATA = PBPCATS_MERGE NWAY MISSING;
  CLASS HPLAN BASEID MAXGRP;
  VAR COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST;
  WHERE MAXGRP = '1';
  OUTPUT OUT = PBPCATS_SUMMARY(DROP = _FREQ_ _TYPE_) SUM=;
RUN;

*******;
*** GET THE OUT OF POCKET MAXIMUM FROM THE PBP DATA;
*** NO LONGER A PERIODICITY FOR OUT OF POCKET MAX;
*******;

DATA PBP_OOPCMAX;

           SET  PBP_FILE(KEEP=HPLAN
                            PBP_A_PLAN_TYPE
                            PBP_A_NETWORK_FLAG
                            PBP_D_OUT_POCKET_AMT_YN
                            PBP_D_OUT_POCKET_AMT
                            PBP_D_MAXENR_OOPC_AMT
                            PBP_D_COMB_MAX_ENR_AMT
                            PBP_D_INN_MAX_ENR_M_YN  
                            PBP_D_MSA_DED_AMT 
                            PBP_D_MSA_ANNUAL_AMT);


  ** USE INN MAX IF AVAILABLE, COMBINED IF NOT AND THEN FOR RPPOS, USE THE MAXENR AMT;

   IF PBP_D_OUT_POCKET_AMT NE . OR PBP_D_COMB_MAX_ENR_AMT NE . OR PBP_D_MAXENR_OOPC_AMT  NE . THEN
      OUT_POCKET_MAX_YN='1';
   ELSE OUT_POCKET_MAX_YN='2';

   IF PBP_D_OUT_POCKET_AMT NE . THEN
        OUT_POCKET_AMT = PBP_D_OUT_POCKET_AMT;

   ELSE IF PBP_D_OUT_POCKET_AMT=. AND PBP_D_COMB_MAX_ENR_AMT NE . THEN
        OUT_POCKET_AMT =PBP_D_COMB_MAX_ENR_AMT;

   ELSE IF PBP_D_OUT_POCKET_AMT=. AND PBP_D_COMB_MAX_ENR_AMT=. THEN
        OUT_POCKET_AMT =PBP_D_MAXENR_OOPC_AMT;

  IF OUT_POCKET_AMT >= 0 OR PUT(HPLAN,$TYPEF.)='MSA';

KEEP HPLAN OUT_POCKET_AMT PBP_D_MSA_DED_AMT PBP_D_MSA_ANNUAL_AMT;
RUN;


PROC SORT DATA = PBP_OOPCMAX;
  BY HPLAN;
RUN;

******;
*** CAP THE COST_SHARE_COST AMOUNT AND COMPUTE REDUCTION FACTORS (BASEID/PLAN);
******;

DATA PBPCATS_PBP_&YEAR;
  MERGE PBPCATS_SUMMARY(IN = A) PBP_OOPCMAX(IN = B);
  BY HPLAN;
  IF A AND B;
  
  IF PUT(HPLAN,$TYPEF.) ^= 'MSA' THEN DO;
    IF COST_SHARE_COST <= OUT_POCKET_AMT THEN COST_SHARE_COST_REDUCTION = 1;
    ELSE IF COST_SHARE_COST > 0 THEN COST_SHARE_COST_REDUCTION = MIN(COST_SHARE_COST, OUT_POCKET_AMT) / COST_SHARE_COST;
    ELSE COST_SHARE_COST_REDUCTION = 0;

    COST_SHARE_COST_REDUCTION_MC  = 1;
    COST_SHARE_COST_REDUCTION_AMO = 1;

    ***SET OUT_POCKET_AMT TO OUT_POCKET_MC_AMT ***;
    ***OUT_POCKET_AMT INN and/or COMBINED MUST INCLUDE ALL MC SERVICES ***;

    PBP_D_OUT_POCKET_TYPE='1';
    OUT_POCKET_MC_AMT    =OUT_POCKET_AMT;

    IF PBP_D_OUT_POCKET_TYPE = '1' THEN DO;
      IF COST_SHARE_COST_MC <= OUT_POCKET_MC_AMT THEN COST_SHARE_COST_REDUCTION_MC = 1;
      ELSE IF COST_SHARE_COST_MC > 0 THEN
        COST_SHARE_COST_REDUCTION_MC = MIN(COST_SHARE_COST_MC,OUT_POCKET_MC_AMT) / COST_SHARE_COST_MC;
      ELSE COST_SHARE_COST_REDUCTION_MC = 0;
    END;
    ELSE IF PBP_D_OUT_POCKET_TYPE = '2' THEN DO;
      IF COST_SHARE_COST_AMO <= OUT_POCKET_AMT THEN COST_SHARE_COST_REDUCTION_AMO = 1;
      ELSE IF COST_SHARE_COST_AMO > 0 THEN
        COST_SHARE_COST_REDUCTION_AMO = MIN(COST_SHARE_COST_AMO,OUT_POCKET_AMT) / COST_SHARE_COST_AMO;
      ELSE COST_SHARE_COST_REDUCTION_AMO = 0;
    END;
    ELSE IF PBP_D_OUT_POCKET_TYPE = '3' THEN DO;

      COST_SHARE_COST_SUM = SUM(COST_SHARE_COST_MC, COST_SHARE_COST_AMO);

      * NEITHER CAP BINDING;
      IF COST_SHARE_COST_SUM <= OUT_POCKET_AMT AND COST_SHARE_COST_MC <= OUT_POCKET_MC_AMT THEN DO;
        COST_SHARE_COST_REDUCTION_MC  = 1;
        COST_SHARE_COST_REDUCTION_AMO = 1;
      END;
      * MEDICARE BINDING, OVERALL NOT BINDING;
      ELSE IF COST_SHARE_COST_SUM <= OUT_POCKET_AMT AND COST_SHARE_COST_MC > OUT_POCKET_MC_AMT THEN DO;
        IF COST_SHARE_COST_MC > 0 THEN
          COST_SHARE_COST_REDUCTION_MC = MIN(COST_SHARE_COST_MC,OUT_POCKET_MC_AMT) / COST_SHARE_COST_MC;
        ELSE COST_SHARE_COST_REDUCTION_MC = 0;
        COST_SHARE_COST_REDUCTION_AMO = 1;
      END;
      * MEDICARE NOT BINDING, OVERALL BINDING;
      ELSE IF COST_SHARE_COST_SUM > OUT_POCKET_AMT AND COST_SHARE_COST_MC <= OUT_POCKET_MC_AMT THEN DO;
        IF COST_SHARE_COST_SUM > 0 THEN
          COST_SHARE_COST_REDUCTION_SUM = MIN(COST_SHARE_COST_SUM,OUT_POCKET_AMT) / COST_SHARE_COST_SUM;
        ELSE COST_SHARE_COST_REDUCTION_MC = 0;
        COST_SHARE_COST_REDUCTION_AMO = COST_SHARE_COST_REDUCTION_SUM;
        COST_SHARE_COST_REDUCTION_MC  = COST_SHARE_COST_REDUCTION_SUM;
      END;
      * MEDICARE BINDING, OVERALL BINDING;
      ELSE IF COST_SHARE_COST_SUM > OUT_POCKET_AMT AND COST_SHARE_COST_MC > OUT_POCKET_MC_AMT THEN DO;
        IF COST_SHARE_COST_MC > 0 THEN
         COST_SHARE_COST_REDUCTION_MC = MIN(COST_SHARE_COST_MC,OUT_POCKET_MC_AMT) / COST_SHARE_COST_MC;
        ELSE COST_SHARE_COST_REDUCTION_MC = 0;
        IF COST_SHARE_COST_AMO > 0 THEN
         COST_SHARE_COST_REDUCTION_AMO = MIN(COST_SHARE_COST_AMO,SUM(OUT_POCKET_AMT,-OUT_POCKET_MC_AMT)) / COST_SHARE_COST_AMO;
        ELSE COST_SHARE_COST_REDUCTION_AMO = 0;
      END;
    END;
  END;
  ELSE IF PUT(HPLAN,$TYPEF.) = 'MSA' THEN DO;
    IF SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO) < PBP_D_MSA_ANNUAL_AMT THEN DO;
      COST_SHARE_COST_REDUCTION_MC = 0;
      COST_SHARE_COST_REDUCTION_AMO = 0;
      MSA_BALANCE=SUM(PBP_D_MSA_ANNUAL_AMT,-COST_SHARE_COST_MC,-COST_SHARE_COST_AMO);
    END;
    ELSE IF SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO) >= PBP_D_MSA_ANNUAL_AMT THEN DO;
      COST_SHARE_COST_REDUCTION_MC = 1 - (PBP_D_MSA_ANNUAL_AMT/SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
      COST_SHARE_COST_REDUCTION_AMO = 1 - (PBP_D_MSA_ANNUAL_AMT/SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
    END;
  END; 
     
RUN;

PROC SORT DATA = PBPCATS_PBP_&YEAR
               (KEEP = HPLAN BASEID COST_SHARE_COST_REDUCTION
                       COST_SHARE_COST_REDUCTION_MC
                       COST_SHARE_COST_REDUCTION_AMO
                       MAXGRP MSA_BALANCE)
          OUT = PBPCATS_PBP_MAX;
  BY BASEID HPLAN;
  WHERE MAXGRP = '1';
RUN;

******;
*** MERGE COST SHARE REDUCTION FACTORS (BASEID/PLAN) ONTO CATEGORY FILE (BASEID/PLAN/CATEGORY);
******;

DATA PBPCATS;
  MERGE PBPCATS_MERGE(IN = A)
        PBPCATS_PBP_MAX(IN = B DROP = MAXGRP);
  BY BASEID HPLAN;
  IF A AND B AND MAXGRP = '1' THEN DO;
    IF PUT(HPLAN,$TYPEF.) ^= 'MSA' THEN DO;
      COST_SHARE_COST = COST_SHARE_COST * COST_SHARE_COST_REDUCTION;
      COST_SHARE_COST_MC = COST_SHARE_COST_MC * COST_SHARE_COST_REDUCTION_MC;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * COST_SHARE_COST_REDUCTION_AMO;
    END;
    ELSE IF PUT(HPLAN,$TYPEF.) = 'MSA' THEN DO;
      COST_SHARE_COST_MC  = COST_SHARE_COST_MC * COST_SHARE_COST_REDUCTION_MC;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * COST_SHARE_COST_REDUCTION_AMO;
      COST_SHARE_COST=SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO);
    END;
  END;

  COST = SUM(COST_SHARE_COST_MC, COST_SHARE_COST_AMO, OTHER_COST);
  COST_CHECK = SUM(COST_SHARE_COST, OTHER_COST);
  IF CATEGORY = '' THEN DELETE;
 
  KEEP BASEID HPLAN COST CATEGORY COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST COST_CHECK MSA_BALANCE AMTTOT;
RUN;

*** MONTHLY COST FOR PEOPLE WITH UTILIZATION BY CATEGORY;

DATA BASEID_PLAN_CATEGORY;
  MERGE PBPCATS(IN = A)

          &INP(IN = B KEEP = BASEID INDMON CELL_GROUP CSYRWGT YEAR WHERE=(YEAR="&YEAR"));

  BY BASEID;
  IF A;

  MONTHLY_COST = COST / INDMON;
  MONTHLY_COST_CHECK = COST_CHECK / INDMON;

  MONTHLY_COST_MC    = COST_SHARE_COST_MC / INDMON;
  MONTHLY_COST_AMO   = COST_SHARE_COST_AMO / INDMON;
  MONTHLY_OTHER_COST = OTHER_COST / INDMON;

  RENAME CSYRWGT = CWGT;

RUN;

* CREATE ALL CATEGORY SUMMING UP MONTHLY COST ACROSS CATEGORIES;
* FOR A PERSON PLAN;


DATA BASEID_PLAN_CATEGORY_ALL;
  SET BASEID_PLAN_CATEGORY;
  BY BASEID HPLAN;

  RETAIN TOT_COSTS TOT_COSTS_CHECK TOT_COSTS_MC TOT_COSTS_AMO TOT_COSTS_OTHER;

  OUTPUT;

  IF FIRST.HPLAN THEN DO;
    TOT_COSTS = 0;
    TOT_COSTS_MC = 0;
    TOT_COSTS_AMO = 0;
    TOT_COSTS_OTHER = 0;
  END;
  IF FIRST.HPLAN THEN TOT_COSTS_CHECK = 0;

  TOT_COSTS + MONTHLY_COST;
  TOT_COSTS_MC + MONTHLY_COST_MC;
  TOT_COSTS_AMO + MONTHLY_COST_AMO;
  TOT_COSTS_OTHER + MONTHLY_OTHER_COST;
  TOT_COSTS_CHECK + MONTHLY_COST_CHECK;

  IF LAST.HPLAN THEN DO;
    CATEGORY = 'ALL';
    MONTHLY_COST = TOT_COSTS;
    MONTHLY_COST_MC = TOT_COSTS_MC;
    MONTHLY_COST_AMO = TOT_COSTS_AMO;
    MONTHLY_OTHER_COST = TOT_COSTS_OTHER;
    MONTHLY_COST_CHECK = TOT_COSTS_CHECK;
    OUTPUT;
  END;

  DROP TOT_COSTS TOT_COSTS_CHECK TOT_COSTS_MC TOT_COSTS_AMO TOT_COSTS_OTHER;
RUN;

PROC SORT DATA = BASEID_PLAN_CATEGORY_ALL OUT=BASEID_PLAN_CATEGORY_ALL;
  BY HPLAN CATEGORY CELL_GROUP;
RUN;


* ADD THE MISSING MEMBERS OF THE COHORT WITH NO UTILIZATION;
* FOR EACH PLAN/CATEGORY ADD A ROW FOR EACH CELL_GROUP FOR THE PEOPLE WITH NO UTILIZATION;
* FOR EACH PLAN WRITE OUT AN ALL CATEGORY ROW FOR EACH MISSING PERSON;

DATA BASEID_PLAN_CATEGORY_COMPLETE;

  IF _N_ = 1 THEN SET  MISSING_CELLS_&YEAR;
  SET BASEID_PLAN_CATEGORY_ALL;
  BY HPLAN CATEGORY;

  ARRAY ACWGT CWGT1 - CWGT30;
  ARRAY ACELL   CELL1   - CELL30;

  OUTPUT;

  IF LAST.HPLAN THEN DO;
    DO I = 1 TO 30;
       CATEGORY = 'ALL';
      CELL_GROUP = ACELL(I);
      BASEID = 'MISS' !! LEFT(PUT(I,2.));
      CWGT = ACWGT(I);
      COST = 0;
      MONTHLY_COST = 0;
      MONTHLY_COST_MC = 0;
      MONTHLY_COST_AMO = 0;
      MONTHLY_OTHER_COST  = 0;
      IF ACELL(I) NE '' THEN OUTPUT;
    END;
  END;

  KEEP BASEID HPLAN CATEGORY CWGT COST CELL_GROUP MONTHLY_COST
       MONTHLY_COST_MC MONTHLY_COST_AMO MONTHLY_OTHER_COST YEAR MSA_BALANCE INDMON AMTTOT;
RUN;


PROC SORT DATA = BASEID_PLAN_CATEGORY_COMPLETE OUT= BASEID_PLAN_CATEGORY_COMP_&YEAR;
  BY CELL_GROUP HPLAN CATEGORY;
RUN;

%MEND;
RUN;


%BASEID_PLAN(&YEAR1);
RUN;
%BASEID_PLAN(&YEAR2);
RUN;
