
* PROGRAM: CONVERT_DST.SAS;
* CONVERTS APPROPRIATE CHARACTER VARIABLES TO NUMERIC LENGTH 8;
options mprint source2;

%macro c_to_n(varlist=,informat=8.);

   %local i word delm;
   %let delm = %str( );
   %let note = %str(NOTES);
   %let yn = %str(_YN);
   %let cats = %str(_CATS);
   %let bens = %str(_BENS);
   %let type = %str(_TYPE_);
   %let per = %str(_PER_);
   %let amo = %str(_AMO_);
   %let pov = %str(_POV);
   %let per_ = %str(_PER);
   %let typ_ = %str(_TYPE);
   %let ad = %str(LIM_AD);
   %let auth = %str(_AUTH);
   %let catex = %str(CATEX);
   %let cat_ex = %str(CAT_EX);
   %let charge = %str(_CHARGE);
   %let apply = %str(_APPLY);
   %let endshare = %str(_SHARE);
   %let share = %str(_SHARE_);
   %let oopt = %str(_OOPT);
   %let id = %str(_ID);
   %let struct = %str(_STRUCT);
   %let service = %str(_SERVICE);
   %let upload = %str(UPLOAD_FILENAME);
   %let name = %str(_NAME);
   %let phone = %str(_PHONE);
   %let flag = %str(_FLAG);
   %let status = %str(STATUS);
   %let p_pbp_a = %str(P_PBP_A);
   %let pbp_a = %str(PBP_A);
   %let spc_var = %str(MRX_ALT_NO_DED_TIER);



   %let i    = 1;
   %let word = %scan(&varlist,&i,&delm);
   %let indword = %index(&word,&note) + %index(&word,&yn) + %index(&word,&cats) + %index(&word,&bens) +
        %index(&word,&type) + %index(&word,&per) + %index(&word,&amo) + %index(&word,&pov) +
        %index(&word,&per_) + %index(&word,&typ_) + %index(&word,&ad) + %index(&word,&auth) +
        %index(&word,&catex) + %index(&word,&cat_ex) + %index(&word,&charge) + %index(&word,&oopt)  +
        %index(&word,&apply) + %index(&word,&share) - %index(&word,&endshare) + %index(&word,&id) +
        %index(&word,&struct) + %index(&word,&service) + %index(&word,&name) + %index(&word,&phone)
        + %index(&word,&flag)+ %index(&word,&status) + %index(&word,&p_pbp_a) + %index(&word,&pbp_a)
        + %index(&word,&spc_var);

   %do %while("&word"^="");

      %if "&word" ^= "QID" and "&word" ^= "hplan" and "&word" ^= "UPLOAD_FILENAME" and "%eval(&indword)" = "0"
      and "&word" ^= "HPLAN" and "&word" ^= "TYPE" %then %do;
         length _&i &informat;
         _&i = input(&word,&informat);
      drop &word;
      rename _&i = &word;
      %end;

      %let i = %eval(&i + 1);
      %let word = %scan(&varlist,&i,&delm);
      %let indword = %index(&word,&note) + %index(&word,&yn) + %index(&word,&cats) + %index(&word,&bens) +
        %index(&word,&type) + %index(&word,&per) + %index(&word,&amo) + %index(&word,&pov) +
        %index(&word,&per_) + %index(&word,&typ_) + %index(&word,&ad) + %index(&word,&auth) +
        %index(&word,&catex) + %index(&word,&cat_ex) + %index(&word,&charge) + %index(&word,&oopt) +
        %index(&word,&apply)  + %index(&word,&share) - %index(&word,&endshare)+ %index(&word,&id) +
        %index(&word,&struct) + %index(&word,&service) + %index(&word,&name) + %index(&word,&phone)
        + %index(&word,&flag)+ %index(&word,&status) + %index(&word,&p_pbp_a) + %index(&word,&pbp_a)
        + %index(&word,&spc_var);
      %end;

   %mend c_to_n;
run;

%macro getvars;
drop nm x varlist;
*if LAST = 1 then do;
array ch(*) _character_;
length nm $32 varlist $32767;
varlist='';
call symput('vars',varlist);
do x=1 to dim(ch);
   nm = vname(ch(x));
   if x = 1 then do;
      varlist = upcase(trim(nm));
   end;
   else do;
      varlist = trim(varlist)||' '||upcase(trim(nm));
   end;
end;
call symput('vars',varlist);
*end;
%mend;

%MACRO PBPIMPCONV(TABLE);

PROC IMPORT OUT= WORK.NEW&TABLE
DATATABLE= "&TABLE "
            DBMS=ACCESS REPLACE;
     DATABASE="&PBP\&PBPMAIN";
     SCANMEMO=YES;
     USEDATE=NO;
     SCANTIME=YES;
RUN;

PROC SORT DATA= NEW&TABLE ;
BY QID;
RUN;

DATA _NULL_;
CALL SYMPUT('OBSNUM',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET NEW&TABLE NOBS=NUMOBS;
STOP;
RUN;

DATA &TABLE;
LENGTH QID $11;
SET NEW&TABLE;
%IF &OBSNUM > 0 %THEN %DO;
%GETVARS;
%END;
RUN;

DATA &TABLE;
SET &TABLE;
%IF &OBSNUM > 0 %THEN %DO;
%c_to_n(varlist = &vars);
%END;
RUN;

%MEND;
RUN;
