
* PROGRAM: COST_SHARING_AMBULANCE.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR AMBULANCE CLAIMS;

DATA AMBULANCE_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='10a'));
RUN;

data ambulance_file;
    SET  PBP_FILE (KEEP =
       CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
       PBP_B10A_MAXENR_AMT PBP_B10A_MAXENR_PER
       PBP_B10A_COPAY_MC_AMT PBP_B10A_COINS_PCT_MC PBP_B10A_DED_AMT
       PBP_B10A_COPAY_WAV_YN PBP_B10A_COINS_WAV_YN);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from ambulance_baseid b, ambulance_file p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO AMBULANCE_COST_SHARE(SERV_CAT);

  DATA &SERV_CAT;
    set cat_join (drop = join_id);

    IF PBP_B10A_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B10A_MAXENR_AMT;

    COST_SHARE_COST = 0;
    OTHER_COST = 0;

      IF PBP_B10A_DED_AMT = . THEN DO;
        IF PBP_B10A_COPAY_WAV_YN NE '1' THEN COST = SUM(COST,(VISITS*PBP_B10A_COPAY_MC_AMT));
        IF PBP_B10A_COINS_WAV_YN NE '1' THEN COST = SUM(COST,(AMTTOT*PBP_B10A_COINS_PCT_MC));
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B10A_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B10A_DED_AMT;
          DEDUCT_SHARE = PBP_B10A_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B10A_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          IF PBP_B10A_COPAY_WAV_YN NE '1' THEN COST = SUM(COST,(VISITS*PBP_B10A_COPAY_MC_AMT));
          IF PBP_B10A_COINS_WAV_YN NE '1' THEN COST = SUM(COST,(AMTTOT*PBP_B10A_COINS_PCT_MC));
        END;
      END;

      IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

      COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "10a";
  RUN;

%MEND AMBULANCE_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=AMBULANCE;
RUN;

%AMBULANCE_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=AMBULANCE(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE AMBULANCE_BASEID AMBULANCE_FILE CAT_JOIN;
QUIT;
RUN;
