
* PROGRAM: COST_SHARING_DIAG.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR DIAG CLAIMS;

DATA DIAG_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='8ad'));
RUN;

data DIAG_FILE;
    SET  PBP_FILE(KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B8A_MAXENR_AMT PBP_B8A_MAXENR_PER

                   PBP_B8A_LAB_COPAY_AMT
                   PBP_B8A_LAB_COPAY_AMT_MAX
                   PBP_B8A_COINS_PCT_LAB
                   PBP_B8A_COINS_PCT_LAB_MAX

                   PBP_B8A_COINS_PCT_DMC
                   PBP_B8A_COINS_PCT_DMC_MAX
                   PBP_B8A_COPAY_MIN_DMC_AMT
                   PBP_B8A_COPAY_MAX_DMC_AMT

                   PBP_B8A_DED_AMT
                   PBP_B8A_COST_SHARE_COINS_YN
                   PBP_B8A_COST_SHARE_COINS_MIN
                   PBP_B8A_COST_SHARE_COPAY_YN
                   PBP_B8A_COST_SHARE_COPAY_MIN );
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from DIAG_BASEID b, DIAG_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO DIAG_COST_SHARE(SERV_CAT);

%LET SERV_CAT = DIAG;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);

    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B8A_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B8A_MAXENR_AMT;

      IF PBP_B8A_DED_AMT = . THEN DO;

        COST = SUM(COST,(VISITS*PBP_B8A_COPAY_MIN_DMC_AMT));
        COST = SUM(COST,(AMTTOT*PBP_B8A_COINS_PCT_DMC));
      END;

      ELSE DO;
          IF AMTTOT <= PBP_B8A_DED_AMT THEN DO;
          COST = AMTTOT;
           END;
        ELSE DO;
          COST = PBP_B8A_DED_AMT;
          DEDUCT_SHARE = PBP_B8A_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B8A_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B8A_COPAY_MIN_DMC_AMT));
          COST = SUM(COST,(AMTTOT*PBP_B8A_COINS_PCT_DMC));
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "8ad";
  RUN;

%MEND DIAG_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=DIAG;
RUN;

%DIAG_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=DIAG(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE DIAG DIAG_BASEID DIAG_FILE CAT_JOIN;
QUIT;
RUN;
