* PROGRAM: COST_SHARING_INPATIENT_PSYCH.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR INPATIENT PSYCH CLAIMS;


DATA INPATIENT_PSYCH_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='1b'));
RUN;

data INPATIENT_PSYCH_FILE;
    SET  PBP_FILE(KEEP =
                        CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN

                        PBP_B1B_COINS_YN
                        PBP_B1B_COPAY_YN
                        PBP_B1B_MDCR_COINS_CSTSHRS_YN
                        PBP_B1B_MDCR_COPAY_CSTSHRS_YN

                        PBP_B1B_COPAY_MCS_AMT
                        PBP_B1B_COPAY_MCS_AMT_INTRVL1 - PBP_B1B_COPAY_MCS_AMT_INTRVL3
                        PBP_B1B_COPAY_MCS_BGND_INTRVL1 - PBP_B1B_COPAY_MCS_BGND_INTRVL3
                        PBP_B1B_COPAY_MCS_ENDD_INTRVL1 - PBP_B1B_COPAY_MCS_ENDD_INTRVL3

                        PBP_B1B_COPAY_NMCS_AMT
                        PBP_B1B_COPAY_NMCS_AMT_INTRVL1 - PBP_B1B_COPAY_NMCS_AMT_INTRVL3
                        PBP_B1B_COPAY_NMCS_BGND_NTRVL1 - PBP_B1B_COPAY_NMCS_BGND_NTRVL3
                        PBP_B1B_COPAY_NMCS_ENDD_NTRVL1 - PBP_B1B_COPAY_NMCS_ENDD_NTRVL3

                        PBP_B1B_COINS_PCT_MCS
                        PBP_B1B_COINS_MCS_PCT_INTRVL1 - PBP_B1B_COINS_MCS_PCT_INTRVL3
                        PBP_B1B_COINS_MCS_BGND_INTRVL1 - PBP_B1B_COINS_MCS_BGND_INTRVL3
                        PBP_B1B_COINS_MCS_ENDD_INTRVL1 - PBP_B1B_COINS_MCS_ENDD_INTRVL3

                        PBP_B1B_COINS_PCT_NMCS
                        PBP_B1B_COINS_NMCS_PCT_INTRVL1 - PBP_B1B_COINS_NMCS_PCT_INTRVL3
                        PBP_B1B_COINS_NMCS_BGND_NTRVL1 - PBP_B1B_COINS_NMCS_BGND_NTRVL3
                        PBP_B1B_COINS_NMCS_ENDD_NTRVL1 - PBP_B1B_COINS_NMCS_ENDD_NTRVL3

                        PBP_B1B_BENDESC_AMO_AD

                        PBP_B1B_COPAY_AD_AMT_INTRVL1 - PBP_B1B_COPAY_AD_AMT_INTRVL3
                        PBP_B1B_COPAY_AD_BGND_INTRVL1 - PBP_B1B_COPAY_AD_BGND_INTRVL3
                        PBP_B1B_COPAY_AD_ENDD_INTRVL1 - PBP_B1B_COPAY_AD_ENDD_INTRVL3

                        PBP_B1B_MAXENR_AMT PBP_B1B_MAXENR_PER PBP_B1B_MAXENR_TYPE
                        PBP_B1A_MAXENR_AMT PBP_B1A_MAXENR_PER

                        PBP_B1B_COINS_AD_PCT_INTRVL1 - PBP_B1B_COINS_AD_PCT_INTRVL3
                        PBP_B1B_COINS_AD_BGND_INTRVL1 - PBP_B1B_COINS_AD_BGND_INTRVL3
                        PBP_B1B_COINS_AD_ENDD_INTRVL1 - PBP_B1B_COINS_AD_ENDD_INTRVL3

                        PBP_B1B_DED_AMT
                        PBP_B1B_BENDESC_LIM_AD
                        PBP_B1B_BENDESC_AMT_AD
                        PBP_B1B_COINS_NMCS_STRUC_YN
                        PBP_B1B_COPAY_NMCS_STRUC_YN
                        PBP_B1B_BENDESC_AMO_NMCS);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.year, b.utlznday, b.totdays, b.lrdays, b.amttot, b.first_stay, p.*
      from INPATIENT_PSYCH_BASEID b, INPATIENT_PSYCH_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

proc sort;
by hplan baseid descending first_stay;
run;

%MACRO INPAT_PSYCH(SERV_CAT);

  DATA &SERV_CAT;
   LENGTH CATEGORY $3;
    RETAIN PBP_DEDUCTIBLE;
    set cat_join (drop = join_id);
    by hplan baseid descending first_stay;
    IF FIRST.BASEID THEN PBP_DEDUCTIBLE = .;

    AMTTOT_PER_DAY = AMTTOT / TOTDAYS;

    IF PBP_B1B_MAXENR_AMT = . AND PBP_B1B_MAXENR_TYPE = '1' THEN DO;
      MAXENR_AMT = PBP_B1A_MAXENR_AMT;
      MAXENR_PER = PBP_B1A_MAXENR_PER;
    END;
    ELSE DO;
      MAXENR_AMT = PBP_B1B_MAXENR_AMT;
      MAXENR_PER = PBP_B1B_MAXENR_PER;
    END;

    IF MAXENR_AMT NE . THEN BENE_MAXIMUM = MAXENR_AMT;


    IF PBP_B1B_COPAY_AD_ENDD_INTRVL1 = 999 THEN PBP_B1B_COPAY_AD_ENDD_INTRVL1 = TOTDAYS;
    ELSE
    IF PBP_B1B_COPAY_AD_ENDD_INTRVL2 = 999 THEN PBP_B1B_COPAY_AD_ENDD_INTRVL2 = TOTDAYS;
    ELSE
    IF PBP_B1B_COPAY_AD_ENDD_INTRVL3 = 999 THEN PBP_B1B_COPAY_AD_ENDD_INTRVL3 = TOTDAYS;

    IF PBP_B1B_COINS_AD_ENDD_INTRVL1 = 999 THEN PBP_B1B_COINS_AD_ENDD_INTRVL1 = TOTDAYS;
    ELSE
    IF PBP_B1B_COINS_AD_ENDD_INTRVL2 = 999 THEN PBP_B1B_COINS_AD_ENDD_INTRVL2 = TOTDAYS;
    ELSE
    IF PBP_B1B_COINS_AD_ENDD_INTRVL3 = 999 THEN PBP_B1B_COINS_AD_ENDD_INTRVL3 = TOTDAYS;

    STAY_COST_MC  = 0;
    STAY_COST_AMO = 0;
    DAY_COST_MC   = 0;
    DAY_COST_AMO  = 0;

    * MEDICARE COVERED STAY;
    IF UTLZNDAY > 0 THEN DO;
      IF FIRST_STAY = 1 THEN PBP_DEDUCTIBLE = PBP_B1B_DED_AMT;

      IF PBP_DEDUCTIBLE > 0 THEN DO;
        IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
          STAY_COST = AMTTOT;
          MEDICARE_COVERED_DAYS = 0;
          ADDITIONAL_DAYS = 0;
          PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
        END;
        ELSE DO;
          AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
          STAY_COST = SUM(PBP_B1B_COPAY_MCS_AMT, AMTTOT * PBP_B1B_COINS_PCT_MCS, PBP_DEDUCTIBLE);
          MEDICARE_COVERED_DAYS = SUM( UTLZNDAY, -LRDAYS );
          ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
          PBP_DEDUCTIBLE = 0;
        END;
      END;
      ELSE DO;
        STAY_COST = SUM(PBP_B1B_COPAY_MCS_AMT, AMTTOT * PBP_B1B_COINS_PCT_MCS);
        MEDICARE_COVERED_DAYS = SUM( UTLZNDAY, -LRDAYS );
        ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
      END;

      STAY_COST_MC = STAY_COST;

      IF MEDICARE_COVERED_DAYS > 0 THEN DO;
        N1 = PBP_B1B_COPAY_MCS_ENDD_INTRVL1 - PBP_B1B_COPAY_MCS_BGND_INTRVL1 + 1;
        N2 = PBP_B1B_COPAY_MCS_ENDD_INTRVL2 - PBP_B1B_COPAY_MCS_BGND_INTRVL2 + 1;
        N3 = PBP_B1B_COPAY_MCS_ENDD_INTRVL3 - PBP_B1B_COPAY_MCS_BGND_INTRVL3 + 1;

        DAY_COPAY = .;
        IF PBP_B1B_COPAY_MCS_ENDD_INTRVL3 > 0 AND
           MEDICARE_COVERED_DAYS > PBP_B1B_COPAY_MCS_ENDD_INTRVL3 THEN DO;
          DAY_COPAY = N1 * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
          DAY_COPAY = SUM( DAY_COPAY, N2 * PBP_B1B_COPAY_MCS_AMT_INTRVL2);
          DAY_COPAY = SUM( DAY_COPAY, N3 * PBP_B1B_COPAY_MCS_AMT_INTRVL3);
        END;
        ELSE IF PBP_B1B_COPAY_MCS_ENDD_INTRVL2 > 0 AND
                MEDICARE_COVERED_DAYS > PBP_B1B_COPAY_MCS_ENDD_INTRVL2 THEN DO;
          DAY_COPAY = N1 * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
          DAY_COPAY = SUM( DAY_COPAY, N2 * PBP_B1B_COPAY_MCS_AMT_INTRVL2);
          DAY_COPAY = SUM( DAY_COPAY, ((MEDICARE_COVERED_DAYS - (N1 + N2)) *
                                                    PBP_B1B_COPAY_MCS_AMT_INTRVL3));
        END;
        ELSE IF PBP_B1B_COPAY_MCS_ENDD_INTRVL1 > 0 AND
                MEDICARE_COVERED_DAYS > PBP_B1B_COPAY_MCS_ENDD_INTRVL1 THEN DO;
          DAY_COPAY = N1 * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
          DAY_COPAY = SUM( DAY_COPAY, ((MEDICARE_COVERED_DAYS - N1) *
                                                    PBP_B1B_COPAY_MCS_AMT_INTRVL2));
        END;
        ELSE DO;
          DAY_COPAY = MEDICARE_COVERED_DAYS * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
        END;

        N1 = PBP_B1B_COINS_MCS_ENDD_INTRVL1 - PBP_B1B_COINS_MCS_BGND_INTRVL1 + 1;
        N2 = PBP_B1B_COINS_MCS_ENDD_INTRVL2 - PBP_B1B_COINS_MCS_BGND_INTRVL2 + 1;
        N3 = PBP_B1B_COINS_MCS_ENDD_INTRVL3 - PBP_B1B_COINS_MCS_BGND_INTRVL3 + 1;

        DAY_COINS = .;
        IF PBP_B1B_COINS_MCS_ENDD_INTRVL3 > 0 AND
           MEDICARE_COVERED_DAYS > PBP_B1B_COINS_MCS_ENDD_INTRVL3 THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
          DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL2);
          DAY_COINS = SUM( DAY_COINS, N3 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL3);
        END;
        ELSE IF PBP_B1B_COINS_MCS_ENDD_INTRVL2 > 0 AND
                MEDICARE_COVERED_DAYS > PBP_B1B_COINS_MCS_ENDD_INTRVL2 THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
          DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL2);
          DAY_COINS = SUM( DAY_COINS, (MEDICARE_COVERED_DAYS - (N1 + N2)) * AMTTOT_PER_DAY *
                                                    PBP_B1B_COINS_MCS_PCT_INTRVL3);
        END;
        ELSE IF PBP_B1B_COINS_MCS_ENDD_INTRVL1 > 0 AND
                MEDICARE_COVERED_DAYS > PBP_B1B_COINS_MCS_ENDD_INTRVL1 THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
          DAY_COINS = SUM( DAY_COINS, (MEDICARE_COVERED_DAYS - N1)* AMTTOT_PER_DAY *
                                                    PBP_B1B_COINS_MCS_PCT_INTRVL2);
        END;
        ELSE DO;
          DAY_COINS = MEDICARE_COVERED_DAYS * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
        END;

        DAY_COST    = SUM(DAY_COPAY, DAY_COINS);
        DAY_COST_MC = SUM(DAY_COPAY, DAY_COINS);
      END; * MEDICARE_COVERED_DAYS > 0;

      IF ADDITIONAL_DAYS > 0 THEN DO;

        IF PBP_B1B_BENDESC_AMO_AD IN ('1','2') THEN DO;

          IF PBP_B1B_BENDESC_LIM_AD = '1' THEN
            PLAN_MAX_AD = 999;
          ELSE
            PLAN_MAX_AD = PBP_B1B_BENDESC_AMT_AD;

          IF ADDITIONAL_DAYS <= PLAN_MAX_AD THEN DO;
            DAYS = ADDITIONAL_DAYS;
          END;
          ELSE DO;
            DAYS = PLAN_MAX_AD;
            NONCOVERED_DAYS = SUM( ADDITIONAL_DAYS, -PLAN_MAX_AD );
          END;

          N1 = PBP_B1B_COPAY_AD_ENDD_INTRVL1 - PBP_B1B_COPAY_AD_BGND_INTRVL1 + 1;
          N2 = PBP_B1B_COPAY_AD_ENDD_INTRVL2 - PBP_B1B_COPAY_AD_BGND_INTRVL2 + 1;
          N3 = PBP_B1B_COPAY_AD_ENDD_INTRVL3 - PBP_B1B_COPAY_AD_BGND_INTRVL3 + 1;

          AD_COPAY = .;
          IF PBP_B1B_COPAY_AD_ENDD_INTRVL3 > 0 AND
             DAYS > PBP_B1B_COPAY_AD_ENDD_INTRVL3 THEN DO;
            AD_COPAY = N1 * PBP_B1B_COPAY_AD_AMT_INTRVL1;
            AD_COPAY = SUM( AD_COPAY, N2 * PBP_B1B_COPAY_AD_AMT_INTRVL2);
            AD_COPAY = SUM( AD_COPAY, N3 * PBP_B1B_COPAY_AD_AMT_INTRVL3);
          END;
          ELSE IF PBP_B1B_COPAY_AD_ENDD_INTRVL2 > 0 AND
                  DAYS > PBP_B1B_COPAY_AD_ENDD_INTRVL2 THEN DO;
            AD_COPAY = N1 * PBP_B1B_COPAY_AD_AMT_INTRVL1;
            AD_COPAY = SUM( AD_COPAY, N2 * PBP_B1B_COPAY_AD_AMT_INTRVL2);
            AD_COPAY = SUM( AD_COPAY, ((DAYS - (N1 + N2)) *
                                                    PBP_B1B_COPAY_AD_AMT_INTRVL3));
          END;
          ELSE IF PBP_B1B_COPAY_AD_ENDD_INTRVL1 > 0 AND
                  DAYS > PBP_B1B_COPAY_AD_ENDD_INTRVL1 THEN DO;
            AD_COPAY = N1 * PBP_B1B_COPAY_AD_AMT_INTRVL1;
            AD_COPAY = SUM( AD_COPAY, ((DAYS - N1) *
                                                    PBP_B1B_COPAY_AD_AMT_INTRVL2));
          END;
          ELSE DO;
            AD_COPAY = DAYS  * PBP_B1B_COPAY_AD_AMT_INTRVL1;
          END;

          N1 = PBP_B1B_COINS_AD_ENDD_INTRVL1 - PBP_B1B_COINS_AD_BGND_INTRVL1 + 1;
          N2 = PBP_B1B_COINS_AD_ENDD_INTRVL2 - PBP_B1B_COINS_AD_BGND_INTRVL2 + 1;
          N3 = PBP_B1B_COINS_AD_ENDD_INTRVL3 - PBP_B1B_COINS_AD_BGND_INTRVL3 + 1;

          AD_COINS = .;
          IF PBP_B1B_COINS_AD_ENDD_INTRVL3 > 0 AND
             DAYS > PBP_B1B_COINS_AD_ENDD_INTRVL3 THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL1;
            AD_COINS = SUM( AD_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL2);
            AD_COINS = SUM( AD_COINS, N3 * AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL3);
          END;
          ELSE IF PBP_B1B_COINS_AD_ENDD_INTRVL2 > 0 AND
                  DAYS > PBP_B1B_COINS_AD_ENDD_INTRVL2 THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL1;
            AD_COINS = SUM( AD_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL2);
            AD_COINS = SUM( AD_COPAY, (DAYS - (N1 + N2)) *
                                                (AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL3));
          END;
          ELSE IF PBP_B1B_COINS_AD_ENDD_INTRVL1 > 0 AND
                  DAYS > PBP_B1B_COINS_AD_ENDD_INTRVL1 THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL1;
            AD_COINS = SUM( AD_COPAY, (DAYS - N1) *
                                               (AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL2));
          END;
          ELSE DO;
            AD_COINS = DAYS * (AMTTOT_PER_DAY * PBP_B1B_COINS_AD_PCT_INTRVL1);
          END;

          DAY_COST     = SUM(DAY_COST, AD_COPAY, AD_COINS);
          DAY_COST_AMO = SUM(DAY_COST_AMO, AD_COPAY, AD_COINS);

        END; * IF PBP_B1B_BENDESC_AMO_AD IN ('1','2');
        ELSE DO;
          NONCOVERED_DAYS = ADDITIONAL_DAYS;
        END;

        IF NONCOVERED_DAYS > 0 THEN DO;
          NONCOV_COST = NONCOVERED_DAYS * AMTTOT_PER_DAY;
        END;

      END; * IF ADDITIONAL_DAYS > 0;

    END; * IF UTLZNDAY > 0;
    ELSE DO;
      * NON-COVERED STAY;
      STAY_COST = .;
      DAY_COPAY = .;
      DAY_COINS = .;

      IF PBP_B1B_BENDESC_AMO_NMCS IN ('1','2') THEN DO;

        * NMCS COPAY STRUCTURE SAME AS MCS;
        IF PBP_B1B_COPAY_NMCS_STRUC_YN = '1' THEN DO;
          IF FIRST_STAY = 1 THEN PBP_DEDUCTIBLE = PBP_B1B_DED_AMT;

          IF PBP_DEDUCTIBLE > 0 THEN DO;
            IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
              STAY_COST = AMTTOT;
              ADDITIONAL_DAYS = 0;
              PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
            END;
            ELSE DO;
              AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
              STAY_COST = SUM(PBP_B1B_COPAY_MCS_AMT, AMTTOT * PBP_B1B_COINS_PCT_MCS, PBP_DEDUCTIBLE);
              ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
              PBP_DEDUCTIBLE = 0;
            END;
          END;
          ELSE DO;
            STAY_COST = SUM(PBP_B1B_COPAY_MCS_AMT, AMTTOT * PBP_B1B_COINS_PCT_MCS);
            ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
          END;

          STAY_COST_AMO = STAY_COST;

          N1 = PBP_B1B_COPAY_MCS_ENDD_INTRVL1 - PBP_B1B_COPAY_MCS_BGND_INTRVL1 + 1;
          N2 = PBP_B1B_COPAY_MCS_ENDD_INTRVL2 - PBP_B1B_COPAY_MCS_BGND_INTRVL2 + 1;
          N3 = PBP_B1B_COPAY_MCS_ENDD_INTRVL3 - PBP_B1B_COPAY_MCS_BGND_INTRVL3 + 1;

          DAY_COPAY = .;
          IF (PBP_B1B_COPAY_MCS_ENDD_INTRVL3 > 0) AND
             (TOTDAYS > PBP_B1B_COPAY_MCS_ENDD_INTRVL3) THEN DO;
            DAY_COPAY = N1 * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
            DAY_COPAY = SUM( DAY_COPAY, N2 * PBP_B1B_COPAY_MCS_AMT_INTRVL2);
            DAY_COPAY = SUM( DAY_COPAY, N3 * PBP_B1B_COPAY_MCS_AMT_INTRVL3);
          END;
          ELSE IF (PBP_B1B_COPAY_MCS_ENDD_INTRVL2 > 0) AND
                  (TOTDAYS > PBP_B1B_COPAY_MCS_ENDD_INTRVL2) THEN DO;
            DAY_COPAY = N1 * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
            DAY_COPAY = SUM( DAY_COPAY, N2 * PBP_B1B_COPAY_MCS_AMT_INTRVL2);
            DAY_COPAY = SUM( DAY_COPAY, ((TOTDAYS - (N1 + N2)) *
                                                    PBP_B1B_COPAY_MCS_AMT_INTRVL3));
          END;
          ELSE IF (PBP_B1B_COPAY_MCS_ENDD_INTRVL1 > 0) AND
                  (TOTDAYS > PBP_B1B_COPAY_MCS_ENDD_INTRVL1) THEN DO;
            DAY_COPAY = N1 * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
            DAY_COPAY = SUM( DAY_COPAY, ((TOTDAYS - N1) *
                                                    PBP_B1B_COPAY_MCS_AMT_INTRVL2));
          END;
          ELSE DO;
            DAY_COPAY = TOTDAYS * PBP_B1B_COPAY_MCS_AMT_INTRVL1;
          END;

        END; * PBP_B1B_COPAY_NMCS_STRUC_YN = '1';
        ELSE
        IF PBP_B1B_COPAY_NMCS_STRUC_YN = '2' THEN DO; * NMCS COPAY STRUCTURE NOT THE SAME AS MCS;
          IF FIRST_STAY = 1 THEN PBP_DEDUCTIBLE = PBP_B1B_DED_AMT;

          IF PBP_DEDUCTIBLE > 0 THEN DO;
            IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
              STAY_COST = AMTTOT;
              ADDITIONAL_DAYS = 0;
              PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
            END;
            ELSE DO;
              AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
              STAY_COST = SUM(PBP_B1B_COPAY_MCS_AMT, AMTTOT * PBP_B1B_COINS_PCT_MCS, PBP_DEDUCTIBLE);
              ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
              PBP_DEDUCTIBLE = 0;
            END;
          END;
          ELSE DO;
            STAY_COST = SUM(PBP_B1B_COPAY_MCS_AMT, AMTTOT * PBP_B1B_COINS_PCT_MCS);
            ADDITIONAL_DAYS = SUM( TOTDAYS, -MEDICARE_COVERED_DAYS );
          END;

          STAY_COST_AMO = STAY_COST;

          N1 = PBP_B1B_COPAY_NMCS_ENDD_NTRVL1 - PBP_B1B_COPAY_NMCS_BGND_NTRVL1 + 1;
          N2 = PBP_B1B_COPAY_NMCS_ENDD_NTRVL2 - PBP_B1B_COPAY_NMCS_BGND_NTRVL2 + 1;
          N3 = PBP_B1B_COPAY_NMCS_ENDD_NTRVL3 - PBP_B1B_COPAY_NMCS_BGND_NTRVL3 + 1;

          DAY_COPAY = .;
          IF (PBP_B1B_COPAY_NMCS_ENDD_NTRVL3 > 0) AND
             (TOTDAYS > PBP_B1B_COPAY_NMCS_ENDD_NTRVL3) THEN DO;
            DAY_COPAY = N1 * PBP_B1B_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM( DAY_COPAY, N2 * PBP_B1B_COPAY_NMCS_AMT_INTRVL2);
            DAY_COPAY = SUM( DAY_COPAY, N3 * PBP_B1B_COPAY_NMCS_AMT_INTRVL3);
          END;
          ELSE IF (PBP_B1B_COPAY_NMCS_ENDD_NTRVL2 > 0) AND
                  (TOTDAYS > PBP_B1B_COPAY_NMCS_ENDD_NTRVL2) THEN DO;
            DAY_COPAY = N1 * PBP_B1B_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM( DAY_COPAY, N2 * PBP_B1B_COPAY_NMCS_AMT_INTRVL2);
            DAY_COPAY = SUM( DAY_COPAY, ((TOTDAYS - (N1 + N2)) *
                                                    PBP_B1B_COPAY_NMCS_AMT_INTRVL3));
          END;
          ELSE IF (PBP_B1B_COPAY_NMCS_ENDD_NTRVL1 > 0) AND
                  (TOTDAYS > PBP_B1B_COPAY_NMCS_ENDD_NTRVL1) THEN DO;
            DAY_COPAY = N1 * PBP_B1B_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM( DAY_COPAY, ((TOTDAYS - N1) *
                                                    PBP_B1B_COPAY_NMCS_AMT_INTRVL2));
          END;
          ELSE DO;
            DAY_COPAY = TOTDAYS * PBP_B1B_COPAY_NMCS_AMT_INTRVL1;
          END;

        END; * PBP_B1B_COPAY_NMCS_STRUC_YN != '1';

        * NMCS COINSURANCE STRUCTURE SAME AS MCS;
        IF PBP_B1B_COINS_NMCS_STRUC_YN = '1' THEN DO;
          STAY_COST     = SUM(STAY_COST, AMTTOT_PER_DAY * PBP_B1B_COINS_PCT_MCS);
          STAY_COST_AMO = SUM(STAY_COST_AMO, AMTTOT_PER_DAY * PBP_B1B_COINS_PCT_MCS);

          N1 = PBP_B1B_COINS_MCS_ENDD_INTRVL1 - PBP_B1B_COINS_MCS_BGND_INTRVL1 + 1;
          N2 = PBP_B1B_COINS_MCS_ENDD_INTRVL2 - PBP_B1B_COINS_MCS_BGND_INTRVL2 + 1;
          N3 = PBP_B1B_COINS_MCS_ENDD_INTRVL3 - PBP_B1B_COINS_MCS_BGND_INTRVL3 + 1;

          DAY_COINS = .;
          IF (PBP_B1B_COINS_MCS_ENDD_INTRVL3 > 0) AND
             (TOTDAYS > PBP_B1B_COINS_MCS_ENDD_INTRVL3) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL2);
            DAY_COINS = SUM( DAY_COINS, N3 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B1B_COINS_MCS_ENDD_INTRVL2 > 0) AND
                  (TOTDAYS > PBP_B1B_COINS_MCS_ENDD_INTRVL2) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL2);
            DAY_COINS = SUM( DAY_COINS, (TOTDAYS - (N1 + N2)) * AMTTOT_PER_DAY *
                                                    PBP_B1B_COINS_MCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B1B_COINS_MCS_ENDD_INTRVL1 > 0) AND
                  (TOTDAYS > PBP_B1B_COINS_MCS_ENDD_INTRVL1) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, (TOTDAYS - N1) * AMTTOT_PER_DAY *
                                                    PBP_B1B_COINS_MCS_PCT_INTRVL2);
          END;
          ELSE DO;
            DAY_COINS = TOTDAYS * AMTTOT_PER_DAY * PBP_B1B_COINS_MCS_PCT_INTRVL1;
          END;

        END; * PBP_B1B_COINS_NMCS_STRUC_YN = '1';
        ELSE
        IF PBP_B1B_COINS_NMCS_STRUC_YN = '2' THEN DO; * NMCS COINSURANCE STRUCTURE NOT THE SAME AS MCS;
          STAY_COST     = SUM(STAY_COST, AMTTOT_PER_DAY * PBP_B1B_COINS_PCT_NMCS);
          STAY_COST_AMO = SUM(STAY_COST_AMO, AMTTOT_PER_DAY * PBP_B1B_COINS_PCT_NMCS);

          N1 = PBP_B1B_COINS_NMCS_ENDD_NTRVL1 - PBP_B1B_COINS_NMCS_BGND_NTRVL1 + 1;
          N2 = PBP_B1B_COINS_NMCS_ENDD_NTRVL2 - PBP_B1B_COINS_NMCS_BGND_NTRVL2 + 1;
          N3 = PBP_B1B_COINS_NMCS_ENDD_NTRVL3 - PBP_B1B_COINS_NMCS_BGND_NTRVL3 + 1;

          DAY_COINS = .;
          IF (PBP_B1B_COINS_NMCS_ENDD_NTRVL3 > 0) AND
             (TOTDAYS > PBP_B1B_COINS_NMCS_ENDD_NTRVL3) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_NMCS_PCT_INTRVL2);
            DAY_COINS = SUM( DAY_COINS, N3 * AMTTOT_PER_DAY * PBP_B1B_COINS_NMCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B1B_COINS_NMCS_ENDD_NTRVL2 > 0) AND
                  (TOTDAYS > PBP_B1B_COINS_NMCS_ENDD_NTRVL2) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1B_COINS_NMCS_PCT_INTRVL2);
            DAY_COINS = SUM( DAY_COINS, (TOTDAYS - (N1 + N2)) * AMTTOT_PER_DAY *
                                                    PBP_B1B_COINS_NMCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B1B_COINS_NMCS_ENDD_NTRVL1 > 0) AND
                  (TOTDAYS > PBP_B1B_COINS_NMCS_ENDD_NTRVL1) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1B_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, (TOTDAYS - N1) * AMTTOT_PER_DAY *
                                                    PBP_B1B_COINS_NMCS_PCT_INTRVL2);
          END;
          ELSE DO;
            DAY_COINS = TOTDAYS * AMTTOT_PER_DAY * PBP_B1B_COINS_NMCS_PCT_INTRVL1;
          END;

        END; * PBP_B1B_COINS_NMCS_STRUC_YN != '1';

        DAY_COST = SUM(DAY_COPAY, DAY_COINS);
        DAY_COST_AMO = SUM(DAY_COPAY, DAY_COINS);

      END; * PBP_B1B_BENDESC_AMO_NMCS IN ('1','2');
      ELSE DO;
        NONCOV_COST = TOTDAYS * AMTTOT_PER_DAY;
      END;

    END; * END UTLZNDAY <= 0;

    COST_SHARE_COST = SUM(STAY_COST, DAY_COST);
    COST_SHARE_COST_MC  = SUM(STAY_COST_MC, DAY_COST_MC);
    COST_SHARE_COST_AMO = SUM(STAY_COST_AMO, DAY_COST_AMO);
    OTHER_COST = NONCOV_COST;

    IF PBP_B1B_MAXENR_PER = '7' AND BENE_MAXIMUM >= 0 AND COST_SHARE_COST > BENE_MAXIMUM THEN DO;
      MAX_REDUCTION = (BENE_MAXIMUM / SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
      COST_SHARE_COST = COST_SHARE_COST * MAX_REDUCTION;
      COST_SHARE_COST_MC = COST_SHARE_COST_MC * MAX_REDUCTION;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * MAX_REDUCTION;
    END;

    CATEGORY = "1b";
  RUN;

%MEND INPAT_PSYCH;

%MACRO RUN_COST;
%LET CAT = INPATIENT_PSYCH;
RUN;

%INPAT_PSYCH(&CAT);
RUN;

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC SORT DATA = INPATIENT_PSYCH;
  BY HPLAN;
RUN;

PROC SUMMARY DATA = INPATIENT_PSYCH NWAY MISSING;
  CLASS YEAR BASEID;
  BY HPLAN;
  VAR AMTTOT COST_SHARE_COST OTHER_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO;
  ID BENE_MAXIMUM PBP_B1B_MAXENR_PER CATEGORY;
  OUTPUT OUT = TOTINP(RENAME = _FREQ_=RCCNT) SUM = ;
RUN;

DATA COSTDATA_INPATIENT_PSYCH;
  SET TOTINP;

  IF PBP_B1B_MAXENR_PER IN ('1','2','3','4','5','6','8') AND BENE_MAXIMUM >= 0 AND
    COST_SHARE_COST > BENE_MAXIMUM THEN DO;
    MAX_REDUCTION = (BENE_MAXIMUM / SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
    COST_SHARE_COST = COST_SHARE_COST * MAX_REDUCTION;
    COST_SHARE_COST_MC = COST_SHARE_COST_MC * MAX_REDUCTION;
    COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * MAX_REDUCTION;
  END;

  COST = SUM(COST_SHARE_COST, OTHER_COST);

  KEEP HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY RCCNT AMTTOT;
RUN;

PROC SORT DATA = COSTDATA_INPATIENT_PSYCH;
  BY YEAR BASEID HPLAN;
RUN;

PROC APPEND DATA=COSTDATA_INPATIENT_PSYCH(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE INPATIENT_PSYCH TOTINP COSTDATA_INPATIENT_PSYCH INPATIENT_PSYCH_BASEID INPATIENT_PSYCH_FILE CAT_JOIN;
QUIT;
RUN;
