
* PROGRAM: COST_SHARING_MEDICARE_DRUGS.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR MDRUGS CLAIMS;

DATA MDRUGS_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='15m'));
RUN;

data MDRUGS_FILE;
    SET  PBP_FILE(KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                      PBP_A_PLAN_TYPE
                      PBP_B20_B_COINS_MIN_PCT
                      PBP_B20_B_MIN_COPAY
                      PBP_B20_COINS_MC_PCT
                      PBP_B20_COPAY_MIN_MC_AMT
                      PBP_B20_DED_AMT
                      MRX_B_COINS_PCT
                      MRX_B_COPAY_MIN_AMT
                      MRX_B_CHEMO_COINS_PCT
                      MRX_B_CHEMO_COPAY_AMT
                      MRX_B_DED_AMT
                      MRX_B_MAX_OOP_AMT
                      MRX_B_MAX_OOP_PER );
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from MDRUGS_BASEID b, MDRUGS_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO MDRUGS_COST_SHARE(SERV_CAT);

%LET SERV_CAT = MDRUGS;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF MRX_B_MAX_OOP_AMT ^ = . THEN BENE_MAX = MRX_B_MAX_OOP_AMT;

    COST = .;

    COST = SUM(COST,(VISITS*MRX_B_COPAY_MIN_AMT));
    COST = SUM(COST,(AMTTOT*MRX_B_COINS_PCT));
    IF BENE_MAX >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAX);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "15m";
  RUN;

%MEND MDRUGS_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=MDRUGS;
RUN;

%MDRUGS_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=MDRUGS(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE MDRUGS MDRUGS_BASEID MDRUGS_FILE CAT_JOIN;
QUIT;
RUN;
