
* PROGRAM: COST_SHARING_URGENT_CARE.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR URGENT CARE CLAIMS;

DATA URGENT_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='4b'));
RUN;

data URGENT_FILE;
    SET  PBP_FILE(KEEP=
       CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
       PBP_B4B_MAXENR_AMT PBP_B4B_MAXENR_PER
       PBP_B4B_COPAY_AMT_MC_MIN PBP_B4B_COINS_PCT_MC_MIN
       PBP_B4B_DED_AMT
       PBP_B4B_MAXENR_TYPE PBP_B4A_MAXENR_AMT PBP_B4A_MAXENR_PER
       PBP_B7A_IA_NUC_COINS_PCT_MAX
       PBP_B7A_IA_NUC_COINS_PCT_MIN
       PBP_B7A_IA_NUC_COINS_YN
       PBP_B7A_IA_NUC_COPAY_AMT_MAX
       PBP_B7A_IA_NUC_COPAY_AMT_MIN
       PBP_B7A_IA_NUC_COPAY_YN
       PBP_B7A_IA_NUC_YN);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from URGENT_BASEID b, URGENT_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO URGENT_COST_SHARE(SERV_CAT);

%LET SERV_CAT = URGENT;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B4B_MAXENR_AMT = . AND PBP_B4B_MAXENR_TYPE = '1' THEN DO;
      MAXENR_AMT = PBP_B4A_MAXENR_AMT;
      MAXENR_PER = PBP_B4A_MAXENR_PER;
    END;
    ELSE DO;
      MAXENR_AMT = PBP_B4B_MAXENR_AMT;
      MAXENR_PER = PBP_B4B_MAXENR_PER;
    END;

    IF MAXENR_AMT NE . THEN BENE_MAXIMUM = MAXENR_AMT;

      IF PBP_B4B_DED_AMT = . THEN DO;
        COST = SUM(COST, (VISITS*PBP_B4B_COPAY_AMT_MC_MIN));
        COST = SUM(COST, (AMTTOT*PBP_B4B_COINS_PCT_MC_MIN));
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B4B_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B4B_DED_AMT;
          DEDUCT_SHARE = PBP_B4B_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B4B_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST, (VISITS*PBP_B4B_COPAY_AMT_MC_MIN));
          COST = SUM(COST, (AMTTOT*PBP_B4B_COINS_PCT_MC_MIN));
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "4b";
  RUN;

%MEND URGENT_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=URGENT;
RUN;

%URGENT_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=URGENT(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE URGENT URGENT_BASEID URGENT_FILE CAT_JOIN;
QUIT;
RUN;
