* EXTRACT FILE CREATION;

%MACRO EXP();

proc format;
  value grpfmt
    1 = 'Excellent'
    2 = 'Very Good'
    3 = 'Good'
    4 = 'Fair'
    5 = 'Poor'
    31 = 'AHC'
    32 = 'CHF'
    33 = 'Diabetes'
;
run;

DATA OOPC_PLAN_HEALTH_DETAIL;
  SET OUT.OOPC_PLAN_DETAIL;
  IF CELL_GROUP IN ('1','2','3','4','5','6') THEN HEALTH = 1;
  ELSE IF CELL_GROUP IN ('7','8','9','10','11','12') THEN HEALTH = 2; 
  ELSE IF CELL_GROUP IN ('13','14','15','16','17','18') THEN HEALTH = 3;
  ELSE IF CELL_GROUP IN ('19','20','21','22','23','24') THEN HEALTH = 4;
  ELSE IF CELL_GROUP IN ('25','26','27','28','29','30') THEN HEALTH = 5;
  ELSE IF CELL_GROUP = '31' THEN HEALTH=31;
  ELSE IF CELL_GROUP = '32' THEN HEALTH=32;
  ELSE IF CELL_GROUP = '33' THEN HEALTH=33;
RUN;

PROC PRINT DATA=OOPC_PLAN_HEALTH_DETAIL (OBS=50);
  TITLE 'OOPC_PLAN_HEALTH_DETAIL';
RUN;

PROC SORT DATA=OOPC_PLAN_HEALTH_DETAIL OUT=OOPC_PLAN_HEALTH_DETAIL;
  BY HPLAN HEALTH CATEGORY;
RUN;

PROC MEANS DATA = OOPC_PLAN_HEALTH_DETAIL NWAY MISSING NOPRINT;
  BY HPLAN HEALTH CATEGORY;
  WEIGHT COMBOWGT_SUM;
  VAR MONTHLY_COST_MEAN;
  OUTPUT OUT = PLAN_CATEGORY_HEALTH(DROP=_TYPE_ _FREQ_) MEAN = MONTHLY_COST_MEAN;
RUN;


DATA SECTION_A(RENAME=(PBP_A_ORG_TYPE=ORG_TYPE
                       PBP_A_PLAN_TYPE=PLAN_TYPE PBP_A_ORG_MARKETING_NAME=MARKETING_NAME
                       PBP_A_ORG_NAME=ORG_NAME PBP_A_Plan_Name=Plan_Name));
  LENGTH TYPE $4;
  SET  PBP_FILE;
  TYPE = PUT(HPLAN,$TYPEF.);
  IF TYPE NE 'NO';
RUN;

DATA PLAN_COSTS_CAT;
  LENGTH CATNAME $ 50;
  SET  PLAN_CATEGORY_HEALTH;
  CATNAME = PUT(CATEGORY,$CATNAME.);
RUN;

* FOR NONMSA PLANS;
DATA PLAN_CATS(KEEP=HPLAN HEALTH CATNAME CATEGORY MONTHLY_COST_MEAN);
  SET PLAN_COSTS_CAT;
RUN;

PROC TRANSPOSE DATA=PLAN_CATS(DROP=CATEGORY) OUT=PARTC_PLANS(DROP=_NAME_);
  VAR MONTHLY_COST_MEAN;
  ID CATNAME;
  BY HPLAN HEALTH;
RUN;

DATA PARTC_PLANS;
  SET PARTC_PLANS;
  * IF PUT(HPLAN,$TYPEF.) NE 'MSA';
RUN;

PROC SORT;
  BY HPLAN HEALTH;
RUN;

DATA PARTC_PLANS_ALL;
  SET
  %IF &MAPD > 0 OR &MAON > 0 OR &FFS > 0 OR &MGAP > 0 OR &MSA > 0 %THEN %DO;
    PARTC_PLANS
  %END;
  ;
  BY HPLAN;
RUN;

PROC SORT DATA=PARTC_PLANS_ALL;
  BY HPLAN HEALTH;
RUN;

DATA PARTC_PLANS
%IF &MAPD > 0 OR &PDP > 0 %THEN %DO;
(DROP=_15)
%END;
;
%IF &MAON = 0 AND &MAPD = 0 AND &PDP > 0 %THEN %DO;
RETAIN
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams 
 Part_C_Deductible .;

%END;
 SET PARTC_PLANS_ALL;
%IF &MAON = 0 AND &MAPD = 0 AND &PDP > 0 %THEN %DO;
 ALL = .;
%END;
%IF &MAPD > 0 OR &PDP > 0 %THEN %DO;
 PartD = _15;
%END;
RUN;

DATA PARTC_PLANS_CD(DROP=MARKETING_NAME);
LENGTH HPLAN $11
       CONTRACT_ID $5
       Plan_ID $3
       Segment_ID $3
       ORG_MKT_NAME $ 50
       Plan_Name    $ 75
       YEAR         $4
       PARTD 8;
ARRAY ACAT(38) 
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
 Part_C_Deductible;

 MERGE PARTC_PLANS(IN=A)
       SECTION_A(IN=C KEEP=PLAN_TYPE TYPE HPLAN CONTRACT_ID Plan_ID MARKETING_NAME Plan_Name Segment_ID);
BY HPLAN;
if type in('MAON','FFS','MGAP') | (type='MSA' & PartD=.) then PartD=input(health,ptdffsh.);
IF TOTAL = . THEN TOTAL = ALL;
Grand_Total = SUM(TOTAL,PartD);
YEAR = "&RUNYEAR";
ORG_MKT_NAME  = MARKETING_NAME;
IF TOTAL = . THEN TOTAL = ALL;
IF TYPE = 'PDP' THEN DO;
   DO I = 1 TO DIM(ACAT);
      ACAT(I) = .;
   END;
   TOTAL = .;
   Grand_Total = SUM(TOTAL,PartD);
END;
*KEEP ONLY PLANS BEING RUN;
IF PUT(HPLAN,$TYPEF.) NE 'NO';
RUN;

proc sort data=partc_plans_cd out=partc_plans_cd;
by hplan health;
run;

data partc_plans_cd;
  merge partc_plans_cd (in=a)
        form.premium_partcd (in=b drop=contract_id plan_id segment_id);
  by hplan;
  if a | (b & type in('FFS','MGAP'));
  if pbp_a_ben_cov='2' then plan_premium=pbp_d_mplusc_bonly_premium;
  else if pbp_a_ben_cov='1' then plan_premium=pbp_d_mplusc_premium;
  
  part_b_premium_val=&PARTB_PREMIUM.;
  part_b_premium=max(sum(part_b_premium_val,-pbp_d_mco_pay_reduct_amt),0);
  part_d_premium=plan_total_premium_net_rebate;
  
  if type='FFS' then do;
    plan_premium=0;
    part_d_premium=0;
  end;
 
run;

data  oopcs_all_final_ma(keep=
 Hplan
 Health 
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
 PartD
 Part_C_Deductible 
 part_b_premium 
 plan_premium 
 part_d_premium 
 Grand_Total)

 OOPCS_ALL_FINAL_PDP(KEEP=
 HPLAN
 HEALTH 
 PartD 
 part_d_premium 
 Grand_Total)
 
 OOPCS_ALL_FINAL_MGAP
 
 OOPCS_ALL_FINAL_FFS
;

LENGTH 
 Health
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
 Part_C_Deductible 
 Total
 PartD
 Grand_Total 
 plan_premium
 part_b_premium
 part_d_premium 8;
SET PARTC_PLANS_CD(KEEP=HPLAN Health  
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Cardiac_Rehabilitation_Services
 Pulmonary_Rehab_Services
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Diabetes_Education
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
 Part_C_Deductible
 Total
 PartD
 Grand_Total
 plan_premium
 part_b_premium
 part_d_premium
 type);

Grand_Total_wPremium=sum(Grand_Total,plan_premium,part_b_premium,part_d_premium);

select(type);
  when('PDP') output OOPCS_ALL_FINAL_PDP;
  when('MAPD') output OOPCS_ALL_FINAL_MA;
  when('MAON') output OOPCS_ALL_FINAL_MA;
  when('MSA') output OOPCS_ALL_FINAL_MA;
  when('FFS') output OOPCS_ALL_FINAL_FFS;
  when('MGAP') output OOPCS_ALL_FINAL_MGAP;
  otherwise;
end;
RUN;

proc sql;
  create table oopc_mgap_state as 
   select o.*,p.state_abbrev as state,p.simple_plantype,p.medigap_premium
 from oopcs_all_final_mgap o,pbp.premiums_medigap2011 p
   where o.hplan=p.hplan;
  quit;
run;

data oopc_final_ma oopc_final_ma_chronics;
  retain 
    hplan
    health_name
    Inpatient_Hospital_Acute_Care
    Inpatient_Mental_Health_Care
    Skilled_Nursing_Facility
    Cardiac_Rehabilitation_Services
    Pulmonary_Rehab_Services
    Emergency_Care
    Urgently_Needed_Care
    Home_Health_Agency
    Primary_Care_Physician
    Chiropractic_Services
    Occupational_Therapy
    Physician_Specialists
    Outpatient_Mental_Health_Care
    Podiatry_Services
    Other_Health_Professionals
    Psychiatric_Care
    Physical_and_Speech_Therapy
    Outpatient_Lab
    Diagnostic_Tests_and_Procedures
    Therapeutic_Radiation
    Outpatient_X_Rays
    Diagnostic_Radiological_Services
    Outpatient_Hospital_Services
    Ambulatory_Surgical_Center
    Chemotherapy_Drugs
    Ambulance
    Durable_Medical_Equipment
    Prosthetic_Devices
    Renal_Dialysis
    Pap_Pelvic_Exams
    Diabetes_Education
    Screen_Mammography_Exams
    PartD
    Medicare_Covered_Part_B_Drugs
    Preventative_Comp_Dental
    Medicare_Covered_Dental
    Eye_Exams
    Hearing_Exams
    Part_C_Deductible
    part_b_premium
    plan_premium
    part_d_premium
    total_cost
  ;
  set oopcs_all_final_ma (drop=grand_total);
  length health_name $9;
  health_name=put(health,grpfmt.);
  total_cost=sum(Inpatient_Hospital_Acute_Care,
    Inpatient_Mental_Health_Care,
    Skilled_Nursing_Facility,
    Cardiac_Rehabilitation_Services,
    Pulmonary_Rehab_Services,
    Emergency_Care,
    Urgently_Needed_Care,
    Home_Health_Agency,
    Primary_Care_Physician,
    Chiropractic_Services,
    Occupational_Therapy,
    Physician_Specialists,
    Outpatient_Mental_Health_Care,
    Podiatry_Services,
    Other_Health_Professionals,
    Psychiatric_Care,
    Physical_and_Speech_Therapy,
    Outpatient_Lab,
    Diagnostic_Tests_and_Procedures,
    Therapeutic_Radiation,
    Outpatient_X_Rays,
    Diagnostic_Radiological_Services,
    Outpatient_Hospital_Services,
    Ambulatory_Surgical_Center,
    Chemotherapy_Drugs,
    Ambulance,
    Durable_Medical_Equipment,
    Prosthetic_Devices,
    Renal_Dialysis,
    Pap_Pelvic_Exams,
    Diabetes_Education,
    Screen_Mammography_Exams,
    Medicare_Covered_Part_B_Drugs,
    Preventative_Comp_Dental,
    Medicare_Covered_Dental,
    Eye_Exams,
    Hearing_Exams,
    Part_C_Deductible,
    PartD,
    plan_premium,
    part_b_premium,
    part_d_premium);
    if health < 31 then output oopc_final_ma;
    else output oopc_final_ma_chronics;
  keep 
    hplan
    Health_name
    Inpatient_Hospital_Acute_Care
    Inpatient_Mental_Health_Care
    Skilled_Nursing_Facility
    Cardiac_Rehabilitation_Services
    Pulmonary_Rehab_Services
    Emergency_Care
    Urgently_Needed_Care
    Home_Health_Agency
    Primary_Care_Physician
    Chiropractic_Services
    Occupational_Therapy
    Physician_Specialists
    Outpatient_Mental_Health_Care
    Podiatry_Services
    Other_Health_Professionals
    Psychiatric_Care
    Physical_and_Speech_Therapy
    Outpatient_Lab
    Diagnostic_Tests_and_Procedures
    Therapeutic_Radiation
    Outpatient_X_Rays
    Diagnostic_Radiological_Services
    Outpatient_Hospital_Services
    Ambulatory_Surgical_Center
    Chemotherapy_Drugs
    Ambulance
    Durable_Medical_Equipment
    Prosthetic_Devices
    Renal_Dialysis
    Pap_Pelvic_Exams
    Diabetes_Education
    Screen_Mammography_Exams
    Medicare_Covered_Part_B_Drugs
    Preventative_Comp_Dental
    Medicare_Covered_Dental
    Eye_Exams
    Hearing_Exams
    Part_C_Deductible
    PartD
    Total_cost
    plan_premium
    part_b_premium
    part_d_premium
  ;
run;

data oopc_final_ma (drop=i);
set oopc_final_ma;
array acat  Inpatient_Hospital_Acute_Care
            Inpatient_Mental_Health_Care
            Skilled_Nursing_Facility
            Cardiac_Rehabilitation_Services
            Pulmonary_Rehab_Services
            Emergency_Care
            Urgently_Needed_Care
            Home_Health_Agency
            Primary_Care_Physician
            Chiropractic_Services
            Occupational_Therapy
            Physician_Specialists
            Outpatient_Mental_Health_Care
            Podiatry_Services
            Other_Health_Professionals
            Psychiatric_Care
            Physical_and_Speech_Therapy
            Outpatient_Lab
            Diagnostic_Tests_and_Procedures
            Therapeutic_Radiation
            Outpatient_X_Rays
            Diagnostic_Radiological_Services
            Outpatient_Hospital_Services
            Ambulatory_Surgical_Center
            Chemotherapy_Drugs
            Ambulance
            Durable_Medical_Equipment
            Prosthetic_Devices
            Renal_Dialysis
            Pap_Pelvic_Exams
            Diabetes_Education
            Screen_Mammography_Exams
            Medicare_Covered_Part_B_Drugs
            Preventative_Comp_Dental
            Medicare_Covered_Dental
            Eye_Exams
            Hearing_Exams
;
do i=1 to dim(acat);
  if acat(i)=. then acat(i)=0;
end;
run;

data oopc_final_pdp oopc_final_pdp_chronics;
  retain
    hplan
    Health_name
    PartD
    part_d_premium
    Grand_Total
  ;
  set OOPCS_ALL_FINAL_PDP (drop=Grand_Total);
  length health_name $9;
  Grand_total=sum(PartD,part_d_premium);
  health_name=put(health,grpfmt.);
  if health < 31 then output oopc_final_pdp;
  else output oopc_final_pdp_chronics;
  keep hplan health_name PartD part_d_premium Grand_Total;
run;

data oopc_final_mgap oopc_final_mgap_chronics;
  retain 
    hplan
    state
    health_name
    Inpatient_Hospital_Acute_Care
    Inpatient_Mental_Health_Care
    Skilled_Nursing_Facility
    Cardiac_Rehabilitation_Services
    Pulmonary_Rehab_Services
    Emergency_Care
    Urgently_Needed_Care
    Home_Health_Agency
    Primary_Care_Physician
    Chiropractic_Services
    Occupational_Therapy
    Physician_Specialists
    Outpatient_Mental_Health_Care
    Podiatry_Services
    Other_Health_Professionals
    Psychiatric_Care
    Physical_and_Speech_Therapy
    Outpatient_Lab
    Diagnostic_Tests_and_Procedures
    Therapeutic_Radiation
    Outpatient_X_Rays
    Diagnostic_Radiological_Services
    Outpatient_Hospital_Services
    Ambulatory_Surgical_Center
    Chemotherapy_Drugs
    Ambulance
    Durable_Medical_Equipment
    Prosthetic_Devices
    Renal_Dialysis
    Pap_Pelvic_Exams
    Diabetes_Education
    Screen_Mammography_Exams
    PartD
    Medicare_Covered_Part_B_Drugs
    Preventative_Comp_Dental
    Medicare_Covered_Dental
    Eye_Exams
    Hearing_Exams
    Part_C_Deductible
    part_b_premium
    medigap_premium
    total_cost
  ;
  set OOPCS_ALL_FINAL_FFS (in=a drop=grand_total)
    oopc_mgap_state (in=b drop=grand_total where=(medigap_premium ^= .));
  length health_name $9;
  if a then hplan='FFS';
  if hplan ^= 'FFS' then medigap_premium=round(medigap_premium/12,.01);
  health_name=put(health,grpfmt.);
  total_cost=sum(Inpatient_Hospital_Acute_Care,
    Inpatient_Mental_Health_Care,
    Skilled_Nursing_Facility,
    Cardiac_Rehabilitation_Services,
    Pulmonary_Rehab_Services,
    Emergency_Care,
    Urgently_Needed_Care,
    Home_Health_Agency,
    Primary_Care_Physician,
    Chiropractic_Services,
    Occupational_Therapy,
    Physician_Specialists,
    Outpatient_Mental_Health_Care,
    Podiatry_Services,
    Other_Health_Professionals,
    Psychiatric_Care,
    Physical_and_Speech_Therapy,
    Outpatient_Lab,
    Diagnostic_Tests_and_Procedures,
    Therapeutic_Radiation,
    Outpatient_X_Rays,
    Diagnostic_Radiological_Services,
    Outpatient_Hospital_Services,
    Ambulatory_Surgical_Center,
    Chemotherapy_Drugs,
    Ambulance,
    Durable_Medical_Equipment,
    Prosthetic_Devices,
    Renal_Dialysis,
    Pap_Pelvic_Exams,
    Diabetes_Education,
    Screen_Mammography_Exams,
    Medicare_Covered_Part_B_Drugs,
    Preventative_Comp_Dental,
    Medicare_Covered_Dental,
    Eye_Exams,
    Hearing_Exams,
    Part_C_Deductible,
    PartD,
    medigap_premium,
    part_b_premium
    );
    
    if health < 31 then output oopc_final_mgap;
    else output oopc_final_mgap_chronics;
  keep 
    hplan
    state
    health
    Health_name
    Inpatient_Hospital_Acute_Care
    Inpatient_Mental_Health_Care
    Skilled_Nursing_Facility
    Cardiac_Rehabilitation_Services
    Pulmonary_Rehab_Services
    Emergency_Care
    Urgently_Needed_Care
    Home_Health_Agency
    Primary_Care_Physician
    Chiropractic_Services
    Occupational_Therapy
    Physician_Specialists
    Outpatient_Mental_Health_Care
    Podiatry_Services
    Other_Health_Professionals
    Psychiatric_Care
    Physical_and_Speech_Therapy
    Outpatient_Lab
    Diagnostic_Tests_and_Procedures
    Therapeutic_Radiation
    Outpatient_X_Rays
    Diagnostic_Radiological_Services
    Outpatient_Hospital_Services
    Ambulatory_Surgical_Center
    Chemotherapy_Drugs
    Ambulance
    Durable_Medical_Equipment
    Prosthetic_Devices
    Renal_Dialysis
    Pap_Pelvic_Exams
    Diabetes_Education
    Screen_Mammography_Exams
    Medicare_Covered_Part_B_Drugs
    Preventative_Comp_Dental
    Medicare_Covered_Dental
    Eye_Exams
    Hearing_Exams
    Part_C_Deductible
    PartD
    Total_cost
    medigap_premium
    part_b_premium
  ;
run;

proc sort data=oopc_final_mgap out=oopc_final_mgap (drop=health rename=Part_C_Deductible=Part_B_Deductible);
by hplan state health;
run;

data oopc_final_mgap (drop=i);
set oopc_final_mgap;
array acat  Inpatient_Hospital_Acute_Care
            Inpatient_Mental_Health_Care
            Skilled_Nursing_Facility
            Cardiac_Rehabilitation_Services
            Pulmonary_Rehab_Services
            Emergency_Care
            Urgently_Needed_Care
            Home_Health_Agency
            Primary_Care_Physician
            Chiropractic_Services
            Occupational_Therapy
            Physician_Specialists
            Outpatient_Mental_Health_Care
            Podiatry_Services
            Other_Health_Professionals
            Psychiatric_Care
            Physical_and_Speech_Therapy
            Outpatient_Lab
            Diagnostic_Tests_and_Procedures
            Therapeutic_Radiation
            Outpatient_X_Rays
            Diagnostic_Radiological_Services
            Outpatient_Hospital_Services
            Ambulatory_Surgical_Center
            Chemotherapy_Drugs
            Ambulance
            Durable_Medical_Equipment
            Prosthetic_Devices
            Renal_Dialysis
            Pap_Pelvic_Exams
            Diabetes_Education
            Screen_Mammography_Exams
            Medicare_Covered_Part_B_Drugs
            Preventative_Comp_Dental
            Medicare_Covered_Dental
            Eye_Exams
            Hearing_Exams
;
do i=1 to dim(acat);
  if acat(i)=. then acat(i)=0;
end;
run;
    
    
PROC EXPORT DATA=oopc_final_ma
            OUTFILE= "&OOPC_EXTRACT_MA"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS_MA &RUNYEAR";
RUN;

PROC EXPORT DATA=oopc_final_pdp
            OUTFILE= "&OOPC_EXTRACT_PDP"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS_PDP &RUNYEAR";
RUN;

PROC EXPORT DATA=oopc_final_mgap
            OUTFILE= "&OOPC_EXTRACT_MGAP"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS_MGAP &RUNYEAR";
RUN;



proc transpose data=oopc_final_ma out=ma_health_totals (drop=_name_);
by hplan;
var total_cost;
id health_name;
run;

proc transpose data=oopc_final_ma_chronics out=ma_health_totals_chronics (drop=_name_);
by hplan;
var total_cost;
id health_name;
run;

data ma_health_totals;
merge ma_health_totals (in=a)
      ma_health_totals_chronics (in=b);
by hplan;
if a & b;
run;

PROC EXPORT DATA=ma_health_totals
            OUTFILE= "&OOPC_MEANS_MA"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS_MA &RUNYEAR";
RUN;

proc transpose data=oopc_final_pdp out=pdp_health_totals (drop=_name_);
by hplan;
var Grand_total;
id health_name;
run;

proc sort data=oopc_final_mgap_chronics out=oopc_final_mgap_chronics;
by hplan state health_name;
run;

proc transpose data=oopc_final_pdp_chronics out=pdp_health_totals_chronics (drop=_name_);
by hplan;
var Grand_total;
id health_name;
run;

data pdp_health_totals;
merge  pdp_health_totals (in=a)
       pdp_health_totals_chronics (in=b);
by hplan;
if a & b;
run;

PROC EXPORT DATA=pdp_health_totals
            OUTFILE= "&OOPC_MEANS_PDP"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS_PDP &RUNYEAR";
RUN;

proc transpose data=oopc_final_mgap out=mgap_health_totals (drop=_name_);
by hplan state;
var total_cost;
id health_name;
run;

proc transpose data=oopc_final_mgap_chronics out=mgap_health_totals_chronics (drop=_name_);
by hplan state;
var total_cost;
id health_name;
run;

data mgap_health_totals;
merge mgap_health_totals (in=a)
      mgap_health_totals_chronics (in=b);
by hplan state;
if a & b;
run;

data mgap_health_totals;
retain hplan state Excellent Very_Good Good Fair Poor AHC CHF Diabetes;
set mgap_health_totals;
run;

PROC EXPORT DATA=mgap_health_totals
            OUTFILE= "&OOPC_MEANS_MGAP"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS_MGAP &RUNYEAR";
RUN;

%MEND;
RUN;

%EXP();
RUN;
