* PROGRAM: OOPCV4M.SAS;
* DESCRIPTION: MAIN MACRO THAT CALLS OTHER PROGRAMS;

%INCLUDE IN0(CLEANUP);
RUN;

%MACRO OOPCV4M(RUNYEAR=, INP=, INC=, PBP=, FORMULARY=, PLANFILE=, OOPC=);

%IF &INPUT = INPUTPLAN %THEN %DO;
%INCLUDE IN0(PBP_IMPORT)/SOURCE2;
RUN;
%INCLUDE IN0(PBP_IMPORT_PARTD)/SOURCE2;
RUN;
%INCLUDE IN0(PBP_DRUG_VARIABLES)/SOURCE2;
RUN;
%END;

%IF &INPUT = INPUTCMS %THEN %DO;
%INCLUDE IN0(PBP_CMS)/SOURCE2;
RUN;
%END;

%IF &INPUT = INPUTMPF %THEN %DO;
%INCLUDE IN0(PBP_CMS)/SOURCE2;
RUN;
%END;
*PART C PROCESS;
%IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 OR &FFS > 0 OR &MGAP > 0 %THEN %DO;


DATA COSTDATA;
LENGTH HPLAN $11 YEAR $4 BASEID $8 CATEGORY $3 COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
     OTHER_COST COST AMTTOT 8;
RETAIN HPLAN YEAR BASEID CATEGORY ' ' COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
     OTHER_COST COST AMTTOT .;
OUTPUT;
RUN;

DATA PBP_FILE_COMPLETE;
SET PBP_FILE;
RUN;

DATA PBP_FILE;
SET PBP_FILE;
IF PUT(HPLAN,$TYPEF.)='PDP' THEN DELETE;
RUN;

%IF &INPUT^=INPUTPLAN %THEN %DO;
  %INCLUDE IN0(CHRONIC)/SOURCE2;
  RUN;
%END;
%INCLUDE IN0(COST_SHARING_AMBULANCE)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_ASC)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_CARDIAC_REHAB)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_CHIROPRACTIC)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_COMP_XRAY)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_DENTAL)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_EDUCATION_DIABETES)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_DIAG)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_DIALYSIS)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_DME)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_ER)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_EYEEXAMS)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_HEARINGEXAMS)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_HHA)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_INPATIENT_ACUTE)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_INPATIENT_PSYCH)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_LAB)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_MAMMOGRAPHY)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_MEDICARE_DENTAL)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_MEDICARE_DRUGS)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_MEDICARE_DRUGS_CHEMO)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_MNTLHLTH)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_ORTHOTICS)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_OT)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_OTHER)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_OUTPAT)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_PAP)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_PCP)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_PODIATRY)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_PSYCH)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_PT)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_PULMONARY_REHAB)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_RADIATION)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_SNF)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_SPECIALIST)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_SUPPLIES)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_URGENT_CARE)/SOURCE2;
RUN;
%INCLUDE IN0(COST_SHARING_XRAY)/SOURCE2;
RUN;

DATA PBP_FILE;
SET PBP_FILE_COMPLETE;
RUN;

%END;
*END OF 1ST PART OF PART C PROCESS;

%INCLUDE IN0(FFS_BENEFIT_OOPC_COST_CALCULATION)/SOURCE2;
RUN;


%IF &PDP > 0 OR &MAPD > 0 %THEN %DO;

%IF &INPUT^=INPUTPLAN %THEN %DO;
  %INCLUDE IN0(FINISH_MRX)/SOURCE2;
  RUN;
%END;
%INCLUDE IN0(BUILD_LOOKUP)/SOURCE2;
RUN;
%INCLUDE IN0(AE_BENEFIT_OOPC_COST_CALCULATION)/SOURCE2;
RUN;
%INCLUDE IN0(BA_BENEFIT_OOPC_COST_CALCULATION)/SOURCE2;
RUN;
%INCLUDE IN0(DS_BENEFIT_OOPC_COST_CALCULATION)/SOURCE2;
RUN;
%INCLUDE IN0(BUILD_GAPDRUGS_FORMAT)/SOURCE2;
RUN;
%INCLUDE IN0(EA_BENEFIT_OOPC_COST_CALCULATION)/SOURCE2;
RUN;
%END;
*END OF 1ST PART OF PART D PROCESS;

*2ND PART OF PART C PROCESS;
%IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 OR &FFS > 0 OR &MGAP > 0 %THEN %DO;
%INCLUDE IN0(PBPCATS)/SOURCE2;
RUN;

%INCLUDE IN0(MISSING_CELLS_YEAR)/SOURCE2;
RUN;
%END;
*END OF 2ND PART OF PART C PROCESS;

*2ND PART OF PART D PROCESS;
%IF &PDP > 0 OR &MAPD > 0 %THEN %DO;

%LET YEAR = &YEAR1;
%LET CLASS =PDP;
RUN;
%INCLUDE IN0(BASEID_DRUGS)/SOURCE2;
RUN;
%LET YEAR = &YEAR2;
RUN;
%INCLUDE IN0(BASEID_DRUGS)/SOURCE2;
RUN;

%LET YEAR = &YEAR1;
%LET CLASS =MAPD;
RUN;
%INCLUDE IN0(BASEID_DRUGS)/SOURCE2;
RUN;
%LET YEAR = &YEAR2;
RUN;
%INCLUDE IN0(BASEID_DRUGS)/SOURCE2;
RUN;
%END;
*END OF 2ND PART OF PART D PROCESS;

%IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 OR &FFS > 0 OR &MGAP > 0 %THEN %DO;
  %INCLUDE IN0(BASEID_PLAN_YEAR)/SOURCE2;
  RUN;
%END;

*FINAL PROGRAM WITH BOTH PART C AND PART D COME TOGETHER;
%INCLUDE IN0(PLAN_LEVEL)/SOURCE2;
RUN;
%INCLUDE IN0(PLAN_CATNAME_NEW)/SOURCE2;
RUN;

%IF &INPUT^=INPUTPLAN %THEN %DO;
  %INCLUDE IN0(MOC_FILE_CREATION)/SOURCE2;
  RUN;
  %INCLUDE IN0(EXTRACT_FILE_CREATION)/SOURCE2;
  RUN;
%END;

%MEND;
RUN;
