* PROGRAM: PLAN_DRUGS.SAS;
* DESCRIPTION: PLAN_CATEGORY_COMBINED PLAN LEVEL.SAS;

DATA BASEID_CATEGORY_ALLYEARS;
  SET    BASEID_PLAN_CATEGORY_&CLASS._&YEAR1 (IN = A)
         BASEID_PLAN_CATEGORY_&CLASS._&YEAR2 (IN = B);
   BY CELL_GROUP HPLAN CATEGORY;

  IF A THEN DO;
     SOURCE = "MCBS &YEAR1";
     COMBO_WGT = CWGT;
  END;

  ELSE IF B THEN DO;
     SOURCE = "MCBS &YEAR2";
     COMBO_WGT = CWGT;
  END;
RUN;


* GET THE MANAGED CARE PART D PREMIUM FROM THE PBP DATASET;


PROC UNIVARIATE DATA = BASEID_CATEGORY_ALLYEARS NOPRINT;
  CLASS HPLAN;
  WEIGHT COMBO_WGT;
  VAR MONTHLY_COST;
  OUTPUT OUT = PLAN MEAN = MONTHLY_COST_MEAN SUM = MONTHLY_COST_SUM;
RUN;

* GET THE SUM OF THE WEIGHTS BY CELL_GROUP;

DATA CCOHORT;
  SET    &INP;
  IF YEAR = "&YEAR1" THEN DO;
     SOURCE = "MCBS &YEAR1";
     COMBO_WGT = CSYRWGT;
  END;

  ELSE IF YEAR = "&YEAR2" THEN DO;
    SOURCE = "MCBS &YEAR2";
    COMBO_WGT = CSYRWGT;
  END;
  KEEP BASEID COMBO_WGT;
RUN;

PROC SUMMARY DATA = CCOHORT NWAY MISSING;
  VAR COMBO_WGT;
  OUTPUT OUT = COHORT_CELL_GROUP(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
RUN;

DATA PLAN_DRUG_COSTS_&CLASS.(DROP=  COMBOWGT_SUM MONTHLY_COST_SUM  );
  IF _N_ = 1 THEN SET COHORT_CELL_GROUP(KEEP = COMBOWGT_SUM);
  SET PLAN(IN = A);
  MONTHLY_COST_MEAN = MONTHLY_COST_SUM / COMBOWGT_SUM;
RUN;
