
* PROGRAM: PARTD_FORM.SAS;
* DESCRIPTION: CREATES SAS FILES FOR THREE TAB DELIMITED FILES;

%LET DIR =c:\oopc\formulary;
%LET FORMFILE = FORMULARY.TXT;
%LET PLANFORM = PLAN_FORMULARY.TXT;
%LET GAPDRUGS = GAP_DRUGS.TXT;

LIBNAME IN "&DIR";

DATA IN.FORMULARY;
INFILE "&DIR.\&FORMFILE" delimiter = '09'x dsd lrecl=1000 missover pad;
INPUT FORMULARY_ID     : $CHAR8.
      RXCUI            : 8.
      TIER_LEVEL_VALUE : 2.;
IF FORMULARY_ID NE ' ';
FORMULARY_VERSION=1;
RUN;

PROC PRINT DATA=IN.FORMULARY(OBS=50);
TITLE 'FORMULARY';
RUN;

DATA IN.PLAN_FORMULARY;
INFILE "&DIR.\&PLANFORM" delimiter = '09'x dsd lrecl=1000 missover pad;
INPUT CONTRACT_ID     : $CHAR5.
      PLAN_ID         : $CHAR3.
      FORMULARY_ID    : $CHAR8.;
IF CONTRACT_ID NE ' ';
RUN;

PROC PRINT DATA=IN.PLAN_FORMULARY(OBS=25);
TITLE 'PLAN_FORMULARY';
RUN;

DATA IN.GAP_DRUGS;
INFILE "&DIR.\&GAPDRUGS" delimiter = '09'x dsd lrecl=1000 missover pad;
INPUT CONTRACT_ID     : $CHAR5.
      PLAN_ID         : $CHAR3.
      RXCUI           : 8.;
IF CONTRACT_ID NE ' ';
RUN;

PROC PRINT DATA=IN.GAP_DRUGS(OBS=25);
TITLE 'GAP_DRUGS';
RUN;
