// #ifndef _mdsgrouper_h
// #define _mdsgrouper_h


void FillRecord( char * Assessment, char * sData, int iLoc, int len );
void FillData( char * Assessment, char * sData, int iLoc, int iLen );
void Trim_I0020B( char * I0020B );

// char pdpmRecord[3691];

static char LungTransplantCodes[14][10] = {"T8630", "T8631", "T8632", "T8633", "T8639", 
"T86810", "T86811", "T86812", "T86818", "T86819", 
"Z4824", "Z48280", "Z942", "Z943"};

static char MajorOrganCodes[49][10] = {"D89810", "D89811", "D89812", "D89813", "T8600", 
"T8601", "T8602", "T8603", "T8609", "T8610", 
"T8611", "T8612", "T8613", "T8619", "T8620", 
"T8621", "T8622", "T8623", "T86290", "T86298", 
"T8630", "T8631", "T8632", "T8633", "T8639", 
"T8640", "T8641", "T8642", "T8643", "T8649", 
"T865", "T86850", "T86851", "T86852", "T86858", 
"T86859", "Z4821", "Z4822", "Z4823", "Z48280", 
"Z48290", "Z940", "Z941", "Z943", "Z944", 
"Z9481", "Z9482", "Z9483", "Z9484"};

static char OpportunisticInfectionsCodes[37][10] = {"A072", "A310", "A312", "B250", "B251", 
"B252", "B258", "B259", "B371", "B377", 
"B3781", "B440", "B441", "B442", "B447", 
"B4489", "B449", "B450", "B451", "B452", 
"B453", "B457", "B458", "B459", "B460", 
"B461", "B462", "B463", "B464", "B465", 
"B468", "B469", "B484", "B488", "B582", 
"B583", "B59"};

static char BoneNecrosisCodes[410][10] = {"A0104", "A0105", "A0223", "A0224", "A3983", 
"A3984", "A5055", "A5440", "A5441", "A5442", 
"A5443", "A5449", "A666", "A6923", "B0682", 
"B2685", "B4282", "M0000", "M00011", "M00012", 
"M00019", "M00021", "M00022", "M00029", "M00031", 
"M00032", "M00039", "M00041", "M00042", "M00049", 
"M00051", "M00052", "M00059", "M00061", "M00062", 
"M00069", "M00071", "M00072", "M00079", "M0008", 
"M0009", "M0010", "M00111", "M00112", "M00119", 
"M00121", "M00122", "M00129", "M00131", "M00132", 
"M00139", "M00141", "M00142", "M00149", "M00151", 
"M00152", "M00159", "M00161", "M00162", "M00169", 
"M00171", "M00172", "M00179", "M0018", "M0019", 
"M0020", "M00211", "M00212", "M00219", "M00221", 
"M00222", "M00229", "M00231", "M00232", "M00239", 
"M00241", "M00242", "M00249", "M00251", "M00252", 
"M00259", "M00261", "M00262", "M00269", "M00271", 
"M00272", "M00279", "M0028", "M0029", "M0080", 
"M00811", "M00812", "M00819", "M00821", "M00822", 
"M00829", "M00831", "M00832", "M00839", "M00841", 
"M00842", "M00849", "M00851", "M00852", "M00859", 
"M00861", "M00862", "M00869", "M00871", "M00872", 
"M00879", "M0088", "M0089", "M009", "M01X0", 
"M01X11", "M01X12", "M01X19", "M01X21", "M01X22", 
"M01X29", "M01X31", "M01X32", "M01X39", "M01X41", 
"M01X42", "M01X49", "M01X51", "M01X52", "M01X59", 
"M01X61", "M01X62", "M01X69", "M01X71", "M01X72", 
"M01X79", "M01X8", "M01X9", "M0210", "M02111", 
"M02112", "M02119", "M02121", "M02122", "M02129", 
"M02131", "M02132", "M02139", "M02141", "M02142", 
"M02149", "M02151", "M02152", "M02159", "M02161", 
"M02162", "M02169", "M02171", "M02172", "M02179", 
"M0218", "M0219", "M0280", "M02811", "M02812", 
"M02819", "M02821", "M02822", "M02829", "M02831", 
"M02832", "M02839", "M02841", "M02842", "M02849", 
"M02851", "M02852", "M02859", "M02861", "M02862", 
"M02869", "M02871", "M02872", "M02879", "M0288", 
"M0289", "M029", "M4620", "M4621", "M4622", 
"M4623", "M4624", "M4625", "M4626", "M4627", 
"M4628", "M4630", "M4631", "M4632", "M4633", 
"M4634", "M4635", "M4636", "M4637", "M4638", 
"M4639", "M726", "M8600", "M86011", "M86012", 
"M86019", "M86021", "M86022", "M86029", "M86031", 
"M86032", "M86039", "M86041", "M86042", "M86049", 
"M86051", "M86052", "M86059", "M86061", "M86062", 
"M86069", "M86071", "M86072", "M86079", "M8608", 
"M8609", "M8610", "M86111", "M86112", "M86119", 
"M86121", "M86122", "M86129", "M86131", "M86132", 
"M86139", "M86141", "M86142", "M86149", "M86151", 
"M86152", "M86159", "M86161", "M86162", "M86169", 
"M86171", "M86172", "M86179", "M8618", "M8619", 
"M8620", "M86211", "M86212", "M86219", "M86221", 
"M86222", "M86229", "M86231", "M86232", "M86239", 
"M86241", "M86242", "M86249", "M86251", "M86252", 
"M86259", "M86261", "M86262", "M86269", "M86271", 
"M86272", "M86279", "M8628", "M8629", "M8630", 
"M86311", "M86312", "M86319", "M86321", "M86322",
"M86329", "M86331", "M86332", "M86339", "M86341", 
"M86342", "M86349", "M86351", "M86352", "M86359", 
"M86361", "M86362", "M86369", "M86371", "M86372", 
"M86379", "M8638", "M8639", "M8640", "M86411", 
"M86412", "M86419", "M86421", "M86422", "M86429", 
"M86431", "M86432", "M86439", "M86441", "M86442", 
"M86449", "M86451", "M86452", "M86459", "M86461", 
"M86462", "M86469", "M86471", "M86472", "M86479", 
"M8648", "M8649", "M8650", "M86511", "M86512", 
"M86519", "M86521", "M86522", "M86529", "M86531", 
"M86532", "M86539", "M86541", "M86542", "M86549", 
"M86551", "M86552", "M86559", "M86561", "M86562", 
"M86569", "M86571", "M86572", "M86579", "M8658", 
"M8659", "M8660", "M86611", "M86612", "M86619", 
"M86621", "M86622", "M86629", "M86631", "M86632", 
"M86639", "M86641", "M86642", "M86649", "M86651", 
"M86652", "M86659", "M86661", "M86662", "M86669", 
"M86671", "M86672", "M86679", "M8668", "M8669", 
"M868X0", "M868X1", "M868X2", "M868X3", "M868X4", 
"M868X5", "M868X6", "M868X7", "M868X8", "M868X9", 
"M869", "M8960", "M89611", "M89612", "M89619", 
"M89621", "M89622", "M89629", "M89631", "M89632", 
"M89639", "M89641", "M89642", "M89649", "M89651", 
"M89652", "M89659", "M89661", "M89662", "M89669", 
"M89671", "M89672", "M89679", "M8968", "M8969"};

static char MyeloidLeukemiaCodes[3][10] = {"C9210", "C9211", "C9212"};

static char EndocarditisCodes[13][10] = {"A0102", "A1884", "A3282", "A3951", "A5203", 
"A78", "B3321", "B376", "I330", "I339", 
"I38", "I39", "M3211"};

static char ImmuneDisordersCodes[47][10] = {"D800", "D801", "D802", "D803", "D804", 
"D805", "D806", "D807", "D808", "D809", 
"D810", "D811", "D812", "D8130", "D8131",
"D8132", "D8139", "D814", "D815", "D816", 
"D817", "D8189", "D819", "D820", "D821", 
"D822", "D823", "D824", "D828", "D829", 
"D830", "D831", "D832", "D838", "D839", 
"D840", "D848", "D849", "D893", "D8940",
"D8941","D8942","D8943","D8949","D8982", 
"D8989", "D899"};

static char LiverDiseaseCodes[14][10] = {"I8500", "I8501", "I8510", "I8511", "K7041", 
"K7111", "K7201", "K7210", "K7211", "K7290", 
"K7291", "K766", "K767", "K7681"};

static char NarcolepsyCodes[4][10] = {"G47411", "G47419", "G47421", "G47429"};

static char CysticFibrosisCodes[5][10] = {"E840", "E8411", "E8419", "E848", "E849"};

static char SpecificImmuneDisordersCodes[2][10] = {"D841", "E8801"};

static char MorbidObesityCodes[7][10] = {"E6601", "E662", "Z6841", "Z6842", "Z6843", 
"Z6844", "Z6845"};

static char PsoriaticAnthropathyCodes[14][10] = {"L4050", "L4051", "L4052", "L4053", "L4054", 
"L4059", "M340", "M341", "M342", "M3481", 
"M3482", "M3483", "M3489", "M349"};

static char ChronicPancreatitisCodes[2][10] = {"K860", "K861"}; 

static char ProlificRetinopathyCodes[124][10] = {"E083511","E083512","E083513","E083519","E083521",
"E083522","E083523","E083529","E083531","E083532",
"E083533","E083539","E083541","E083542","E083543",
"E083549","E083551","E083552","E083553","E083559",
"E083591","E083592","E083593","E083599","E093511",
"E093512","E093513","E093519","E093521","E093522",
"E093523","E093529","E093531","E093532","E093533",
"E093539","E093541","E093542","E093543","E093549",
"E093551","E093552","E093553","E093559","E093591",
"E093592","E093593","E093599","E103511","E103512",
"E103513","E103519","E103521","E103522","E103523",
"E103529","E103531","E103532","E103533","E103539",
"E103541","E103542","E103543","E103549","E103551",
"E103552","E103553","E103559","E103591","E103592",
"E103593","E103599","E113511","E113512","E113513",
"E113519","E113521","E113522","E113523","E113529",
"E113531","E113532","E113533","E113539","E113541",
"E113542","E113543","E113549","E113551","E113552",
"E113553","E113559","E113591","E113592","E113593",
"E113599","E133511","E133512","E133513","E133519",
"E133521","E133522","E133523","E133529","E133531",
"E133532","E133533","E133539","E133541","E133542",
"E133543","E133549","E133551","E133552","E133553",
"E133559","E133591","E133592","E133593","E133599",
"H4310", "H4311", "H4312", "H4313"};

static char ImplantedDeviceCodes[322][10] = {"M96621", "M96622", "M96629", "M96631", "M96632", 
"M96639", "M9665", "M96661", "M96662", "M96669", 
"M96671", "M96672", "M96679", "M9669", "N99510", 
"N99511", "N99512", "N99518", "N99520", "N99521", 
"N99522", "N99523", "N99524", "N99528", "N99530", 
"N99531", "N99532", "N99533", "N99534", "N99538",
"T82310A", "T82311A", "T82312A", "T82318A", "T82319A", 
"T82320A", "T82321A", "T82322A", "T82328A", "T82329A", 
"T82330A", "T82331A", "T82332A", "T82338A", "T82339A", 
"T82390A", "T82391A", "T82392A", "T82398A", "T82399A", 
"T82510A", "T82511A", "T82513A", "T82514A", "T82515A", 
"T82518A", "T82520A", "T82521A", "T82523A", "T82524A", 
"T82525A", "T82528A", "T82530A", "T82531A", "T82533A", 
"T82534A", "T82535A", "T82538A", "T82590A", "T82591A", 
"T82593A", "T82594A", "T82595A", "T82598A", "T826XXA",
"T827XXA", "T82818A", "T82828A", "T82838A", "T82848A", 
"T82856A", "T82858A", "T82868A", "T82898A", "T83010A", 
"T83011A", "T83012A", "T83018A", "T83020A", "T83021A", 
"T83022A", "T83028A", "T83030A", "T83031A", "T83032A",
"T83038A", "T83090A", "T83091A", "T83092A", "T83098A", 
"T83110A", "T83111A", "T83112A", "T83113A", "T83118A",
"T83120A", "T83121A", "T83122A", "T83123A", "T83128A", 
"T83190A", "T83191A", "T83192A", "T83193A", "T83198A", 
"T8321XA", "T8322XA", "T8323XA", "T8324XA", "T8325XA",
"T8329XA", "T83410A", "T83411A", "T83418A", "T83420A", 
"T83421A", "T83428A", "T83490A", "T83491A", "T83498A", 
"T83510A", "T83511A", "T83512A", "T83518A", "T83590A",
"T83591A", "T83592A", "T83593A", "T83598A", "T8361XA",
"T8362XA", "T8369XA", "T83711A", "T83712A", "T83713A",
"T83714A", "T83718A", "T83719A", "T83721A", "T83722A",
"T83723A", "T83724A", "T83728A", "T83729A", "T8379XA",
"T8381XA", "T8382XA", "T8383XA", "T8384XA", "T8385XA", 
"T8386XA", "T8389XA", "T839XXA", "T84010A", "T84011A",
"T84012A", "T84013A", "T84018A", "T84019A", "T84020A", 
"T84021A", "T84022A", "T84023A", "T84028A", "T84029A", 
"T84030A", "T84031A", "T84032A", "T84033A", "T84038A",
"T84039A", "T84050A", "T84051A", "T84052A", "T84053A", 
"T84058A", "T84059A", "T84060A", "T84061A", "T84062A", 
"T84063A", "T84068A", "T84069A", "T84090A", "T84091A", 
"T84092A", "T84093A", "T84098A", "T84099A", "T84110A", 
"T84111A", "T84112A", "T84113A", "T84114A", "T84115A", 
"T84116A", "T84117A", "T84119A", "T84120A", "T84121A", 
"T84122A", "T84123A", "T84124A", "T84125A", "T84126A", 
"T84127A", "T84129A", "T84190A", "T84191A", "T84192A", 
"T84193A", "T84194A", "T84195A", "T84196A", "T84197A", 
"T84199A", "T84210A", "T84213A", "T84216A", "T84218A", 
"T84220A", "T84223A", "T84226A", "T84228A", "T84290A", 
"T84293A", "T84296A", "T84298A", "T84310A", "T84318A", 
"T84320A", "T84328A", "T84390A", "T84398A", "T84410A", 
"T84418A", "T84420A", "T84428A", "T84490A", "T84498A", 
"T8450XA", "T8451XA", "T8452XA", "T8453XA", "T8454XA", 
"T8459XA", "T8460XA", "T84610A", "T84611A", "T84612A", 
"T84613A", "T84614A", "T84615A", "T84619A", "T84620A", 
"T84621A", "T84622A", "T84623A", "T84624A", "T84625A", 
"T84629A", "T8463XA", "T8469XA", "T847XXA", "T8481XA", 
"T8482XA", "T8483XA", "T8484XA", "T8485XA", "T8486XA", 
"T8489XA", "T849XXA", "T8501XA", "T8502XA", "T8503XA", 
"T8509XA", "T85110A", "T85111A", "T85112A", "T85113A",
"T85118A", "T85120A", "T85121A", "T85122A", "T85123A",
"T85128A", "T85190A", "T85191A", "T85192A", "T85193A",
"T85199A", "T85615A", "T85625A", "T85635A", "T85695A",
"T8572XA", "T85730A", "T85731A", "T85732A", "T85733A",
"T85734A", "T85735A", "T85738A", "T8579XA", "T85810A",
"T85820A", "T85830A", "T85840A", "T85850A", "T85860A",
"T85890A", "T86842"};

static char AscepticNecrosisCodes[241][10] = {"M8700", "M87011", "M87012", "M87019", "M87021", 
"M87022", "M87029", "M87031", "M87032", "M87033", 
"M87034", "M87035", "M87036", "M87037", "M87038",
"M87039", "M87041", "M87042", "M87043", "M87044", 
"M87045", "M87046", "M87050", "M87051", "M87052", 
"M87059", "M87061", "M87062", "M87063", "M87064", 
"M87065", "M87066", "M87071", "M87072", "M87073", 
"M87074", "M87075", "M87076", "M87077", "M87078", 
"M87079", "M8708", "M8709", "M8710", "M87111", 
"M87112", "M87119", "M87121", "M87122", "M87129", 
"M87131", "M87132", "M87133", "M87134", "M87135", 
"M87136", "M87137", "M87138", "M87139", "M87141", 
"M87142", "M87143", "M87144", "M87145", "M87146", 
"M87150", "M87151", "M87152", "M87159", "M87161", 
"M87162", "M87163", "M87164", "M87165", "M87166", 
"M87171", "M87172", "M87173", "M87174", "M87175", 
"M87176", "M87177", "M87178", "M87179", "M87180", 
"M87188", "M8719", "M8720", "M87211", "M87212",
"M87219", "M87221", "M87222", "M87229", "M87231", 
"M87232", "M87233", "M87234", "M87235", "M87236", 
"M87237", "M87238", "M87239", "M87241", "M87242", 
"M87243", "M87244", "M87245", "M87246", "M87250", 
"M87251", "M87252", "M87256", "M87261", "M87262", 
"M87263", "M87264", "M87265", "M87266", "M87271", 
"M87272", "M87273", "M87274", "M87275", "M87276", 
"M87277", "M87278", "M87279", "M8728", "M8729", 
"M8730", "M87311", "M87312", "M87319", "M87321", 
"M87322", "M87329", "M87331", "M87332", "M87333", 
"M87334", "M87335", "M87336", "M87337", "M87338", 
"M87339", "M87341", "M87342", "M87343", "M87344",
"M87345", "M87346", "M87350", "M87351", "M87352", 
"M87353", "M87361", "M87362", "M87363", "M87364", 
"M87365", "M87366", "M87371", "M87372", "M87373", 
"M87374", "M87375", "M87376", "M87377", "M87378", 
"M87379", "M8738", "M8739", "M8780", "M87811", 
"M87812", "M87819", "M87821", "M87822", "M87829", 
"M87831", "M87832", "M87833", "M87834", "M87835", 
"M87836", "M87837", "M87838", "M87839", "M87841", 
"M87842", "M87843", "M87844", "M87845", "M87849", 
"M87850", "M87851", "M87852", "M87859", "M87861", 
"M87862", "M87863", "M87864", "M87865", "M87869", 
"M87871", "M87872", "M87873", "M87874", "M87875", 
"M87876", "M87877", "M87878", "M87879", "M8788", 
"M8789", "M879", "M9050", "M90511", "M90512", 
"M90519", "M90521", "M90522", "M90529", "M90531",
"M90532", "M90539", "M90541", "M90542", "M90549", 
"M90551", "M90552", "M90559", "M90561", "M90562", 
"M90569", "M90571", "M90572", "M90579", "M9058", 
"M9059"};

static char RespiratoryFailureCodes[27][10] = {"I462", "I468", "I469", "I4901", "I4902", 
"J80", "J810", "J951", "J952", "J953", 
"J95821", "J95822", "J9600", "J9601", "J9602", 
"J9610", "J9611", "J9612", "J9620", "J9621", 
"J9622", "J9690", "J9691", "J9692", "R570", 
"R579", "T8111XA"};

static char MyelodysplasticCodes[12][10] = {"D460", "D461", "D4620", "D4621", "D4622", 
"D464", "D469", "D46A", "D46B", "D46Z", 
"D474", "D7581"};

static char TissueDisordersCodes[137][10] = {"M081", "M300", "M301", "M302", "M303", 
"M308", "M310", "M311", "M312", "M3130", 
"M3131", "M314", "M315", "M316", "M317", 
"M320", "M3210", "M3211", "M3212", "M3213", 
"M3214", "M3215", "M3219", "M328", "M329", 
"M3300", "M3301", "M3302", "M3303", "M3309", 
"M3310", "M3311", "M3312", "M3313", "M3319", 
"M3320", "M3321", "M3322", "M3329", "M3390", 
"M3391", "M3392", "M3393", "M3399", "M3500", 
"M3501", "M3502", "M3503", "M3504", "M3509", 
"M351", "M355", "M358", "M359", "M360", 
"M368", "M450", "M451", "M452", "M453", 
"M454", "M455", "M456", "M457", "M458", 
"M459", "M4600", "M4601", "M4602", "M4603", 
"M4604", "M4605", "M4606", "M4607", "M4608", 
"M4609", "M461", "M4650", "M4651", "M4652", 
"M4653", "M4654", "M4655", "M4656", "M4657", 
"M4658", "M4659", "M4680", "M4681", "M4682", 
"M4683", "M4684", "M4685", "M4686", "M4687", 
"M4688", "M4689", "M4690", "M4691", "M4692", 
"M4693", "M4694", "M4695", "M4696", "M4697", 
"M4698", "M4699", "M488X1", "M488X2", "M488X3", 
"M488X4", "M488X5", "M488X6", "M488X7", "M488X8", 
"M488X9", "M4980", "M4981", "M4982", "M4983", 
"M4984", "M4985", "M4986", "M4987", "M4988", 
"M4989", "Q7960", "Q7961", "Q7962", "Q7963",
"Q7969", "Q8740", "Q87410", "Q87418", "Q8742", 
"Q8743", "Q8782"};

static char DiabeticRetinopathyCodes[130][10] = {"E08311", "E08319", "E083211", "E083212", "E083213", 
"E083219", "E083291", "E083292", "E083293", "E083299", 
"E083311", "E083312", "E083313", "E083319", "E083391", 
"E083392", "E083393", "E083399", "E083411", "E083412", 
"E083413", "E083419", "E083491", "E083492", "E083493", 
"E083499", "E09311",  "E09319", "E093211", "E093212", 
"E093213", "E093219", "E093291", "E093292", "E093293", 
"E093299", "E093311", "E093312", "E093313", "E093319", 
"E093391", "E093392", "E093393", "E093399", "E093411", 
"E093412", "E093413", "E093419", "E093491", "E093492", 
"E093493", "E093499", "E10311", "E10319", "E103211", 
"E103212", "E103213", "E103219", "E103291", "E103292", 
"E103293", "E103299", "E103311", "E103312", "E103313", 
"E103319", "E103391", "E103392", "E103393", "E103399", 
"E103411", "E103412", "E103413", "E103419", "E103491", 
"E103492", "E103493", "E103499", "E11311", "E11319", 
"E113211", "E113212", "E113213", "E113219", "E113291", 
"E113292", "E113293", "E113299", "E113311", "E113312", 
"E113313", "E113319", "E113391", "E113392", "E113393", 
"E113399", "E113411", "E113412", "E113413", "E113419", 
"E113491", "E113492", "E113493", "E113499", "E13311",
"E13319", "E133211", "E133212", "E133213", "E133219", 
"E133291", "E133292", "E133293", "E133299", "E133311", 
"E133312", "E133313", "E133319", "E133391", "E133392", 
"E133393", "E133399", "E133411", "E133412", "E133413", 
"E133419", "E133491", "E133492", "E133493", "E133499"};

static char SevereSkinCodes[96][10] = {"L1230", "L1231", "L1235", "L511", "L512",
"L513", "T3111", "T3121", "T3122", "T3131",
"T3132", "T3133", "T3141", "T3142", "T3143",
"T3144", "T3151", "T3152", "T3153", "T3154", 
"T3155", "T3161", "T3162", "T3163", "T3164", 
"T3165", "T3166", "T3171", "T3172", "T3173", 
"T3174", "T3175", "T3176", "T3177", "T3181", 
"T3182", "T3183", "T3184", "T3185", "T3186", 
"T3187", "T3188", "T3191", "T3192", "T3193", 
"T3194", "T3195", "T3196", "T3197", "T3198", 
"T3199", "T3211", "T3221", "T3222", "T3231", 
"T3232", "T3233", "T3241", "T3242", "T3243", 
"T3244", "T3251", "T3252", "T3253", "T3254", 
"T3255", "T3261", "T3262", "T3263", "T3264", 
"T3265", "T3266", "T3271", "T3272", "T3273", 
"T3274", "T3275", "T3276", "T3277", "T3281", 
"T3282", "T3283", "T3284", "T3285", "T3286", 
"T3287", "T3288", "T3291", "T3292", "T3293", 
"T3294", "T3295", "T3296", "T3297", "T3298",
"T3299"};

static char IntractableEpilepsyCodes[22][10] = {"G40011", "G40019", "G40111", "G40119", "G40211", 
"G40219", "G40311", "G40319", "G40411", "G40419", 
"G40803", "G40804", "G40813", "G40814", "G40823", 
"G40824", "G40911", "G40919", "G40A11", "G40A19",
"G40B11", "G40B19"};

static char ImmuneDisorderCodes[19][10] = {"D61810", "D61811", "D61818", "D700", "D701", 
"D702", "D703", "D704", "D708", "D709", 
"D71", "D720", "D761", "D762", "D763", 
"D89810", "D89811", "D89812", "D89813"};

static char CirrhosisLiverCodes[10][10] = {"K7030", "K7031", "K7040", "K7041", "K709", 
"K743", "K744", "K745", "K7460", "K7469"};

static char RespiratoryArrestCodes[1][10] = {"R092"};

static char PulmonaryFibrosisCodes[43][10] = {"B4481", "J470", "J471", "J479", "J700", 
"J701", "J702", "J703", "J704", "J705", 
"J708", "J709", "J8401", "J8402", "J8403", 
"J8409", "J8410", "J84111", "J84112", "J84113", 
"J84114", "J84115", "J84116", "J84117", "J8417", 
"J842", "J8481", "J8482", "J8483", "J84841", 
"J84842", "J84843", "J84848", "J8489", "J849", 
"J99", "M3213", "M3301", "M3311", "M3321", 
"M3391", "M3481", "M3502"};

// ---------------------------------------------------

static char OralCancerCodes[49][10] = {"C000", "C001", "C003", "C004", "C005", 
"C006", "C008", "C002", "C009", "C01", 
"C020", "C021", "C022", "C023", "C028",
"C024", "C029", "C030", "C031", 
"C039", "C040", "C041", "C048", "C049", 
"C099", "C098", "C090", "C091", "C100", 
"C101", "C108", "C102", "C103", "C104", 
"C109", "C140", "C142", "C148", "C060", 
"C061", "C050", "C051", "C052", "C059", 
"C058", "C062", "C0689", "C0680", "C069"};

static char SpeechLanguageCodes[30][10] = {"I69020", "I69021", "I69022", "I69023", "I69028", 
"I69120", "I69121", "I69122", "I69123", "I69128", 
"I69220", "I69221", "I69222", "I69223", "I69228", 
"I69320", "I69321", "I69322", "I69323", "I69328", 
"I69820", "I69821", "I69822", "I69823", "I69828", 
"I69920", "I69921", "I69922", "I69923", "I69928"};

static char ALSCodes[1][10] = {"G1221"};

static char ApraxiaCodes[6][10] = {"I69090", "I69190", "I69290", "I69390", "I69890", "I69990"};

static char DyspagiaCodes[6][10] = {"I69091", "I69191", "I69291", "I69391", "I69891", "I69991"};

static char LaryngealCancerCodes[6][10] = {"C320", "C321", "C322", "C323", "C328", "C329"};

#ifdef SOLARIS

	int mdsgrouper( char* pdpmRecord, char* HIPPSCode,  int* errorcode, char* HIPPSVersionCode );  
//	int mdsgrouper_XML( char* sXMLRecord, char* HIPPSCode,  int* errorcode, char* HIPPSVersionCode ); 
//   int mdsgrouper_XML_FILE( char* sXMLFile, char* HIPPSCode,  int* errorcode, char* HIPPSVersionCode );    

#else

extern "C" __declspec(dllexport) 

		int __stdcall mdsgrouper( char* pdpmRecord, char* HIPPSCode,  int* errorcode, char* HIPPSVersionCode );
	//	int __stdcall mdsgrouper_XML( char* sXMLRecord, char* HIPPSCode,  int* errorcode, char* HIPPSVersionCode ); 
	//	int __stdcall mdsgrouper_XML_FILE( char* sXMLFile, char* HIPPSCode,  int* errorcode, char* HIPPSVersionCode );

#endif

static char HIPPSCodeGenerated[6];

// #endif


/*
 static char pdpmXMLRecord[3691];

struct PDPMXMLItem {
	   char name[9];
	   int loc;
	   int len;
};


static PDPMXMLItem items[154] = {{"A0310B", 272, 2 },
		{"B0100", 511, 1 },
		{"B0700", 515, 1 },
		{"C0100", 519, 1 },
		{"C0500", 527, 2 },
		{"C0700", 530, 1 },
		{"C1000", 537, 1 },
		{"D0300", 562, 2 },
		{"D0600", 585, 2 },
		{"E0100A", 588, 1 },
		{"E0100B", 589, 1 },
		{"E0200A", 591, 1 },
		{"E0200B", 592, 1 },
		{"E0200C", 593, 1 },
		{"E0800", 601, 1 },
		{"E0900", 602, 1 },
		{"H0100C", 684, 1 },
		{"H0100D", 685, 1 },
		{"H0200C", 689, 1 },
		{"H0500", 692, 1 },
		{"I1300", 705, 1 },
		{"I1700", 710, 1 },
		{"I2000", 711, 1 },
		{"I2100", 712, 1 },
		{"I2500", 716, 1 },
		{"I2900", 717, 1 },
		{"I4300", 727, 1 },
		{"I4400", 728, 1 },
		{"I4500", 729, 1 },
		{"I4900", 731, 1 },
		{"I5100", 733, 1 },
		{"I5200", 734, 1 },
		{"I5300", 736, 1 },
		{"I5500", 739, 1 },
		{"I5600", 740, 1 },
		{"I6200", 747, 1 },
		{"I6300", 748, 1 },
		{"I8000A", 751, 8 },
		{"I8000B", 759, 8 },
		{"I8000C", 767, 8 },
		{"I8000D", 775, 8 },
		{"I8000E", 783, 8 },
		{"I8000F", 791, 8 },
		{"I8000G", 799, 8 },
		{"I8000H", 807, 8 },
		{"I8000I", 815, 8 },
		{"I8000J", 823, 8 },
		{"J1100C", 851, 1 },
		{"J1550A", 855, 1 },
		{"J1550B", 856, 1 },
		{"K0100A", 867, 1 },
		{"K0100B", 868, 1 },
		{"K0100C", 869, 1 },
		{"K0100D", 870, 1 },
		{"K0300", 877, 1 },
		{"M0300B1", 900, 1 },
		{"M0300C1", 910, 1 },
		{"M0300D1", 912, 1 },
		{"M0300F1", 916, 1 },
		{"M1030", 940, 1 },
		{"M1040A", 941, 1 },
		{"M1040B", 942, 1 },
		{"M1040C", 943, 1 },
		{"M1040D", 944, 1 },
		{"M1040E", 945, 1 },
		{"M1040F", 946, 1 },
		{"M1200A", 948, 1 },
		{"M1200B", 949, 1 },
		{"M1200C", 950, 1 },
		{"M1200D", 951, 1 },
		{"M1200E", 952, 1 },
		{"M1200F", 953, 1 },
		{"M1200G", 954, 1 },
		{"M1200H", 955, 1 },
		{"M1200I", 956, 1 },
		{"N0350A", 959, 1 },
		{"N0350B", 960, 1 },
		{"O0100A2", 970, 1 },
		{"O0100B2", 972, 1 },
		{"O0100C2", 974, 1 },
		{"O0100D2", 976, 1 },
		{"O0100E2", 978, 1 },
		{"O0100F2", 980, 1 },
		{"O0100H2", 984, 1 },
		{"O0100I2", 986, 1 },
		{"O0100J2", 988, 1 },
		{"O0100M2", 993, 1 },
		{"O0400D2", 1099, 1 },
		{"O0500A", 1110, 1 },
		{"O0500B", 1111, 1 },
		{"O0500C", 1112, 1 },
		{"O0500D", 1113, 1 },
		{"O0500E", 1114, 1 },
		{"O0500F", 1115, 1 },
		{"O0500G", 1116, 1 },
		{"O0500H", 1117, 1 },
		{"O0500I", 1118, 1 },
		{"O0500J", 1119, 1 },
		{"K0510A1", 1444, 1 },
		{"K0510A2", 1445, 1 },
		{"K0510B1", 1446, 1 },
		{"K0510B2", 1447, 1 },
		{"K0510C2", 1449, 1 },
		{"K0710A2", 1467, 1 },
		{"K0710A3", 1468, 1 },
		{"K0710B2", 1470, 1 },
		{"K0710B3", 1471, 1 },
		{"GG0130A1", 1498, 2 },
		{"GG0130A5", 1704, 2 },
		{"GG0130B1", 1504, 2 },
		{"GG0130B5", 1706, 2 },
		{"GG0130C1", 1510, 2 },
		{"GG0130C5", 1708, 2 },
		{"GG0170B1", 1516, 2 },
		{"GG0170B5", 1710, 2 },
		{"GG0170C1", 1522, 2 },
		{"GG0170C5", 1712, 2 },
		{"GG0170D1", 1528, 2 },
		{"GG0170D5", 1714, 2 },
		{"GG0170E1", 1534, 2 },
		{"GG0170E5", 1716, 2 },
		{"GG0170F1", 1540, 2 },
		{"GG0170F5", 1718, 2 },
		{"GG0170I1", 1651, 2 },
		{"GG0170I5", 1720, 2 },
		{"GG0170J1", 1548, 2 },
		{"GG0170J5", 1722, 2 },
		{"GG0170K1", 1554, 2 },
		{"GG0170K5", 1724, 2 },
		{"I0020B", 1726, 8 },
		{"J2100", 1734, 1 },
		{"J2300", 1735, 1 },
		{"J2310", 1736, 1 },
		{"J2320", 1737, 1 },
		{"J2330", 1738, 1 },
		{"J2400", 1739, 1 },
		{"J2410", 1740, 1 },
		{"J2420", 1741, 1 },
		{"J2500", 1743, 1 },
		{"J2510", 1744, 1 },
		{"J2520", 1745, 1 },
		{"J2530", 1746, 1 },
		{"J2600", 1748, 1 },
		{"J2610", 1749, 1 },
		{"J2620", 1750, 1 },
		{"J2700", 1752, 1 },
		{"J2710", 1753, 1 },
		{"J2800", 1755, 1 },
		{"J2810", 1756, 1 },
		{"J2900", 1758, 1 },
		{"J2910", 1759, 1 },
		{"J2920", 1760, 1 },
		{"J2930", 1761, 1 },
		{"J2940", 1762, 1 }};

*/