
/*********************************************************************************\

PROGRAM:      		$/PUF/R2/Dev/SNF/1/BSA_SNF_Beneficiary_PUF_2008.sas

DESCRIPTION:  		To read csv format SNF PUF to SAS dataset
 	
INPUT FILES:   		2008_BSA_SNF_Beneficiary_PUF.csv

OUTPUT FILES:       BSA_SNF_Beneficiary_PUF_2008.sas7bdat

OTHER OUTPUT:		Contents, proc print and freq distribution

                       
\*********************************************************************************/
              
FOOTNOTE 'BSA_SNF_Beneficiary_PUF_2008.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
filename in "INSERT_INPUT_DIRECTORY_NAME\2008_BSA_SNF_Beneficiary_PUF.csv" ;  * <-- Place Input File Path Here *;

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;



*Formats Code : Formats will be included if the following is uncommented *;
/*
Proc format;

Value SEXF
	1 = 'MALE'
	2 = 'FEMALE'
;

Value AGEF
	1	= 'Under 65'
	2	= '65 - 69'
	3	= '70 - 74 '
	4	= '75 - 79 '
	5	= '80 - 84 '
	6	= '85 or Older'
;


Value ADMF
	1 =  '1'
	2 =  '2 or more'
	
;

Value RHBF
	0 = '0 days' 
	1 = '1 - 8 days'
	2 = '9 - 20 days'
	3 = '21 - 40 days'
	4 = '41 or more'
	
;

Value  RHBXSF
	0 = '0 days' 
	1 = '1 - 20 days' 
	2 = '21 or more'
;

run;

*/
 

data PUF.BSA_SNF_Beneficiary_PUF_2008(label='SNF BENEFICIARY PUBLIC USE FILE');

infile in dlm = ',' dsd missover truncover firstobs = 2;
 
  * Input Record *;
  input SNF_BENE_ID 			:$22.	
       	BENE_SEX_IDENT_CD 
		BENE_AGE_CAT_CD
		SNF_ADM_CD 
		SNF_RHB_CD                  
		SNF_RHBXS_CD                              
		SNF_PMT_AMT  				
		
  ;

  /* Uncomment following to apply formatted and coded value */  
   /*
BENE_SEX_IDENT_CD_codedvalue=BENE_SEX_IDENT_CD;
BENE_AGE_CAT_CD_codedvalue=BENE_AGE_CAT_CD;            
SNF_ADM_CD_codedvalue=SNF_ADM_CD;                  
SNF_RHB_CD_codedvalue=SNF_RHB_CD;                              
SNF_RHBXS_CD_codedvalue=SNF_RHBXS_CD ;

  */

  * Formats *;
 
*** Uncomment following to apply formats ;
/*
	format  
	BENE_SEX_IDENT_CD                  	SEXF.
    BENE_AGE_CAT_CD						AGEF.
   	SNF_ADM_CD		 				   	ADMF.
    SNF_RHB_CD	                     	RHBF.
	SNF_RHBXS_CD	 					RHBXSF.
	;
*/

   * Labels *;
  label SNF_BENE_ID							= "Encrypted PUF ID"
		BENE_SEX_IDENT_CD					= "Beneficiary gender code "
		BENE_AGE_CAT_CD						= "Beneficiary age category code "
		SNF_ADM_CD 							= "Number of covered admissions"
		SNF_RHB_CD                   		= "Number of days of Rehabilitation Services covered by the Medicare Program"
		SNF_RHBXS_CD                        = "Number of days of Rehabilitation plus Extensive Services covered by the Medicare program"   
		SNF_PMT_AMT   						= "Medicare payment amount"
                 
;
   
run;

*** Uncomment following to apply formatted and coded values ;

/*
data PUF.BSA_SNF_Beneficiary_PUF_2008;
retain 	SNF_BENE_ID BENE_SEX_IDENT_CD BENE_SEX_IDENT_CD_codedvalue BENE_AGE_CAT_CD BENE_AGE_CAT_CD_codedvalue SNF_ADM_CD SNF_ADM_CD_codedvalue 
SNF_RHB_CD SNF_RHB_CD_codedvalue SNF_RHBXS_CD SNF_RHBXS_CD_codedvalue SNF_PMT_AMT;
set PUF.BSA_SNF_Beneficiary_PUF_2008;
label 	BENE_SEX_IDENT_CD_codedvalue					= "Beneficiary gender code "
		BENE_AGE_CAT_CD_codedvalue						= "Beneficiary age category code "
		SNF_ADM_CD 										= "Number of covered admissions"
		SNF_RHB_CD                   					= "Number of days of Rehabilitation Services covered by the Medicare Program"
		SNF_RHBXS_CD                        			= "Number of days of Rehabilitation plus Extensive Services covered by the Medicare program"   
		SNF_PMT_AMT   									= "Medicare payment amount"
		;

run;
*/


title 'SNF BENEFICIARY PUBLIC USE FILE';
proc contents data=PUF.BSA_SNF_Beneficiary_PUF_2008 varnum;
proc print data=PUF.BSA_SNF_Beneficiary_PUF_2008 (obs=10);
  title2 'Sample Listing - 10 Rows';
run;


proc freq data=PUF.BSA_SNF_Beneficiary_PUF_2008;
  title2 'Freqs';
  table BENE_SEX_IDENT_CD                       
		BENE_AGE_CAT_CD               
        SNF_ADM_CD 
		SNF_RHB_CD                  
		SNF_RHBXS_CD                              
		SNF_PMT_AMT /missing;
run;

* End of Program *;
