
/*********************************************************************************\

PROGRAM:      		Chronic_Conditions_PUF_2010.sas

DESCRIPTION:  		To read csv format Chronic Condition PUF to SAS dataset
 	
INPUT FILES:   		2010_Chronic_Conditions_PUF.csv

OUTPUT FILES:       Chronic_Conditions_PUF_2010.sas7bdat

OTHER OUTPUT:		Contents, proc print 

                       
\*********************************************************************************/
              
FOOTNOTE 'Chronic_Conditions_PUF_2010.sas';
* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

filename in "INSERT_INPUT_DIRECTORY_NAME\2010_Chronic_Conditions_PUF.csv" ;  * <-- Place Input File Path Here *;



* Output SAS Library *;

libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;

 
* Input File Reference *;


*Formats Code : Uncomment the following if want to include formats *;


Proc format;

Value SEXF
	1 = 'MALE '
	2 = 'FEMALE'
;

Value AGEF
	1	= 'Under  65 '
	2	= '65 - 69 '
	3	= '70 - 74 '
	4	= '75 - 79 '
	5	= '80 - 84 '
	6	= '85 and older'
	;
value CCF
 	1 = 'Yes'
	0 = 'No'
	;
value CC_2F
   1 = 'Yes'
   0 = 'No'
   ;
value DUALF
   1 = 'Yes'
   0 = 'No'
;
run;

data  PUF.Chronic_Conditions_PUF_2010;
infile in dlm=','   dsd missover truncover firstobs=2 ;

input   BENE_SEX_IDENT_CD 
		BENE_AGE_CAT_CD  
		CC_ALZHDMTA 
		CC_CANCER 
		CC_CHF
		CC_CHRNKIDN
		CC_COPD
		CC_DEPRESSN 
		CC_DIABETES
		CC_ISCHMCHT
		CC_OSTEOPRS
		CC_RA_OA
		CC_STRKETIA
		CC_2_OR_MORE 
		DUAL_STUS 
		BENE_COUNT_PA_LT_12
		AVE_MO_EN_PA_LT_12
		AVE_PA_PAY_PA_LT_12
		AVE_IP_PAY_PA_LT_12
		AVE_SNF_PAY_PA_LT_12 
		AVE_OTH_PAY_PA_LT_12  
		AVE_IP_ADM_PA_LT_12
		AVE_SNF_DAYS_PA_LT_12
		BENE_COUNT_PA_EQ_12
		AVE_PA_PAY_PA_EQ_12
		AVE_IP_PAY_PA_EQ_12
		AVE_SNF_PAY_PA_EQ_12
		AVE_OTH_PAY_PA_EQ_12
		AVE_IP_ADM_PA_EQ_12
		AVE_SNF_DAYS_PA_EQ_12
		BENE_COUNT_PB_LT_12
		AVE_MO_EN_PB_LT_12
		AVE_PB_PAY_PB_LT_12
		AVE_CA_PAY_PB_LT_12
		AVE_OP_PAY_PB_LT_12
		AVE_OTH_PAY_PB_LT_12
		AVE_CA_VST_PB_LT_12
		AVE_OP_VST_PB_LT_12
		BENE_COUNT_PB_EQ_12
		AVE_PB_PAY_PB_EQ_12
		AVE_CA_PAY_PB_EQ_12
		AVE_OP_PAY_PB_EQ_12
		AVE_OTH_PAY_PB_EQ_12
		AVE_CA_VST_PB_EQ_12
		AVE_OP_VST_PB_EQ_12 
		BENE_COUNT_PC_LT_12
		AVE_MO_EN_PC_LT_12
		BENE_COUNT_PC_EQ_12
		BENE_COUNT_PD_LT_12
		AVE_MO_EN_PD_LT_12
		AVE_PDE_CST_PD_LT_12
		AVE_PDE_PD_LT_12
		BENE_COUNT_PD_EQ_12
		AVE_PDE_CST_PD_EQ_12 
		AVE_PDE_PD_EQ_12
				
		;

 
  * Formats *;
 
*** Uncomment following to apply formats ;
/*	
format  
	BENE_SEX_IDENT_CD     SEXF.
    BENE_AGE_CAT_CD		  AGEF.
    CC_ALZHDMTA   		  CCF.
    CC_CANCER             CCF.
    CC_CHF   			  CCF.
	CC_CHRNKIDN			  CCF.	
	CC_COPD               CCF.
	CC_DEPRESSN           CCF.
	CC_DIABETES           CCF.
	CC_ISCHMCHT           CCF.
	CC_OSTEOPRS           CCF.
    CC_RA_OA              CCF.
	CC_STRKETIA           CCF.
	CC_2_OR_MORE          CC_2F.
	DUAL_STUS             DUALF.

		;	*/

 
  * Labels *;


   label  		BENE_SEX_IDENT_CD='Gender'
				BENE_AGE_CAT_CD='Age'
				CC_ALZHDMTA  = 'Alzheimer''s Disease and Related Disorders or Senile Dementia'
				CC_CANCER  = 'Cancer'
				CC_CHF = 'Heart Failure'
				CC_CHRNKIDN= 'Chronic Kidney Disease'
				CC_COPD= 'Chronic Obstructive Pulmonary Disease'
				CC_DEPRESSN = 'Depression'
				CC_DIABETES= 'Diabetes'
				CC_ISCHMCHT= 'Ischemic Heart Disease'
				CC_OSTEOPRS = 'Osteoporosis'
				CC_RA_OA = 'Rheumatoid Arthritis/Osteoarthritis Arthritis'
				CC_STRKETIA= 'Stroke/Transient Ischemic Attack'
				CC_2_OR_MORE = 'Multiple Chronic Conditions'
				DUAL_STUS = 'Dual Eligibility Status'

				BENE_COUNT_PA_LT_12 = 'Count of Beneficiaries (Part A < 12)' 
				AVE_MO_EN_PA_LT_12 = 'Average Months of Enrollment (Part A < 12)'
				AVE_PA_PAY_PA_LT_12= 'Average Medicare Payment for Part A per Beneficiary (Part A < 12)'
				AVE_IP_PAY_PA_LT_12 = 'Average Medicare Payment for IP per Beneficiary (Part A < 12)'
				AVE_SNF_PAY_PA_LT_12  = 'Average Medicare Payment for SNF per Beneficiary (Part A < 12)'
				AVE_OTH_PAY_PA_LT_12  ='Average Medicare Payment for other services per Beneficiary (Part A < 12)'
				AVE_IP_ADM_PA_LT_12 = 'Average IP Admissions per Beneficiary(Part A < 12)'
				AVE_SNF_DAYS_PA_LT_12 = 'Average SNF Covered Days per Beneficiary (Part A < 12)' 

				BENE_COUNT_PA_EQ_12 =  'Count of Beneficiaries (Part A = 12)'
				AVE_PA_PAY_PA_EQ_12 =  'Average Medicare Payment for Part A per Beneficiary (Part A = 12) '
				AVE_IP_PAY_PA_EQ_12 =  'Average Medicare Payment for IP per Beneficiary (Part A = 12)'
				AVE_SNF_PAY_PA_EQ_12 = 'Average Medicare Payment for SNF per beneficiary (Part A = 12) '
				AVE_OTH_PAY_PA_EQ_12 = 'Average Medicare Payment for other services per Beneficiary (Part A = 12) '
				AVE_IP_ADM_PA_EQ_12 =  'Average IP Admissions  per Beneficiary  (Part A = 12) '
				AVE_SNF_DAYS_PA_EQ_12 ='Average SNF Covered Days  per Beneficiary  (Part A = 12) '

				BENE_COUNT_PB_LT_12 = 'Count of Beneficiaries (Part B < 12) '
				AVE_MO_EN_PB_LT_12 =  'Average Months of Enrollment (Part B < 12) '
				AVE_PB_PAY_PB_LT_12=  'Average Medicare Payment for Part B per Beneficiary (Part B < 12)' 
				AVE_CA_PAY_PB_LT_12 = 'Average Medicare Payment for CA per Beneficiary (Part B < 12) '
				AVE_OP_PAY_PB_LT_12 = 'Average Medicare Payment for OP per Beneficiary (Part B < 12) '
				AVE_OTH_PAY_PB_LT_12= 'Average Medicare Payment for other services per Beneficiary (Part B < 12) '
				AVE_CA_VST_PB_LT_12 = 'Average CA Visits per Beneficiary (Part B < 12) '
				AVE_OP_VST_PB_LT_12 = 'Average OP Visits per Beneficiary  (Part B < 12) '

				BENE_COUNT_PB_EQ_12 = 'Count of Beneficiaries (Part B = 12) '
				AVE_PB_PAY_PB_EQ_12 = 'Average Medicare Payment for Part B per Beneficiary (Part B = 12) '
				AVE_CA_PAY_PB_EQ_12 = 'Average Medicare Payment for CA per Beneficiary (Part B = 12) '
				AVE_OP_PAY_PB_EQ_12 = 'Average Medicare Payment for OP per Beneficiary (Part B = 12) '
				AVE_OTH_PAY_PB_EQ_12= 'Average Medicare Payment for other services per Beneficiary (Part B = 12)'
				AVE_CA_VST_PB_EQ_12 = 'Average CA Visits per Beneficiary (Part B = 12) '
				AVE_OP_VST_PB_EQ_12 = 'Average OP Visits per Beneficiary  (Part B = 12) '
				
				BENE_COUNT_PC_LT_12 = 'Count of Beneficiaries (Part C < 12) '
				AVE_MO_EN_PC_LT_12 = 'Average Months of Enrollment (Part C < 12) '
				BENE_COUNT_PC_EQ_12 = 'Count of Beneficiaries (Part C = 12) '

				BENE_COUNT_PD_LT_12 = 'Count of Beneficiaries (Part D < 12) '
				AVE_MO_EN_PD_LT_12 = 'Average Months of Enrollment (Part D < 12) '
				AVE_PDE_CST_PD_LT_12 = 'Average Drug Cost per Beneficiary (Part D < 12) '
				AVE_PDE_PD_LT_12 = 'Average Prescriptions per  Beneficiary (Part D < 12) '

				BENE_COUNT_PD_EQ_12 = 'Count of Beneficiaries (Part D = 12) '
				AVE_PDE_CST_PD_EQ_12  = 'Average Drug Cost per Beneficiary (Part D = 12) '
				AVE_PDE_PD_EQ_12 = 'Average Prescriptions per Beneficiary (Part D = 12) '
				;
	
 
  
run;

 
title 'CHRONIC CONDITIONS PUBLIC USE FILE';
proc contents data=PUF.Chronic_Conditions_PUF_2010 varnum;
proc print data=PUF.Chronic_Conditions_PUF_2010 (obs=10);
title2 'Sample Listing - 10 Rows';
run;


 
* End of Program *;
