*pbp_b6.sas;

libname out '.\sas_data_sets\PBP';
options pageno=1 linesize = 200 nocenter;

data pbp_b6;

length
	pbp_a_hnumber                    $5
	pbp_a_plan_identifier            $3
	pbp_a_ben_cov                    $1
	pbp_a_plan_type                  $2
	orgtype                          $2
	bid_id                           $13
	pbp_b6_maxenr_yn                 $1
	pbp_b6_maxenr_per                $1
	pbp_b6_coins_yn                  $1
	pbp_b6_ded_yn                    $1
	pbp_b6_copay_yn                  $1
	pbp_b6_auth_yn                   $1
	pbp_b6_refer_yn                  $1
	pbp_b6_mm_limit_yn               $1
	pbp_b6_mm_nmc_yn                 $1
	pbp_b6_mm_limit_services         $4
	pbp_b6_mm_services               $4
	pbp_b6_mm_addl_service_other1    $144
	pbp_b6_mm_addl_service_other2    $144
	pbp_b6_mm_maxplan_yn             $1
	pbp_b6_mm_maxplan_per            $1
	pbp_b6_mm_limit_unit_type_ahc    $1
	pbp_b6_mm_limit_unit_per_ahc     $1
	pbp_b6_mm_limit_unit_type_pc     $1
	pbp_b6_mm_limit_unit_per_pc      $1
	pbp_b6_mm_limit_unit_type_oth1   $1
	pbp_b6_mm_limit_unit_per_oth1    $1
	pbp_b6_mm_limit_unit_type_oth2   $1
	pbp_b6_mm_limit_unit_per_oth2    $1
	pbp_b6_mm_coins_yn               $1
	pbp_b6_mm_coins_services         $4
	pbp_b6_mm_copay_yn               $1
	pbp_b6_mm_copay_services         $4
	pbp_b6_mmp_waiver_yn             $1
	pbp_b6_mmp_waiver_srvc           $4
	pbp_b6_mm_auth_yn                $1
	pbp_b6_mm_refer_yn               $1
;

infile '.\pbp\pbp_b6_home_health.txt' delimiter = '09'x
dsd lrecl = 30000 firstobs=2 missover;


input
	pbp_a_hnumber
	pbp_a_plan_identifier
	segment_id
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	bid_id
	version
	pbp_b6_maxenr_yn
	pbp_b6_maxenr_amt
	pbp_b6_maxenr_per
	pbp_b6_coins_yn
	pbp_b6_coins_pct_mc_min
	pbp_b6_coins_pct_mc_max
	pbp_b6_ded_yn
	pbp_b6_ded_amt
	pbp_b6_copay_yn
	pbp_b6_copay_mc_amt_min
	pbp_b6_copay_mc_amt_max
	pbp_b6_auth_yn
	pbp_b6_refer_yn
	pbp_b6_mm_limit_yn
	pbp_b6_mm_nmc_yn
	pbp_b6_mm_limit_services
	pbp_b6_mm_services
	pbp_b6_mm_addl_service_other1
	pbp_b6_mm_addl_service_other2
	pbp_b6_mm_maxplan_yn
	pbp_b6_mm_maxplan_amt
	pbp_b6_mm_maxplan_per
	pbp_b6_mm_limit_unit_type_ahc
	pbp_b6_mm_limit_unit_num_ahc
	pbp_b6_mm_limit_unit_per_ahc
	pbp_b6_mm_limit_unit_type_pc
	pbp_b6_mm_limit_unit_num_pc
	pbp_b6_mm_limit_unit_per_pc
	pbp_b6_mm_limit_unit_type_oth1
	pbp_b6_mm_limit_unit_num_oth1
	pbp_b6_mm_limit_unit_per_oth1
	pbp_b6_mm_limit_unit_type_oth2
	pbp_b6_mm_limit_unit_num_oth2
	pbp_b6_mm_limit_unit_per_oth2
	pbp_b6_mm_coins_yn
	pbp_b6_mm_coins_services
	pbp_b6_mm_coins_addl_min
	pbp_b6_mm_coins_addl_max
	pbp_b6_mm_coins_pcs_min
	pbp_b6_mm_coins_pcs_max
	pbp_b6_mm_coins_other1_min
	pbp_b6_mm_coins_other1_max
	pbp_b6_mm_coins_other2_min
	pbp_b6_mm_coins_other2_max
	pbp_b6_mm_copay_yn
	pbp_b6_mm_copay_services
	pbp_b6_mm_copay_addl_min
	pbp_b6_mm_copay_addl_max
	pbp_b6_mm_copay_pcs_min
	pbp_b6_mm_copay_pcs_max
	pbp_b6_mm_copay_other1_min
	pbp_b6_mm_copay_other1_max
	pbp_b6_mm_copay_other2_min
	pbp_b6_mm_copay_other2_max
	pbp_b6_mmp_waiver_yn
	pbp_b6_mmp_waiver_srvc
	pbp_b6_mm_auth_yn
	pbp_b6_mm_refer_yn
;


label
	pbp_a_hnumber                    = 'H Number'
	pbp_a_plan_identifier            = 'Plan ID'
	segment_id                       = 'Segment ID'
	pbp_a_ben_cov                    = 'Coverage Criteria'
	pbp_a_plan_type                  = 'Plan Type'
	orgtype                          = 'Organization Type'
	bid_id                           = 'Bid ID'
	version                          = 'Version Number'
	pbp_b6_maxenr_yn                 = 'Home Health Max Enr YN'
	pbp_b6_maxenr_amt                = 'Home Health Max Enr Amt'
	pbp_b6_maxenr_per                = 'Home Health Max Enr Per'
	pbp_b6_coins_yn                  = 'Home Health Coinsurance YN'
	pbp_b6_coins_pct_mc_min          = 'Home Health MC Min Coins Pct'
	pbp_b6_coins_pct_mc_max          = 'Home Health MC Max Coins Pct'
	pbp_b6_ded_yn                    = 'Home Health Deductible YN'
	pbp_b6_ded_amt                   = 'Home Health Deductible Amt'
	pbp_b6_copay_yn                  = 'Home Health Copayment YN'
	pbp_b6_copay_mc_amt_min          = 'Home Health MC Min Copay Amt'
	pbp_b6_copay_mc_amt_max          = 'Home Health MC Max Copay Amt'
	pbp_b6_auth_yn                   = 'Home Health Enrollee Auth'
	pbp_b6_refer_yn                  = 'Home Health Referral YN'
	pbp_b6_mm_limit_yn               = 'Home Health Limit YN'
	pbp_b6_mm_nmc_yn                 = 'Home Health Non-Medicare YN'
	pbp_b6_mm_limit_services         = 'HH MMP Limit Srvsc'
	pbp_b6_mm_services               = 'Home Health Non-Medicare Sel'
	pbp_b6_mm_addl_service_other1    = 'Other 1 Service Name'
	pbp_b6_mm_addl_service_other2    = 'Other 2 Service Name'
	pbp_b6_mm_maxplan_yn             = 'Home Health Max Plan YN'
	pbp_b6_mm_maxplan_amt            = 'Home Health Max Plan Amt'
	pbp_b6_mm_maxplan_per            = 'Home Health Max Plan Per'
	pbp_b6_mm_limit_unit_type_ahc    = 'HH AHC Unit Type'
	pbp_b6_mm_limit_unit_num_ahc     = 'HH AHC Unit Num'
	pbp_b6_mm_limit_unit_per_ahc     = 'HH AHC Unit Per'
	pbp_b6_mm_limit_unit_type_pc     = 'HH PC Unit Type'
	pbp_b6_mm_limit_unit_num_pc      = 'HH PC Unit Num'
	pbp_b6_mm_limit_unit_per_pc      = 'HH PC Unit Per'
	pbp_b6_mm_limit_unit_type_oth1   = 'HH OTH1 Unit Type'
	pbp_b6_mm_limit_unit_num_oth1    = 'HH OTH1 Unit Num'
	pbp_b6_mm_limit_unit_per_oth1    = 'HH OTH1 Unit Per'
	pbp_b6_mm_limit_unit_type_oth2   = 'HH OTH2 Unit Type'
	pbp_b6_mm_limit_unit_num_oth2    = 'HH OTH2 Unit Num'
	pbp_b6_mm_limit_unit_per_oth2    = 'HH OTH2 Unit Per'
	pbp_b6_mm_coins_yn               = 'Home Health Coinsurance YN'
	pbp_b6_mm_coins_services         = 'Home Health Non-Medicare Sel'
	pbp_b6_mm_coins_addl_min         = 'Indicate minimum Coinsurance'
	pbp_b6_mm_coins_addl_max         = 'Indicate maximum Coinsurance'
	pbp_b6_mm_coins_pcs_min          = 'Indicate minimum Coinsurance'
	pbp_b6_mm_coins_pcs_max          = 'Indicate maximum Coinsurance'
	pbp_b6_mm_coins_other1_min       = 'Indicate minimum Coinsurance'
	pbp_b6_mm_coins_other1_max       = 'Indicate maximum Coinsurance'
	pbp_b6_mm_coins_other2_min       = 'Indicate minimum Coinsurance'
	pbp_b6_mm_coins_other2_max       = 'Indicate maximum Coinsurance'
	pbp_b6_mm_copay_yn               = 'Home Health Coinsurance YN'
	pbp_b6_mm_copay_services         = 'Home Health Non-Medicare Sel'
	pbp_b6_mm_copay_addl_min         = 'Indicate minimum Coinsurance'
	pbp_b6_mm_copay_addl_max         = 'Indicate maximum Coinsurance'
	pbp_b6_mm_copay_pcs_min          = 'Indicate minimum Coinsurance'
	pbp_b6_mm_copay_pcs_max          = 'Indicate maximum Coinsurance'
	pbp_b6_mm_copay_other1_min       = 'Indicate minimum Coinsurance'
	pbp_b6_mm_copay_other1_max       = 'Indicate maximum Coinsurance'
	pbp_b6_mm_copay_other2_min       = 'Indicate minimum Coinsurance'
	pbp_b6_mm_copay_other2_max       = 'Indicate maximum Coinsurance'
	pbp_b6_mmp_waiver_yn             = 'B6 Waiver'
	pbp_b6_mmp_waiver_srvc           = 'waiver picklist'
	pbp_b6_mm_auth_yn                = 'Home Health Enrollee Auth'
	pbp_b6_mm_refer_yn               = 'Home Health Referral YN'
;

run;

proc sort data = pbp_b6 out=out.pbp_b6;
  by Pbp_a_hnumber pbp_a_plan_identifier segment_id;
run;

proc print data = out.pbp_b6(obs = 10);
  title 'pbp_b6_home_health file ';
run;

proc means data = out.pbp_b6;
  title 'pbp_b6_home_health file ';
run;

proc freq data = out.pbp_b6;
table
	pbp_a_ben_cov
	pbp_a_plan_type
	orgtype
	pbp_b6_maxenr_yn
	pbp_b6_maxenr_per
	pbp_b6_coins_yn
	pbp_b6_ded_yn
	pbp_b6_copay_yn
	pbp_b6_auth_yn
	pbp_b6_refer_yn
	pbp_b6_mm_limit_yn
	pbp_b6_mm_nmc_yn
	pbp_b6_mm_limit_services
	pbp_b6_mm_services
	pbp_b6_mm_maxplan_yn
	pbp_b6_mm_maxplan_per
	pbp_b6_mm_limit_unit_type_ahc
	pbp_b6_mm_limit_unit_per_ahc
	pbp_b6_mm_limit_unit_type_pc
	pbp_b6_mm_limit_unit_per_pc
	pbp_b6_mm_limit_unit_type_oth1
	pbp_b6_mm_limit_unit_per_oth1
	pbp_b6_mm_limit_unit_type_oth2
	pbp_b6_mm_limit_unit_per_oth2
	pbp_b6_mm_coins_yn
	pbp_b6_mm_coins_services
	pbp_b6_mm_copay_yn
	pbp_b6_mm_copay_services
	pbp_b6_mmp_waiver_yn
	pbp_b6_mmp_waiver_srvc
	pbp_b6_mm_auth_yn
	pbp_b6_mm_refer_yn
/ missing;
run;

proc contents data = out.pbp_b6;
  title 'pbp_b6 data';
run;