/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.logic.processor;

import com.mmm.cms.hh.pdgm.claim.ClaimElementCollectionIF;
import com.mmm.cms.hh.pdgm.claim.ClaimIF;
import com.mmm.cms.hh.pdgm.claim.OasisResponseIF;
import com.mmm.cms.hh.pdgm.claim.ReturnCode;
import com.mmm.cms.hh.pdgm.data.files.TableNames_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditId_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditType_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.Oasis_EN;
import com.mmm.cms.hh.pdgm.diagnosis.ClinicalGroup;
import com.mmm.cms.hh.pdgm.diagnosis.ComorbidityGroup;
import com.mmm.cms.hh.pdgm.diagnosis.Diagnosis;
import com.mmm.cms.hh.pdgm.diagnosis.DiagnosisIF;
import com.mmm.cms.hh.pdgm.diagnosis.DiagnosisSubchapter;
import com.mmm.cms.hh.pdgm.grouper.DataManagerIF;
import com.mmm.cms.hh.pdgm.grouper.utility.Utility;
import com.mmm.cms.hh.pdgm.logic.specification.IsValidOasisResponse;
import com.mmm.cms.hh.pdgm.logic.validation.Edit;
import com.mmm.cms.hh.pdgm.logic.validation.EditIF;
import com.mmm.cms.hh.pdgm.reference.objects.ClinicalGroupObject;
import com.mmm.cms.hh.pdgm.reference.objects.ComorbidityGroupObject;
import com.mmm.cms.hh.pdgm.reference.objects.DiagnosisObject;
import com.mmm.cms.hh.pdgm.reference.objects.DiagnosisSubchapterObject;
import com.mmm.cms.hh.pdgm.reference.objects.HippsValueObject;
import com.mmm.cms.hh.pdgm.reference.objects.OasisRespondObject;
import com.mmm.cms.hh.pdgm.reference.objects.ReturnCodeObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HippsPositionAbstract {
    private ClaimIF claim;
    private DataManagerIF dataManager;

    protected DiagnosisIF findDxByComorbidity(List<DiagnosisIF> dxList, String name) {
        if (dxList == null || dxList.isEmpty() || name == null || name.isEmpty()) {
            return null;
        }
        for (DiagnosisIF dx : dxList) {
            if (dx.getEditCollection().hasEditId(EditId_EN.VALUE_INVALID) || !dx.getComorbidityGroup().getName().trim().equalsIgnoreCase(name.trim())) continue;
            return dx;
        }
        return null;
    }

    protected void addHippsLogicMessage(EditId_EN hippsPosition, String text) {
        Edit edit = new Edit(hippsPosition, text, EditType_EN.SPECIFICATION, Level.INFO);
        this.getClaim().getHippsCode().addEdit(edit);
    }

    protected boolean validateFunctionalFields() {
        boolean valOther;
        boolean valHospRisk = this.validateRiskHospitalisation();
        if (!valHospRisk) {
            this.addReturnCode(Oasis_EN.M1033_HOSP_RISK_HSTRY_FALLS.getErrorReturnCode());
        }
        if (!(valHospRisk & (valOther = this.validateOtherFunctionalFields()))) {
            this.claim.getOasisFields().addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, "OASIS has invalid or inconsistent value(s). " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
        }
        return valHospRisk & valOther;
    }

    private String getValidValues(OasisResponseIF oResp, List<OasisRespondObject> refList) {
        ArrayList<String> validList = new ArrayList<String>();
        for (OasisRespondObject oasRespRef : refList) {
            if (!oResp.getType().name().startsWith(oasRespRef.getFieldId().trim().toUpperCase())) continue;
            validList.add(oasRespRef.getResponse());
        }
        return Utility.join(validList);
    }

    private boolean validateFunctionalField(OasisResponseIF oResp, List<OasisRespondObject> refList) {
        IsValidOasisResponse actualResp = new IsValidOasisResponse(oResp);
        for (OasisRespondObject oasRespRef : refList) {
            if (!actualResp.isSatisfiedBy(oasRespRef)) continue;
            oResp.setScore(Integer.parseInt(oasRespRef.getCategoryPoints()));
            return true;
        }
        return false;
    }

    private boolean validateOtherFunctionalFields() {
        boolean retFlag = true;
        String PREFIX_NOT = "M1033";
        List<OasisRespondObject> refList = this.dataManager.getDataMap().get(TableNames_EN.OASIS_Responses).getData();
        ClaimElementCollectionIF<OasisResponseIF> oResList = this.claim.getOasisFields();
        for (OasisResponseIF oResp : oResList) {
            if (oResp.getType().name().startsWith("M1033") || this.validateFunctionalField(oResp, refList)) continue;
            oResp.addEdit(new Edit(EditId_EN.VALUE_INVALID, oResp.toString() + ". Valid values=[" + this.getValidValues(oResp, refList) + "]", EditType_EN.CONSISTENCY, Level.SEVERE));
            this.addReturnCode(oResp.getType().getErrorReturnCode());
            retFlag = false;
        }
        return retFlag;
    }

    private boolean validateRiskHospitalisation() {
        boolean retFlag = true;
        String PREFIX = "M1033";
        List<String> VALID_VALUES = Arrays.asList("0", "1");
        int sum = 0;
        int noneAbove = 0;
        ClaimElementCollectionIF<OasisResponseIF> oResList = this.claim.getOasisFields();
        for (OasisResponseIF oResp : oResList) {
            if (!oResp.getType().name().startsWith("M1033")) continue;
            if (!VALID_VALUES.contains(oResp.getValue())) {
                oResp.addEdit(new Edit(EditId_EN.VALUE_INVALID, oResp.toString() + ". Valid values=[" + Utility.join(VALID_VALUES) + "]", EditType_EN.CONSISTENCY, Level.SEVERE));
                retFlag &= false;
                continue;
            }
            int val = Integer.parseInt(oResp.getValue());
            sum += val;
            if (oResp.getType().name().equals(Oasis_EN.M1033_HOSP_RISK_NONE_ABOVE.name())) {
                noneAbove = val;
            }
            if (!oResp.getType().name().equals(Oasis_EN.M1033_HOSP_RISK_CRNT_EXHSTN.name()) && !oResp.getType().name().equals(Oasis_EN.M1033_HOSP_RISK_OTHR_RISK.name())) continue;
            oResp.addEdit(new Edit(EditId_EN.VALUE_IGNORE, oResp.toString() + " " + EditId_EN.VALUE_IGNORE.getDescription(), EditType_EN.SPECIFICATION, Level.INFO));
        }
        if (noneAbove > 0 && sum - noneAbove > 0) {
            this.claim.getOasisFields().addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, "If M1033_HOSP_RISK_NONE_ABOVE = 1, then all items from M1033_HOSP_RISK_HSTRY_FALLS through M1033_HOSP_RISK_OTHR_RISK must = 0. " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
            retFlag &= false;
        }
        if (sum == 0) {
            this.claim.getOasisFields().addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, "If M1033_HOSP_RISK_NONE_ABOVE = 0, then at least one item from M1033_HOSP_RISK_HSTRY_FALLS through M1033_HOSP_RISK_OTHR_RISK must = 1. " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
            retFlag &= false;
        }
        return retFlag;
    }

    protected void validateDiagnoses() {
        try {
            DiagnosisIF pdx = this.validateDiagnosis(this.claim.getPrimaryDiagnosis());
            if (!pdx.getEditCollection().hasEditId(EditId_EN.VALUE_INVALID)) {
                this.claim.setPrimaryDiagnosis(pdx);
            } else {
                List<EditIF> editList = pdx.getEditCollection().getEditId(EditId_EN.VALUE_INVALID);
                if (editList != null && !editList.isEmpty()) {
                    editList.get(0).setServerityLevel(Level.SEVERE);
                }
            }
            ClaimElementCollectionIF<DiagnosisIF> sdxList = this.claim.getSecondaryDiagnoses();
            for (int i = 0; i < sdxList.size(); ++i) {
                DiagnosisIF diag = (DiagnosisIF)sdxList.get(i);
                DiagnosisIF dxF = this.validateDiagnosis(diag);
                if (dxF.getEditCollection().hasEditId(EditId_EN.VALUE_INVALID)) continue;
                sdxList.set(i, dxF);
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(HippsPositionAbstract.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private DiagnosisIF validateDiagnosis(DiagnosisIF dx) throws ParseException {
        DiagnosisIF dxRef = null;
        dxRef = this.getDiagnosisReference(dx.getValue());
        if (dxRef == null) {
            dx.addEdit(new Edit(EditId_EN.VALUE_INVALID, dx.toString() + EditId_EN.VALUE_INVALID.getDescription(), EditType_EN.CONSISTENCY, Level.WARNING));
            dxRef = dx;
        } else {
            dxRef.addEdit(new Edit(EditId_EN.VALUE_VALID, dxRef.toString() + EditId_EN.VALUE_VALID.getDescription(), EditType_EN.INFO, Level.INFO));
        }
        dxRef.setVerified(true);
        return dxRef;
    }

    private DiagnosisIF getDiagnosisReference(String value) throws ParseException {
        Diagnosis dx = null;
        DiagnosisObject dxObj = (DiagnosisObject)this.dataManager.getDataMap().get(TableNames_EN.Diagnoses).getDataMap().get(value);
        if (dxObj == null) {
            return null;
        }
        ClinicalGroupObject clinicalGroupObj = (ClinicalGroupObject)this.dataManager.getDataMap().get(TableNames_EN.Clinical_Groups).getDataMap().get(dxObj.getClinicalGroup());
        ClinicalGroup clinicalGroup = null;
        if (clinicalGroupObj != null) {
            clinicalGroup = new ClinicalGroup(0, clinicalGroupObj);
        }
        ComorbidityGroupObject comorbidityGroupObj = (ComorbidityGroupObject)this.dataManager.getDataMap().get(TableNames_EN.Comorbidity_Groups).getDataMap().get(dxObj.getComorbidityGroup());
        ComorbidityGroup comorbidityGroup = null;
        if (comorbidityGroupObj != null) {
            comorbidityGroup = new ComorbidityGroup(0, comorbidityGroupObj);
        }
        List diagSubchapObjList = this.dataManager.getDataMap().get(TableNames_EN.Diagnosis_Subchapters).getData();
        DiagnosisSubchapter diagnosisSubchapter = null;
        for (DiagnosisSubchapterObject diagSubchapObj : diagSubchapObjList) {
            String key = diagSubchapObj.getDiagnosisFrom() + "-" + diagSubchapObj.getDiagnosisTo();
            if (!key.trim().equalsIgnoreCase(dxObj.getSubChapter().trim())) continue;
            diagnosisSubchapter = new DiagnosisSubchapter(diagSubchapObj);
            break;
        }
        dx = new Diagnosis(0, dxObj, clinicalGroup, comorbidityGroup, diagnosisSubchapter);
        return dx;
    }

    public boolean setHippsCode(int position, String value) {
        HippsValueObject hipps = this.getHippsValueReference(position, value);
        if (hipps != null) {
            this.getClaim().getHippsCode().setValue(hipps);
            return true;
        }
        Edit edit = new Edit(EditId_EN.VALUE_NOT_CALCULATED, "Not able to calculeate HIPPS value in position: " + position, EditType_EN.INFO, Level.SEVERE);
        this.getClaim().getHippsCode().addEdit(edit);
        return false;
    }

    private HippsValueObject getHippsValueReference(int position, String value) {
        for (Object obj : this.dataManager.getDataMap().get(TableNames_EN.HIPPS_Structure).getData()) {
            if (!((HippsValueObject)obj).getPosition().equals("" + position) || !((HippsValueObject)obj).getValue().equalsIgnoreCase(value)) continue;
            return (HippsValueObject)obj;
        }
        return null;
    }

    public boolean addReturnCode(int code) {
        if (this.getClaim().hasReturnCode(code)) {
            return false;
        }
        ReturnCodeObject grcObj = this.getReturnCodeReference(code);
        if (grcObj != null) {
            ReturnCode grc = null;
            try {
                grc = new ReturnCode(grcObj);
            }
            catch (ParseException ex) {
                Logger.getLogger(HippsPositionAbstract.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!this.getClaim().getReturnCodes().contains(grc)) {
                this.getClaim().getReturnCodes().add(grc);
            }
            return true;
        }
        Edit edit = new Edit(EditId_EN.VALUE_INVALID, "Not able to set Return Code: " + code, EditType_EN.INFO, Level.SEVERE);
        this.getClaim().getReturnCodes().addEdit(edit);
        return false;
    }

    private ReturnCodeObject getReturnCodeReference(int code) {
        for (Object obj : this.dataManager.getDataMap().get(TableNames_EN.Return_Codes).getData()) {
            if (Integer.parseInt(((ReturnCodeObject)obj).getCode()) != code) continue;
            return (ReturnCodeObject)obj;
        }
        return null;
    }

    public HippsPositionAbstract(ClaimIF claim, DataManagerIF dataManager) {
        this.claim = claim;
        this.dataManager = dataManager;
    }

    public ClaimIF getClaim() {
        return this.claim;
    }

    public void setClaim(ClaimIF claim) {
        this.claim = claim;
    }

    public DataManagerIF getDataManager() {
        return this.dataManager;
    }

    public void setDataManager(DataManagerIF dataManager) {
        this.dataManager = dataManager;
    }
}

