/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.logic.validation.EditCollectionIF;
import com.mmm.cms.hh.pdgm.logic.validation.EditIF;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author US340646
 * @param <T>
 */
public class ClaimElementCollection<T> extends ArrayList<T> implements ClaimElementCollectionIF<T> {

    private static final long serialVersionUID = 1L;
    
    private final ClaimElementBase claimElement;

    /**
     * Constructor
     */
    public ClaimElementCollection() {
        this.claimElement = new ClaimElementBase();
    }

    /**
     *
     * @param edits
     */
    @Override
    public void addEdits(List<EditIF> edits) {
        claimElement.addEdits(edits);
    }

    /**
     *
     * @return
     */
    @Override
    public EditCollectionIF getEditCollection() {
        return claimElement.getEditCollection();
    }

    /**
     *
     * @param edit
     */
    @Override
    public void addEdit(EditIF edit) {
        claimElement.addEdit(edit);
    }
}
