/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.common.abstr.EditableIF;
import com.mmm.cms.hh.pdgm.reference.objects.HippsValueObject;
import java.util.Map;

/**
 *
 * @author US340646
 */
public interface HippsCodeIF extends EditableIF {

    /**
     * @return the hipps
     */
    Map<Integer, HippsValueObject> getHipps();

    /**
     * @param hipps the hipps to set
     */
    void setHipps(Map<Integer, HippsValueObject> hipps);

    /**
     *
     * @param value
     * @return
     */
    boolean setValue(HippsValueObject value);

    /**
     *
     * @return
     */
    String getHippsCode();
    
    /**
     *
     * @return
     */
    String getFinalHippsCode();

    /**
     *
     * @param position
     * @return
     */
    String getHippsCharacter(int position);

    /**
     *
     * @param position
     * @return
     */
    HippsValueObject getValue(int position);
    
    /**
     *
     * @return
     */
    boolean isHippsComplete();

}
