/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.IdentifiableIF;
import com.mmm.cms.hh.pdgm.reference.objects.ReturnCodeObject;
import java.io.Serializable;
import java.text.ParseException;

/**
 *
 * @author US340646
 */
public class ReturnCode implements IdentifiableIF, DescribableIF, Serializable {

    private static final long serialVersionUID = 1L;
    
    @Override
    public String toString() {
        return "ReturnCode{" + "id=" + id + ", description=" + description + '}';
    }

    /**
     * Constructor
     */
    public ReturnCode() {
    }

    /**
     *
     * @param rco
     * @throws ParseException
     */
    public ReturnCode(ReturnCodeObject rco) throws ParseException {
        this.id = Integer.parseInt(rco.getCode());
        this.description = rco.getDescription();
    }
    
    /**
     *
     * @param id
     * @param description
     */
    public ReturnCode(int id, String description) {
        this.id = id;
        this.description = description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }
    
    private int id;
    private String description;
    
}
