/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.ValuableIF;
import java.io.Serializable;

/**
 *
 * @author US340646
 */
public class ValidityFlag implements ValuableIF, DescribableIF, Serializable{

    private static final long serialVersionUID = 1L;
    
    @Override
    public String toString() {
        return "ValidityFlag{" + "value=" + value + ", description=" + description + '}';
    }

    /**
     * Constructor
     */
    public ValidityFlag() {
    }

    /**
     *
     * @param value
     * @param description
     */
    public ValidityFlag(String value, String description) {
        this.value = value;
        this.description = description;
    }

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    private String value;
    private String description;
    
}
