/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */

package com.mmm.cms.hh.pdgm.data.exchange;

import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author US340646
 */


public class HippsContainer implements HippsContainerIF {
    
    final String VALUE_POSITION_UNAVAILABLE = "NA";
    final String VALUE_UNAVAILABLE = "Value not available";
    
    Map<Integer, HippsPosition> hipps = new TreeMap();
    
    public HippsContainer() {
        for (int i = 1; i < 6; i++) {
            hipps.put(i, new HippsPosition("0", VALUE_UNAVAILABLE));
        }
    }
    
    private HippsPosition getPosition(int position) {
        HippsPosition naPos = new HippsPosition("NA", "HIPPS position: '" + position + "' not applicable");
        return hipps.getOrDefault(position, naPos);
    }
    
    @Override
    public String getPositionValue(int position) {
        return getPosition(position).getValue();
    }

    @Override
    public void setPositionValue(int position, String value) {
        HippsPosition pos = getPosition(position);
        if(!pos.getValue().equalsIgnoreCase(VALUE_POSITION_UNAVAILABLE)) {
            pos.setValue(value);
        }
    }

    @Override
    public String getPositionDescription(int position) {
        return getPosition(position).getDescription();
    }

    @Override
    public void setPositionDescription(int position, String description) {
        HippsPosition pos = getPosition(position);
        if(!pos.getValue().equalsIgnoreCase(VALUE_POSITION_UNAVAILABLE)) {
            pos.setDescription(description);
        }
    }

    @Override
    public int getPositionsCount() {
        return hipps.size();
    }
    
}
