/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.data.files;

import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.IdentifiableIF;

/**
 *
 * @author us340646
 */
public enum TableNames_EN implements DescribableIF, IdentifiableIF {

    // Table Names

    // Reference Tables (ROT)

    /**
     *
     */
    Diagnoses(0,"Diagnoses", "Diagnosis_Codes.txt", true),

    /**
     *
     */
    Clinical_Groups(1,"Clinical Groups", "Clinical_Groups.txt", true),

    /**
     *
     */
    Comorbidity_Groups(2,"Comorbidity Groups", "Comorbidity_Groups.txt", true),

    /**
     *
     */
    Comorbidity_Interactions(3,"Comorbidity Interactions", "Comorbidity_Interactions.txt", true),

    /**
     *
     */
    Diagnosis_Subchapters(4,"Diagnosis Subchapters", "Diagnosis_Subchapters.txt", true),

    /**
     *
     */
    HIPPS_Structure(5,"HIPPS Structure", "HIPPS_Structure.txt", true),

    /**
     *
     */
    OASIS_Responses(6,"OASIS Responses", "OASIS_Responses.txt", false),

    /**
     *
     */
    Return_Codes(7,"Return Codes", "Return_Codes.txt", false),

    // Version Table

    /**
     *
     */
    Grouper_Versions(8,"Grouper Versions", "Grouper_Versions.txt", false),

    // Claim Layout Table

    /**
     *
     */
    Claim_Layout(9,"Claim Layout", "Claim_Layout.txt", false)
    
    ;
    
    private String fileName;
    private String description;
    private int id;
    private boolean viewable;

    private TableNames_EN(int id, String description, String fileName, boolean viewable) {
        this.id = id;
        this.description = description;
        this.fileName = fileName;
        this.viewable = viewable;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the fileName
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * @param fileName the fileName to set
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * @return the viewable
     */
    public boolean isViewable() {
        return viewable;
    }

    /**
     * @param viewable the viewable to set
     */
    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

}
