/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.data.loader;

import com.mmm.cms.hh.pdgm.data.interf.LineParserIF;
import com.mmm.cms.hh.pdgm.grouper.utility.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 *
 * @author US340646
 */
public class LineParser implements LineParserIF {

    private static final Logger LOG = Logger.getLogger(LineParser.class.getName());
    
    // Char Separated Values parser 

    /**
     *
     * @param delimiter
     */
    public LineParser(String delimiter) {
        this.parseTo = (String line) -> {
            List<String> retList = new ArrayList<>();
            StringTokenizer tokenizer = new StringTokenizer(line, delimiter);
            while (tokenizer.hasMoreTokens()) {
                retList.add(tokenizer.nextToken());
            }
            return retList;
        };
    }

    // Fixed Format Parser with variable field length

    /**
     *
     * @param fieldSizeList
     */
    public LineParser(List<Integer> fieldSizeList) {
        int layoutLen = Utility.sum(fieldSizeList);
        this.parseTo = (String line) -> {
            List<String> retList = new ArrayList();
            if (layoutLen <= line.length()) {
                int start = 0;
                for (int i = 0; i < fieldSizeList.size(); i++) {
                    retList.add(line.substring(start, start + fieldSizeList.get(i)));
                    start += fieldSizeList.get(i);
                }
            } else {
                LOG.log(Level.SEVERE, "Input Record Length error = {0} chars", layoutLen);
            }
            return retList;
        };
    }

    // Default (Tab Separated) Parser

    /**
     * Constructor with default TAB separator
     */
    public LineParser() {
        this("\t");
    }

    /**
     *
     * @param line
     * @return
     */
    @Override
    public List<String> parseLine(String line) {
        return Stream.of(line).map(parseTo).collect(Collectors.toList()).get(0);
    }

    private final Function<String, List<String>> parseTo;

}
