/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.data.meta.enumer;

import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.IdentifiableIF;

/**
 *
 * @author us340646
 */
public enum EditId_EN implements DescribableIF, IdentifiableIF {

    // Some generic Edit IDs

    /**
     *
     */

    VALUE_VALID(1,"Valid"),

    /**
     *
     */
    VALUE_INVALID(2,"Invalid"),

    /**
     *
     */
    VALUE_OUT_OF_RANGE(3,"Out of range"),

    /**
     *
     */
    VALUE_NOT_CALCULATED(4,"Not able to calculate"),

    /**
     *
     */
    VALUE_UNGROUPABLE(5,"Not able to group"),

    /**
     *
     */
    VALUE_IGNORE(6,"Ignore for scoring/grouping"),

    /**
     *
     */
    VALUE_SUBSTITUTED(7,"Value was substituted"),

    /**
     *
     */
    VALUE_HIPPS1(70,"Grouping Details on HIPPS 1"),

    /**
     *
     */
    VALUE_HIPPS2(80,"Grouping Details on HIPPS 2"),

    /**
     *
     */
    VALUE_HIPPS3(90,"Grouping Details on HIPPS 3"),

    /**
     *
     */
    VALUE_HIPPS4(100,"Grouping Details on HIPPS 4"),

    /**
     *
     */
    VALUE_HIPPS5(110,"Grouping Details on HIPPS 5"),

    /**
     *
     */
    VALUE_RETURN(120,"Grouping Return Code")    
    ;
    
    private String description;
    private int id;

    private EditId_EN(int id, String description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

}
