/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.diagnosis;

import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.IdentifiableIF;
import com.mmm.cms.hh.pdgm.reference.objects.DiagnosisSubchapterObject;
import java.io.Serializable;

/**
 *
 * @author US340646
 */
public class DiagnosisSubchapter implements IdentifiableIF, DescribableIF, Serializable {

    private static final long serialVersionUID = 1L;
    
    @Override
    public String toString() {
        return "DiagnosisSubchapter{" + "id=" + id + ", dxFrom=" + dxFrom + ", dxTo=" + dxTo + ", description=" + description + '}';
    }
    
    /**
     *
     * @param dxSubchapterObject
     */
    public DiagnosisSubchapter(DiagnosisSubchapterObject dxSubchapterObject) {
        this.id = Integer.parseInt(dxSubchapterObject.getId());
        this.dxFrom = dxSubchapterObject.getDiagnosisFrom();
        this.dxTo = dxSubchapterObject.getDiagnosisTo();
        this.description = dxSubchapterObject.getDescription();
    }
    
    /**
     *
     * @param id
     * @param dxFrom
     * @param dxTo
     * @param description
     */
    public DiagnosisSubchapter(int id, String dxFrom, String dxTo, String description) {
        this.id = id;
        this.dxFrom = dxFrom;
        this.dxTo = dxTo;
        this.description = description;
    }

    /**
     * @return the dxFrom
     */
    public String getDxFrom() {
        return dxFrom;
    }

    /**
     * @param dxFrom the dxFrom to set
     */
    public void setDxFrom(String dxFrom) {
        this.dxFrom = dxFrom;
    }

    /**
     * @return the dxTo
     */
    public String getDxTo() {
        return dxTo;
    }

    /**
     * @param dxTo the dxTo to set
     */
    public void setDxTo(String dxTo) {
        this.dxTo = dxTo;
    }
    private int id;
    private String dxFrom;
    private String dxTo;
    private String description;

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}
