/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.grouper;

import com.mmm.cms.hh.pdgm.data.files.TableNames_EN;
import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainerIF;
import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.IdentifiableIF;
import com.mmm.cms.hh.pdgm.common.abstr.NameableIF;
import java.util.Date;
import java.util.List;

/**
 *
 * @author US340646
 */
public interface GrouperIF extends IdentifiableIF, DescribableIF, NameableIF{

    /**
     *
     * @return
     */
    List<Integer> getClaimLayout();

    /**
     *
     * @return
     */
    List<Integer> getClaimLayoutInputOnly();

    /**
     *
     * @return
     */
    ClaimContainerIF getEmptyClaim();

    /**
     *
     * @param claim
     */
    void group(ClaimContainerIF claim);

    /**
     *
     * @param claimInput
     * @return
     */
    String group(String claimInput);

    /**
     *
     * @return
     */
    Date getStartDate();

    /**
     *
     * @return
     */
    Date getEndDate();

    /**
     *
     * @return
     */
    boolean isActive();

    /**
     *
     * @return
     */
    boolean isDefault();

    /**
     *
     * @return
     */
    String getVersion();

    /**
     *
     * @param tableType
     * @return
     */
    DataContainerIF<PositionAccessorIF> getAvailableTableContent(TableNames_EN tableType);
}
