/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.specification;

import com.mmm.cms.hh.pdgm.diagnosis.ComorbidityGroup;
import com.mmm.cms.hh.pdgm.diagnosis.DiagnosisIF;
import com.mmm.cms.hh.pdgm.logic.specification.abstr.AbstractSpecification;
import java.util.List;

/**
 *
 * @author US340646
 */
public class IsInComorbidityInteraction extends AbstractSpecification<ComorbidityGroup> {

    private final List<DiagnosisIF> dxList;

    /**
     *
     * @param dxList
     */
    public IsInComorbidityInteraction(List<DiagnosisIF> dxList) {
        this.dxList = dxList;
    }

    /**
     *
     * @param comorbidity
     * @return
     */
    @Override
    public boolean isSatisfiedBy(ComorbidityGroup comorbidity) {
        if(dxList == null) {
            return false;
        }
        for (DiagnosisIF dx : dxList) {
            if(dx.getComorbidityGroup().getName().trim()
                    .equalsIgnoreCase(comorbidity.getName().trim())) {
                return true;
            }
        }
        // not found
        return false;
    }

}
