/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.specification;

import static com.mmm.cms.hh.pdgm.data.meta.MetaData.FORMAT_DATE;
import com.mmm.cms.hh.pdgm.grouper.GrouperIF;
import com.mmm.cms.hh.pdgm.logic.specification.abstr.AbstractSpecification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author US340646
 */
public class IsValidFromDate extends AbstractSpecification<GrouperIF> {

    private Date date = null;

    /**
     *
     * @param date
     */
    public IsValidFromDate(String date) {
        this.date = processDate(date);
    }

    private Date processDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
        Date ret = null;
        try {
            ret = sdf.parse(date);
        } catch (ParseException ex) {
            // to prevent NPE
        }
        return ret;
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return isDateInBetweenIncludingEndPoints(gv.getStartDate(), gv.getEndDate(), date);
    }

    private boolean isDateInBetweenIncludingEndPoints(final Date min, final Date max, final Date date) {
        if (date == null) {
            return false;
        }
        return !(date.before(min) || date.after(max));
    }
}
