/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.LayoutElementIF;
import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.layout.claim.ClaimField;

/**
 *
 * @author US340646
 */
public class ClaimFieldObject extends ClaimField implements PositionAccessorIF, LayoutElementIF {

    @Override
    public String toString() {
        return "Field Sequence:'" + getSequence()
                + "', Name:'" + getName()
                + "', Type:'" + getType()
                + "', Position:'" + getPosition()
                + "', Length:'" + getLength()
                + "', Occurrence:'" + getOccurrence()
                + "', Source:'" + getSource()
                + "', Description:'" + getDescription()
                + "'";
    }

    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch (position) {
            case 0:
                return getSequence();
            case 1:
                return getName();
            case 2:
                return getType();
            case 3:
                return getPosition();
            case 4:
                return getLength();
            case 5:
                return getOccurrence();
            case 6:
                return getSource();
            case 7:
                return getDescription();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch (position) {
            case 0:
                setSequence(value);
                return true;
            case 1:
                setName(value);
                return true;
            case 2:
                setType(value);
                return true;
            case 3:
                setPosition(value);
                return true;
            case 4:
                setLength(value);
                return true;
            case 5:
                setOccurrence(value);
                return true;
            case 6:
                setSource(value);
                return true;
            case 7:
                setDescription(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }

    /**
     *
     * @return
     */
    @Override
    public Integer getElementId() {
        return Integer.parseInt(getSequence());
    }

    /**
     *
     * @return
     */
    @Override
    public String getElementName() {
        return getName();
    }

    /**
     *
     * @return
     */
    @Override
    public String getElementType() {
        return getType();
    }

    /**
     *
     * @return
     */
    @Override
    public Integer getElementPosition() {
        return Integer.parseInt(getPosition());
    }

    /**
     *
     * @return
     */
    @Override
    public Integer getElementLength() {
        return Integer.parseInt(getLength());
    }

    /**
     *
     * @return
     */
    @Override
    public Integer getElementOccurrence() {
        return Integer.parseInt(getOccurrence());
    }

    /**
     *
     * @return
     */
    @Override
    public String getElementDescription() {
        return getDescription();
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 8;
    }

    private boolean loadDescription;

    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

}
