/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.layout.rot.ClinicalGroup;

/**
 *
 * @author US340646
 */
public class ClinicalGroupObject extends ClinicalGroup implements PositionAccessorIF {

    @Override
    public String toString() {
        return "Clinical Group ID:'" + getId() +
                "', Clinical Group Name:'" + getName() +
                "', Clinical Group:'" + getDescription() +
                "', Low Points:'" + getLowPoints() +
                "', High Points:'" + getHighPoints() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getId();
            case 1:
                return getName();
            case 2:
                return getDescription();
            case 3:
                return getLowPoints();
            case 4:
                return getHighPoints();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setId(value);
                return true;
            case 1:
                setName(value);
                return true;
            case 2:
                setDescription(value);
                return true;
            case 3:
                setLowPoints(value);
                return true;
            case 4:
                setHighPoints(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 5;
    }
    
    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }

    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
