/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.layout.rot.OasisRespond;

/**
 *
 * @author US340646
 */
public class OasisRespondObject extends OasisRespond implements PositionAccessorIF {

    @Override
    public String toString() {
        return "OASIS Field ID:'" + getFieldId() +
                "', OASIS Field Description:'" + getFieldDescription() +
                "', Response:'" + getResponse() +
                "', Response Category:'" + getResponseCategory() +
                "', Responses Limit:'" + getResponseLimit() +
                "', Category Points:'" + getCategoryPoints() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getFieldId();
            case 1:
                return getFieldDescription();
            case 2:
                return getResponse();
            case 3:
                return getResponseCategory();
            case 4:
                return getResponseLimit();
            case 5:
                return getCategoryPoints();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setFieldId(value);
                return true;
            case 1:
                setFieldDescription(value);
                return true;
            case 2:
                setResponse(value);
                return true;
            case 3:
                setResponseCategory(value);
                return true;
            case 4:
                setResponseLimit(value);
                return true;
            case 5:
                setCategoryPoints(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 6;
    }

    @Override
    public void setFieldDescription(String value) {
        if (isLoadDescription()) {
            super.setFieldDescription(value);
        }
    }

    
    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
