/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.layout.rot.ReturnCode;

/**
 *
 * @author US340646
 */
public class ReturnCodeObject extends ReturnCode implements PositionAccessorIF{

    @Override
    public String toString() {
        return "Grouper Return Code:'" + getCode() +
                "', Description:'" + getDescription() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getCode();
            case 1:
                return getDescription();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setCode(value);
                return true;
            case 1:
                setDescription(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 2;
    }

    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }
    
    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

}
