

* PROGRAM: OOPCV1P.SAS;
* DESCRIPTION: MAIN OOPC PROGRAM;

%LET INPUTDIR    = c:\oopc_c\input;
%LET PROGDIR     = c:\oopc_c\programs;
%LET PBPDIR      = c:\oopc_c\pbp;
%LET PLANFILEDIR = c:\oopc_c\programs;
%LET OUTPUT      = c:\oopc_c\output;

%LET INPUT=INPUTPLAN;

OPTIONS OBS = MAX NOCENTER MSGLEVEL = N SUMSIZE = 1000M BUFNO = 6
   SORTPGM = SAS  NOSORTEQUALS THREADS = YES NOTES SPOOL;
OPTIONS VALIDVARNAME=ANY;

OPTIONS NOMPRINT NOSOURCE2;
RUN;

FILENAME IN0     "&INPUTDIR.";
LIBNAME  IN1     "&INPUTDIR.";

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****BEGIN OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;


*SET UP MACRO VARIABLES FOR YEARS;
%LET PBPMAIN       = PBP2023.MDB;
%LET YEAR1         = 2018;
%LET YEAR2         = 2019;
%LET RUNYEAR       = 2023;
%LET MCBSYR1       = 'MCBS 18';
%LET MCBSYR2       = 'MCBS 19';
%LET PARTA_DEDUCT  = 1600;
%LET PARTB_DEDUCT  = 226.00;
%LET B1_DED_AMT=1600;
%LET B1_COPAY_BGND_INT1=1;
%LET B1_COPAY_BGND_INT2=61;
%LET B1_COPAY_BGND_INT3=91;
%LET B1_COPAY_ENDD_INT1=60;
%LET B1_COPAY_ENDD_INT2=90;
%LET B1_COPAY_ENDD_INT3=150;
%LET B1_COPAY_AMT_INT1=0;
%LET B1_COPAY_AMT_INT2=400;
%LET B1_COPAY_AMT_INT3=800;
%LET B2_COPAY_AMT_INT1=0;
%LET B2_COPAY_AMT_INT2=200.00;
%LET B2_COPAY_BGND_INT1=1;
%LET B2_COPAY_BGND_INT2=21;
%LET B2_COPAY_BGND_INT3=.;
%LET B2_COPAY_ENDD_INT1=20;
%LET B2_COPAY_ENDD_INT2=100;
%LET B2_COPAY_ENDD_INT3=.;

%macro obsnvars(ds);
   %global dset nvars nobs;
   %let dset=&ds;
   %let dsid = %sysfunc(open(&dset));
   %if &dsid %then
      %do;
         %let nobs =%sysfunc(attrn(&dsid,NOBS));
         %let nvars=%sysfunc(attrn(&dsid,NVARS));
         %let rc = %sysfunc(close(&dsid));
      %end;
   %else
      %put Open for data set &dset failed - %sysfunc(sysmsg());
%mend obsnvars;

%INCLUDE IN0(OOPCV1M.SAS)/SOURCE2;
run;

data _null_;
  ddate = put(date(),YYMMDDN8.);
  put ddate=;
  call symput('file_date', trim(left(ddate)));
run;

%OOPCV1M(RUNYEAR           =2023,
         INP               =IN1.PERSON,
         INC               =IN1.UTILIZATION,
         CATEG             =IN1.CATEGORY,
         PBP               =&PBPDIR,
         PLANFILE          =&PLANFILEDIR\PLANFILE.TXT,
         OOPC              =&OUTPUT.\OOPC_RUN&file_date..xlsx);
run;

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****ENDED OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;
