* PROGRAM NAME:  C:\COST_SHARE_AUTOMATE\PARTD_VER\BENEFIT_OOPC_COST_CALCULATION.SAS;

LIBNAME LIBRARY "&INPUTDIR";

%MACRO FMT;
  %IF &NUM > 0 %THEN %DO;
    DATA FORMULARY_FMT (KEEP=START LABEL HLO FMTNAME);
      SET FORMULARY_LIST (RENAME=FORMULARY_ID=START) END=LAST;
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$FORMF';
      LABEL='YES';
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START='OTHER';
        LABEL='NO';
        HLO='O';
        OUTPUT;
      END;
    RUN;
  %END;
  %ELSE %DO;
    DATA FORMULARY_FMT (KEEP=START LABEL HLO FMTNAME);
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$FORMF';
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    RUN;
  %END;
  
  PROC FORMAT CNTLIN=FORMULARY_FMT;
  RUN;
%MEND;

%MACRO PLANS;
  DATA PLANS;
    %IF &NUM = 0 %THEN %DO;
      SET RICPME_SAMPLE_COHORT(OBS=1);
      DELETE;
      STOP;
    %END;
    %ELSE %DO;
      SET RICPME_SAMPLE_COHORT;
      IF PUT(FORMULARY_ID,$FORMF.)='YES';
    %END;
  RUN;
%MEND;

%MACRO COSTCALCS(BENTYPE,BENNUM);
  DATA PBP_EXTRACT FORMULARY_LIST (KEEP=FORMULARY_ID);
    SET MRX_EXTRACT;
    IF MRX_BENEFIT_TYPE = "&BENNUM.";
    TIER_LEVEL=INPUT(MRX_TIER_ID,3.);
    OUTPUT PBP_EXTRACT;
    OUTPUT FORMULARY_LIST;
  RUN;

  PROC SORT DATA=PBP_EXTRACT OUT=PLANCNT NODUPKEY;
    BY HPLAN;
  RUN;

  DATA _NULL_;
    CALL SYMPUT('PLANCNT',TRIM(LEFT(PUT(NUMOBS,4.))));
    PUT NUMOBS=;
    STOP;
    SET PLANCNT NOBS=NUMOBS;
    STOP;
  RUN;

  PROC SORT DATA=FORMULARY_LIST NODUPKEY;
    BY FORMULARY_ID;
  RUN;

  DATA _NULL_;
    CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
    STOP;
    SET FORMULARY_LIST NOBS=NUMOBS;
    STOP;
  RUN;

  %FMT;
  RUN;

  %PLANS;
  RUN;

  PROC SORT DATA = PBP_EXTRACT;
    BY HPLAN FORMULARY_ID TIER_LEVEL;
  RUN;

  DATA PBP_EXTRACT;
    SET PBP_EXTRACT;
    BY HPLAN FORMULARY_ID TIER_LEVEL;
    OUTPUT;
    %IF "&BENTYPE."^="DS" %THEN %DO;
      IF LAST.FORMULARY_ID THEN DO;
        TIER_LEVEL=9;
        OUTPUT;
      END;
    %END;
  RUN;

  %IF "&BENTYPE."="DS" %THEN %DO;
    PROC SQL;
      CREATE TABLE PBP_PLANS AS
        SELECT A.FORMULARY_ID, A.TIER_LEVEL AS TIER_LEVEL_VALUE, A.AVG_PRICE, A.DRUG_TYPE,
          A.BASEID, A.RX_SCRIPT_ORDER, A.RXCUI, A.ORXCUI, A.SCRIPT_CNT30,
          P.HPLAN, P.PLAN_DEDUCTIBLE, P.PLAN_ICL, P.PLAN_THRESHOLD, 
          P.PLAN_COPAY_CAT_GEN, P.PLAN_COPAY_CAT_BRAND, P.MRX_FIRST_FILL
         FROM PLANS A, PBP_EXTRACT P
         WHERE (A.FORMULARY_ID = P.FORMULARY_ID)
         ORDER BY P.HPLAN, A.BASEID, A.RX_SCRIPT_ORDER, A.RXCUI, A.TIER_LEVEL, A.AVG_PRICE, A.ORXCUI
       ;
    RUN;
  %END;

  %ELSE %IF "&BENTYPE."="AE" %THEN %DO;
    PROC SQL;
     CREATE TABLE PBP_PLANS AS
        SELECT A.TIER_LEVEL AS TIER_LEVEL_VALUE, A.AVG_PRICE, A.DRUG_TYPE, A.BASEID, A.RX_SCRIPT_ORDER,
          A.RXCUI, A.ORXCUI, A.SCRIPT_CNT30,
          P.FORMULARY_ID, P.HPLAN, P.PLAN_DEDUCTIBLE, P.PLAN_ICL, P.PLAN_THRESHOLD, P.MRX_AE_OOPTCS_APPLY,
          P.PLAN_COPAY, P.PLAN_COINS, P.PLAN_COPAY_CAT_GEN, P.PLAN_COPAY_CAT_BRAND,
          P.PLAN_COPAY_CAT, P.PLAN_COINS_CAT, P.MRX_FIRST_FILL, P.MRX_TIER_CSTSHR_STRUCT_TYPE,
          P.MRX_TIER_FORM_EX, P.MRX_TIER_FORM_EX_2_YN, P.MRX_TIER_FORM_EX_2
         FROM PLANS A, PBP_EXTRACT P
         WHERE (A.FORMULARY_ID = P.FORMULARY_ID AND A.TIER_LEVEL=P.TIER_LEVEL)
         ORDER BY P.HPLAN, A.BASEID, A.RX_SCRIPT_ORDER, A.RXCUI, A.TIER_LEVEL, A.AVG_PRICE, A.ORXCUI
       ;
    RUN;
  %END;

  %ELSE %IF "&BENTYPE."="BA" %THEN %DO;
    PROC SQL;
      CREATE TABLE PBP_PLANS AS
        SELECT A.TIER_LEVEL AS TIER_LEVEL_VALUE, A.AVG_PRICE, A.DRUG_TYPE, A.BASEID, A.RX_SCRIPT_ORDER, 
          A.RXCUI, A.ORXCUI, A.SCRIPT_CNT30,
          P.FORMULARY_ID, P.HPLAN, P.PLAN_DEDUCTIBLE, P.PLAN_ICL, P.PLAN_THRESHOLD, P.PLAN_COPAY, P.PLAN_COINS,
          P.PLAN_COPAY_CAT_GEN, P.PLAN_COPAY_CAT_BRAND, P.PLAN_COINS_PRE, P.PLAN_COPAY_PRE,
          P.PLAN_COPAY_CAT, P.PLAN_COINS_CAT, P.MRX_FIRST_FILL, P.MRX_ALT_DED_TYPE_YN,
          P.MRX_ALT_NO_DED_TIER, P.MRX_ALT_GEN_CSTSHR_STRUCT, 
          P.MRX_ALT_PRE_ICL_COST_SHARE, P.MRX_ALT_CSTSHR_POST_OOPT, P.MRX_TIER_CSTSHR_STRUCT_TYPE,
          P.MRX_TIER_FORM_EX, P.MRX_TIER_FORM_EX_2_YN, P.MRX_TIER_FORM_EX_2
         FROM PLANS A, PBP_EXTRACT P
         WHERE (A.FORMULARY_ID = P.FORMULARY_ID AND A.TIER_LEVEL=P.TIER_LEVEL)
         ORDER BY P.HPLAN, A.BASEID, A.RX_SCRIPT_ORDER, A.RXCUI, A.TIER_LEVEL, A.AVG_PRICE, A.ORXCUI
       ;
    RUN;
  %END;

  %ELSE %IF "&BENTYPE."="EA" %THEN %DO;
    PROC SQL;
      CREATE TABLE PBP_PLANS AS
        SELECT A.TIER_LEVEL AS TIER_LEVEL_VALUE, A.AVG_PRICE, A.DRUG_TYPE, A.BASEID, A.RX_SCRIPT_ORDER, 
          A.RXCUI, A.ORXCUI, A.SCRIPT_CNT30,
          P.FORMULARY_ID, P.HPLAN, P.PLAN_DEDUCTIBLE, P.PLAN_ICL, P.PLAN_THRESHOLD, P.PLAN_COPAY, P.PLAN_COINS,
          P.PLAN_COPAY_GAP, P.PLAN_COINS_GAP, P.PLAN_COPAY_CAT_GEN, P.PLAN_COPAY_CAT_BRAND,
          P.PLAN_COINS_PRE, P.PLAN_COPAY_PRE, P.PLAN_COPAY_CAT, P.PLAN_COINS_CAT, P.MRX_FIRST_FILL,
          P.MRX_ALT_DED_TYPE_YN, P.MRX_ALT_NO_DED_TIER, P.MRX_ALT_GAP_COVG_YN,
          P.MRX_ALT_PRE_ICL_COST_SHARE, P.MRX_ALT_CSTSHR_POST_OOPT, P.MRX_TIER_CSTSHR_STRUCT_TYPE,
          P.GAP_COVERAGE_FLAG, P.MRX_ALT_GEN_CSTSHR_STRUCT,
          P.MRX_TIER_FORM_EX, P.MRX_TIER_FORM_EX_2_YN, P.MRX_TIER_FORM_EX_2, 
          P.PLAN_SSM, P.COHORT_1_COPAY, P.COHORT_2_COPAY, P.COHORT_3_COPAY, P.COHORT_4_COPAY, P.COHORT_5_COPAY
         FROM PLANS A, PBP_EXTRACT P
         WHERE (A.FORMULARY_ID = P.FORMULARY_ID AND A.TIER_LEVEL=P.TIER_LEVEL)
         ORDER BY P.HPLAN, A.BASEID, A.RX_SCRIPT_ORDER, A.RXCUI, A.TIER_LEVEL, A.AVG_PRICE, A.ORXCUI
       ;
    RUN;
  %END;
  
  %EXCEPT_TA;
  
  DATA &BENTYPE._COST_CALCS;
    SET PBP_PLANS;
    BY HPLAN BASEID RX_SCRIPT_ORDER RXCUI;
    AVG_PRICE=AVG_PRICE*SCRIPT_CNT30;
    RETAIN DEDUCTIBLE ICL NONCOVERED_DRUGS COPAY_OOPC COINS_OOPC TOTAL_COVERED_OOPC TOTAL_COSTS
       REMAINING_DEDUCTIBLE REMAINING_ICL THRESHOLD;
    IF FIRST.BASEID THEN DO;
      DEDUCTIBLE = 0;
      ICL = 0;
      THRESHOLD = 0;
      NONCOVERED_DRUGS = 0;
      COPAY_OOPC = 0;
      COINS_OOPC = 0;
      TOTAL_COVERED_OOPC = 0;
      TOTAL_COSTS = 0;
    END;
    LENGTH CPRX $16 CPSRX $19;
    CPRX=SUBSTR(HPLAN,1,8)||LEFT(PUT(RXCUI,8.));
    CPSRX=HPLAN||LEFT(PUT(RXCUI,8.));
    IF TIER_LEVEL_VALUE = 9 THEN NONCOVERED_DRUGS + AVG_PRICE;
    ELSE DO;
      %INCLUDE IN0(&BENTYPE._CALCS)/SOURCE2;
    END;
    TOTAL_COSTS + AVG_PRICE;
    IF LAST.BASEID THEN DO;
      TOTAL_OOPC = SUM(NONCOVERED_DRUGS,TOTAL_COVERED_OOPC);
      OUTPUT;
    END;
    KEEP HPLAN BASEID FORMULARY_ID TOTAL_OOPC;
  RUN;

%MEND;

%COSTCALCS(DS,1);
%COSTCALCS(AE,2);
%COSTCALCS(BA,3);
%COSTCALCS(EA,4);

PROC DATASETS MEMTYPE=DATA LIB=WORK NOLIST;
  DELETE PLANS;
  QUIT;
RUN;

RUN;
QUIT;
RUN;