* PROGRAM: CLEANUP.SAS;
* DESCRIPTION: CLEANS UP ANY DATASETS IN THE WORK DIRECTORY;

%MACRO CLEANUP;
  PROC SQL;
    CREATE TABLE MEMBERS AS
      SELECT MEMNAME
      FROM DICTIONARY.TABLES
      WHERE LIBNAME='WORK' AND MEMTYPE = 'DATA';
    QUIT;
  RUN;

  DATA _NULL_;
    CALL SYMPUT('NUMDS',TRIM(LEFT(PUT(NUMDS,2.))));
    STOP;
    SET MEMBERS NOBS=NUMDS;
    STOP;
  RUN;

  %IF "&NUMDS" = "0" %THEN %DO;
  %END;
  %ELSE %DO;
    PROC DATASETS LIBRARY=WORK KILL;
    QUIT;
  %END;
  RUN;
%MEND;

%CLEANUP;
RUN;
