* PROGRAM NAME:  FFS_BENEFIT_OOPC_COST_CALCULATION.sas;

LIBNAME INPUT   "&INPUTDIR";

DATA AVG_PRICE_FMT (KEEP=START LABEL HLO FMTNAME);
  SET INPUT.RXCUI_REFERENCE END=LAST;
  LENGTH FMTNAME $8 HLO $1;
  FMTNAME='PRCFMT';
  START=RXCUI;
  LABEL=AVG_PRICE;
  HLO=' ';
  OUTPUT;
  IF LAST THEN DO;
    START=.;
    LABEL=.;
    HLO='O';
    OUTPUT;
  END;
RUN;

PROC FORMAT CNTLIN=AVG_PRICE_FMT LIBRARY=LIBRARY;
RUN;

DATA BENE_SCRIPT;
  SET INPUT.BENE_SCRIPT;
  AVG_PRICE=INPUT(PUT(RXCUI,PRCFMT.),4.);
  AVG_PRICE=AVG_PRICE*SCRIPT_CNT30;
RUN;

PROC SUMMARY DATA=BENE_SCRIPT NWAY MISSING;
  CLASS BASEID;
  VAR AVG_PRICE;
  OUTPUT OUT=FFS_COST_CALCS (DROP=_TYPE_ _FREQ_) SUM=COST;
RUN;

DATA FFS_DRUGS;
  MERGE FFS_COST_CALCS (IN=A)
        INPUT.PERSON(IN=B KEEP = BASEID CSYRWGT INDMON YEAR);
  BY BASEID;
  IF B;
  IF NOT A THEN COST=0;
  MONTHLY_COST=COST/INDMON;
RUN;

PROC SUMMARY DATA=FFS_DRUGS NWAY MISSING;
  VAR MONTHLY_COST;
  OUTPUT OUT=FFS_DRUGS_COSTS(DROP=_TYPE_ _FREQ_) MEAN=;
RUN;

DATA _NULL_;
  SET FFS_DRUGS_COSTS;
  CALL SYMPUT("PTDFFS",LEFT(PUT(MONTHLY_COST,8.3)));
RUN;





