
* PLAN_CATNAME_NEW.SAS;
* DESCRIPTION: PERFORM FINAL CALCULATIONS AND CREATE FINAL SPREADSHEET;

LIBNAME PBP "&PBPDIR";
LIBNAME OUTPUT "&OUTPUT";

%MACRO PLAN;

  DATA CCOHORT;
    SET IN1.PERSON(KEEP=BASEID CSYRWGT);
    COMBO_WGT = CSYRWGT;
  RUN;

  PROC SUMMARY DATA = CCOHORT NWAY MISSING;
    VAR COMBO_WGT;
    OUTPUT OUT = COHORT_CELL_GROUP(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
  RUN;

  %IF &PDP > 0 OR &MAPD > 0 %THEN %DO;

    DATA BASEID_CATEGORY_ALLYEARS;
      SET BASEID_PLAN_CATEGORY_PARTD (RENAME=CWGT=COMBO_WGT);
      BY HPLAN CATEGORY;
    RUN;

    PROC SORT DATA=BASEID_CATEGORY_ALLYEARS;
      BY HPLAN CATEGORY;
    RUN;

    PROC MEANS DATA = BASEID_CATEGORY_ALLYEARS NWAY NOPRINT;
      CLASS HPLAN CATEGORY;
      WEIGHT COMBO_WGT;
      VAR MONTHLY_COST;
      OUTPUT OUT = PLAN (DROP=_TYPE_ _FREQ_) SUM = MONTHLY_COST_SUM;
    RUN;

    DATA PLAN_COSTS;
      IF _N_ = 1 THEN SET COHORT_CELL_GROUP(KEEP = COMBOWGT_SUM);
      SET PLAN(IN = A);
      MONTHLY_COST_MEAN = MONTHLY_COST_SUM / COMBOWGT_SUM;
    RUN;

    PROC SORT DATA=PLAN_COSTS;
      BY HPLAN;
    RUN;

    DATA PLAN_COSTS_CAT(KEEP=HPLAN CATEGORY MONTHLY_COST_MEAN);
      SET PLAN_COSTS(WHERE=(HPLAN ^=:' ' AND CATEGORY ^= '   '));
    RUN;

    PROC TRANSPOSE DATA=PLAN_COSTS_CAT OUT=PARTD_PLANS(DROP=_NAME_);
      VAR MONTHLY_COST_MEAN;
      ID CATEGORY;
      BY HPLAN;
    RUN;

    DATA PARTD_PLANS_ALL;
      SET PARTD_PLANS (RENAME=PTD=PARTD);
    RUN;

  %END;  
    
  PROC SORT DATA=MASTER_PLANFILE;
    BY HPLAN;
  RUN;

  %IF &INPUT=INPUTCMS %THEN %DO;
    PROC SORT DATA=PBP.PBP_FILE OUT=PBP_FILE_SORT;
      BY HPLAN; 
    RUN;
  %END;

  %IF &INPUT=INPUTPLAN %THEN %DO;
    PROC SORT DATA=PBPPLANS_ALL(KEEP=QID pbp_a_plan_name pbp_a_plan_type RENAME=QID=HPLAN)
      OUT=PBP_FILE_SORT;
      BY HPLAN; 
    RUN;
  %END;
  

  DATA SECTION_A(RENAME=(PBP_A_PLAN_TYPE=PLAN_TYPE PBP_A_Plan_Name=Plan_Name));
    MERGE PBP_FILE_SORT (IN=A)
          MASTER_PLANFILE (IN=B);
    BY HPLAN;
    IF A & B;
    LENGTH TYPE $4;
    TYPE=PUT(HPLAN,$TYPEALL.);
  RUN;

  DATA PARTD_PLANS_CD;
    LENGTH HPLAN $11
         CONTRACT_ID $5
         PLAN_ID $3
         SEGMENT_ID $3
         PLAN_NAME $75
         YEAR $4
         PARTD 8;
    %IF &PDP>0 OR &MAPD>0 %THEN %DO;           
      MERGE SECTION_A(IN=A KEEP=PLAN_TYPE TYPE HPLAN PLAN_NAME)
            PARTD_PLANS_ALL (IN=B);
    %END;
    %ELSE %DO; 
      SET SECTION_A (IN=A KEEP=PLAN_TYPE TYPE HPLAN PLAN_NAME);
    %END;
    BY HPLAN;
    IF A;
    IF TYPE IN('MAON','MSA') THEN PARTD=&PTDFFS.;
    YEAR = "&RUNYEAR";
    CONTRACT_ID=SUBSTR(HPLAN,1,5);
    PLAN_ID=SUBSTR(HPLAN,6,3);
    SEGMENT_ID=SUBSTR(HPLAN,9,3);
  RUN;

  DATA OOPCS_ALL_FINAL_CD(DROP=TYPE HPLAN RENAME=(CONTRACT_ID=Contract_Number
    YEAR=BENEFIT_YEAR));
    LENGTH CONTRACT_ID $5 PLAN_ID $3 SEGMENT_ID $3 PLAN_NAME $75 YEAR $4 
    %IF &INPUT^=INPUTPLAN %THEN %DO;
      FORMULARY_VERSION 8
    %END;
    PARTD 8
    PBP_VERSION_DATE $21;
    SET PARTD_PLANS_CD(KEEP=CONTRACT_ID PLAN_ID SEGMENT_ID PLAN_NAME YEAR 
        PARTD HPLAN TYPE);
      BY HPLAN;
    %IF &INPUT^=INPUTPLAN %THEN %DO;
      FORMULARY_VERSION=INPUT(PUT(CONTRACT_ID||PLAN_ID,$CONTVER.),8.);
    %END;
    PBP_VERSION_DATE=PUT(HPLAN,$HISTFMT.);
  RUN;
  
  PROC EXPORT DATA=OOPCS_ALL_FINAL_CD 
    OUTFILE= "&OUTPUT.\OOPC_RUN&file_date..xlsx" 
       DBMS=XLSX REPLACE;
    SHEET="OOPCS &RUNYEAR";
  RUN;

  %IF &INPUT=INPUTCMS %THEN %DO;

    DATA RUN_DOCUMENTATION;
      LENGTH NOTES $250;
      NOTES="OOPC Model Version/Date:  &MODVERSION.";
      OUTPUT;
      NOTES="Plan Model Year:  &RUNYEAR.";
      OUTPUT;
      NOTES="PBP/Formulary Data Extract Date:  &EXT_DATE.";
      OUTPUT;
      NOTES="FRF Related Files Date:  &FRF_DATE. with 17 additional May 2022 RxCUIs";
      OUTPUT;
      NOTES="Cohort Year:   &SAMPLE_COHORT_YEAR.";
      OUTPUT;
      NOTES="PDE Price Data Year:  &PDE_YEAR";
      OUTPUT;
      NOTES="Part D Parameter Year:  &RUNYEAR.";
      OUTPUT;
    RUN;
  
    PROC EXPORT DATA=RUN_DOCUMENTATION
                OUTFILE= "&OUTPUT.\OOPC_RUN&file_date..xlsx"
                DBMS=XLSX REPLACE;
         SHEET="RUN_DOCUMENTATION";
    RUN;
  %END;
%MEND;

%PLAN;
RUN;
