* PROGRAM: COST_SHARING_INPATIENT_ACUTE.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR INPATIENT ACUTE CLAIMS;

%MACRO INPAT_ACUTE(SERV_CAT);

  DATA INPATIENT_ACUTE_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE = (CATEGORY = '1a'));
    IF BENEFIT_PERIOD_FLAG=1 THEN BENEFIT_PERIOD_COUNT=1;
    ELSE BENEFIT_PERIOD_COUNT=0;
  RUN;

  PROC SUMMARY DATA=INPATIENT_ACUTE_BASEID NWAY MISSING;
    CLASS BASEID YEAR;
    OUTPUT OUT=BENESUM (DROP=_TYPE_ RENAME=_FREQ_=STAYCNT);
  RUN;

  PROC SORT DATA=INPATIENT_ACUTE_BASEID;
    BY BASEID YEAR;  
  RUN;

  DATA INPATIENT_ACUTE_BASEID (DROP=STAYCNT);
    MERGE INPATIENT_ACUTE_BASEID (IN=A DROP=AMTTOT)
          BENESUM (IN=B);
    BY BASEID YEAR;
    IF A & B;
    AMTTOT=SUM(AMTTOT_FACILITY,AMTTOT_PHYSICIAN);
  RUN;

  DATA INPATIENT_ACUTE_FILE;
    SET PBP_FILE(KEEP =
                 CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN

                 PBP_B1A_COINS_YN
                 PBP_B1A_COPAY_YN

                 PBP_B1A_MC_COINS_CSTSHR_YN_T1 - PBP_B1A_MC_COINS_CSTSHR_YN_T3
                 PBP_B1A_MC_COPAY_CSTSHR_YN_T1 - PBP_B1A_MC_COPAY_CSTSHR_YN_T3

                 PBP_B1A_COPAY_MCS_AMT_T1 - PBP_B1A_COPAY_MCS_AMT_T3
                 PBP_B1A_COPAY_MCS_AMT_INT1_T1 - PBP_B1A_COPAY_MCS_AMT_INT1_T3
                 PBP_B1A_COPAY_MCS_AMT_INT2_T1 - PBP_B1A_COPAY_MCS_AMT_INT2_T3
                 PBP_B1A_COPAY_MCS_AMT_INT3_T1 - PBP_B1A_COPAY_MCS_AMT_INT3_T3
                 PBP_B1A_COPAY_MCS_BGND_INT1_T1 - PBP_B1A_COPAY_MCS_BGND_INT1_T3
                 PBP_B1A_COPAY_MCS_BGND_INT2_T1 - PBP_B1A_COPAY_MCS_BGND_INT2_T3
                 PBP_B1A_COPAY_MCS_BGND_INT3_T1 - PBP_B1A_COPAY_MCS_BGND_INT3_T3
                 PBP_B1A_COPAY_MCS_ENDD_INT1_T1 - PBP_B1A_COPAY_MCS_ENDD_INT1_T3
                 PBP_B1A_COPAY_MCS_ENDD_INT2_T1 - PBP_B1A_COPAY_MCS_ENDD_INT2_T3
                 PBP_B1A_COPAY_MCS_ENDD_INT3_T1 - PBP_B1A_COPAY_MCS_ENDD_INT3_T3

                 PBP_B1A_COPAY_NMCS_AMT
                 PBP_B1A_COPAY_NMCS_AMT_INTRVL1 - PBP_B1A_COPAY_NMCS_AMT_INTRVL3
                 PBP_B1A_COPAY_NMCS_BGND_NTRVL1 - PBP_B1A_COPAY_NMCS_BGND_NTRVL3
                 PBP_B1A_COPAY_NMCS_ENDD_NTRVL1 - PBP_B1A_COPAY_NMCS_ENDD_NTRVL3

                 PBP_B1A_COINS_MCS_PCT_T1 - PBP_B1A_COINS_MCS_PCT_T3
                 PBP_B1A_COINS_MCS_PCT_INT1_T1 - PBP_B1A_COINS_MCS_PCT_INT1_T3
                 PBP_B1A_COINS_MCS_PCT_INT2_T1 - PBP_B1A_COINS_MCS_PCT_INT2_T3
                 PBP_B1A_COINS_MCS_PCT_INT3_T1 - PBP_B1A_COINS_MCS_PCT_INT3_T3
                 PBP_B1A_COINS_MCS_BGND_INT1_T1 - PBP_B1A_COINS_MCS_BGND_INT1_T3
                 PBP_B1A_COINS_MCS_BGND_INT2_T1 - PBP_B1A_COINS_MCS_BGND_INT2_T3
                 PBP_B1A_COINS_MCS_BGND_INT3_T1 - PBP_B1A_COINS_MCS_BGND_INT3_T3
                 PBP_B1A_COINS_MCS_ENDD_INT1_T1 - PBP_B1A_COINS_MCS_ENDD_INT1_T3
                 PBP_B1A_COINS_MCS_ENDD_INT2_T1 - PBP_B1A_COINS_MCS_ENDD_INT2_T3
                 PBP_B1A_COINS_MCS_ENDD_INT3_T1 - PBP_B1A_COINS_MCS_ENDD_INT3_T3

                 PBP_B1A_COINS_NMCS_PCT
                 PBP_B1A_COINS_NMCS_PCT_INTRVL1 - PBP_B1A_COINS_NMCS_PCT_INTRVL3
                 PBP_B1A_COINS_NMCS_BGND_NTRVL1 - PBP_B1A_COINS_NMCS_BGND_NTRVL3
                 PBP_B1A_COINS_NMCS_ENDD_NTRVL1 - PBP_B1A_COINS_NMCS_ENDD_NTRVL3
                 
                 PBP_B1A_MAXENR_AMT PBP_B1A_MAXENR_PER
 
                 PBP_B1A_BENDESC_AMO_AD
                 PBP_B1A_AD_COST_VARY_TIERS_YN
                 PBP_B1A_AD_COST_VARY_LOW_TIER
                 
                 PBP_B1A_COPAY_AD_AMT_INT1_T1 - PBP_B1A_COPAY_AD_AMT_INT1_T3
                 PBP_B1A_COPAY_AD_AMT_INT2_T1 - PBP_B1A_COPAY_AD_AMT_INT2_T3
                 PBP_B1A_COPAY_AD_AMT_INT3_T1 - PBP_B1A_COPAY_AD_AMT_INT3_T3
                 PBP_B1A_COPAY_AD_BGND_INT1_T1 - PBP_B1A_COPAY_AD_BGND_INT1_T3
                 PBP_B1A_COPAY_AD_BGND_INT2_T1 - PBP_B1A_COPAY_AD_BGND_INT2_T3
                 PBP_B1A_COPAY_AD_BGND_INT3_T1 - PBP_B1A_COPAY_AD_BGND_INT3_T3
                 PBP_B1A_COPAY_AD_ENDD_INT1_T1 - PBP_B1A_COPAY_AD_ENDD_INT1_T3
                 PBP_B1A_COPAY_AD_ENDD_INT2_T1 - PBP_B1A_COPAY_AD_ENDD_INT2_T3
                 PBP_B1A_COPAY_AD_ENDD_INT3_T1 - PBP_B1A_COPAY_AD_ENDD_INT3_T3
 
                 PBP_B1A_COINS_AD_PCT_INT1_T1 - PBP_B1A_COINS_AD_PCT_INT1_T3
                 PBP_B1A_COINS_AD_PCT_INT2_T1 - PBP_B1A_COINS_AD_PCT_INT2_T3
                 PBP_B1A_COINS_AD_PCT_INT3_T1 - PBP_B1A_COINS_AD_PCT_INT3_T3
                 PBP_B1A_COINS_AD_BGND_INT1_T1 - PBP_B1A_COINS_AD_BGND_INT1_T3
                 PBP_B1A_COINS_AD_BGND_INT2_T1 - PBP_B1A_COINS_AD_BGND_INT2_T3
                 PBP_B1A_COINS_AD_BGND_INT3_T1 - PBP_B1A_COINS_AD_BGND_INT3_T3
                 PBP_B1A_COINS_AD_ENDD_INT1_T1 - PBP_B1A_COINS_AD_ENDD_INT1_T3
                 PBP_B1A_COINS_AD_ENDD_INT2_T1 - PBP_B1A_COINS_AD_ENDD_INT2_T3
                 PBP_B1A_COINS_AD_ENDD_INT3_T1 - PBP_B1A_COINS_AD_ENDD_INT3_T3

                 PBP_B1A_DED_AMT_T1 - PBP_B1A_DED_AMT_T3
                 PBP_B1A_BENDESC_LIM_AD
                 PBP_B1A_BENDESC_AMT_AD
                 PBP_B1A_COINS_NMCS_STRUC_YN
                 PBP_B1A_COPAY_NMCS_STRUC_YN
                 PBP_B1A_BENDESC_AMO_NMCS
                   
                 PBP_B1A_COST_VARY_LOW_TIER
                 PBP_B1A_COST_VARY_TIERS_YN
                 PBP_B1A_COST_VARY_TIER_NUM
                 PBP_A_PLAN_TYPE
                 PBP_D_DIFF_DEDUCT_YN
                 PBP_D_DIFF_DEDUCT_1A_T1_AMT
                 PBP_D_DIFF_DEDUCT_1A_T2_AMT
                 PBP_D_DIFF_DEDUCT_1A_T3_AMT
                 PBP_B1A_HOSP_BEN_PERIOD
                 PBP_B1A_COST_DISCHARGE_YN
                 PBP_D_DEDUCT_IHA_AMT);
    JOIN_ID = '1';

    %DO I = 1 %TO 3;
      IF (PBP_B1A_COINS_YN='1' & PBP_B1A_MC_COINS_CSTSHR_YN_T&I.='1') | 
        (PBP_B1A_COPAY_YN='1' & PBP_B1A_MC_COPAY_CSTSHR_YN_T&I.='1') THEN DO;
        PBP_B1A_DED_AMT_T&I.             = &B1_DED_AMT.;
        PBP_B1A_COPAY_MCS_BGND_INT1_T&I. = &B1_COPAY_BGND_INT1.;  
        PBP_B1A_COPAY_MCS_BGND_INT2_T&I. = &B1_COPAY_BGND_INT2.; 
        PBP_B1A_COPAY_MCS_BGND_INT3_T&I. = &B1_COPAY_BGND_INT3.; 
        PBP_B1A_COPAY_MCS_ENDD_INT1_T&I. = &B1_COPAY_ENDD_INT1.; 
        PBP_B1A_COPAY_MCS_ENDD_INT2_T&I. = &B1_COPAY_ENDD_INT2.; 
        PBP_B1A_COPAY_MCS_ENDD_INT3_T&I. = &B1_COPAY_ENDD_INT3.;
        PBP_B1A_COPAY_MCS_AMT_INT1_T&I.  = &B1_COPAY_AMT_INT1.;
        PBP_B1A_COPAY_MCS_AMT_INT2_T&I.  = &B1_COPAY_AMT_INT2.;
        PBP_B1A_COPAY_MCS_AMT_INT3_T&I.  = &B1_COPAY_AMT_INT3.;
      END;
    %END;

    IF PBP_B1A_MAXENR_AMT NE . THEN DO;
      IF PBP_B1A_MAXENR_PER = '1' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B1A_MAXENR_PER = '2' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B1A_MAXENR_PER = '3' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B1A_MAXENR_PER = '4' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B1A_MAXENR_PER = '5' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B1A_MAXENR_PER = '6' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT; * EVERY BENEFIT PERIOD;
      ELSE IF PBP_B1A_MAXENR_PER = '7' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT; * EVERY STAY;
      ELSE IF PBP_B1A_MAXENR_PER = '8' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT; * OTHER;
    END;
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.YEAR, B.UTLZNDAY, B.TOTDAYS, B.LRDAYS, B.AMTTOT, B.AMTTOT_FACILITY, B.FIRST_STAY, B.BENEFIT_PERIOD_FLAG, 
      B.BENEFIT_PERIOD_COUNT, P.*
      FROM INPATIENT_ACUTE_BASEID B, INPATIENT_ACUTE_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='1a'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  PROC SORT;
    BY HPLAN BASEID YEAR DESCENDING FIRST_STAY;
  RUN;

  DATA &SERV_CAT;
    LENGTH CATEGORY $4;
    RETAIN PBP_DEDUCTIBLE;
    SET CAT_JOIN (DROP = JOIN_ID);
    BY HPLAN BASEID YEAR DESCENDING FIRST_STAY;
    IF FIRST.BASEID THEN PBP_DEDUCTIBLE = .;
    IF PUT(HPLAN,$TYPEF.) IN('FFS','MGAP') THEN AMTTOT=AMTTOT_FACILITY;
    AMTTOT_PER_DAY = AMTTOT / TOTDAYS;

    LENGTH LOW_TIER_ID $1;
    LOW_TIER_ID = '1';
    IF PBP_B1A_COST_VARY_TIERS_YN = '2' THEN LOW_TIER_ID = '1';
    ELSE IF PBP_B1A_COST_VARY_TIERS_YN = '1' THEN LOW_TIER_ID=PBP_B1A_COST_VARY_LOW_TIER;
    LT=INPUT(LOW_TIER_ID,3.);

    LENGTH LOW_TIER_ID_AD $1;
    LOW_TIER_ID_AD = '1';
    IF PBP_B1A_AD_COST_VARY_TIERS_YN = '2' THEN LOW_TIER_ID_AD = '1';
    ELSE IF PBP_B1A_AD_COST_VARY_TIERS_YN = '1' THEN LOW_TIER_ID_AD=PBP_B1A_AD_COST_VARY_LOW_TIER;
    LTAD=INPUT(LOW_TIER_ID_AD,3.);

    IF PBP_B1A_HOSP_BEN_PERIOD IN('2','4') THEN DO;
      IF FIRST_STAY=1 THEN BENEFIT_PERIOD_FLAG=1;
      ELSE BENEFIT_PERIOD_FLAG=0;
      IF BENEFIT_PERIOD_COUNT > 1 THEN BENEFIT_PERIOD_COUNT=1;
    END;
    ELSE IF PBP_B1A_HOSP_BEN_PERIOD = '3' THEN DO;
      BENEFIT_PERIOD_FLAG = 1;
      BENEFIT_PERIOD_COUNT = 1;
    END;

    IF PBP_B1A_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B1A_MAXENR_AMT;
    
    IF PBP_B1A_COST_DISCHARGE_YN = '1' THEN DO;
      IF TOTDAYS = UTLZNDAY THEN DO;
        TOTDAYS = TOTDAYS + 1;
        UTLZNDAY = UTLZNDAY + 1;
      END;
      ELSE IF TOTDAYS > UTLZNDAY THEN DO;
        TOTDAYS = TOTDAYS + 1;
      END;
    END;

    ARRAY X_B1A_MC_COINS_CSTSHR_YN_T(3) $1 PBP_B1A_MC_COINS_CSTSHR_YN_T1 - PBP_B1A_MC_COINS_CSTSHR_YN_T3;
    ARRAY X_B1A_MC_COPAY_CSTSHR_YN_T(3) $1 PBP_B1A_MC_COPAY_CSTSHR_YN_T1 - PBP_B1A_MC_COPAY_CSTSHR_YN_T3;
    ARRAY X_B1A_COPAY_MCS_AMT_T(3)        PBP_B1A_COPAY_MCS_AMT_T1 - PBP_B1A_COPAY_MCS_AMT_T3;
    ARRAY X_B1A_COPAY_MCS_AMT_INT1_T(3)   PBP_B1A_COPAY_MCS_AMT_INT1_T1 - PBP_B1A_COPAY_MCS_AMT_INT1_T3;
    ARRAY X_B1A_COPAY_MCS_AMT_INT2_T(3)   PBP_B1A_COPAY_MCS_AMT_INT2_T1 - PBP_B1A_COPAY_MCS_AMT_INT2_T3;
    ARRAY X_B1A_COPAY_MCS_AMT_INT3_T(3)   PBP_B1A_COPAY_MCS_AMT_INT3_T1 - PBP_B1A_COPAY_MCS_AMT_INT3_T3;
    ARRAY X_B1A_COPAY_MCS_BGND_INT1_T(3)  PBP_B1A_COPAY_MCS_BGND_INT1_T1 - PBP_B1A_COPAY_MCS_BGND_INT1_T3;
    ARRAY X_B1A_COPAY_MCS_BGND_INT2_T(3)  PBP_B1A_COPAY_MCS_BGND_INT2_T1 - PBP_B1A_COPAY_MCS_BGND_INT2_T3;
    ARRAY X_B1A_COPAY_MCS_BGND_INT3_T(3)  PBP_B1A_COPAY_MCS_BGND_INT3_T1 - PBP_B1A_COPAY_MCS_BGND_INT3_T3;
    ARRAY X_B1A_COPAY_MCS_ENDD_INT1_T(3)  PBP_B1A_COPAY_MCS_ENDD_INT1_T1 - PBP_B1A_COPAY_MCS_ENDD_INT1_T3;
    ARRAY X_B1A_COPAY_MCS_ENDD_INT2_T(3)  PBP_B1A_COPAY_MCS_ENDD_INT2_T1 - PBP_B1A_COPAY_MCS_ENDD_INT2_T3;
    ARRAY X_B1A_COPAY_MCS_ENDD_INT3_T(3)  PBP_B1A_COPAY_MCS_ENDD_INT3_T1 - PBP_B1A_COPAY_MCS_ENDD_INT3_T3;
    ARRAY X_B1A_COINS_MCS_PCT_T(3)        PBP_B1A_COINS_MCS_PCT_T1 - PBP_B1A_COINS_MCS_PCT_T3;
    ARRAY X_B1A_COINS_MCS_PCT_INT1_T(3)   PBP_B1A_COINS_MCS_PCT_INT1_T1 - PBP_B1A_COINS_MCS_PCT_INT1_T3;
    ARRAY X_B1A_COINS_MCS_PCT_INT2_T(3)   PBP_B1A_COINS_MCS_PCT_INT2_T1 - PBP_B1A_COINS_MCS_PCT_INT2_T3;
    ARRAY X_B1A_COINS_MCS_PCT_INT3_T(3)   PBP_B1A_COINS_MCS_PCT_INT3_T1 - PBP_B1A_COINS_MCS_PCT_INT3_T3;
    ARRAY X_B1A_COINS_MCS_BGND_INT1_T(3)  PBP_B1A_COINS_MCS_BGND_INT1_T1 - PBP_B1A_COINS_MCS_BGND_INT1_T3;
    ARRAY X_B1A_COINS_MCS_BGND_INT2_T(3)  PBP_B1A_COINS_MCS_BGND_INT2_T1 - PBP_B1A_COINS_MCS_BGND_INT2_T3;
    ARRAY X_B1A_COINS_MCS_BGND_INT3_T(3)  PBP_B1A_COINS_MCS_BGND_INT3_T1 - PBP_B1A_COINS_MCS_BGND_INT3_T3;
    ARRAY X_B1A_COINS_MCS_ENDD_INT1_T(3)  PBP_B1A_COINS_MCS_ENDD_INT1_T1 - PBP_B1A_COINS_MCS_ENDD_INT1_T3;
    ARRAY X_B1A_COINS_MCS_ENDD_INT2_T(3)  PBP_B1A_COINS_MCS_ENDD_INT2_T1 - PBP_B1A_COINS_MCS_ENDD_INT2_T3;
    ARRAY X_B1A_COINS_MCS_ENDD_INT3_T(3)  PBP_B1A_COINS_MCS_ENDD_INT3_T1 - PBP_B1A_COINS_MCS_ENDD_INT3_T3;
    ARRAY X_B1A_COPAY_AD_AMT_INT1_T(3)    PBP_B1A_COPAY_AD_AMT_INT1_T1 - PBP_B1A_COPAY_AD_AMT_INT1_T3;
    ARRAY X_B1A_COPAY_AD_AMT_INT2_T(3)    PBP_B1A_COPAY_AD_AMT_INT2_T1 - PBP_B1A_COPAY_AD_AMT_INT2_T3;
    ARRAY X_B1A_COPAY_AD_AMT_INT3_T(3)    PBP_B1A_COPAY_AD_AMT_INT3_T1 - PBP_B1A_COPAY_AD_AMT_INT3_T3;
    ARRAY X_B1A_COPAY_AD_BGND_INT1_T(3)   PBP_B1A_COPAY_AD_BGND_INT1_T1 - PBP_B1A_COPAY_AD_BGND_INT1_T3;
    ARRAY X_B1A_COPAY_AD_BGND_INT2_T(3)   PBP_B1A_COPAY_AD_BGND_INT2_T1 - PBP_B1A_COPAY_AD_BGND_INT2_T3;
    ARRAY X_B1A_COPAY_AD_BGND_INT3_T(3)   PBP_B1A_COPAY_AD_BGND_INT3_T1 - PBP_B1A_COPAY_AD_BGND_INT3_T3;
    ARRAY X_B1A_COPAY_AD_ENDD_INT1_T(3)   PBP_B1A_COPAY_AD_ENDD_INT1_T1 - PBP_B1A_COPAY_AD_ENDD_INT1_T3;
    ARRAY X_B1A_COPAY_AD_ENDD_INT2_T(3)   PBP_B1A_COPAY_AD_ENDD_INT2_T1 - PBP_B1A_COPAY_AD_ENDD_INT2_T3;
    ARRAY X_B1A_COPAY_AD_ENDD_INT3_T(3)   PBP_B1A_COPAY_AD_ENDD_INT3_T1 - PBP_B1A_COPAY_AD_ENDD_INT3_T3;
    ARRAY X_B1A_COINS_AD_PCT_INT1_T(3)    PBP_B1A_COINS_AD_PCT_INT1_T1 - PBP_B1A_COINS_AD_PCT_INT1_T3;
    ARRAY X_B1A_COINS_AD_PCT_INT2_T(3)    PBP_B1A_COINS_AD_PCT_INT2_T1 - PBP_B1A_COINS_AD_PCT_INT2_T3;
    ARRAY X_B1A_COINS_AD_PCT_INT3_T(3)    PBP_B1A_COINS_AD_PCT_INT3_T1 - PBP_B1A_COINS_AD_PCT_INT3_T3;
    ARRAY X_B1A_COINS_AD_BGND_INT1_T(3)   PBP_B1A_COINS_AD_BGND_INT1_T1 - PBP_B1A_COINS_AD_BGND_INT1_T3;
    ARRAY X_B1A_COINS_AD_BGND_INT2_T(3)   PBP_B1A_COINS_AD_BGND_INT2_T1 - PBP_B1A_COINS_AD_BGND_INT2_T3;
    ARRAY X_B1A_COINS_AD_BGND_INT3_T(3)   PBP_B1A_COINS_AD_BGND_INT3_T1 - PBP_B1A_COINS_AD_BGND_INT3_T3;
    ARRAY X_B1A_COINS_AD_ENDD_INT1_T(3)   PBP_B1A_COINS_AD_ENDD_INT1_T1 - PBP_B1A_COINS_AD_ENDD_INT1_T3;
    ARRAY X_B1A_COINS_AD_ENDD_INT2_T(3)   PBP_B1A_COINS_AD_ENDD_INT2_T1 - PBP_B1A_COINS_AD_ENDD_INT2_T3;
    ARRAY X_B1A_COINS_AD_ENDD_INT3_T(3)   PBP_B1A_COINS_AD_ENDD_INT3_T1 - PBP_B1A_COINS_AD_ENDD_INT3_T3;
    ARRAY X_B1A_DED_AMT_T(3)              PBP_B1A_DED_AMT_T1 - PBP_B1A_DED_AMT_T3;
    ARRAY X_D_DIFF_DEDUCT_1A_AMT_T(3)     PBP_D_DIFF_DEDUCT_1A_T1_AMT PBP_D_DIFF_DEDUCT_1A_T2_AMT 
                                          PBP_D_DIFF_DEDUCT_1A_T3_AMT;


    IF X_B1A_COPAY_AD_ENDD_INT1_T(LTAD) = 999 THEN 
      X_B1A_COPAY_AD_ENDD_INT1_T(LTAD) = SUM(TOTDAYS,X_B1A_COPAY_AD_BGND_INT1_T(LTAD)-1);
    ELSE IF X_B1A_COPAY_AD_ENDD_INT2_T(LTAD) = 999 THEN 
      X_B1A_COPAY_AD_ENDD_INT2_T(LTAD) = SUM(TOTDAYS,X_B1A_COPAY_AD_BGND_INT1_T(LTAD)-1);
    ELSE IF X_B1A_COPAY_AD_ENDD_INT3_T(LTAD) = 999 THEN 
      X_B1A_COPAY_AD_ENDD_INT3_T(LTAD) = SUM(TOTDAYS,X_B1A_COPAY_AD_BGND_INT1_T(LTAD)-1);

    IF X_B1A_COINS_AD_ENDD_INT1_T(LTAD) = 999 THEN 
      X_B1A_COINS_AD_ENDD_INT1_T(LTAD) = SUM(TOTDAYS,X_B1A_COINS_AD_BGND_INT1_T(LTAD)-1);
    ELSE IF X_B1A_COINS_AD_ENDD_INT2_T(LTAD) = 999 THEN 
      X_B1A_COINS_AD_ENDD_INT2_T(LTAD) = SUM(TOTDAYS,X_B1A_COINS_AD_BGND_INT1_T(LTAD)-1);
    ELSE IF X_B1A_COINS_AD_ENDD_INT3_T(LTAD) = 999 THEN 
      X_B1A_COINS_AD_ENDD_INT3_T(LTAD) = SUM(TOTDAYS,X_B1A_COINS_AD_BGND_INT1_T(LTAD)-1);

    STAY_COST_MC = 0;
    STAY_COST_AMO = 0;
    DAY_COST_MC = 0;
    DAY_COST_AMO = 0;

    * MEDICARE COVERED STAY;
    IF UTLZNDAY > 0 THEN DO;
      IF PLAN_DED_CAT='1' THEN DO;
        IF PLAN_DED_AMTTOT_MC_PTA>0 THEN PBP_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTA;
        ELSE PBP_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
      END;
      ELSE DO;
        IF PUT(HPLAN,$TYPEF.) IN('FFS','MGAP') | (X_B1A_MC_COINS_CSTSHR_YN_T(LT)='1' | 
          X_B1A_MC_COPAY_CSTSHR_YN_T(LT)='1') THEN DO;
          IF BENEFIT_PERIOD_FLAG=1 THEN DO;
            IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_DIFF_DEDUCT_YN='1' THEN 
            PBP_DEDUCTIBLE=X_D_DIFF_DEDUCT_1A_AMT_T(LT);
            ELSE PBP_DEDUCTIBLE=X_B1A_DED_AMT_T(LT);
          END;
        END;

        ELSE IF FIRST_STAY = 1 THEN DO;
          IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_DIFF_DEDUCT_YN='1' THEN 
            PBP_DEDUCTIBLE=X_D_DIFF_DEDUCT_1A_AMT_T(LT);
          ELSE PBP_DEDUCTIBLE = X_B1A_DED_AMT_T(LT);
        END;
      END;
         
      IF PBP_DEDUCTIBLE > 0 THEN DO;
        IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
          STAY_COST = AMTTOT;
          MEDICARE_COVERED_DAYS = 0;
          ADDITIONAL_DAYS = 0;
          PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
        END;
        ELSE DO;
          AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
          STAY_COST = SUM(X_B1A_COPAY_MCS_AMT_T(LT), AMTTOT * X_B1A_COINS_MCS_PCT_T(LT), 
            PBP_DEDUCTIBLE);
          MEDICARE_COVERED_DAYS = SUM(UTLZNDAY, -LRDAYS);
          ADDITIONAL_DAYS = SUM(TOTDAYS, -MEDICARE_COVERED_DAYS);
          PBP_DEDUCTIBLE = 0;
        END;
      END;
      ELSE DO;
        STAY_COST = SUM(X_B1A_COPAY_MCS_AMT_T(LT), AMTTOT * X_B1A_COINS_MCS_PCT_T(LT));
        MEDICARE_COVERED_DAYS = SUM(UTLZNDAY, -LRDAYS);
        ADDITIONAL_DAYS = SUM(TOTDAYS, -MEDICARE_COVERED_DAYS);
      END;
      
      STAY_COST_MC = STAY_COST;

      IF MEDICARE_COVERED_DAYS > 0 THEN DO;
        N1 = X_B1A_COPAY_MCS_ENDD_INT1_T(LT) - X_B1A_COPAY_MCS_BGND_INT1_T(LT) + 1;
        N2 = X_B1A_COPAY_MCS_ENDD_INT2_T(LT) - X_B1A_COPAY_MCS_BGND_INT2_T(LT) + 1;
        N3 = X_B1A_COPAY_MCS_ENDD_INT3_T(LT) - X_B1A_COPAY_MCS_BGND_INT3_T(LT) + 1;
        
        DAY_COPAY = .;
        IF X_B1A_COPAY_MCS_ENDD_INT3_T(LT) > 0 &
          MEDICARE_COVERED_DAYS > X_B1A_COPAY_MCS_ENDD_INT3_T(LT) THEN DO;
          DAY_COPAY = N1 * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
          DAY_COPAY = SUM(DAY_COPAY, N2 * X_B1A_COPAY_MCS_AMT_INT2_T(LT));
          DAY_COPAY = SUM(DAY_COPAY, N3 * X_B1A_COPAY_MCS_AMT_INT3_T(LT));
        END;
        ELSE IF X_B1A_COPAY_MCS_ENDD_INT2_T(LT) > 0 &
          MEDICARE_COVERED_DAYS > X_B1A_COPAY_MCS_ENDD_INT2_T(LT) THEN DO;
          DAY_COPAY = N1 * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
          DAY_COPAY = SUM(DAY_COPAY, N2 * X_B1A_COPAY_MCS_AMT_INT2_T(LT));
          DAY_COPAY = SUM(DAY_COPAY, ((MEDICARE_COVERED_DAYS - (N1 + N2)) *
            X_B1A_COPAY_MCS_AMT_INT3_T(LT)));
        END;
        ELSE IF X_B1A_COPAY_MCS_ENDD_INT1_T(LT) > 0 &
          MEDICARE_COVERED_DAYS > X_B1A_COPAY_MCS_ENDD_INT1_T(LT) THEN DO;
          DAY_COPAY = N1 * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
          DAY_COPAY = SUM(DAY_COPAY, ((MEDICARE_COVERED_DAYS - N1) *
            X_B1A_COPAY_MCS_AMT_INT2_T(LT)));
        END;
        ELSE DO;
          DAY_COPAY = MEDICARE_COVERED_DAYS * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
        END;

        N1 = X_B1A_COINS_MCS_ENDD_INT1_T(LT) - X_B1A_COINS_MCS_BGND_INT1_T(LT) + 1;
        N2 = X_B1A_COINS_MCS_ENDD_INT2_T(LT) - X_B1A_COINS_MCS_BGND_INT2_T(LT) + 1;
        N3 = X_B1A_COINS_MCS_ENDD_INT3_T(LT) - X_B1A_COINS_MCS_BGND_INT3_T(LT) + 1;

        DAY_COINS = .;
        IF X_B1A_COINS_MCS_ENDD_INT3_T(LT) > 0 &
          MEDICARE_COVERED_DAYS > X_B1A_COINS_MCS_ENDD_INT3_T(LT) THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
          DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT2_T(LT));
          DAY_COINS = SUM(DAY_COINS, N3 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT3_T(LT));
        END;
        ELSE IF X_B1A_COINS_MCS_ENDD_INT2_T(LT) > 0 &
          MEDICARE_COVERED_DAYS > X_B1A_COINS_MCS_ENDD_INT2_T(LT) THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
          DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT2_T(LT));
          DAY_COINS = SUM(DAY_COINS, (MEDICARE_COVERED_DAYS - (N1 + N2)) * AMTTOT_PER_DAY *
            X_B1A_COINS_MCS_PCT_INT3_T(LT));
        END;
        ELSE IF X_B1A_COINS_MCS_ENDD_INT1_T(LT)> 0 &
          MEDICARE_COVERED_DAYS > X_B1A_COINS_MCS_ENDD_INT1_T(LT) THEN DO;
          DAY_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
          DAY_COINS = SUM(DAY_COINS, (MEDICARE_COVERED_DAYS - N1)* AMTTOT_PER_DAY *
            X_B1A_COINS_MCS_PCT_INT2_T(LT));
        END;
        ELSE DO;
          DAY_COINS = MEDICARE_COVERED_DAYS * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
        END;

        DAY_COST = SUM(DAY_COPAY, DAY_COINS);
        DAY_COST_MC = SUM(DAY_COPAY, DAY_COINS);
      END; * MEDICARE_COVERED_DAYS > 0;

      IF ADDITIONAL_DAYS > 0 THEN DO;

        IF PBP_B1A_BENDESC_AMO_AD = '2' THEN DO;

          IF PBP_B1A_BENDESC_LIM_AD = '1' THEN PLAN_MAX_AD = 
            SUM(TOTDAYS,MAX(X_B1A_COPAY_AD_BGND_INT1_T(LTAD)-1,X_B1A_COINS_AD_BGND_INT1_T(LTAD)-1));
          ELSE PLAN_MAX_AD = PBP_B1A_BENDESC_AMT_AD;
            
          IF ADDITIONAL_DAYS <= PLAN_MAX_AD THEN DO;
            DAYS = ADDITIONAL_DAYS;
          END;
          ELSE DO;
            DAYS = PLAN_MAX_AD;
            NONCOVERED_DAYS = SUM(ADDITIONAL_DAYS, -PLAN_MAX_AD);
          END;

          N1 = X_B1A_COPAY_AD_ENDD_INT1_T(LTAD) - X_B1A_COPAY_AD_BGND_INT1_T(LTAD) + 1;
          N2 = X_B1A_COPAY_AD_ENDD_INT2_T(LTAD) - X_B1A_COPAY_AD_BGND_INT2_T(LTAD) + 1;
          N3 = X_B1A_COPAY_AD_ENDD_INT3_T(LTAD) - X_B1A_COPAY_AD_BGND_INT3_T(LTAD) + 1;

          AD_COPAY = .;
          IF X_B1A_COPAY_AD_ENDD_INT3_T(LTAD) > 0 &
            DAYS > SUM(X_B1A_COPAY_AD_ENDD_INT3_T(LTAD),-(X_B1A_COPAY_AD_BGND_INT1_T(LTAD)-1)) THEN DO;
            AD_COPAY = N1 * X_B1A_COPAY_AD_AMT_INT1_T(LTAD);
            AD_COPAY = SUM(AD_COPAY, N2 * X_B1A_COPAY_AD_AMT_INT2_T(LTAD));
            AD_COPAY = SUM(AD_COPAY, N3 * X_B1A_COPAY_AD_AMT_INT3_T(LTAD));
          END;
          ELSE IF X_B1A_COPAY_AD_ENDD_INT2_T(LTAD) > 0 &
            DAYS > SUM(X_B1A_COPAY_AD_ENDD_INT2_T(LTAD),-(X_B1A_COPAY_AD_BGND_INT1_T(LTAD)-1)) THEN DO;
            AD_COPAY = N1 * X_B1A_COPAY_AD_AMT_INT1_T(LTAD);
            AD_COPAY = SUM(AD_COPAY, N2 * X_B1A_COPAY_AD_AMT_INT2_T(LTAD));
            AD_COPAY = SUM(AD_COPAY, ((DAYS - (N1 + N2)) * X_B1A_COPAY_AD_AMT_INT3_T(LTAD)));
          END;
          ELSE IF X_B1A_COPAY_AD_ENDD_INT1_T(LTAD) > 0 &
            DAYS > SUM(X_B1A_COPAY_AD_ENDD_INT1_T(LTAD),-(X_B1A_COPAY_AD_BGND_INT1_T(LTAD)-1)) THEN DO;
            AD_COPAY = N1 * X_B1A_COPAY_AD_AMT_INT1_T(LTAD);
            AD_COPAY = SUM(AD_COPAY, ((DAYS - N1) * X_B1A_COPAY_AD_AMT_INT2_T(LTAD)));
          END;
          ELSE DO;
            AD_COPAY = DAYS * X_B1A_COPAY_AD_AMT_INT1_T(LTAD);
          END;

          N1 = X_B1A_COINS_AD_ENDD_INT1_T(LTAD) - X_B1A_COINS_AD_BGND_INT1_T(LTAD) + 1;
          N2 = X_B1A_COINS_AD_ENDD_INT2_T(LTAD) - X_B1A_COINS_AD_BGND_INT2_T(LTAD) + 1;
          N3 = X_B1A_COINS_AD_ENDD_INT3_T(LTAD) - X_B1A_COINS_AD_BGND_INT3_T(LTAD) + 1;

          AD_COINS = .;
          IF X_B1A_COINS_AD_ENDD_INT3_T(LTAD) > 0 &
            DAYS > SUM(X_B1A_COINS_AD_ENDD_INT3_T(LTAD),-(X_B1A_COINS_AD_BGND_INT1_T(LTAD)-1)) THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT1_T(LTAD);
            AD_COINS = SUM(AD_COINS, N2 * AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT2_T(LTAD));
            AD_COINS = SUM(AD_COINS, N3 * AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT3_T(LTAD));
          END;
          ELSE IF X_B1A_COINS_AD_ENDD_INT2_T(LTAD) > 0 &
            DAYS > SUM(X_B1A_COINS_AD_ENDD_INT2_T(LTAD)-(X_B1A_COINS_AD_BGND_INT1_T(LTAD)-1)) THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT1_T(LTAD);
            AD_COINS = SUM(AD_COINS, N2 * AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT2_T(LTAD));
            AD_COINS = SUM(AD_COPAY, (DAYS - (N1 + N2)) * (AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT3_T(LTAD)));
          END;
          ELSE IF X_B1A_COINS_AD_ENDD_INT1_T(LTAD) > 0 &
            DAYS > SUM(X_B1A_COINS_AD_ENDD_INT1_T(LTAD),-(X_B1A_COINS_AD_BGND_INT1_T(LTAD)-1)) THEN DO;
            AD_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT1_T(LTAD);
            AD_COINS = SUM(AD_COPAY, (DAYS - N1) *(AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT2_T(LTAD)));
          END;
          ELSE DO;
            AD_COINS = DAYS * (AMTTOT_PER_DAY * X_B1A_COINS_AD_PCT_INT1_T(LTAD));
          END;

          DAY_COST = SUM(DAY_COST, AD_COPAY, AD_COINS);
          DAY_COST_AMO = SUM(DAY_COST_AMO, AD_COPAY, AD_COINS);

        END; * IF PBP_B1A_BENDESC_AMO_AD IN ('1','2');
        ELSE DO;
          NONCOVERED_DAYS = ADDITIONAL_DAYS;
        END;

        IF NONCOVERED_DAYS > 0 THEN DO;
          NONCOV_COST = NONCOVERED_DAYS * AMTTOT_PER_DAY;
        END;

      END; * IF ADDITIONAL_DAYS > 0;

    END; * IF UTLZNDAY > 0;
    ELSE DO;

      * NON-COVERED STAY;
      STAY_COST = .;
      DAY_COPAY = .;
      DAY_COINS = .;

      IF PBP_B1A_BENDESC_AMO_NMCS IN ('1','2') THEN DO;

        * NMCS COPAY STRUCTURE SAME AS MCS;
        IF PBP_B1A_COPAY_NMCS_STRUC_YN = '1' THEN DO;
        
          IF PLAN_DED_CAT='1' THEN DO;
            PLAN_DED_AMTTOT_AMO_PTA=SUM(PLAN_DEDUCT_PTA,-PLAN_DED_AMTTOT_MC_PTA);
	    IF PLAN_DED_AMTTOT_AMO_PTA>0 THEN PBP_DEDUCTIBLE=PLAN_DED_AMTTOT_AMO_PTA;
	    ELSE PBP_DEDUCTIBLE=SUM(PLAN_DED_AMTTOT,-PLAN_DED_AMTTOT_MC);
          END;
          ELSE DO;
            IF FIRST_STAY = 1 THEN DO;
              IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_DIFF_DEDUCT_YN='1' THEN PBP_DEDUCTIBLE=X_D_DIFF_DEDUCT_1A_AMT_T(LT);
              ELSE PBP_DEDUCTIBLE = X_B1A_DED_AMT_T(LT);
            END;
            IF PUT(HPLAN,$TYPEF.) IN('FFS','MGAP') | (X_B1A_MC_COINS_CSTSHR_YN_T(LT)='1' | X_B1A_MC_COPAY_CSTSHR_YN_T(LT)='1') THEN DO;
              IF BENEFIT_PERIOD_FLAG=1 THEN DO;
                IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_DIFF_DEDUCT_YN='1' THEN PBP_DEDUCTIBLE=X_D_DIFF_DEDUCT_1A_AMT_T(LT);
                ELSE PBP_DEDUCTIBLE=X_B1A_DED_AMT_T(LT);
              END;
            END;
          END;
          
          CAT_DEDUCTIBLE_SUP=0;
          IF PBP_D_DEDUCT_IHA_AMT>0 THEN CAT_DEDUCTIBLE_SUP=PBP_D_DEDUCT_IHA_AMT;
          
          PBP_DEDUCTIBLE=SUM(PBP_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP);
          
          IF PBP_DEDUCTIBLE > 0 THEN DO;
            IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
              STAY_COST = AMTTOT;
              ADDITIONAL_DAYS = 0;
              PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
            END;
            ELSE DO;
              AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
              STAY_COST = SUM(X_B1A_COPAY_MCS_AMT_T(LT), AMTTOT * X_B1A_COINS_MCS_PCT_T(LT), PBP_DEDUCTIBLE);
              ADDITIONAL_DAYS = SUM(TOTDAYS, -MEDICARE_COVERED_DAYS);
              PBP_DEDUCTIBLE = 0;
            END;
          END;
          ELSE DO;
            STAY_COST    = SUM(X_B1A_COPAY_MCS_AMT_T(LT), AMTTOT * X_B1A_COINS_MCS_PCT_T(LT));
            ADDITIONAL_DAYS = SUM(TOTDAYS, -MEDICARE_COVERED_DAYS);
          END;

          STAY_COST_AMO = STAY_COST;
          N1 = X_B1A_COPAY_MCS_ENDD_INT1_T(LT) - X_B1A_COPAY_MCS_BGND_INT1_T(LT) + 1;
          N2 = X_B1A_COPAY_MCS_ENDD_INT2_T(LT) - X_B1A_COPAY_MCS_BGND_INT2_T(LT) + 1;
          N3 = X_B1A_COPAY_MCS_ENDD_INT3_T(LT) - X_B1A_COPAY_MCS_BGND_INT3_T(LT) + 1;
          
          
          DAY_COPAY = .;
          IF (X_B1A_COPAY_MCS_ENDD_INT3_T(LT) > 0) &
            (TOTDAYS > X_B1A_COPAY_MCS_ENDD_INT3_T(LT)) THEN DO;
            DAY_COPAY = N1 * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
            DAY_COPAY = SUM(DAY_COPAY, N2 * X_B1A_COPAY_MCS_AMT_INT2_T(LT));
            DAY_COPAY = SUM(DAY_COPAY, N3 * X_B1A_COPAY_MCS_AMT_INT3_T(LT));
          END;
          ELSE IF (X_B1A_COPAY_MCS_ENDD_INT2_T(LT) > 0) &
            (TOTDAYS > X_B1A_COPAY_MCS_ENDD_INT2_T(LT)) THEN DO;
            DAY_COPAY = N1 * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
            DAY_COPAY = SUM(DAY_COPAY, N2 * X_B1A_COPAY_MCS_AMT_INT2_T(LT));
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - (N1 + N2)) * X_B1A_COPAY_MCS_AMT_INT3_T(LT)));
          END;
          ELSE IF (X_B1A_COPAY_MCS_ENDD_INT1_T(LT) > 0) &
            (TOTDAYS > X_B1A_COPAY_MCS_ENDD_INT1_T(LT)) THEN DO;
            DAY_COPAY = N1 * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - N1) * X_B1A_COPAY_MCS_AMT_INT2_T(LT)));
          END;
          ELSE DO;
            DAY_COPAY = TOTDAYS * X_B1A_COPAY_MCS_AMT_INT1_T(LT);
          END;

        END; * PBP_B1A_COPAY_NMCS_STRUC_YN = '1';
        ELSE
        IF PBP_B1A_COPAY_NMCS_STRUC_YN = '2'  THEN DO; * NMCS COPAY STRUCTURE NOT THE SAME AS MCS;
          IF PLAN_DED_CAT = '1' THEN DO;
	    PLAN_DED_AMTTOT_AMO_PTA = SUM(PLAN_DEDUCT_PTA,-PLAN_DED_AMTTOT_MC_PTA);
	    IF PLAN_DED_AMTTOT_AMO_PTA>0 THEN PBP_DEDUCTIBLE = PLAN_DED_AMTTOT_AMO_PTA;
	    ELSE PBP_DEDUCTIBLE = SUM(PLAN_DED_AMTTOT,-PLAN_DED_AMTTOT_MC);
          END;
          ELSE DO;
            IF FIRST_STAY = 1 THEN DO;
              IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_DIFF_DEDUCT_YN = '1' THEN 
                PBP_DEDUCTIBLE = X_D_DIFF_DEDUCT_1A_AMT_T(LT);
              ELSE PBP_DEDUCTIBLE = X_B1A_DED_AMT_T(LT);
            END;
            IF PUT(HPLAN,$TYPEF.) IN('FFS','MGAP') | (X_B1A_MC_COINS_CSTSHR_YN_T(LT) = '1' | 
              X_B1A_MC_COPAY_CSTSHR_YN_T(LT) = '1') THEN DO;
              IF BENEFIT_PERIOD_FLAG = 1 THEN DO;
                IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_DIFF_DEDUCT_YN = '1' THEN 
                  PBP_DEDUCTIBLE = X_D_DIFF_DEDUCT_1A_AMT_T(LT);
                ELSE PBP_DEDUCTIBLE =X_B1A_DED_AMT_T(LT);
              END;
            END;
          END;
          
          CAT_DEDUCTIBLE_SUP=0;
          IF PBP_D_DEDUCT_IHA_AMT>0 THEN CAT_DEDUCTIBLE_SUP = PBP_D_DEDUCT_IHA_AMT;

          PBP_DEDUCTIBLE=SUM(PBP_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP);

          IF PBP_DEDUCTIBLE > 0 THEN DO;
            IF AMTTOT < PBP_DEDUCTIBLE THEN DO;
              STAY_COST = AMTTOT;
              ADDITIONAL_DAYS = 0;
              PBP_DEDUCTIBLE = SUM(PBP_DEDUCTIBLE,-AMTTOT);
            END;
            ELSE DO;
              AMTTOT = SUM(AMTTOT,-PBP_DEDUCTIBLE);
              STAY_COST = SUM(PBP_B1A_COPAY_NMCS_AMT, AMTTOT * PBP_B1A_COINS_NMCS_PCT, PBP_DEDUCTIBLE);
              ADDITIONAL_DAYS = SUM(TOTDAYS, -MEDICARE_COVERED_DAYS);
              PBP_DEDUCTIBLE = 0;
            END;
          END;
          ELSE DO;
            STAY_COST = SUM(PBP_B1A_COPAY_NMCS_AMT, AMTTOT * PBP_B1A_COINS_NMCS_PCT);
            ADDITIONAL_DAYS = SUM(TOTDAYS, -MEDICARE_COVERED_DAYS);
          END;

          STAY_COST_AMO = STAY_COST;

          N1 = PBP_B1A_COPAY_NMCS_ENDD_NTRVL1 - PBP_B1A_COPAY_NMCS_BGND_NTRVL1 + 1;
          N2 = PBP_B1A_COPAY_NMCS_ENDD_NTRVL2 - PBP_B1A_COPAY_NMCS_BGND_NTRVL2 + 1;
          N3 = PBP_B1A_COPAY_NMCS_ENDD_NTRVL3 - PBP_B1A_COPAY_NMCS_BGND_NTRVL3 + 1;

          DAY_COPAY = .;
          IF (PBP_B1A_COPAY_NMCS_ENDD_NTRVL3 > 0) &
            (TOTDAYS > PBP_B1A_COPAY_NMCS_ENDD_NTRVL3) THEN DO;
            DAY_COPAY = N1 * PBP_B1A_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, N2 * PBP_B1A_COPAY_NMCS_AMT_INTRVL2);
            DAY_COPAY = SUM(DAY_COPAY, N3 * PBP_B1A_COPAY_NMCS_AMT_INTRVL3);
          END;
          ELSE IF (PBP_B1A_COPAY_NMCS_ENDD_NTRVL2 > 0) &
            (TOTDAYS > PBP_B1A_COPAY_NMCS_ENDD_NTRVL2) THEN DO;
            DAY_COPAY = N1 * PBP_B1A_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, N2 * PBP_B1A_COPAY_NMCS_AMT_INTRVL2);
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - (N1 + N2)) * PBP_B1A_COPAY_NMCS_AMT_INTRVL3));
          END;
          ELSE IF (PBP_B1A_COPAY_NMCS_ENDD_NTRVL1 > 0) &
            (TOTDAYS > PBP_B1A_COPAY_NMCS_ENDD_NTRVL1) THEN DO;
            DAY_COPAY = N1 * PBP_B1A_COPAY_NMCS_AMT_INTRVL1;
            DAY_COPAY = SUM(DAY_COPAY, ((TOTDAYS - N1) * PBP_B1A_COPAY_NMCS_AMT_INTRVL2));
          END;
          ELSE DO;
            DAY_COPAY = TOTDAYS * PBP_B1A_COPAY_NMCS_AMT_INTRVL1;
          END;

        END; * PBP_B1A_COPAY_NMCS_STRUC_YN ^= '1';

        * NMCS COINSURANCE STRUCTURE SAME AS MCS;
        IF PBP_B1A_COINS_NMCS_STRUC_YN = '1' THEN DO;
          STAY_COST = SUM(STAY_COST, AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_T(LT));
          STAY_COST_AMO = SUM(STAY_COST_AMO, AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_T(LT));

          N1 = X_B1A_COINS_MCS_ENDD_INT1_T(LT) - X_B1A_COINS_MCS_BGND_INT1_T(LT) + 1;
          N2 = X_B1A_COINS_MCS_ENDD_INT2_T(LT) - X_B1A_COINS_MCS_BGND_INT2_T(LT) + 1;
          N3 = X_B1A_COINS_MCS_ENDD_INT3_T(LT) - X_B1A_COINS_MCS_BGND_INT3_T(LT) + 1;

          DAY_COINS = .;
          IF (X_B1A_COINS_MCS_ENDD_INT3_T(LT) > 0) &
            (TOTDAYS > X_B1A_COINS_MCS_ENDD_INT3_T(LT)) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
            DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT2_T(LT));
            DAY_COINS = SUM(DAY_COINS, N3 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT3_T(LT));
          END;
          ELSE IF (X_B1A_COINS_MCS_ENDD_INT2_T(LT) > 0) &
            (TOTDAYS > X_B1A_COINS_MCS_ENDD_INT2_T(LT)) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
            DAY_COINS = SUM(DAY_COINS, N2 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT2_T(LT));
            DAY_COINS = SUM(DAY_COINS, (TOTDAYS - (N1 + N2)) * AMTTOT_PER_DAY *
              X_B1A_COINS_MCS_PCT_INT3_T(LT));
          END;
          ELSE IF (X_B1A_COINS_MCS_ENDD_INT1_T(LT) > 0) &
            (TOTDAYS > X_B1A_COINS_MCS_ENDD_INT1_T(LT)) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
            DAY_COINS = SUM(DAY_COINS, (TOTDAYS - N1) * AMTTOT_PER_DAY *
              X_B1A_COINS_MCS_PCT_INT2_T(LT));
          END;
          ELSE DO;
            DAY_COINS = TOTDAYS * AMTTOT_PER_DAY * X_B1A_COINS_MCS_PCT_INT1_T(LT);
          END;

        END; * PBP_B1A_COINS_NMCS_STRUC_YN = '1';
        ELSE
        IF PBP_B1A_COINS_NMCS_STRUC_YN = '2' THEN DO; * NMCS COINSURANCE STRUCTURE NOT THE SAME AS MCS;
          STAY_COST = SUM(STAY_COST, AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT);
          STAY_COST_AMO = SUM(STAY_COST_AMO, AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT);

          N1 = PBP_B1A_COINS_NMCS_ENDD_NTRVL1 - PBP_B1A_COINS_NMCS_BGND_NTRVL1 + 1;
          N2 = PBP_B1A_COINS_NMCS_ENDD_NTRVL2 - PBP_B1A_COINS_NMCS_BGND_NTRVL2 + 1;
          N3 = PBP_B1A_COINS_NMCS_ENDD_NTRVL3 - PBP_B1A_COINS_NMCS_BGND_NTRVL3 + 1;

          DAY_COINS = .;
          IF (PBP_B1A_COINS_NMCS_ENDD_NTRVL3 > 0) &
            (TOTDAYS > PBP_B1A_COINS_NMCS_ENDD_NTRVL3) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT_INTRVL2);
            DAY_COINS = SUM( DAY_COINS, N3 * AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B1A_COINS_NMCS_ENDD_NTRVL2 > 0) &
            (TOTDAYS > PBP_B1A_COINS_NMCS_ENDD_NTRVL2) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, N2 * AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT_INTRVL2);
            DAY_COINS = SUM( DAY_COINS, (TOTDAYS - (N1 + N2)) * AMTTOT_PER_DAY *
              PBP_B1A_COINS_NMCS_PCT_INTRVL3);
          END;
          ELSE IF (PBP_B1A_COINS_NMCS_ENDD_NTRVL1 > 0) &
            (TOTDAYS > PBP_B1A_COINS_NMCS_ENDD_NTRVL1) THEN DO;
            DAY_COINS = N1 * AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT_INTRVL1;
            DAY_COINS = SUM( DAY_COINS, (TOTDAYS - N1) * AMTTOT_PER_DAY *
              PBP_B1A_COINS_NMCS_PCT_INTRVL2);
          END;
          ELSE DO;
            DAY_COINS = TOTDAYS * AMTTOT_PER_DAY * PBP_B1A_COINS_NMCS_PCT_INTRVL1;
          END;

        END; * PBP_B1A_COINS_NMCS_STRUC_YN ^= '1';

        DAY_COST = SUM(DAY_COPAY, DAY_COINS);
        DAY_COST_AMO = SUM(DAY_COPAY, DAY_COINS);
        * NONCOV_COST = SUM(STAY_COST, DAY_COPAY, DAY_COINS);

      END; * PBP_B1A_BENDESC_AMO_NMCS IN ('1','2');
      ELSE DO;
        NONCOV_COST = TOTDAYS * AMTTOT_PER_DAY;
      END;

    END; * END UTLZNDAY <= 0;

    COST_SHARE_COST = SUM(STAY_COST, DAY_COST);
    COST_SHARE_COST_MC  = SUM(STAY_COST_MC, DAY_COST_MC);
    COST_SHARE_COST_AMO = SUM(STAY_COST_AMO, DAY_COST_AMO);
    OTHER_COST = NONCOV_COST;

    IF PBP_B1A_MAXENR_PER = '7' & BENE_MAXIMUM >= 0 & COST_SHARE_COST > BENE_MAXIMUM THEN DO;
      MAX_REDUCTION = (BENE_MAXIMUM / SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
      COST_SHARE_COST = COST_SHARE_COST * MAX_REDUCTION;
      COST_SHARE_COST_MC = COST_SHARE_COST_MC * MAX_REDUCTION;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * MAX_REDUCTION;
    END;

    CATEGORY = "1a";

  RUN;

  PROC SORT DATA = INPATIENT_ACUTE;
    BY HPLAN;
  RUN;

  PROC SUMMARY DATA = INPATIENT_ACUTE NWAY MISSING;
    CLASS YEAR BASEID;
    BY HPLAN;
    VAR AMTTOT COST_SHARE_COST OTHER_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO BENEFIT_PERIOD_COUNT;
    ID BENE_MAXIMUM PBP_B1A_MAXENR_PER CATEGORY;
    OUTPUT OUT = TOTINP(RENAME = _FREQ_=RCCNT) SUM = ;
  RUN;

  DATA COSTDATA_INPATIENT_ACUTE;
    SET TOTINP;

    IF PBP_B1A_MAXENR_PER='6' THEN BENE_MAXIMUM=BENE_MAXIMUM*BENEFIT_PERIOD_COUNT;

    IF PBP_B1A_MAXENR_PER IN ('1','2','3','4','5','6','8') & BENE_MAXIMUM >= 0 &
      COST_SHARE_COST > BENE_MAXIMUM THEN DO;
        MAX_REDUCTION = (BENE_MAXIMUM / SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
      COST_SHARE_COST = COST_SHARE_COST * MAX_REDUCTION;
      COST_SHARE_COST_MC = COST_SHARE_COST_MC * MAX_REDUCTION;
      COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * MAX_REDUCTION;
    END;

    COST = SUM(COST_SHARE_COST, OTHER_COST);
    
    KEEP HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
         OTHER_COST COST CATEGORY RCCNT AMTTOT;
  RUN;

  PROC SORT DATA = COSTDATA_INPATIENT_ACUTE;
    BY YEAR BASEID HPLAN;
  RUN;
 
  PROC APPEND DATA=COSTDATA_INPATIENT_ACUTE(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE INPATIENT_ACUTE TOTINP COSTDATA_INPATIENT_ACUTE INPATIENT_ACUTE_BASEID INPATIENT_ACUTE_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;